/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.SyncMan.MsgService.Reliability;

import com.sap.sapdb.SyncMan.MsgService.MsgQueueClient;
import com.sap.sapdb.SyncMan.MsgService.Reliability.Reliability;
import com.sap.sapdb.SyncMan.SyncManTest;
import com.sap.sapdb.testframe.testcase.TestCase;
import java.io.InputStream;
import java.util.Properties;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.naming.InitialContext;

public class ReceiveR_010
extends MsgQueueClient
implements ExceptionListener {
    private int m_NoRedeliveredMessagesReceived;
    private int m_RedeliveredMessagesReceived;
    private boolean m_ServerShutdown;
    private boolean m_ServerAlreadyShutdown;

    public ReceiveR_010(TestCase aTestCase, ThreadGroup aThreadGroup, String queueName, String user, String password, String id) throws Exception {
        super(aTestCase, 2, queueName, user, password, "", 1, false, 1, false, aThreadGroup, "ReceiveR_010" + id);
        this.m_NumberOfSender = 3;
        this.m_NoRedeliveredMessagesReceived = 0;
        this.m_RedeliveredMessagesReceived = 0;
        this.m_ServerAlreadyShutdown = false;
        this.m_ServerShutdown = false;
        this.m_Receiver.setMessageListener((MessageListener)this);
        this.m_Connection.setExceptionListener((ExceptionListener)this);
        this.m_Connection.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(JMSException jsme) {
        System.out.println("\u00b0\u00b0\u00b0\u00b0\u00b0Exit Receiver due to: " + jsme.toString());
        ReceiveR_010 receiveR_010 = this;
        synchronized (receiveR_010) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        block7: {
            try {
                MapMessage mapMessage = (MapMessage)message;
                boolean m_BooleanMessage = mapMessage.getBoolean("BooleanValue");
                byte m_ByteMessage = mapMessage.getByte("ByteValue");
                short m_ShortMessage = mapMessage.getShort("ShortValue");
                char m_CharMessage = mapMessage.getChar("CharValue");
                int m_IntMessage = mapMessage.getInt("IntValue");
                long m_LongMessage = mapMessage.getLong("LongValue");
                float m_FloatMessage = mapMessage.getFloat("FloatValue");
                double m_DoubleMessage = mapMessage.getDouble("DoubleValue");
                String m_StringMessage = mapMessage.getString("StringValue");
                if (!message.getJMSRedelivered() && !this.m_ServerShutdown && m_BooleanMessage && m_ByteMessage == 1 && m_ShortMessage == 1 && m_CharMessage == '1' && m_IntMessage == 100 && m_LongMessage == 10L && m_FloatMessage == 0.1f && m_DoubleMessage == 0.001 && m_StringMessage.equals("1")) {
                    ++this.m_NoRedeliveredMessagesReceived;
                }
                if (message.getJMSRedelivered() && !this.m_ServerShutdown && m_BooleanMessage && m_ByteMessage == 1 && m_ShortMessage == 1 && m_CharMessage == '1' && m_IntMessage == 100 && m_LongMessage == 10L && m_FloatMessage == 0.1f && m_DoubleMessage == 0.001 && m_StringMessage.equals("1")) {
                    ++this.m_RedeliveredMessagesReceived;
                }
                if ((this.m_NoRedeliveredMessagesReceived != this.m_NumberOfMessages * this.m_NumberOfSender / 2 || this.m_ServerAlreadyShutdown) && this.m_NoRedeliveredMessagesReceived + this.m_RedeliveredMessagesReceived != this.m_NumberOfMessages * this.m_NumberOfSender) break block7;
                ReceiveR_010 receiveR_010 = this;
                synchronized (receiveR_010) {
                    this.notify();
                }
            }
            catch (JMSException ex) {
                this.m_TestCase.addMessage(String.valueOf(this.toString()) + ".onMessage", 'E', ex.getMessage());
            }
        }
    }

    private void stopMessageServer() {
        ((Reliability)this.m_TestCase).stopMessageServer();
        this.m_ServerShutdown = true;
        this.m_TestCase.addMessage("stopMessageServer", 'I', "Server stopped");
        this.m_ServerAlreadyShutdown = true;
    }

    private void startMessageServer() {
        try {
            this.m_Receiver.setMessageListener(null);
            ((Reliability)this.m_TestCase).startMessageServer();
            Properties jndiProps = new Properties();
            InputStream istream = ClassLoader.getSystemClassLoader().getResourceAsStream("jndi.properties");
            jndiProps.load(istream);
            if (istream != null) {
                istream.close();
            }
            jndiProps.setProperty("jndi.port", ((SyncManTest)this.m_TestCase).getJndiPort());
            jndiProps.setProperty("jms.port", ((SyncManTest)this.m_TestCase).getMsgServerPort());
            InitialContext jndi = new InitialContext(jndiProps);
            QueueConnectionFactory conFactory = (QueueConnectionFactory)jndi.lookup("jms.QueueConnectionFactory");
            this.m_Connection = conFactory.createQueueConnection(this.m_user, this.m_password);
            this.m_ReceiveSession = this.m_Connection.createQueueSession(false, 1);
            Queue Queue2 = (Queue)jndi.lookup("jms.queue." + this.m_queue.getQueueName());
            this.m_Receiver = this.m_ReceiveSession.createReceiver(Queue2);
            this.m_Receiver.setMessageListener((MessageListener)this);
            this.m_Connection.setExceptionListener((ExceptionListener)this);
            this.m_Connection.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.m_TestCase.addMessage(String.valueOf(this.toString()) + ".startMessageServer", 'E', ex.toString());
        }
        this.m_TestCase.addMessage("startMessageServer", 'I', "Server started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            ReceiveR_010 receiveR_010 = this;
            synchronized (receiveR_010) {
                this.wait(3000 * this.m_NumberOfMessages * this.m_NumberOfSender);
            }
            this.stopMessageServer();
            Thread.sleep(20000L);
            this.m_ServerShutdown = false;
            this.startMessageServer();
            receiveR_010 = this;
            synchronized (receiveR_010) {
                this.wait(2000 * this.m_NumberOfMessages * this.m_NumberOfSender);
            }
            System.out.println("\u00b0\u00b0\u00b0\u00b0\u00b0" + this.toString() + " --> " + Integer.toString(this.m_NoRedeliveredMessagesReceived) + " Message(s) received, not redelivered");
            System.out.println("\u00b0\u00b0\u00b0\u00b0\u00b0" + this.toString() + " --> " + Integer.toString(this.m_RedeliveredMessagesReceived) + " Message(s) received, but redelivered");
            char messageType = this.m_NoRedeliveredMessagesReceived + this.m_RedeliveredMessagesReceived < this.m_NumberOfMessages * this.m_NumberOfSender ? (char)'E' : 'I';
            this.m_TestCase.addMessage(String.valueOf(this.toString()) + ".run", messageType, "Received (not redelivered): " + Integer.toString(this.m_NoRedeliveredMessagesReceived) + " Messages (MapMessage) of " + Integer.toString(this.m_NumberOfMessages * this.m_NumberOfSender / 2));
            this.m_TestCase.addMessage(String.valueOf(this.toString()) + ".run", messageType, "Received (redelivered): " + Integer.toString(this.m_RedeliveredMessagesReceived) + " Messages (MapMessage) of " + Integer.toString(this.m_NumberOfMessages * this.m_NumberOfSender / 2));
            this.close();
            System.out.println("\u00b0\u00b0\u00b0\u00b0\u00b0Wait 20 sec for Message Server .........");
            System.out.println("\u00b0\u00b0\u00b0\u00b0\u00b0....................................");
            Thread.sleep(20000L);
            this.stopMessageServer();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            this.m_TestCase.addMessage(String.valueOf(this.toString()) + ".run", 'E', ex.toString());
        }
        catch (JMSException ex) {
            ex.printStackTrace();
            this.m_TestCase.addMessage(String.valueOf(this.toString()) + ".run", 'E', ex.toString());
        }
    }
}

