/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.SyncMan.MsgService;

import com.sap.sapdb.SyncMan.SyncManTest;
import com.sap.sapdb.testframe.testcase.TestCase;
import java.io.InputStream;
import java.util.Properties;
import javax.jms.MessageListener;
import javax.naming.InitialContext;

public abstract class MsgClient
extends Thread
implements MessageListener {
    protected TestCase m_TestCase = null;
    protected int m_NumberOfSender = -1;
    protected int m_NumberOfMessages = -1;
    protected int m_NumberOfPublishers = -1;
    protected int m_MessagesSend = -1;
    protected int m_SendBlock = -1;
    protected int m_MessagesReceived = -1;
    protected int m_AcknowledgeBlock = -1;
    protected int m_DeliveryMode = -1;
    protected InitialContext m_jndi = null;
    protected String m_user = null;
    protected String m_password = null;
    protected String m_DeliveryModeAsString = null;

    public MsgClient(TestCase testCase, int deliveryMode, String user, String password, ThreadGroup group, String name) throws Exception {
        super(group, name);
        this.setDaemon(true);
        this.m_user = user;
        this.m_password = password;
        this.m_DeliveryMode = deliveryMode;
        this.m_TestCase = testCase;
        if (this.m_DeliveryMode == 2) {
            this.m_DeliveryModeAsString = "PERSISTENT";
        }
        if (this.m_DeliveryMode == 1) {
            this.m_DeliveryModeAsString = "NON_PERSISTENT";
        }
        Properties jndiProps = new Properties();
        InputStream istream = ClassLoader.getSystemClassLoader().getResourceAsStream("jndi.properties");
        jndiProps.load(istream);
        if (istream != null) {
            istream.close();
        }
        jndiProps.setProperty("jndi.port", ((SyncManTest)testCase).getJndiPort());
        jndiProps.setProperty("jms.port", ((SyncManTest)testCase).getMsgServerPort());
        this.m_jndi = new InitialContext(jndiProps);
        this.m_NumberOfSender = 1;
        this.m_NumberOfPublishers = 1;
        this.m_NumberOfMessages = 100;
        this.m_MessagesSend = 0;
        this.m_SendBlock = 0;
        this.m_MessagesReceived = 0;
        this.m_AcknowledgeBlock = 0;
    }
}

