/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.SyncMan.MsgService.DurableSub;

import com.sap.sapdb.SyncMan.MsgService.MsgTopicClient;
import com.sap.sapdb.SyncMan.SyncManTest;
import com.sap.sapdb.testframe.testcase.TestCase;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;

public class SubPubD_011
extends MsgTopicClient {
    private boolean m_AlreadyStop = false;
    private int m_MessagesReceivedUntilNow = 0;
    private int m_CommitBlock;
    private int m_RollbackPublish = 0;
    private int m_CommitPublish = 0;
    private int m_RollbackSubscribe = 0;
    private int m_CommitSubscribe = 0;
    private int m_SentBlock;

    public SubPubD_011(TestCase aTestCase, ThreadGroup aThreadGroup, String topicName, String user, String password, String id, int deliveryMode) throws Exception {
        super(aTestCase, deliveryMode, topicName, user, password, "", true, 1, true, 1, true, aThreadGroup, "SubPubD_010" + id);
        this.m_Subscriber.setMessageListener((MessageListener)this);
        this.m_Connection.start();
    }

    protected void writeMessage() throws JMSException {
        TextMessage message = this.m_PubSession.createTextMessage();
        message.setJMSDeliveryMode(this.m_DeliveryMode);
        int i = 0;
        while (i < 10) {
            String text = Integer.toString(this.m_SentBlock);
            message.setIntProperty("CommitBlock", this.m_SentBlock);
            message.setText(text);
            this.m_Publisher.publish((Message)message);
            ++this.m_MessagesSend;
            ++i;
        }
        ++this.m_SentBlock;
        if (this.m_SentBlock % 2 == 1) {
            this.m_PubSession.commit();
            ++this.m_CommitPublish;
        } else {
            this.m_PubSession.rollback();
            ++this.m_RollbackPublish;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        block9: {
            try {
                TextMessage textMessage = (TextMessage)message;
                this.m_CommitBlock = textMessage.getIntProperty("CommitBlock");
                int i = 0;
                while (i < this.m_NumberOfMessages * this.m_NumberOfPublishers / 10) {
                    String text;
                    if (this.m_CommitBlock == i && (text = textMessage.getText()).equalsIgnoreCase(Integer.toString(this.m_CommitBlock))) {
                        ++this.m_MessagesReceived;
                        if (this.m_MessagesReceived % 2 == 0) {
                            this.m_SubSession.rollback();
                            ++this.m_RollbackSubscribe;
                        } else {
                            this.m_SubSession.commit();
                            ++this.m_CommitSubscribe;
                        }
                    }
                    ++i;
                }
                if (this.m_MessagesReceived != this.m_NumberOfMessages * this.m_NumberOfPublishers * 2 + 1) break block9;
                SubPubD_011 subPubD_011 = this;
                synchronized (subPubD_011) {
                    this.notify();
                }
            }
            catch (JMSException ex) {
                this.m_TestCase.addMessage(String.valueOf(this.toString()) + ".onMessage", 'E', ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.m_TestCase.addMessage(String.valueOf(this.toString()) + ".run", 'I', "Start writing Messages.");
            while (this.m_MessagesSend < this.m_NumberOfMessages * this.m_NumberOfPublishers * 2) {
                this.writeMessage();
            }
            this.m_PubSession.commit();
            System.out.println("\u00b0\u00b0\u00b0\u00b0\u00b0" + this.toString() + " --> " + this.m_CommitPublish * 10 + " Message(s) published (commit) ... DeliveryMode: " + this.m_DeliveryModeAsString);
            System.out.println("\u00b0\u00b0\u00b0\u00b0\u00b0" + this.toString() + " --> " + this.m_RollbackPublish * 10 + " Message(s) published (rollback) ... DeliveryMode: " + this.m_DeliveryModeAsString);
            this.m_TestCase.addMessage(String.valueOf(this.toString()) + ".run", 'I', "Sent: " + Integer.toString(this.m_MessagesSend) + " Messages (map),stopped sending Messages, thereof " + this.m_RollbackSubscribe * 10 + " Rollbacks and " + this.m_CommitSubscribe * 10 + " Commits ... DeliveryMode: " + this.m_DeliveryModeAsString);
            SubPubD_011 subPubD_011 = this;
            synchronized (subPubD_011) {
                while (true) {
                    if (this.m_MessagesReceived >= this.m_NumberOfMessages * this.m_NumberOfPublishers / 6 && !this.m_AlreadyStop) {
                        this.closeSub();
                        this.m_MessagesReceivedUntilNow = this.m_MessagesReceived;
                        try {
                            this.wait(20000L);
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                            this.m_TestCase.addMessage(String.valueOf(this.toString()) + ".run", 'E', ex.toString());
                        }
                        this.startSub();
                        this.m_AlreadyStop = true;
                    }
                    if (this.m_MessagesReceived >= this.m_NumberOfMessages * this.m_NumberOfPublishers / 2 && this.m_AlreadyStop) {
                        this.unSubscribeSub();
                        this.m_MessagesReceivedUntilNow = this.m_MessagesReceived;
                        try {
                            this.wait(20000L);
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                            this.m_TestCase.addMessage(String.valueOf(this.toString()) + ".run", 'E', ex.toString());
                        }
                        this.startSub();
                        try {
                            this.wait(20000L);
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                            this.m_TestCase.addMessage(String.valueOf(this.toString()) + ".run", 'I', ex.toString());
                        }
                        if (this.m_MessagesReceivedUntilNow == this.m_MessagesReceived) {
                            this.m_TestCase.addMessage(String.valueOf(this.toString()) + ".run", 'I', "No more messages subscribed");
                            break;
                        }
                        this.m_TestCase.addMessage(String.valueOf(this.toString()) + ".run", 'E', "More messages subscribed");
                        break;
                    }
                    this.wait(100L);
                }
            }
            System.out.println("\u00b0\u00b0\u00b0\u00b0\u00b0" + this.toString() + " --> " + this.m_MessagesReceived + " Message(s) received");
            char messageType = this.m_MessagesReceived > 0 && this.m_MessagesReceivedUntilNow > 0 && this.m_MessagesReceived >= this.m_MessagesReceivedUntilNow ? (char)'I' : 'E';
            this.m_TestCase.addMessage(String.valueOf(this.toString()) + ".run", messageType, "Received until Subscriber.close(): " + Integer.toString(this.m_MessagesReceivedUntilNow) + SyncManTest.LSEP + "   Received until m_SubSession.unsubscribe(Subscriber): " + Integer.toString(this.m_MessagesReceived) + SyncManTest.LSEP + "   Messages (text) of " + Integer.toString(this.m_NumberOfMessages * this.m_NumberOfPublishers));
            this.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.m_TestCase.addMessage(String.valueOf(this.toString()) + ".run", 'E', ex.toString());
        }
    }
}

