/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.util;

import com.sap.sdb.syncMan.util.DebugOutput;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;

public class ConnectionPool {
    private int m_databaseType;
    private String m_databaseURL;
    private String m_jdbcDriver;
    private String m_username;
    private String m_password;
    private String m_schemaName;
    private LinkedList m_connectionList;
    private static ConnectionPool s_connectionPool = null;
    private static final int DB_NONE = 0;
    private static final int MAXDB = 1;
    private static final int MINDB = 2;
    private static final int MYSQL = 3;
    private static final int FOREIGN_DB = 4;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ConnectionPool(String jdbcDriver, String databaseURL, String hostName, String databaseName, String username, String password) throws Exception {
        String db_name = databaseName;
        this.m_databaseType = 0;
        this.m_databaseURL = databaseURL;
        this.m_jdbcDriver = jdbcDriver;
        this.m_schemaName = "SYNCHRONIZATIONSERVICE";
        if (this.m_jdbcDriver.startsWith("com.sap.dbtech.jdbc.DriverSapDB")) {
            this.m_databaseType = 1;
        } else if (this.m_jdbcDriver.startsWith("com.sap.sdb.minDB")) {
            this.m_databaseType = 2;
        } else if (this.m_jdbcDriver.startsWith("com.mysql.jdbc.Driver")) {
            this.m_databaseType = 3;
            this.m_schemaName = db_name;
        } else {
            this.m_databaseType = 4;
        }
        if (this.m_databaseURL == null) {
            if (this.m_databaseType != 1) throw new Exception("cannot create database URL for non-MaxDB JDBC Driver. Please specify URL explicitly.");
            this.m_databaseURL = "jdbc:sapdb://" + hostName + "/" + db_name + "?timeout=0";
        } else {
            int hostnameLen;
            int dbnameStart;
            int uriStart = this.m_databaseURL.indexOf("//") + 2;
            int qMarkPos = this.m_databaseURL.indexOf("?", dbnameStart = uriStart + (hostnameLen = this.m_databaseURL.indexOf("/", uriStart) - uriStart) + 1);
            db_name = this.m_databaseURL.substring(dbnameStart, qMarkPos != -1 ? qMarkPos : this.m_databaseURL.length());
        }
        this.m_username = username.startsWith("\"") && username.endsWith("\"") ? username.substring(1, username.length() - 1) : username.toUpperCase();
        this.m_password = password.startsWith("\"") && password.endsWith("\"") ? password.substring(1, password.length() - 1) : password.toUpperCase();
        this.m_connectionList = new LinkedList();
        try {
            Class.forName(this.m_jdbcDriver);
            return;
        }
        catch (ClassNotFoundException ex) {
            throw new SQLException(ex.toString());
        }
    }

    private static void checkInstance() throws IllegalStateException {
        if (s_connectionPool == null) {
            throw new IllegalStateException("ConnectionPool singleton not created.");
        }
    }

    private void cleanUp() {
        Iterator iter = this.m_connectionList.iterator();
        while (iter.hasNext()) {
            Connection conn = (Connection)iter.next();
            try {
                conn.rollback();
            }
            catch (SQLException ex) {
                DebugOutput.printException(ex);
            }
            try {
                conn.close();
            }
            catch (SQLException ex) {
                DebugOutput.printException(ex);
            }
        }
    }

    public static synchronized void createInstance(String jdbcDriver, String databaseURL, String hostName, String databaseName, String userName, String password) throws Exception {
        if (s_connectionPool != null) {
            throw new IllegalStateException("ConnectionPool singleton already created.");
        }
        s_connectionPool = new ConnectionPool(jdbcDriver, databaseURL, hostName, databaseName, userName, password);
    }

    public static synchronized void createInstance(String databaseURL, String jdbcDriver, String userName, String password) throws Exception {
        if (s_connectionPool != null) {
            throw new IllegalStateException("ConnectionPool singleton already created.");
        }
        s_connectionPool = new ConnectionPool(jdbcDriver, databaseURL, null, null, userName, password);
    }

    public static synchronized void destroyInstance() {
        if (s_connectionPool != null) {
            s_connectionPool.cleanUp();
            s_connectionPool = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeConnection(Connection connection) throws SQLException, IllegalStateException {
        if (connection == null) {
            return;
        }
        connection.rollback();
        Class clazz = ConnectionPool.class;
        synchronized (clazz) {
            if (s_connectionPool != null) {
                ConnectionPool.s_connectionPool.m_connectionList.add(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection() throws SQLException, IllegalStateException {
        Connection connection = null;
        String url = null;
        String username = null;
        String password = null;
        Class clazz = ConnectionPool.class;
        synchronized (clazz) {
            ConnectionPool.checkInstance();
            if (!ConnectionPool.s_connectionPool.m_connectionList.isEmpty()) {
                connection = (Connection)ConnectionPool.s_connectionPool.m_connectionList.removeFirst();
            }
            if (connection == null) {
                url = ConnectionPool.s_connectionPool.m_databaseURL;
                username = ConnectionPool.s_connectionPool.m_username;
                password = ConnectionPool.s_connectionPool.m_password;
            }
        }
        if (connection == null) {
            if (ConnectionPool.s_connectionPool.m_databaseType == 1) {
                connection = DriverManager.getConnection(url, "\"" + username + "\"", "\"" + password + "\"");
                ConnectionPool.setReplicationSession(connection);
            } else {
                connection = DriverManager.getConnection(url, username, password);
            }
        }
        connection.setAutoCommit(false);
        if (!ConnectionPool.isMinDB()) {
            connection.setTransactionIsolation(2);
        }
        return connection;
    }

    private static String getHex2String(byte[] bytearr) {
        if (bytearr == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        for (int k = 0; k < bytearr.length; ++k) {
            if ((bytearr[k] & 0xFF) < 16) {
                sb.append("0");
            }
            sb.append(Integer.toString(bytearr[k] & 0xFF, 16));
        }
        return sb.toString();
    }

    public static synchronized String getReplicationUserName() throws IllegalStateException {
        if (s_connectionPool != null) {
            return ConnectionPool.s_connectionPool.m_username;
        }
        throw new IllegalStateException("ConnectionPool singleton not created.");
    }

    public static synchronized String getReplicationUserPassword() throws IllegalStateException {
        if (s_connectionPool != null) {
            return ConnectionPool.s_connectionPool.m_password;
        }
        throw new IllegalStateException("ConnectionPool singleton not created.");
    }

    public static String getSchema() throws IllegalStateException {
        if (s_connectionPool != null) {
            return ConnectionPool.s_connectionPool.m_schemaName;
        }
        throw new IllegalStateException("ConnectionPool singleton not created.");
    }

    private static byte[] internalSetReplicationSession(Connection dbCon) throws SQLException {
        byte[] seed = null;
        try {
            CallableStatement call = dbCon.prepareCall("SET SESSION REPLICATION ?");
            call.registerOutParameter(1, -2);
            call.execute();
            seed = call.getBytes(1);
            call.close();
        }
        catch (SQLException ex) {
            if (ConnectionPool.isMissingReplicationPrivilege(ex)) {
                throw new SQLException("Missing replication privilege [" + ex.getErrorCode() + "]", ex.getSQLState(), ex.getErrorCode());
            }
            throw ex;
        }
        int crypt = 8003;
        byte[] cryptBuffer = new byte[8];
        for (int ix = 0; ix < 8; ++ix) {
            crypt = (crypt * 214013 + 2531011) / 65536 % 8193;
            cryptBuffer[ix] = (byte)(crypt * seed[ix] % 256);
        }
        return cryptBuffer;
    }

    public static synchronized boolean isDuplicateKey(Exception ex) throws IllegalStateException {
        if (s_connectionPool != null) {
            boolean retval = false;
            switch (ConnectionPool.s_connectionPool.m_databaseType) {
                case 1: {
                    SQLException sqlex;
                    if (!(ex instanceof SQLException) || (sqlex = (SQLException)ex).getErrorCode() != 200) break;
                    retval = true;
                    break;
                }
                case 2: {
                    SQLException sqlex;
                    if (!(ex instanceof SQLException) || (sqlex = (SQLException)ex).getErrorCode() != 200) break;
                    retval = true;
                    break;
                }
                case 3: {
                    SQLException sqlex;
                    if (!(ex instanceof SQLException) || (sqlex = (SQLException)ex).getErrorCode() != 1062) break;
                    retval = true;
                    break;
                }
            }
            return retval;
        }
        throw new IllegalStateException("ConnectionPool singleton not created.");
    }

    public static synchronized boolean isMaxDB() throws IllegalStateException {
        if (s_connectionPool != null) {
            return ConnectionPool.s_connectionPool.m_databaseType == 1;
        }
        throw new IllegalStateException("ConnectionPool singleton not created.");
    }

    public static synchronized boolean isMinDB() throws IllegalStateException {
        if (s_connectionPool != null) {
            return ConnectionPool.s_connectionPool.m_databaseType == 2;
        }
        throw new IllegalStateException("ConnectionPool singleton not created.");
    }

    private static synchronized boolean isMissingReplicationPrivilege(Exception ex) throws IllegalStateException {
        if (s_connectionPool != null) {
            boolean retval = false;
            switch (ConnectionPool.s_connectionPool.m_databaseType) {
                case 1: {
                    SQLException sqlex;
                    if (!(ex instanceof SQLException) || (sqlex = (SQLException)ex).getErrorCode() != -5009) break;
                    retval = true;
                    break;
                }
            }
            return retval;
        }
        throw new IllegalStateException("ConnectionPool singleton not created.");
    }

    public static synchronized boolean isMySQL() throws IllegalStateException {
        if (s_connectionPool != null) {
            return ConnectionPool.s_connectionPool.m_databaseType == 3;
        }
        throw new IllegalStateException("ConnectionPool singleton not created.");
    }

    public static synchronized boolean isWorkRolledBackOrTimeout(Exception ex) throws IllegalStateException {
        if (s_connectionPool != null) {
            boolean retval = false;
            switch (ConnectionPool.s_connectionPool.m_databaseType) {
                case 1: {
                    if (!(ex instanceof SQLException)) break;
                    SQLException sqlex = (SQLException)ex;
                    if (sqlex.getErrorCode() == 600) {
                        retval = true;
                    }
                    if (sqlex.getErrorCode() != 500) break;
                    retval = true;
                    break;
                }
                case 2: {
                    SQLException sqlex;
                    if (!(ex instanceof SQLException) || (sqlex = (SQLException)ex).getErrorCode() != 500) break;
                    retval = true;
                    break;
                }
                case 3: {
                    if (!(ex instanceof SQLException)) break;
                    SQLException sqlex = (SQLException)ex;
                    if (sqlex.getErrorCode() == 1205) {
                        retval = true;
                    }
                    if (sqlex.getErrorCode() != 1206) break;
                    retval = true;
                    break;
                }
            }
            return retval;
        }
        throw new IllegalStateException("ConnectionPool singleton not created.");
    }

    public static void setReplicationSession(Connection dbCon) throws SQLException {
        byte[] cryptBuffer = ConnectionPool.internalSetReplicationSession(dbCon);
        String setSessionStatement = "SET SESSION REPLICATION x'" + ConnectionPool.getHex2String(cryptBuffer) + "' WITH TRIGGER INTERNAL";
        Statement stmt = dbCon.createStatement();
        stmt.execute(setSessionStatement);
        stmt.close();
        dbCon.commit();
    }
}

