/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.message;

import com.sap.sdb.syncMan.message.SyncManMessage;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;

public class RowReceiveMessage
extends SyncManMessage {
    private transient HashMap m_afterImageColMap = new HashMap();
    private transient HashMap m_beforeImageColMap = null;

    RowReceiveMessage() {
    }

    void deserialize(BytesMessage bytesMsg) throws JMSException {
        int columnCount = bytesMsg.readInt();
        for (int i = 0; i < columnCount; ++i) {
            this.deserializeColumn(bytesMsg);
        }
    }

    private void deserializeColumn(BytesMessage bytesMsg) throws JMSException {
        Object obj = null;
        HashMap colMap = this.m_afterImageColMap;
        if (bytesMsg.readByte() == 0) {
            if (this.m_beforeImageColMap == null) {
                this.m_beforeImageColMap = new HashMap();
            }
            colMap = this.m_beforeImageColMap;
        }
        Long columnID = new Long(bytesMsg.readLong());
        int columnType = bytesMsg.readInt();
        if (columnType != 0) {
            switch (columnType) {
                case 5: {
                    obj = new Short(bytesMsg.readShort());
                    break;
                }
                case 4: {
                    obj = new Integer(bytesMsg.readInt());
                    break;
                }
                case 8: {
                    obj = new Double(bytesMsg.readDouble());
                    break;
                }
                case -1: 
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 12: {
                    obj = bytesMsg.readUTF();
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    obj = this.readByteArray(bytesMsg);
                    break;
                }
                default: {
                    obj = this.readObject(bytesMsg);
                }
            }
        }
        colMap.put(columnID, obj);
    }

    public String getAckDestId() {
        return null;
    }

    public HashMap getBeforeImageData() {
        return this.m_beforeImageColMap;
    }

    public HashMap getData() {
        return this.m_afterImageColMap;
    }

    private byte[] readByteArray(BytesMessage msg) throws JMSException {
        int len = msg.readInt();
        if (len < 0) {
            return null;
        }
        byte[] byteArray = new byte[len];
        if (len > 0) {
            msg.readBytes(byteArray);
        }
        return byteArray;
    }

    private Object readObject(BytesMessage msg) throws JMSException {
        try {
            byte[] byteArray = this.readByteArray(msg);
            ByteArrayInputStream byteStream = new ByteArrayInputStream(byteArray);
            ObjectInputStream objStream = new ObjectInputStream(byteStream);
            Object obj = objStream.readObject();
            objStream.close();
            return obj;
        }
        catch (JMSException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JMSException(ex.toString());
        }
    }

    public String toString() {
        return "\r\nRECEIVE: " + super.toString() + this.colMapToString(true) + this.colMapToString(false);
    }

    private String colMapToString(boolean afterImage) {
        String image;
        HashMap colMap = afterImage ? this.m_afterImageColMap : this.m_beforeImageColMap;
        String string = image = afterImage ? " AFTER " : " BEFORE";
        if (colMap == null) {
            return "";
        }
        try {
            int colCount = 0;
            StringBuffer str = new StringBuffer(256);
            Iterator iter = colMap.entrySet().iterator();
            while (iter.hasNext()) {
                ++colCount;
                Map.Entry currEntry = iter.next();
                Object obj = currEntry.getValue();
                str.append("\r\n");
                str.append("   ");
                str.append(colCount);
                str.append(image);
                str.append(" colID=");
                str.append(((Long)currEntry.getKey()).toString());
                str.append(", value=");
                if (obj == null) {
                    str.append("null");
                    continue;
                }
                if (obj instanceof byte[]) {
                    str.append("<byte[");
                    str.append(((byte[])obj).length);
                    str.append("]>");
                    continue;
                }
                String objstr = obj.toString();
                if (objstr.length() > 48) {
                    str.append(objstr.substring(0, 48));
                    str.append("...");
                    continue;
                }
                str.append(objstr);
            }
            return str.toString();
        }
        catch (Exception ex) {
            return "\r\n   *** colMapToString: " + ex.getMessage();
        }
    }
}

