/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.consumption;

import com.sap.sdb.syncMan.consumption.TableConsumptionSQLHandler;
import com.sap.sdb.syncMan.definition.ReplicationTable;
import com.sap.sdb.syncMan.message.RowReceiveMessage;
import com.sap.sdb.syncMan.util.ConnectionPool;
import com.sap.sdb.syncMan.util.DebugOutput;
import com.sap.sdb.syncMan.util.SQLBuilder;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Hashtable;

public class MySQLTableConsumptionSQLHandler
extends TableConsumptionSQLHandler {
    private Hashtable m_insertCache = new Hashtable();
    private Hashtable m_deleteCache = new Hashtable();
    private Hashtable m_updateVersionCache;
    private Hashtable m_insertVersionCache;
    private Hashtable m_deleteFromVersionTableCache;
    private Hashtable m_lockDataRowCache;
    private Hashtable m_unlockDataRowCache;
    private Hashtable m_insertShadowTableEntryForRefreshCache;
    private Hashtable m_insertShadowTableEntryForRefreshEchoCache;
    private Hashtable m_insertTransactionTableEntryForRefreshCache;
    private Hashtable m_rowVersionMatchesCache;
    private Hashtable m_setSourceClientIDInShadowTableCache;
    private Hashtable m_updateColumnGroupVersionInShadowTableCache;
    private Hashtable m_columnGroupVersionMatchesCache;
    private Hashtable m_setReceivedVersionsCache;
    private Hashtable m_setReceivedVersionsInShadowTableCache;
    private Hashtable m_auditMsgCache;
    private Hashtable m_updateCache = new Hashtable();
    private String m_keyClauseSQL = " where ";
    private String m_versionKeyClauseSQL = " where ";
    private String m_updateStartSQL;
    private String m_insertStmtSQL;
    private String m_deleteStmtSQL;
    private String m_updateVersionSQL;
    private String m_insertVersionSQL;
    private String m_deleteFromVersionTableSQL;
    private String m_lockDataRowSQL;
    private String m_unlockDataRowSQL;
    private String m_insertShadowTableEntryForRefreshSQL;
    private String m_insertShadowTableEntryForRefreshEchoSQL;
    private String m_insertTransactionTableEntryForRefreshSQL;
    private String m_rowVersionSQL;
    private String m_rowVersionMatchesSQL;
    private String m_updateColumnGroupVersionInShadowTableSQL;
    private String m_setSourceClientIDInShadowTableSQL;
    private String m_columnGroupVersionMatchesSQL;
    private String m_setReceivedVersionsSQL;
    private String m_setReceivedVersionsInShadowTableSQL;
    private String m_auditMsgSQL;

    public MySQLTableConsumptionSQLHandler(ReplicationTable table) throws Exception {
        super(table);
        int key_idx;
        int i;
        int i2;
        int key_idx2;
        this.m_updateVersionCache = new Hashtable();
        this.m_insertVersionCache = new Hashtable();
        this.m_deleteFromVersionTableCache = new Hashtable();
        this.m_lockDataRowCache = new Hashtable();
        this.m_unlockDataRowCache = new Hashtable();
        this.m_insertShadowTableEntryForRefreshCache = new Hashtable();
        this.m_insertShadowTableEntryForRefreshEchoCache = new Hashtable();
        this.m_insertTransactionTableEntryForRefreshCache = new Hashtable();
        this.m_rowVersionMatchesCache = new Hashtable();
        this.m_setSourceClientIDInShadowTableCache = new Hashtable();
        this.m_updateColumnGroupVersionInShadowTableCache = new Hashtable();
        this.m_columnGroupVersionMatchesCache = new Hashtable();
        this.m_setReceivedVersionsCache = new Hashtable();
        this.m_setReceivedVersionsInShadowTableCache = new Hashtable();
        this.m_auditMsgCache = new Hashtable();
        String insertStartSQL = "insert into " + table.getTableName().getSQLTableName() + " ";
        this.m_updateStartSQL = "update " + table.getTableName().getSQLTableName() + " ";
        String deleteStartSQL = "delete from  " + table.getTableName().getSQLTableName() + " ";
        this.m_lockDataRowSQL = "lock tables " + table.getTableName().getSQLTableName() + " write";
        this.m_unlockDataRowSQL = "unlock tables";
        for (key_idx2 = 0; key_idx2 < this.m_key_count; ++key_idx2) {
            this.m_keyClauseSQL = this.m_keyClauseSQL + "`" + this.m_keyNames[key_idx2] + "`" + "= ? ";
            if (key_idx2 >= this.m_key_count - 1) continue;
            this.m_keyClauseSQL = this.m_keyClauseSQL + " and ";
        }
        for (key_idx2 = 0; key_idx2 < this.m_key_count; ++key_idx2) {
            this.m_versionKeyClauseSQL = this.m_versionKeyClauseSQL + "`_" + this.m_keyNames[key_idx2] + "`" + "= ? ";
            if (key_idx2 >= this.m_key_count - 1) continue;
            this.m_versionKeyClauseSQL = this.m_versionKeyClauseSQL + " and ";
        }
        String insert_set_exprSQL = "set ";
        for (i2 = 0; i2 < this.m_key_count; ++i2) {
            if (i2 != 0) {
                insert_set_exprSQL = insert_set_exprSQL + ",";
            }
            insert_set_exprSQL = insert_set_exprSQL + "`" + this.m_keyNames[i2] + "`" + "=?";
        }
        for (i2 = 0; i2 < this.m_non_key_count; ++i2) {
            insert_set_exprSQL = insert_set_exprSQL + ",";
            insert_set_exprSQL = insert_set_exprSQL + "`" + this.m_nonKeyNames[i2] + "`" + "=?";
        }
        this.m_insertStmtSQL = insertStartSQL + insert_set_exprSQL;
        this.m_deleteStmtSQL = deleteStartSQL + this.m_keyClauseSQL;
        this.m_updateVersionSQL = "update " + table.getVersionTableName().getSQLTableName() + " set `" + "COL_GROUP_VERSION" + "`=? " + this.m_versionKeyClauseSQL;
        this.m_deleteFromVersionTableSQL = "delete from " + table.getVersionTableName().getSQLTableName() + this.m_versionKeyClauseSQL;
        String insert_version_set_exprSQL = " set `ROW_VERSION`=?, `COL_GROUP_VERSION`=?, `ROW_CREATOR`=?, `LAST_UPDATER`=? ";
        String insert_version_key_setSQL = " ";
        for (i = 0; i < this.m_key_count; ++i) {
            insert_version_key_setSQL = insert_version_key_setSQL + ", `_" + this.m_keyNames[i] + "`" + "=? ";
        }
        this.m_insertVersionSQL = "insert into " + table.getVersionTableName().getSQLTableName() + insert_version_set_exprSQL + insert_version_key_setSQL;
        this.m_setReceivedVersionsInShadowTableSQL = "update " + table.getShadowTableName().getSQLTableName() + " set " + "`" + "ROW_VERSION" + "`=?, " + "`" + "COL_GROUP_VERSION" + "`=?, " + "`" + "ROW_CREATOR" + "`=?, " + "`" + "UPDATER_ID" + "`=? " + this.m_versionKeyClauseSQL + " and `" + "REP_TRANSID" + "` = TRANSACTION" + " and `" + "UPDATER_ID" + "` = " + -2;
        this.m_setReceivedVersionsSQL = "update " + table.getVersionTableName().getSQLTableName() + insert_version_set_exprSQL + this.m_versionKeyClauseSQL;
        this.m_insertShadowTableEntryForRefreshSQL = "insert into " + table.getShadowTableName().getSQLTableName() + "( ";
        for (i = 0; i < this.m_key_count; ++i) {
            this.m_insertShadowTableEntryForRefreshSQL = this.m_insertShadowTableEntryForRefreshSQL + "`_" + this.m_keyNames[i] + "`" + ",";
        }
        for (i = 0; i < this.m_non_key_count; ++i) {
            this.m_insertShadowTableEntryForRefreshSQL = this.m_insertShadowTableEntryForRefreshSQL + "`_" + this.m_nonKeyNames[i] + "`" + ",";
        }
        this.m_insertShadowTableEntryForRefreshSQL = this.m_insertShadowTableEntryForRefreshSQL + "`REP_TRANSID`, `REP_COUNTER`, `REP_TYPE`, `REP_CHANGE`, `ROW_CREATOR`, `ROW_VERSION`, `COL_GROUP_VERSION`, `UPDATER_ID` ) select ";
        for (i = 0; i < this.m_key_count; ++i) {
            this.m_insertShadowTableEntryForRefreshSQL = this.m_insertShadowTableEntryForRefreshSQL + "d.`" + this.m_keyNames[i] + "`" + ", ";
        }
        for (i = 0; i < this.m_non_key_count; ++i) {
            this.m_insertShadowTableEntryForRefreshSQL = this.m_insertShadowTableEntryForRefreshSQL + "d.`" + this.m_nonKeyNames[i] + "`" + ", ";
        }
        this.m_insertShadowTableEntryForRefreshSQL = this.m_insertShadowTableEntryForRefreshSQL + "TRANSACTION, " + this.m_sequenceSQLName + ".NEXTVAL, " + "?, " + "?, " + "v.`" + "ROW_CREATOR" + "`, " + "v.`" + "ROW_VERSION" + "`, " + "v.`" + "COL_GROUP_VERSION" + "`, " + "v.`" + "LAST_UPDATER" + "`" + " from " + table.getTableName().getSQLTableName() + " d, " + table.getVersionTableName().getSQLTableName() + " v" + " where ";
        for (key_idx = 0; key_idx < this.m_key_count; ++key_idx) {
            this.m_insertShadowTableEntryForRefreshSQL = this.m_insertShadowTableEntryForRefreshSQL + "d.`" + this.m_keyNames[key_idx] + "`" + "=?";
            this.m_insertShadowTableEntryForRefreshSQL = this.m_insertShadowTableEntryForRefreshSQL + " and ";
        }
        for (key_idx = 0; key_idx < this.m_key_count; ++key_idx) {
            this.m_insertShadowTableEntryForRefreshSQL = this.m_insertShadowTableEntryForRefreshSQL + "d.`" + this.m_keyNames[key_idx] + "`" + "= " + "v.`" + "_" + this.m_keyNames[key_idx] + "`";
            if (key_idx >= this.m_key_count - 1) continue;
            this.m_insertShadowTableEntryForRefreshSQL = this.m_insertShadowTableEntryForRefreshSQL + " and ";
        }
        this.m_insertShadowTableEntryForRefreshEchoSQL = "insert into " + table.getShadowTableName().getSQLTableName() + "( " + "`" + "REP_TRANSID" + "`, `" + "REP_COUNTER" + "`, `" + "REP_TYPE" + "`, `" + "ROW_CREATOR" + "`, `" + "ROW_VERSION" + "`, `" + "UPDATER_ID" + "` " + " ) values ( " + "TRANSACTION, " + this.m_sequenceSQLName + ".NEXTVAL, " + 6 + ", " + " ?, " + " ?, " + " ? " + " ) ";
        this.m_insertTransactionTableEntryForRefreshSQL = "insert into `" + table.getUnit().getSchema().getSchemaName() + "`." + "`" + "REPLICATION_TRANSACTION_LIST" + "`" + " ( " + "`" + "REP_TRANSID" + "`" + ", " + "`" + "TABLE_SCHEMA" + "`" + ", " + "`" + "TABLE_NAME" + "`" + ", " + "`" + "REP_SEQ" + "`" + " ) values ( " + "TRANSACTION, " + "'" + table.getTableName().getOwner() + "' , " + "'" + table.getTableName().getIdentifier() + "' , " + this.m_sequenceSQLName + ".NEXTVAL ) update duplicates";
        this.m_rowVersionSQL = "select `ROW_CREATOR`, `ROW_VERSION` from " + table.getVersionTableName().getSQLTableName() + this.m_versionKeyClauseSQL;
        this.m_rowVersionMatchesSQL = this.m_rowVersionSQL + " and " + "`" + "ROW_CREATOR" + "`" + " = ?" + " and " + "`" + "ROW_VERSION" + "`" + " = ?";
        this.m_setSourceClientIDInShadowTableSQL = "update " + table.getShadowTableName().getSQLTableName() + " set " + "`" + "UPDATER_ID" + "`" + "=? " + this.m_versionKeyClauseSQL + " and " + "`" + "REP_TRANSID" + "`" + " = TRANSACTION" + " and " + "`" + "UPDATER_ID" + "`" + " = " + -2;
        this.m_updateColumnGroupVersionInShadowTableSQL = "update " + table.getShadowTableName().getSQLTableName() + " set " + "`" + "UPDATER_ID" + "`" + "=? " + this.m_versionKeyClauseSQL + " and " + "`" + "REP_TRANSID" + "`" + " = TRANSACTION" + " and " + "`" + "UPDATER_ID" + "`" + " = " + -2;
        this.m_columnGroupVersionMatchesSQL = "select `COL_GROUP_VERSION` from " + table.getVersionTableName().getSQLTableName() + this.m_versionKeyClauseSQL;
        this.m_auditMsgSQL = "insert into " + table.getAuditTableName().getSQLTableName() + "( ";
        for (i = 0; i < this.m_key_count; ++i) {
            this.m_auditMsgSQL = this.m_auditMsgSQL + "`_" + this.m_keyNames[i] + "`" + ",";
        }
        this.m_auditMsgSQL = this.m_auditMsgSQL + "`LAST_UPDATER`, `AUDIT_TIME`, `CONFLICT_TYPE`, `ROW_CREATOR`, `ROW_VERSION`, `REP_TYPE`  ) values ( ";
        for (i = 0; i < this.m_key_count; ++i) {
            this.m_auditMsgSQL = this.m_auditMsgSQL + " ?, ";
        }
        this.m_auditMsgSQL = this.m_auditMsgSQL + " ?, TIMESTAMP,  ?,  ?,  ?,  ?  ) ";
    }

    public boolean executeInsertMessage(Connection konnek, RowReceiveMessage msg) throws Exception {
        boolean retval = false;
        int changeCount = 0;
        PreparedStatement pstmt = null;
        pstmt = this.paramInsert(konnek, msg);
        try {
            changeCount = pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            if (ConnectionPool.isDuplicateKey(sqle)) {
                changeCount = 0;
            }
            throw sqle;
        }
        retval = changeCount > 0;
        return retval;
    }

    public boolean executeUpdateMessage(Connection konnek, RowReceiveMessage msg) throws Exception {
        boolean retval = false;
        int changeCount = 0;
        PreparedStatement pstmt = null;
        pstmt = this.paramUpdate(konnek, msg);
        changeCount = pstmt.executeUpdate();
        retval = changeCount > 0;
        return retval;
    }

    public boolean executeDeleteMessage(Connection konnek, RowReceiveMessage msg) throws Exception {
        boolean retval = false;
        int changeCount = 0;
        PreparedStatement pstmt = null;
        pstmt = this.paramDelete(konnek, msg);
        changeCount = pstmt.executeUpdate();
        retval = changeCount > 0;
        return retval;
    }

    public void updateColumnGroupVersionInVersionTable(Connection konnek, RowReceiveMessage msg) throws Exception {
        HashMap data = msg.getData();
        long version = msg.getColGroupVersion();
        PreparedStatement pstmt = this.getCachedPStatement(konnek, this.m_updateVersionCache, this.m_updateVersionSQL);
        pstmt.setLong(1, version);
        for (int i = 0; i < this.m_key_count; ++i) {
            Object dobj = data.get(this.m_keyIDs[i]);
            this.setParam(dobj, i + 2, pstmt, this.m_keyTypes[i]);
        }
        pstmt.executeUpdate();
    }

    public void deleteVersion(Connection konnek, RowReceiveMessage msg) throws Exception {
        PreparedStatement pstmt = this.getCachedPStatement(konnek, this.m_deleteFromVersionTableCache, this.m_deleteFromVersionTableSQL);
        for (int i = 0; i < this.m_key_count; ++i) {
            Object dobj = msg.getData().get(this.m_keyIDs[i]);
            this.setParam(dobj, i + 1, pstmt, this.m_keyTypes[i]);
        }
        pstmt.executeUpdate();
    }

    public void insertVersion(Connection konnek, RowReceiveMessage msg) throws Exception {
        PreparedStatement insertstmt = this.getCachedPStatement(konnek, this.m_insertVersionCache, this.m_insertVersionSQL);
        HashMap data = msg.getData();
        insertstmt.setLong(1, msg.getRowVersion());
        insertstmt.setLong(2, msg.getColGroupVersion());
        insertstmt.setLong(3, msg.getRowCreatorID());
        insertstmt.setLong(4, 0L);
        for (int i = 0; i < this.m_key_count; ++i) {
            Object dobj = data.get(this.m_keyIDs[i]);
            this.setParam(dobj, i + 5, insertstmt, this.m_keyTypes[i]);
        }
        insertstmt.executeUpdate();
    }

    public boolean rowVersionMatches(Connection konnek, RowReceiveMessage msg) throws Exception {
        boolean retval = false;
        HashMap data = msg.getData();
        PreparedStatement pstmt = this.getCachedPStatement(konnek, this.m_rowVersionMatchesCache, this.m_rowVersionMatchesSQL);
        for (int i = 0; i < this.m_key_count; ++i) {
            Object dobj = data.get(this.m_keyIDs[i]);
            this.setParam(dobj, i + 1, pstmt, this.m_keyTypes[i]);
        }
        pstmt.setLong(this.m_key_count + 1, msg.getRowCreatorID());
        pstmt.setLong(this.m_key_count + 2, msg.getRowVersion());
        ResultSet result = pstmt.executeQuery();
        if (result.next()) {
            retval = true;
        }
        result.close();
        return retval;
    }

    public void lockDataRow(Connection konnek, RowReceiveMessage msg) throws Exception {
        PreparedStatement pstmt = this.getCachedPStatement(konnek, this.m_lockDataRowCache, this.m_lockDataRowSQL);
        pstmt.executeUpdate();
    }

    public void unlockDataRow(Connection konnek, RowReceiveMessage msg) throws Exception {
        PreparedStatement pstmt = this.getCachedPStatement(konnek, this.m_unlockDataRowCache, this.m_unlockDataRowSQL);
        pstmt.executeUpdate();
    }

    public void insertShadowTableEntryForRefresh(Connection konnek, RowReceiveMessage msg, boolean requireEcho) throws Exception {
        HashMap data = msg.getData();
        PreparedStatement pstmt = this.getCachedPStatement(konnek, this.m_insertShadowTableEntryForRefreshCache, this.m_insertShadowTableEntryForRefreshSQL);
        pstmt.setInt(1, requireEcho ? 4 : 5);
        pstmt.setBytes(2, SQLBuilder.newByteArrayFromID(msg.getUpdaterId()));
        for (int i = 0; i < this.m_key_count; ++i) {
            Object dobj = data.get(this.m_keyIDs[i]);
            this.setParam(dobj, i + 3, pstmt, this.m_keyTypes[i]);
        }
        int howMuch = pstmt.executeUpdate();
        if (DebugOutput.isVerboseConsumptionMsg()) {
            DebugOutput.println("consumption INFO : insertShadowTableEntryForRefresh has updated : " + howMuch + " row(s) :::" + msg.toString());
        }
    }

    public void insertTransactionTableEntryForRefresh(Connection konnek) throws Exception {
        PreparedStatement pstmt = this.getCachedPStatement(konnek, this.m_insertTransactionTableEntryForRefreshCache, this.m_insertTransactionTableEntryForRefreshSQL);
        pstmt.executeUpdate();
    }

    public void insertShadowTableEntryForRefreshEcho(Connection konnek, RowReceiveMessage msg) throws Exception {
        PreparedStatement pstmt = this.getCachedPStatement(konnek, this.m_insertShadowTableEntryForRefreshEchoCache, this.m_insertShadowTableEntryForRefreshEchoSQL);
        pstmt.setLong(1, msg.getRowCreatorID());
        pstmt.setLong(2, msg.getRowVersion());
        pstmt.setLong(3, msg.getUpdaterId());
        pstmt.executeUpdate();
    }

    public void insertTransactionTableEntryForRefreshEcho(Connection konnek) throws Exception {
        PreparedStatement pstmt = this.getCachedPStatement(konnek, this.m_insertTransactionTableEntryForRefreshCache, this.m_insertTransactionTableEntryForRefreshSQL);
        pstmt.executeUpdate();
    }

    public void setSourceClientIDInShadowTable(Connection konnek, RowReceiveMessage msg) throws Exception {
        HashMap data = msg.getData();
        PreparedStatement pstmt = this.getCachedPStatement(konnek, this.m_setSourceClientIDInShadowTableCache, this.m_setSourceClientIDInShadowTableSQL);
        pstmt.setLong(1, msg.getUpdaterId());
        for (int i = 0; i < this.m_key_count; ++i) {
            Object dobj = data.get(this.m_keyIDs[i]);
            this.setParam(dobj, i + 2, pstmt, this.m_keyTypes[i]);
        }
        pstmt.executeUpdate();
    }

    public void setReceivedVersions(Connection konnek, RowReceiveMessage msg) throws Exception {
        PreparedStatement updtstmt = this.getCachedPStatement(konnek, this.m_setReceivedVersionsCache, this.m_setReceivedVersionsSQL);
        HashMap data = msg.getData();
        updtstmt.setLong(1, msg.getRowVersion());
        updtstmt.setLong(2, msg.getColGroupVersion());
        updtstmt.setLong(3, msg.getRowCreatorID());
        updtstmt.setLong(4, msg.getColGroupVersion());
        for (int i = 0; i < this.m_key_count; ++i) {
            Object dobj = data.get(this.m_keyIDs[i]);
            this.setParam(dobj, i + 5, updtstmt, this.m_keyTypes[i]);
        }
        updtstmt.executeUpdate();
    }

    public void setReceivedVersionsInShadowTable(Connection konnek, RowReceiveMessage msg) throws Exception {
        PreparedStatement updtstmt = this.getCachedPStatement(konnek, this.m_setReceivedVersionsInShadowTableCache, this.m_setReceivedVersionsInShadowTableSQL);
        HashMap data = msg.getData();
        updtstmt.setLong(1, msg.getRowVersion());
        updtstmt.setLong(2, msg.getColGroupVersion());
        updtstmt.setLong(3, msg.getRowCreatorID());
        updtstmt.setLong(4, msg.getUpdaterId());
        for (int i = 0; i < this.m_key_count; ++i) {
            Object dobj = data.get(this.m_keyIDs[i]);
            this.setParam(dobj, i + 5, updtstmt, this.m_keyTypes[i]);
        }
        updtstmt.executeUpdate();
    }

    public void updateColumnGroupVersionInShadowTable(Connection konnek, RowReceiveMessage msg) throws Exception {
        HashMap data = msg.getData();
        PreparedStatement pstmt = this.getCachedPStatement(konnek, this.m_updateColumnGroupVersionInShadowTableCache, this.m_updateColumnGroupVersionInShadowTableSQL);
        pstmt.setLong(1, msg.getUpdaterId());
        for (int i = 0; i < this.m_key_count; ++i) {
            Object dobj = data.get(this.m_keyIDs[i]);
            this.setParam(dobj, i + 2, pstmt, this.m_keyTypes[i]);
        }
        pstmt.executeUpdate();
    }

    public boolean columnGroupVersionMatches(Connection konnek, RowReceiveMessage msg) throws Exception {
        boolean retval = false;
        if (msg.getColGroupVersion() == -1L) {
            retval = true;
        } else {
            HashMap data = msg.getData();
            PreparedStatement pstmt = this.getCachedPStatement(konnek, this.m_columnGroupVersionMatchesCache, this.m_columnGroupVersionMatchesSQL);
            for (int i = 0; i < this.m_key_count; ++i) {
                Object dobj = data.get(this.m_keyIDs[i]);
                this.setParam(dobj, i + 1, pstmt, this.m_keyTypes[i]);
            }
            ResultSet result = pstmt.executeQuery();
            if (result.next()) {
                long version = result.getLong(1);
                result.close();
                retval = version == msg.getColGroupVersion() - 1L;
            } else {
                result.close();
                throw new Exception("consumption ERROR : version table entry not found, sync message :" + msg.toString());
            }
        }
        return retval;
    }

    public void auditMsg(Connection konnek, RowReceiveMessage msg, int conflictType) throws Exception {
        HashMap data = msg.getData();
        PreparedStatement pstmt = this.getCachedPStatement(konnek, this.m_auditMsgCache, this.m_auditMsgSQL);
        if (data == null) {
            for (int i = 0; i < this.m_key_count; ++i) {
                this.setParam(null, i + 1, pstmt, this.m_keyTypes[i]);
            }
        } else {
            for (int i = 0; i < this.m_key_count; ++i) {
                Object dobj = data.get(this.m_keyIDs[i]);
                this.setParam(dobj, i + 1, pstmt, this.m_keyTypes[i]);
            }
        }
        pstmt.setLong(this.m_key_count + 1, msg.getUpdaterId());
        pstmt.setInt(this.m_key_count + 2, conflictType);
        pstmt.setLong(this.m_key_count + 3, msg.getRowCreatorID());
        pstmt.setLong(this.m_key_count + 4, msg.getRowVersion());
        pstmt.setInt(this.m_key_count + 5, msg.getActionType());
        pstmt.executeUpdate();
    }

    private PreparedStatement paramDelete(Connection konnek, RowReceiveMessage msg) throws Exception {
        HashMap data = msg.getData();
        PreparedStatement pstmt = this.getCachedPStatement(konnek, this.m_deleteCache, this.m_deleteStmtSQL);
        for (int i = 0; i < this.m_key_count; ++i) {
            Object dobj = data.get(this.m_keyIDs[i]);
            this.setParam(dobj, i + 1, pstmt, this.m_keyTypes[i]);
        }
        return pstmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement paramUpdate(Connection konnek, RowReceiveMessage msg) throws Exception {
        int i;
        PreparedStatement pstmt;
        int i2;
        HashMap data = msg.getData();
        HashMap beforeimg = msg.getBeforeImageData();
        StringBuffer sigbuf = new StringBuffer("");
        for (i2 = 0; i2 < this.m_non_key_count; ++i2) {
            if (data.containsKey(this.m_nonKeyIDs[i2])) {
                sigbuf.append("1");
                continue;
            }
            sigbuf.append("0");
        }
        if (beforeimg != null && !beforeimg.isEmpty()) {
            for (i2 = 0; i2 < this.m_non_key_count; ++i2) {
                if (beforeimg.containsKey(this.m_nonKeyIDs[i2])) {
                    sigbuf.append(beforeimg.get(this.m_nonKeyIDs[i2]) == null ? "n" : "1");
                    continue;
                }
                sigbuf.append("0");
            }
        }
        String sig = sigbuf.toString();
        MySQLTableConsumptionSQLHandler mySQLTableConsumptionSQLHandler = this;
        synchronized (mySQLTableConsumptionSQLHandler) {
            pstmt = null;
            Hashtable<String, PreparedStatement> khash = (Hashtable<String, PreparedStatement>)this.m_updateCache.get(konnek);
            if (khash == null) {
                khash = new Hashtable<String, PreparedStatement>();
                this.m_updateCache.put(konnek, khash);
            } else {
                pstmt = (PreparedStatement)khash.get(sig);
            }
            if (pstmt == null) {
                StringBuffer set_exprSQL_buf = new StringBuffer("set ");
                boolean set_comma = false;
                for (int i3 = 0; i3 < this.m_non_key_count; ++i3) {
                    if (sig.charAt(i3) == '0') continue;
                    if (set_comma) {
                        set_exprSQL_buf.append(",");
                    } else {
                        set_comma = true;
                    }
                    set_exprSQL_buf.append("`");
                    set_exprSQL_buf.append(this.m_nonKeyNames[i3]);
                    set_exprSQL_buf.append("`=?");
                }
                String beforeQualSQL = "";
                if (beforeimg != null && !beforeimg.isEmpty()) {
                    StringBuffer beforeQualSQL_buf = new StringBuffer("");
                    for (int i4 = 0; i4 < this.m_non_key_count; ++i4) {
                        char sigchar = sig.charAt(this.m_non_key_count + i4);
                        if (sigchar == '0') continue;
                        beforeQualSQL_buf.append(" and ");
                        beforeQualSQL_buf.append("`");
                        beforeQualSQL_buf.append(this.m_nonKeyNames[i4]);
                        if (sigchar == '1') {
                            beforeQualSQL_buf.append("`=?");
                            continue;
                        }
                        if (sigchar != 'n') continue;
                        beforeQualSQL_buf.append("` is NULL");
                    }
                    beforeQualSQL = beforeQualSQL_buf.toString();
                }
                String stmtSQL = this.m_updateStartSQL + set_exprSQL_buf.toString() + this.m_keyClauseSQL + beforeQualSQL;
                if (DebugOutput.isVerboseConsumption()) {
                    DebugOutput.println("consumption INFO : update not cached, msg : " + msg.toString());
                    DebugOutput.println("consumption INFO : update not cached, sig : " + sig);
                    DebugOutput.println("consumption INFO : update not cached, SQL : " + stmtSQL);
                    DebugOutput.println("consumption INFO : update not cached, key : " + this.m_keyClauseSQL);
                    DebugOutput.println("consumption INFO : update not cached, b4Q : " + beforeQualSQL);
                }
                pstmt = konnek.prepareStatement(stmtSQL);
                khash.put(sig, pstmt);
            }
        }
        int paridx = 1;
        for (i = 0; i < this.m_non_key_count; ++i) {
            if (sig.charAt(i) == '0') continue;
            this.setParam(data.get(this.m_nonKeyIDs[i]), paridx++, pstmt, this.m_nonKeyTypes[i]);
        }
        for (i = 0; i < this.m_key_count; ++i) {
            this.setParam(data.get(this.m_keyIDs[i]), paridx++, pstmt, this.m_keyTypes[i]);
        }
        if (beforeimg != null && !beforeimg.isEmpty()) {
            for (i = 0; i < this.m_non_key_count; ++i) {
                if (sig.charAt(this.m_non_key_count + i) != '1') continue;
                this.setParam(beforeimg.get(this.m_nonKeyIDs[i]), paridx++, pstmt, this.m_nonKeyTypes[i]);
            }
        }
        return pstmt;
    }

    private PreparedStatement paramInsert(Connection konnek, RowReceiveMessage msg) throws Exception {
        Object dobj;
        int i;
        HashMap data = msg.getData();
        PreparedStatement pstmt = this.getCachedPStatement(konnek, this.m_insertCache, this.m_insertStmtSQL);
        int paridx = 1;
        for (i = 0; i < this.m_key_count; ++i) {
            dobj = data.get(this.m_keyIDs[i]);
            this.setParam(dobj, paridx++, pstmt, this.m_keyTypes[i]);
        }
        for (i = 0; i < this.m_non_key_count; ++i) {
            dobj = data.get(this.m_nonKeyIDs[i]);
            this.setParam(dobj, paridx++, pstmt, this.m_nonKeyTypes[i]);
        }
        return pstmt;
    }

    private synchronized PreparedStatement getCachedPStatement(Connection konnek, Hashtable cache, String SQL) throws Exception {
        PreparedStatement retval = (PreparedStatement)cache.get(konnek);
        if (retval == null) {
            if (DebugOutput.isVerboseConsumption()) {
                DebugOutput.println("consumption INFO : statement not cached, SQL : " + SQL + " thread : " + Thread.currentThread());
            }
            retval = konnek.prepareStatement(SQL);
            cache.put(konnek, retval);
        }
        return retval;
    }

    private void setParam(Object dobj, int paridx, PreparedStatement pstmt, int sql_type) throws Exception {
        if (dobj == null) {
            pstmt.setNull(paridx, sql_type);
        } else {
            switch (sql_type) {
                case 5: {
                    short x = (Short)dobj;
                    pstmt.setShort(paridx, x);
                    break;
                }
                case 4: {
                    int x = (Integer)dobj;
                    pstmt.setInt(paridx, x);
                    break;
                }
                case -1: 
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 12: {
                    String x = (String)dobj;
                    pstmt.setString(paridx, x);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    byte[] x = (byte[])dobj;
                    pstmt.setBytes(paridx, x);
                    break;
                }
                default: {
                    if (dobj instanceof Boolean) {
                        pstmt.setBoolean(paridx, (Boolean)dobj);
                        break;
                    }
                    if (dobj instanceof Time) {
                        pstmt.setTime(paridx, (Time)dobj);
                        break;
                    }
                    if (dobj instanceof Date) {
                        pstmt.setDate(paridx, (Date)dobj);
                        break;
                    }
                    if (dobj instanceof Timestamp) {
                        pstmt.setTimestamp(paridx, (Timestamp)dobj);
                        break;
                    }
                    pstmt.setObject(paridx, dobj, sql_type);
                }
            }
        }
    }
}

