/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.capture;

import com.sap.sdb.programmargs.Convert;
import com.sap.sdb.syncMan.util.TableName;
import java.util.Iterator;
import java.util.LinkedList;

class CaptureTransEntry {
    private LinkedList m_list = new LinkedList();
    private byte[] m_transIDBytes;
    private String m_transID;
    private long m_maxSequence;

    CaptureTransEntry(byte[] transIDBytes) {
        this.m_transIDBytes = transIDBytes;
        this.m_transID = Convert.bytesToHexStr(transIDBytes);
        this.m_maxSequence = -1L;
    }

    void addTable(String tableOwner, String tableIdentifier, long sequence) {
        this.m_list.addLast(new TableName(tableOwner, tableIdentifier));
        if (sequence > this.m_maxSequence) {
            this.m_maxSequence = sequence;
        }
    }

    int getTableCount() {
        return this.m_list.size();
    }

    Iterator getTableIterator() {
        return this.m_list.iterator();
    }

    long getMaxSequence() {
        return this.m_maxSequence;
    }

    TableName getTheOnlyOneTable() {
        return this.m_list.size() == 1 ? (TableName)this.m_list.getFirst() : null;
    }

    String getTransID() {
        return this.m_transID;
    }

    byte[] getTransIDBytes() {
        return this.m_transIDBytes;
    }
}

