/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan;

import com.sap.sdb.syncMan.SyncService;
import com.sap.sdb.syncMan.util.DebugOutput;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Date;
import java.util.StringTokenizer;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class SyncServiceAdminThread
extends Thread {
    private SyncService mSyncService = null;
    private boolean mStopFlag = false;
    private Socket mAdminSocket;
    private boolean mConnectedFlag = false;
    private ServerSocket mListenSocket;
    private SSLServerSocket mListenSSLSocket;
    private int mPort;
    private boolean mUseSSL;
    private String mAdminPassword;
    private boolean mAuthorizedFlag = false;
    private static final String LSEP = System.getProperty("line.separator", "\r\n");

    public SyncServiceAdminThread(SyncService syncService, int port, boolean useSSL, String adminPassword) {
        super("SyncServiceAdminThread");
        this.mPort = port;
        this.mUseSSL = useSSL;
        this.mSyncService = syncService;
        this.mAdminPassword = adminPassword;
    }

    public void pleaseStop() {
        this.mStopFlag = true;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void processCommands(InputStream i, OutputStream o) throws IOException {
        block31: {
            in = new BufferedReader(new InputStreamReader(i));
            out = new PrintWriter(new OutputStreamWriter(o));
            var6_5 = this;
            synchronized (var6_5) {
                if (!this.mConnectedFlag) ** break block27
                out.println("ONLY ONE ADMIN CONNECTION ALLOWED AT A TIME.");
                out.close();
            }
            var10_9 = null;
            try {
                out.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                in.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.mConnectedFlag = false;
            this.mAuthorizedFlag = false;
            {
                return;
                {
                    this.mConnectedFlag = true;
                }
                while (!this.mStopFlag) {
                    out.flush();
                    line = in.readLine();
                    if (line != null) {
                        try {
                            st = new StringTokenizer(line);
                            command = st.nextToken().toLowerCase();
                            if (command.equals("password")) {
                                p = st.nextToken();
                                if (p.equals(this.mAdminPassword)) {
                                    out.println("OK");
                                    this.mAuthorizedFlag = true;
                                    continue;
                                }
                                out.println("INVALID PASSWORD");
                                continue;
                            }
                            if (command.equals("help")) {
                                out.println("\thelp" + SyncServiceAdminThread.LSEP + "\tquit" + SyncServiceAdminThread.LSEP + "\tpassword <password>" + SyncServiceAdminThread.LSEP + "Password protected:" + SyncServiceAdminThread.LSEP + "---------------------" + SyncServiceAdminThread.LSEP + "\tshutdown" + SyncServiceAdminThread.LSEP);
                                continue;
                            }
                            if (command.equals("quit")) {
                                this.mAdminSocket.close();
                                this.mConnectedFlag = false;
                                this.mAuthorizedFlag = false;
                                continue;
                            }
                            if (command.equals("shutdown")) {
                                if (!this.isAuthorized(out)) continue;
                                this.mSyncService.shutdownServer();
                                System.exit(0);
                                continue;
                            }
                            out.println("Unknown command <" + command + ">");
                        }
                        catch (Exception e) {
                            out.println("EXCEPTION WHILE PARSING OR EXECUTING COMMAND:");
                            out.println(e);
                        }
                        continue;
                    }
                    try {
                        out.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    try {
                        in.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    this.mConnectedFlag = false;
                    this.mAuthorizedFlag = false;
                    this.mAdminSocket.close();
                }
            }
            var10_10 = null;
            try {
                out.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                in.close();
                break block31;
            }
            catch (Exception ex) {
                // empty catch block
            }
            {
            }
            catch (Throwable var9_19) {
                var10_11 = null;
                try {
                    out.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    in.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.mConnectedFlag = false;
                this.mAuthorizedFlag = false;
                throw var9_19;
            }
        }
        this.mConnectedFlag = false;
        this.mAuthorizedFlag = false;
    }

    private boolean isAuthorized(PrintWriter out) {
        if (!this.mAuthorizedFlag) {
            out.println("PASSWORD REQUIRED");
            return false;
        }
        return true;
    }

    public void run() {
        try {
            if (this.mUseSSL) {
                SSLServerSocketFactory sslServFact = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
                this.mListenSSLSocket = (SSLServerSocket)sslServFact.createServerSocket(this.mPort);
                this.mListenSSLSocket.setSoTimeout(5000);
            } else {
                this.mListenSocket = new ServerSocket(this.mPort);
                this.mListenSocket.setSoTimeout(5000);
            }
        }
        catch (IOException ex) {
            DebugOutput.println("[" + new Date() + " " + this.getName() + "] " + ex.toString());
            System.exit(-1);
        }
        while (!this.mStopFlag) {
            try {
                this.mAdminSocket = this.mListenSocket.accept();
                try {
                    InputStream in = this.mAdminSocket.getInputStream();
                    OutputStream out = this.mAdminSocket.getOutputStream();
                    this.processCommands(in, out);
                }
                catch (SSLException ssl) {
                    DebugOutput.println("[" + new Date() + " " + this.getName() + "] connection closed due to: " + ssl.toString());
                    this.mAdminSocket.close();
                }
                catch (IOException e) {
                    DebugOutput.println("[" + new Date() + " " + this.getName() + "] connection closed due to: " + e.toString());
                    this.mAdminSocket.close();
                }
            }
            catch (SocketTimeoutException ex) {
            }
            catch (Exception ex) {
                DebugOutput.println("[" + new Date() + " " + this.getName() + "] " + ex.toString());
                try {
                    if (this.mAdminSocket == null) continue;
                    this.mAdminSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            if (this.mListenSocket != null) {
                this.mListenSocket.close();
            }
            if (this.mAdminSocket != null) {
                this.mAdminSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

