/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan;

import com.sap.sdb.syncMan.SyncManThread;
import com.sap.sdb.syncMan.util.DebugOutput;
import java.util.Iterator;
import java.util.LinkedList;

public class SyncManThreadManager {
    private boolean m_stopCalled = false;
    private LinkedList m_threadList = new LinkedList();
    private Exception m_fatalError = null;
    private ThreadMonitoring m_threadMonitoring = null;
    private static SyncManThreadManager s_manager = null;
    private static int DEFAULT_DISPLAY_INTERVAL = 10;
    private static int LOOP_WAIT_FOR_STOP_THREADS = 30;
    private static long SLEEP_WAIT_FOR_STOP_THREADS = 5000L;

    private SyncManThreadManager() {
        s_manager = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void abortAllThreads(Exception fatalError) {
        SyncManThreadManager manager = s_manager;
        if (manager == null) {
            return;
        }
        SyncManThreadManager syncManThreadManager = manager;
        synchronized (syncManThreadManager) {
            if (manager.m_fatalError != null) {
                return;
            }
            manager.m_fatalError = fatalError;
        }
        manager.stopThreads(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean addThread() {
        SyncManThreadManager manager = s_manager;
        if (manager == null) {
            return false;
        }
        SyncManThreadManager syncManThreadManager = manager;
        synchronized (syncManThreadManager) {
            if (manager.m_stopCalled) {
                return false;
            }
            manager.m_threadList.addLast(Thread.currentThread());
            return true;
        }
    }

    public static synchronized void createInstance() {
        if (s_manager == null) {
            s_manager = new SyncManThreadManager();
        }
    }

    public static void destroyInstance() {
        SyncManThreadManager manager = s_manager;
        s_manager = null;
        if (manager != null) {
            manager.stopThreads(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Exception getFatalError() {
        SyncManThreadManager manager = s_manager;
        if (manager == null) {
            return null;
        }
        SyncManThreadManager syncManThreadManager = manager;
        synchronized (syncManThreadManager) {
            return manager.m_fatalError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Exception getException() {
        SyncManThreadManager manager = s_manager;
        if (manager == null) {
            return null;
        }
        SyncManThreadManager syncManThreadManager = manager;
        synchronized (syncManThreadManager) {
            return manager.m_fatalError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isErrorOccurred() {
        SyncManThreadManager manager = s_manager;
        if (manager == null) {
            return false;
        }
        SyncManThreadManager syncManThreadManager = manager;
        synchronized (syncManThreadManager) {
            return manager.m_fatalError != null;
        }
    }

    private synchronized void runNewMonitor(int displayIntervalSec) {
        if (this.m_stopCalled) {
            return;
        }
        if (this.m_threadMonitoring != null) {
            this.m_threadMonitoring.setDisplayInterval(displayIntervalSec);
            return;
        }
        this.m_threadMonitoring = new ThreadMonitoring(this, displayIntervalSec);
        this.m_threadMonitoring.setDaemon(true);
        this.m_threadMonitoring.start();
    }

    private synchronized void showState() {
        DebugOutput.println();
        DebugOutput.println("---------- " + this.m_threadList.size() + " threads ----------");
        Iterator iter = this.m_threadList.iterator();
        while (iter.hasNext()) {
            SyncManThread currThread = (SyncManThread)iter.next();
            currThread.printState();
        }
    }

    static void startMonitoring(int displayIntervalSec) {
        SyncManThreadManager manager = s_manager;
        if (manager != null) {
            manager.runNewMonitor(displayIntervalSec);
        }
    }

    public static void stopAllThreads() {
        SyncManThreadManager manager = s_manager;
        if (manager == null) {
            return;
        }
        manager.stopThreads(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopThreads(boolean doWait) {
        Object currThread;
        SyncManThreadManager syncManThreadManager = this;
        synchronized (syncManThreadManager) {
            if (!this.m_stopCalled) {
                this.m_stopCalled = true;
                if (DebugOutput.isVerbose()) {
                    DebugOutput.println();
                    DebugOutput.println("---------- stopping all threads ----------");
                }
                if (this.m_threadMonitoring != null) {
                    this.m_threadMonitoring.interrupt();
                    this.m_threadMonitoring = null;
                }
                Iterator iter = this.m_threadList.iterator();
                while (iter.hasNext()) {
                    currThread = (SyncManThread)iter.next();
                    ((SyncManThread)currThread).pleaseStop();
                }
            }
        }
        if (!doWait) {
            return;
        }
        for (int i = 0; i < LOOP_WAIT_FOR_STOP_THREADS; ++i) {
            boolean runningFound = false;
            currThread = this;
            synchronized (currThread) {
                Iterator iter = this.m_threadList.iterator();
                while (!runningFound && iter.hasNext()) {
                    SyncManThread currThread2 = (SyncManThread)iter.next();
                    if (currThread2.hasStopped()) continue;
                    runningFound = true;
                }
            }
            if (!runningFound) {
                return;
            }
            try {
                Thread.sleep(SLEEP_WAIT_FOR_STOP_THREADS);
                continue;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
    }

    private class ThreadMonitoring
    extends Thread {
        private SyncManThreadManager m_threadManager;
        private long m_sleepMSec;

        ThreadMonitoring(SyncManThreadManager threadManager, int displayIntervalSec) {
            this.m_threadManager = threadManager;
            this.setDisplayInterval(displayIntervalSec);
        }

        public void run() {
            try {
                while (true) {
                    Thread.sleep(this.m_sleepMSec);
                    this.m_threadManager.showState();
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        void setDisplayInterval(int displayIntervalSec) {
            this.m_sleepMSec = displayIntervalSec < 1 ? (long)(DEFAULT_DISPLAY_INTERVAL * 1000) : (long)(displayIntervalSec * 1000);
        }
    }
}

