/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc.translators;

import java.sql.*;
import com.sap.dbtech.util.*;
/**
 *
 */
public class AsciiStreamTranslator extends StreamTranslator {
    /**
     * AsciiStreamTranslator constructor comment.
     * @param mode int
     * @param ioType int
     * @param dataType int
     * @param len int
     * @param ioLen int
     * @param bufpos int
     */
    protected AsciiStreamTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos, 
            boolean readOnly, 
            boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos, readOnly, autoIncr);
        characterDatatypePostfix = " ASCII";
    }
    /**
     *
     * @return java.io.InputStream
     * @exception java.sql.SQLException The exception description.
     */
    public java.io.InputStream getAsciiStream (
        SQLParamController controller,
        StructuredMem mem,
        StructuredMem longData) throws SQLException
    {
        return this.getStream (controller, mem, longData);
    }
    /**
     *
     * @return java.lang.String
     */
    public Object getObject (
        SQLParamController controller,
        StructuredMem mem)
            throws SQLException
    {
        Object result;

        result = this.getString (controller, mem);
        if (result == null) {
            result = null;
        }
        return result;
    }
    /**
     *
     * @return java.io.InputStream
     * @exception java.sql.SQLException The exception description.
     */
    public Object transAsciiStreamForInput (
        java.io.InputStream stream, int length) throws SQLException
    {
        return this.transStreamForInput (stream, length);
    }
    /**
     *
     * @return java.io.InputStream
     * @exception java.sql.SQLException The exception description.
     */
    public Object transCharacterStreamForInput (
        java.io.Reader reader, int length) throws SQLException
    {
        if (reader == null) {
            return reader;
        }
        java.io.InputStream stream = new ReaderInputStream (reader, false);
        return this.transStreamForInput (stream, length);
    }
    
   
	public Object transStringForInput (String val)
		throws SQLException
	{
		if (val == null) {
			return null;
		} else {
			return new Putval
				(com.sap.dbtech.util.StringUtil.bytes_iso8859_1(val), bufpos);
		}
	}
    boolean isPackectEncodingUnicode() {
        return false;
    }

}
