/*!******************************************************************************

  @file         hkb50_1.h

  ------------------------------------------------------------------------------

  @author       UweH

  @brief        KB_trans_state

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

\endif

********************************************************************************/

#ifndef HKB50_1_H
#define HKB50_1_H


/*===========================================================================*
 *     RefType: C++                                                          *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\x65\x05\xec\xa5\x54\x64\x98\x3a\x4f\x7b\x33\x3a\x90\xdb\x9f\xd6'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"
#include "gkb05.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void kb50CheckConsistViewOfTrans (
    tgg00_TransContext    &  Trans,
    tkb05_TransEntry      &  ThisTrans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k50DelCollisionEntry (
    tkb05_ObjCollGlob     &  ObjCollGlob,
    tkb05_TransEntry      &  LockTransEntry,
    tkb05_ObjCollEntryPtr  &  CollEntry);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k50hash_rowid (
    tkb05_RowId           &  RowId,
    tsp00_Int2               KeyLen,
    tsp00_Int4            &  HashValue);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k50init_wanted_rowid_lock (
    void                  *  MoveObj,
    tsp00_Int4               MoveObjSize,
    tsp00_Int4               pos,
    integer                  KeyLen,
    tkb05_WantedLock      &  WantedLock,
    tgg00_BasisError      &  MoveError);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k50init1_wanted_rowid_lock (
    void                  *  MoveObj,
    tsp00_Int4               MoveObjSize,
    tsp00_Int4               pos,
    integer                  KeyLen,
    tkb05_WantedLock      &  WantedLock,
    tgg00_BasisError      &  MoveError);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool kb50IsValidCollisionEntry (
    tkb05_ObjCollisionEntry  &  ObjCollEntry,
    tgg92_KernelOid&         Oid);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb50RemoveObjLocks (
    tsp00_TaskId             TaskId,
    tkb05_TransEntry      &  ThisTrans);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

