/*
        ========== licence begin  GPL
        Copyright (c) 2006 SAP AG

        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
        ========== licence end

*/

#ifndef SDBMSG_DBMSRV_H
#define SDBMSG_DBMSRV_H
/*
This header file was generated by buildmsg.pl
--- Do not edit....
*/
#ifdef __cplusplus
#ifndef MSG_LIST_HPP
#include "SAPDB/Messages/Msg_List.hpp"
#endif
#ifndef MSG_ARG_HPP
#include "SAPDB/Messages/Msg_Arg.hpp"
#endif
#ifndef MSG_SIMPLEARG_HPP
#include "SAPDB/Messages/Msg_SimpleArg.hpp"
#endif
#endif

#ifndef SDB_RELEASE_070600  /* don't merge this define - only this date: 2006-04-27 09:26:51 */
#error SDBMsg_DBMSrv.h was probably integrated between releases, do not integrate this header file, \
use buildmsg
#endif


#define SDBMSG_DBMSRV_COMPONENT "DBMSrv"
/* Begin of all message defines for component DBMSrv -> */
/* Begin of defines for message ERR: ID = 1, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_ERR 1, "DBMSrv", __FILE__, __LINE__, "Common error", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message ERR */
/* Begin of defines for message NOTIMPL: ID = 2, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_NOTIMPL 2, "DBMSrv", __FILE__, __LINE__, "DBM command $COMMAND_NAME$ has not been implemented yet", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_NOTIMPL__COMMAND_NAME "COMMAND_NAME"
/* <- End of defines for message NOTIMPL */
/* Begin of defines for message FILE: ID = 3, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_FILE 3, "DBMSrv", __FILE__, __LINE__, "File handling error", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message FILE */
/* Begin of defines for message PARAM: ID = 4, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_PARAM 4, "DBMSrv", __FILE__, __LINE__, "Wrong parameters", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message PARAM */
/* Begin of defines for message MEM: ID = 5, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_MEM 5, "DBMSrv", __FILE__, __LINE__, "Memory allocation error", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message MEM */
/* Begin of defines for message RTE: ID = 6, VERSION = 2, TAGS = 1 -> */
#define SDBMSG_DBMSRV_RTE 6, "DBMSrv", __FILE__, __LINE__, "Runtime environment error", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("2"))
/* <- End of defines for message RTE */
/* Begin of defines for message RTEEXT: ID = 7, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_RTEEXT 7, "DBMSrv", __FILE__, __LINE__, "Runtime environment error", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message RTEEXT */
/* Begin of defines for message NOUTILSESSION: ID = 8, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NOUTILSESSION 8, "DBMSrv", __FILE__, __LINE__, "no utility session available", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NOUTILSESSION */
/* Begin of defines for message NODBSESSION: ID = 9, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NODBSESSION 9, "DBMSrv", __FILE__, __LINE__, "no database session available", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NODBSESSION */
/* Begin of defines for message NOBACKUPSESSION: ID = 10, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_NOBACKUPSESSION 10, "DBMSrv", __FILE__, __LINE__, "No $SESSIONTYPE$ session available", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_NOBACKUPSESSION__SESSIONTYPE "SESSIONTYPE"
/* <- End of defines for message NOBACKUPSESSION */
/* Begin of defines for message NOHISTORYSESSION: ID = 11, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NOHISTORYSESSION 11, "DBMSrv", __FILE__, __LINE__, "No backup history session available", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NOHISTORYSESSION */
/* Begin of defines for message SQL: ID = 12, VERSION = 2, TAGS = 3 -> */
#define SDBMSG_DBMSRV_SQL 12, "DBMSrv", __FILE__, __LINE__, "SQL error", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("2"))
#define SDBMSGTAG_DBMSRV_SQL__ERRORTEXT "ERRORTEXT"
#define SDBMSGTAG_DBMSRV_SQL__RETURNCODE "RETURNCODE"
/* <- End of defines for message SQL */
/* Begin of defines for message TOOSMALL: ID = 13, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_TOOSMALL 13, "DBMSrv", __FILE__, __LINE__, "Packet size too small for reply", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message TOOSMALL */
/* Begin of defines for message NOMEDIA: ID = 14, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NOMEDIA 14, "DBMSrv", __FILE__, __LINE__, "No media file found", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NOMEDIA */
/* Begin of defines for message MENOTFOUND: ID = 15, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_MENOTFOUND 15, "DBMSrv", __FILE__, __LINE__, "Backup medium not found", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message MENOTFOUND */
/* Begin of defines for message MENOVALID: ID = 16, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_MENOVALID 16, "DBMSrv", __FILE__, __LINE__, "Invalid medium definition", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message MENOVALID */
/* Begin of defines for message BANOVALIDTYPE: ID = 17, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_BANOVALIDTYPE 17, "DBMSrv", __FILE__, __LINE__, "Invalid backup type", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message BANOVALIDTYPE */
/* Begin of defines for message NOHISTORY: ID = 18, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NOHISTORY 18, "DBMSrv", __FILE__, __LINE__, "Backup history file not available", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NOHISTORY */
/* Begin of defines for message NOHELP: ID = 20, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NOHELP 20, "DBMSrv", __FILE__, __LINE__, "Parameter help file not found", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NOHELP */
/* Begin of defines for message XPNOTFOUND: ID = 21, VERSION = 2, TAGS = 2 -> */
#define SDBMSG_DBMSRV_XPNOTFOUND 21, "DBMSrv", __FILE__, __LINE__, "Parameter $PARAMETER$ not found", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("2"))
#define SDBMSGTAG_DBMSRV_XPNOTFOUND__PARAMETER "PARAMETER"
/* <- End of defines for message XPNOTFOUND */
/* Begin of defines for message XPSYNTAX: ID = 22, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_XPSYNTAX 22, "DBMSrv", __FILE__, __LINE__, "Syntax error in the parameter help file", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message XPSYNTAX */
/* Begin of defines for message COMMAND: ID = 23, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_COMMAND 23, "DBMSrv", __FILE__, __LINE__, "Unknown DBM command \"$COMMAND_NAME$\"", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_COMMAND__COMMAND_NAME "COMMAND_NAME"
/* <- End of defines for message COMMAND */
/* Begin of defines for message PARAMEXIST: ID = 24, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_PARAMEXIST 24, "DBMSrv", __FILE__, __LINE__, "Parameter file of database already exists", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message PARAMEXIST */
/* Begin of defines for message NOXPSESSION: ID = 25, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NOXPSESSION 25, "DBMSrv", __FILE__, __LINE__, "Parameter session inactive", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NOXPSESSION */
/* Begin of defines for message XPSESSION: ID = 26, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_XPSESSION 26, "DBMSrv", __FILE__, __LINE__, "Parameter session active", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message XPSESSION */
/* Begin of defines for message XPCHECK: ID = 27, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_XPCHECK 27, "DBMSrv", __FILE__, __LINE__, "Parameter check: Failure or request", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message XPCHECK */
/* Begin of defines for message XPINFCONV: ID = 28, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_XPINFCONV 28, "DBMSrv", __FILE__, __LINE__, "Invalid value", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message XPINFCONV */
/* Begin of defines for message NOCHECK: ID = 29, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NOCHECK 29, "DBMSrv", __FILE__, __LINE__, "no running parameter check", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NOCHECK */
/* Begin of defines for message XPNOMODIFY: ID = 30, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_XPNOMODIFY 30, "DBMSrv", __FILE__, __LINE__, "Parameter must not be modified", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message XPNOMODIFY */
/* Begin of defines for message XPDIRTY: ID = 31, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_XPDIRTY 31, "DBMSrv", __FILE__, __LINE__, "Parameter file has not been checked", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message XPDIRTY */
/* Begin of defines for message XPREADONLY: ID = 32, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_XPREADONLY 32, "DBMSrv", __FILE__, __LINE__, "Parameter is read-only", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message XPREADONLY */
/* Begin of defines for message SYSTEM: ID = 33, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_SYSTEM 33, "DBMSrv", __FILE__, __LINE__, "System call failed", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message SYSTEM */
/* Begin of defines for message LOGON: ID = 34, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_LOGON 34, "DBMSrv", __FILE__, __LINE__, "Logon to the DBM server failed", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message LOGON */
/* Begin of defines for message SYSLOGON: ID = 35, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_SYSLOGON 35, "DBMSrv", __FILE__, __LINE__, "Logon to operating system failed", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message SYSLOGON */
/* Begin of defines for message EXECUTE: ID = 36, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_EXECUTE 36, "DBMSrv", __FILE__, __LINE__, "Error in program execution", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message EXECUTE */
/* Begin of defines for message VOLCHECK: ID = 37, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_VOLCHECK 37, "DBMSrv", __FILE__, __LINE__, "error while checking volume", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message VOLCHECK */
/* Begin of defines for message VOLTYPE: ID = 38, VERSION = 1, TAGS = 4 -> */
#define SDBMSG_DBMSRV_VOLTYPE 38, "DBMSrv", __FILE__, __LINE__, "The $VOLUME_CONT_TYPE$ volume with ID $VOLUME_ID$ does not have a device type", (Msg_Has4Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_VOLTYPE__VOLUME_ID "VOLUME_ID"
#define SDBMSGTAG_DBMSRV_VOLTYPE__PARAMETER "PARAMETER"
#define SDBMSGTAG_DBMSRV_VOLTYPE__VOLUME_CONT_TYPE "VOLUME_CONT_TYPE"
/* <- End of defines for message VOLTYPE */
/* Begin of defines for message STATE: ID = 39, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_STATE 39, "DBMSrv", __FILE__, __LINE__, "The operational state of the database instance could not be determined", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message STATE */
/* Begin of defines for message DBRUN: ID = 40, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_DBRUN 40, "DBMSrv", __FILE__, __LINE__, "Database instance is running", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message DBRUN */
/* Begin of defines for message XPOVERFLOW: ID = 41, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_XPOVERFLOW 41, "DBMSrv", __FILE__, __LINE__, "Value not permitted", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message XPOVERFLOW */
/* Begin of defines for message BAOVERWRITE: ID = 42, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_BAOVERWRITE 42, "DBMSrv", __FILE__, __LINE__, "File already exists and cannot be overwritten", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message BAOVERWRITE */
/* Begin of defines for message NOUSER: ID = 43, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NOUSER 43, "DBMSrv", __FILE__, __LINE__, "required user not set", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NOUSER */
/* Begin of defines for message BASAVETYPECON: ID = 44, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_BASAVETYPECON 44, "DBMSrv", __FILE__, __LINE__, "Backup type conflicts with medium definition", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message BASAVETYPECON */
/* Begin of defines for message BANOSAVETYPE: ID = 45, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_BANOSAVETYPE 45, "DBMSrv", __FILE__, __LINE__, "Backup type not defined", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message BANOSAVETYPE */
/* Begin of defines for message BANOAUTOMED: ID = 46, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_BANOAUTOMED 46, "DBMSrv", __FILE__, __LINE__, "No medium found for automatic log backup", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message BANOAUTOMED */
/* Begin of defines for message DBEXIST: ID = 47, VERSION = 2, TAGS = 2 -> */
#define SDBMSG_DBMSRV_DBEXIST 47, "DBMSrv", __FILE__, __LINE__, "Database instance $DATABASE_NAME$ already exists", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("2"))
#define SDBMSGTAG_DBMSRV_DBEXIST__DATABASE_NAME "DATABASE_NAME"
/* <- End of defines for message DBEXIST */
/* Begin of defines for message USRSAVE: ID = 48, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_USRSAVE 48, "DBMSrv", __FILE__, __LINE__, "Could not save DBM operator data", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message USRSAVE */
/* Begin of defines for message USRREAD: ID = 49, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_USRREAD 49, "DBMSrv", __FILE__, __LINE__, "Could not read DBM operator data", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message USRREAD */
/* Begin of defines for message USRFAIL: ID = 50, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_USRFAIL 50, "DBMSrv", __FILE__, __LINE__, "User authorization failed", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message USRFAIL */
/* Begin of defines for message USREXISTS: ID = 51, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_USREXISTS 51, "DBMSrv", __FILE__, __LINE__, "User name already exists", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message USREXISTS */
/* Begin of defines for message NODBNAME: ID = 52, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NODBNAME 52, "DBMSrv", __FILE__, __LINE__, "Database name required", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NODBNAME */
/* Begin of defines for message DBNAME: ID = 53, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_DBNAME 53, "DBMSrv", __FILE__, __LINE__, "do not use dbname", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message DBNAME */
/* Begin of defines for message TOOMANYPARAM: ID = 54, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_TOOMANYPARAM 54, "DBMSrv", __FILE__, __LINE__, "Too many parameters", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message TOOMANYPARAM */
/* Begin of defines for message TOOFEWPARAM: ID = 55, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_TOOFEWPARAM 55, "DBMSrv", __FILE__, __LINE__, "Too few parameters", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message TOOFEWPARAM */
/* Begin of defines for message USRDELSELF: ID = 56, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_USRDELSELF 56, "DBMSrv", __FILE__, __LINE__, "Cannot delete current user", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message USRDELSELF */
/* Begin of defines for message USRDELDBM: ID = 57, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_USRDELDBM 57, "DBMSrv", __FILE__, __LINE__, "Cannot delete DBM operator", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message USRDELDBM */
/* Begin of defines for message USRDELSDBA: ID = 58, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_USRDELSDBA 58, "DBMSrv", __FILE__, __LINE__, "Cannot delete database system administrator", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message USRDELSDBA */
/* Begin of defines for message NEEDLOGON: ID = 59, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NEEDLOGON 59, "DBMSrv", __FILE__, __LINE__, "DBM server logon required", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NEEDLOGON */
/* Begin of defines for message NEEDSYSLOGON: ID = 60, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NEEDSYSLOGON 60, "DBMSrv", __FILE__, __LINE__, "System logon required", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NEEDSYSLOGON */
/* Begin of defines for message LASTREG: ID = 61, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_LASTREG 61, "DBMSrv", __FILE__, __LINE__, "Cannot delete last registration of instance", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message LASTREG */
/* Begin of defines for message NOENTRY: ID = 62, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NOENTRY 62, "DBMSrv", __FILE__, __LINE__, "No entry found", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NOENTRY */
/* Begin of defines for message MISSRIGHT: ID = 63, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_MISSRIGHT 63, "DBMSrv", __FILE__, __LINE__, "No server rights for this command", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message MISSRIGHT */
/* Begin of defines for message DBNORUN: ID = 64, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_DBNORUN 64, "DBMSrv", __FILE__, __LINE__, "Database instance is not running", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message DBNORUN */
/* Begin of defines for message NOUSERS: ID = 65, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NOUSERS 65, "DBMSrv", __FILE__, __LINE__, "no users found", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NOUSERS */
/* Begin of defines for message VERSION: ID = 66, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_VERSION 66, "DBMSrv", __FILE__, __LINE__, "incompatible versions (param and kernel)", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message VERSION */
/* Begin of defines for message NOSERVICESESSION: ID = 67, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NOSERVICESESSION 67, "DBMSrv", __FILE__, __LINE__, "No service session active", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NOSERVICESESSION */
/* Begin of defines for message XPMIN: ID = 68, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_XPMIN 68, "DBMSrv", __FILE__, __LINE__, "parameter value smaller than minimum allowed", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message XPMIN */
/* Begin of defines for message XPMAX: ID = 69, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_XPMAX 69, "DBMSrv", __FILE__, __LINE__, "parameter value higher than maximum allowed", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message XPMAX */
/* Begin of defines for message XPVALUESET: ID = 70, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_XPVALUESET 70, "DBMSrv", __FILE__, __LINE__, "Parameter value invalid", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message XPVALUESET */
/* Begin of defines for message USRFRM: ID = 71, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_USRFRM 71, "DBMSrv", __FILE__, __LINE__, "invalid user record format", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message USRFRM */
/* Begin of defines for message NOREPLY: ID = 72, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NOREPLY 72, "DBMSrv", __FILE__, __LINE__, "No reply available", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NOREPLY */
/* Begin of defines for message TOOLCHK: ID = 73, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_TOOLCHK 73, "DBMSrv", __FILE__, __LINE__, "External backup tool not found", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message TOOLCHK */
/* Begin of defines for message MEDIUMCHK: ID = 74, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_MEDIUMCHK 74, "DBMSrv", __FILE__, __LINE__, "Medium cannot be used with this external backup tool", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message MEDIUMCHK */
/* Begin of defines for message PREPARE: ID = 75, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_PREPARE 75, "DBMSrv", __FILE__, __LINE__, "Preparation of backup operation failed", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message PREPARE */
/* Begin of defines for message DBREQ: ID = 76, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_DBREQ 76, "DBMSrv", __FILE__, __LINE__, "Cannot start operation", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message DBREQ */
/* Begin of defines for message TOOLREQ: ID = 77, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_TOOLREQ 77, "DBMSrv", __FILE__, __LINE__, "Error while starting external backup tool", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message TOOLREQ */
/* Begin of defines for message OPCHK: ID = 78, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_OPCHK 78, "DBMSrv", __FILE__, __LINE__, "Cannot check state of backup operation", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message OPCHK */
/* Begin of defines for message POSTOP: ID = 79, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_POSTOP 79, "DBMSrv", __FILE__, __LINE__, "Error while finishing backup", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message POSTOP */
/* Begin of defines for message BACKUPOP: ID = 80, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_BACKUPOP 80, "DBMSrv", __FILE__, __LINE__, "Backup failed", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message BACKUPOP */
/* Begin of defines for message CLEANUP: ID = 81, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_CLEANUP 81, "DBMSrv", __FILE__, __LINE__, "Cannot free all operational resources after backup operation", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message CLEANUP */
/* Begin of defines for message MISSMIRR: ID = 82, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_MISSMIRR 82, "DBMSrv", __FILE__, __LINE__, "Data for mirrored volume missing", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message MISSMIRR */
/* Begin of defines for message MAXDATA: ID = 83, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_MAXDATA 83, "DBMSrv", __FILE__, __LINE__, "Maximum data size exceeded", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message MAXDATA */
/* Begin of defines for message MAXVOLCNT: ID = 84, VERSION = 1, TAGS = 4 -> */
#define SDBMSG_DBMSRV_MAXVOLCNT 84, "DBMSrv", __FILE__, __LINE__, "Maximum number of volumes of type $VOLUME_TYPE$ already utilized", (Msg_Has4Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_MAXVOLCNT__VOLUME_TYPE "VOLUME_TYPE"
#define SDBMSGTAG_DBMSRV_MAXVOLCNT__VOLUME_MAXCOUNT "VOLUME_MAXCOUNT"
#define SDBMSGTAG_DBMSRV_MAXVOLCNT__PARAMETER "PARAMETER"
/* <- End of defines for message MAXVOLCNT */
/* Begin of defines for message NOADDD: ID = 85, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NOADDD 85, "DBMSrv", __FILE__, __LINE__, "Configuration update not allowed (parameter file is inactive)", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NOADDD */
/* Begin of defines for message KEYEXISTS: ID = 86, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_KEYEXISTS 86, "DBMSrv", __FILE__, __LINE__, "Installation key \"$DBMSRV_COMP$\" already exists", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_KEYEXISTS__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message KEYEXISTS */
/* Begin of defines for message SERVICEDB: ID = 87, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_SERVICEDB 87, "DBMSrv", __FILE__, __LINE__, "Cannot register service database instance for $DBMSRV_COMP$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_SERVICEDB__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message SERVICEDB */
/* Begin of defines for message WRONGINST: ID = 88, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_WRONGINST 88, "DBMSrv", __FILE__, __LINE__, "DBM Server instroot is $DBMSRV_COMP$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_WRONGINST__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message WRONGINST */
/* Begin of defines for message INVDBNAME: ID = 89, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_INVDBNAME 89, "DBMSrv", __FILE__, __LINE__, "Database name $DBMSRV_COMP$ is invalid", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_INVDBNAME__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message INVDBNAME */
/* Begin of defines for message PARAMVER: ID = 90, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_PARAMVER 90, "DBMSrv", __FILE__, __LINE__, "Wrong version of parameter help file (cserv.pcf):\\n$DBMSRV_COMP1$\\n$DBMSRV_COMP2$", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_PARAMVER__DBMSRV_COMP1 "DBMSRV_COMP1"
#define SDBMSGTAG_DBMSRV_PARAMVER__DBMSRV_COMP2 "DBMSRV_COMP2"
/* <- End of defines for message PARAMVER */
/* Begin of defines for message DBAUNKNOWN: ID = 91, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_DBAUNKNOWN 91, "DBMSrv", __FILE__, __LINE__, "Database system administrator unknown", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message DBAUNKNOWN */
/* Begin of defines for message AANOTEXIST_1: ID = 92, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_AANOTEXIST_1 92, "DBMSrv", __FILE__, __LINE__, "AANOTEXIST_1", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message AANOTEXIST_1 */
/* Begin of defines for message DBAWRONG: ID = 93, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_DBAWRONG 93, "DBMSrv", __FILE__, __LINE__, "Wrong database system administrator", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message DBAWRONG */
/* Begin of defines for message EBFDIRTY: ID = 94, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_EBFDIRTY 94, "DBMSrv", __FILE__, __LINE__, "Invalid format of external backup history $FILENAME$ in line $LINE_NO$", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_EBFDIRTY__FILENAME "FILENAME"
#define SDBMSGTAG_DBMSRV_EBFDIRTY__LINE_NO "LINE_NO"
/* <- End of defines for message EBFDIRTY */
/* Begin of defines for message NOEBIDLIST: ID = 95, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NOEBIDLIST 95, "DBMSrv", __FILE__, __LINE__, "No information on external backup IDs available", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NOEBIDLIST */
/* Begin of defines for message AANOTEXIST_2: ID = 96, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_AANOTEXIST_2 96, "DBMSrv", __FILE__, __LINE__, "AANOTEXIST_2", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message AANOTEXIST_2 */
/* Begin of defines for message IMPERSONATE: ID = 97, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_IMPERSONATE 97, "DBMSrv", __FILE__, __LINE__, "cannot impersonate to database owner", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message IMPERSONATE */
/* Begin of defines for message ASCII: ID = 98, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_ASCII 98, "DBMSrv", __FILE__, __LINE__, "7-Bit ASCII overflow in parameter", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message ASCII */
/* Begin of defines for message NOTADMIN: ID = 99, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NOTADMIN 99, "DBMSrv", __FILE__, __LINE__, "database has to be in operational state ADMIN", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NOTADMIN */
/* Begin of defines for message TOOMANYFILES: ID = 100, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_TOOMANYFILES 100, "DBMSrv", __FILE__, __LINE__, "too many files to list", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message TOOMANYFILES */
/* Begin of defines for message INVUSRNAME: ID = 101, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_INVUSRNAME 101, "DBMSrv", __FILE__, __LINE__, "user name $DBMSRV_COMP$ is reserved", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_INVUSRNAME__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message INVUSRNAME */
/* Begin of defines for message SQLREADONLY: ID = 102, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_SQLREADONLY 102, "DBMSrv", __FILE__, __LINE__, "sql session is read only", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message SQLREADONLY */
/* Begin of defines for message BADVERSION: ID = 103, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_BADVERSION 103, "DBMSrv", __FILE__, __LINE__, "invalid version: $DBMSRV_COMP$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_BADVERSION__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message BADVERSION */
/* Begin of defines for message MIGRATE: ID = 104, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_MIGRATE 104, "DBMSrv", __FILE__, __LINE__, "no migration possible from $DBMSRV_COMP$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_MIGRATE__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message MIGRATE */
/* Begin of defines for message SHUTDOWN: ID = 105, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_SHUTDOWN 105, "DBMSrv", __FILE__, __LINE__, "shutdown of database occured", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message SHUTDOWN */
/* Begin of defines for message KNLDIRTY: ID = 106, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_KNLDIRTY 106, "DBMSrv", __FILE__, __LINE__, "The backup history file $FILENAME$ is corrupted in line $LINE_NO$", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_KNLDIRTY__FILENAME "FILENAME"
#define SDBMSGTAG_DBMSRV_KNLDIRTY__LINE_NO "LINE_NO"
/* <- End of defines for message KNLDIRTY */
/* Begin of defines for message MDFDIRTY: ID = 107, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_MDFDIRTY 107, "DBMSrv", __FILE__, __LINE__, "The backup media history file $FILENAME$ is corrupted in line $LINE_NO$", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_MDFDIRTY__FILENAME "FILENAME"
#define SDBMSGTAG_DBMSRV_MDFDIRTY__LINE_NO "LINE_NO"
/* <- End of defines for message MDFDIRTY */
/* Begin of defines for message NOVOLDIR: ID = 108, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_NOVOLDIR 108, "DBMSrv", __FILE__, __LINE__, "the directory $DBMSRV_COMP$ does not exist", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_NOVOLDIR__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message NOVOLDIR */
/* Begin of defines for message NOVOLLINK: ID = 109, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_NOVOLLINK 109, "DBMSrv", __FILE__, __LINE__, "the symbolic link $DBMSRV_COMP$ does not exist", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_NOVOLLINK__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message NOVOLLINK */
/* Begin of defines for message BAWRONGMEDIUM: ID = 110, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_BAWRONGMEDIUM 110, "DBMSrv", __FILE__, __LINE__, "the backup medium can not be used for the command", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message BAWRONGMEDIUM */
/* Begin of defines for message BAWRONGSAVETYPE: ID = 111, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_BAWRONGSAVETYPE 111, "DBMSrv", __FILE__, __LINE__, "medium has wrong save type", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message BAWRONGSAVETYPE */
/* Begin of defines for message NOPREVSTAGEBACKUP: ID = 112, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NOPREVSTAGEBACKUP 112, "DBMSrv", __FILE__, __LINE__, "no stage files were backed up previously", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NOPREVSTAGEBACKUP */
/* Begin of defines for message MEEXISTSASGROUP: ID = 113, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_MEEXISTSASGROUP 113, "DBMSrv", __FILE__, __LINE__, "a media group with that name is already existing, use another name for your medium", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message MEEXISTSASGROUP */
/* Begin of defines for message MEEXISTSASMEDIUM: ID = 114, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_MEEXISTSASMEDIUM 114, "DBMSrv", __FILE__, __LINE__, "a medium with that name is already existing, use another name for your media group", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message MEEXISTSASMEDIUM */
/* Begin of defines for message MEAMBIGUOUS: ID = 115, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_MEAMBIGUOUS 115, "DBMSrv", __FILE__, __LINE__, "the medium can not be used, because there exist a single medium and a media group with the same name", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message MEAMBIGUOUS */
/* Begin of defines for message UTLIOSEQNEED: ID = 116, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_UTLIOSEQNEED 116, "DBMSrv", __FILE__, __LINE__, "invalid value ($DBMSRV_COMP$) for first needed IO sequence reported by database kernel", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_UTLIOSEQNEED__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message UTLIOSEQNEED */
/* Begin of defines for message UTLIOSEQAVAIL: ID = 117, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_UTLIOSEQAVAIL 117, "DBMSrv", __FILE__, __LINE__, "invalid value ($DBMSRV_COMP$) for first available IO sequence reported by database kernel", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_UTLIOSEQAVAIL__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message UTLIOSEQAVAIL */
/* Begin of defines for message LOGFULL: ID = 118, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_LOGFULL 118, "DBMSrv", __FILE__, __LINE__, "The log area is full", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message LOGFULL */
/* Begin of defines for message NOHSS: ID = 119, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_NOHSS 119, "DBMSrv", __FILE__, __LINE__, "The command $DBMSRV_COMP$ is not available for this operation", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_NOHSS__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message NOHSS */
/* Begin of defines for message HSS: ID = 120, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_HSS 120, "DBMSrv", __FILE__, __LINE__, "hot standby error", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message HSS */
/* Begin of defines for message NORESTORESTRATEGY: ID = 121, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NORESTORESTRATEGY 121, "DBMSrv", __FILE__, __LINE__, "Can not determine a restore strategy from the backup history", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NORESTORESTRATEGY */
/* Begin of defines for message BACKNOTINHIST: ID = 122, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_BACKNOTINHIST 122, "DBMSrv", __FILE__, __LINE__, "The backup can not be found in the backup history", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message BACKNOTINHIST */
/* Begin of defines for message NOMASTER: ID = 123, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NOMASTER 123, "DBMSrv", __FILE__, __LINE__, "This is not a master instance", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NOMASTER */
/* Begin of defines for message NOVERSIONMATCH: ID = 124, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_NOVERSIONMATCH 124, "DBMSrv", __FILE__, __LINE__, "No matching version found at node $DBMSRV_COMP$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_NOVERSIONMATCH__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message NOVERSIONMATCH */
/* Begin of defines for message NEEDADMI: ID = 125, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NEEDADMI 125, "DBMSrv", __FILE__, __LINE__, "The operating system user is not a member of the database administrators group", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NEEDADMI */
/* Begin of defines for message SERVICEDBNOTFOUND: ID = 126, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_SERVICEDBNOTFOUND 126, "DBMSrv", __FILE__, __LINE__, "The service database could not be found", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message SERVICEDBNOTFOUND */
/* Begin of defines for message ADDVOLNAMETOOLONG: ID = 127, VERSION = 2, TAGS = 3 -> */
#define SDBMSG_DBMSRV_ADDVOLNAMETOOLONG 127, "DBMSrv", __FILE__, __LINE__, "The name '$VOLUME_NAME$' of the new volume is too long. Volume not added", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("2"))
#define SDBMSGTAG_DBMSRV_ADDVOLNAMETOOLONG__VOLUME_NAME "VOLUME_NAME"
#define SDBMSGTAG_DBMSRV_ADDVOLNAMETOOLONG__LIMIT "LIMIT"
/* <- End of defines for message ADDVOLNAMETOOLONG */
/* Begin of defines for message NOEXPLAIN: ID = 128, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_NOEXPLAIN 128, "DBMSrv", __FILE__, __LINE__, "The command $COMMAND_NAME$ cannot be explained by the DBM Server", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_NOEXPLAIN__COMMAND_NAME "COMMAND_NAME"
/* <- End of defines for message NOEXPLAIN */
/* Begin of defines for message ILLEGALVOLSIZE: ID = 129, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_ILLEGALVOLSIZE 129, "DBMSrv", __FILE__, __LINE__, "Value \"$VALUE$\" of parameter \"$DBMSRV_CONFIGVAR$\" cannot be used for calculating the volume size of a new volume", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_ILLEGALVOLSIZE__VALUE "VALUE"
#define SDBMSGTAG_DBMSRV_ILLEGALVOLSIZE__DBMSRV_CONFIGVAR "DBMSRV_CONFIGVAR"
/* <- End of defines for message ILLEGALVOLSIZE */
/* Begin of defines for message PERCENTVAL_ILLEGAL: ID = 130, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_PERCENTVAL_ILLEGAL 130, "DBMSrv", __FILE__, __LINE__, "Percentage $PERCENTVALUE$ is illegal", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_PERCENTVAL_ILLEGAL__PERCENTVALUE "PERCENTVALUE"
/* <- End of defines for message PERCENTVAL_ILLEGAL */
/* Begin of defines for message AUTOEXT_ILLMODE: ID = 131, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_AUTOEXT_ILLMODE 131, "DBMSrv", __FILE__, __LINE__, "Mode \"$DBMSRV_COMP$\" is illegal", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_AUTOEXT_ILLMODE__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message AUTOEXT_ILLMODE */
/* Begin of defines for message SHMPANIC: ID = 132, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_SHMPANIC 132, "DBMSrv", __FILE__, __LINE__, "DBM shared memory panic! file: $DBMSRV_COMP1$ line: $DBMSRV_COMP2$", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_SHMPANIC__DBMSRV_COMP1 "DBMSRV_COMP1"
#define SDBMSGTAG_DBMSRV_SHMPANIC__DBMSRV_COMP2 "DBMSRV_COMP2"
/* <- End of defines for message SHMPANIC */
/* Begin of defines for message SHMRESLOCK: ID = 133, VERSION = 2, TAGS = 4 -> */
#define SDBMSG_DBMSRV_SHMRESLOCK 133, "DBMSrv", __FILE__, __LINE__, "Resource '$DBMSRV_COMP$' was locked during the last $TIME_VALUE$ seconds (in the end by process $PID$)", (Msg_Has4Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("2"))
#define SDBMSGTAG_DBMSRV_SHMRESLOCK__DBMSRV_COMP "DBMSRV_COMP"
#define SDBMSGTAG_DBMSRV_SHMRESLOCK__PID "PID"
#define SDBMSGTAG_DBMSRV_SHMRESLOCK__TIME_VALUE "TIME_VALUE"
/* <- End of defines for message SHMRESLOCK */
/* Begin of defines for message EVENTNONEAVAIL: ID = 134, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_EVENTNONEAVAIL 134, "DBMSrv", __FILE__, __LINE__, "no event available", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message EVENTNONEAVAIL */
/* Begin of defines for message ADDVOLWRONGMODE: ID = 135, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_ADDVOLWRONGMODE 135, "DBMSrv", __FILE__, __LINE__, "Operation not supported for volume mode $DBMSRV_COMP$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_ADDVOLWRONGMODE__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message ADDVOLWRONGMODE */
/* Begin of defines for message ADDVOLERRFDEGRANGE: ID = 136, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_ADDVOLERRFDEGRANGE 136, "DBMSrv", __FILE__, __LINE__, "Specified filling degree $DBMSRV_COMP$ is out of range", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_ADDVOLERRFDEGRANGE__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message ADDVOLERRFDEGRANGE */
/* Begin of defines for message ILLEGALTIMEFMT: ID = 137, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_ILLEGALTIMEFMT 137, "DBMSrv", __FILE__, __LINE__, "Time string $DBMSRV_COMP$ is not legal", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_ILLEGALTIMEFMT__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message ILLEGALTIMEFMT */
/* Begin of defines for message UNKNOWNINFOTYPE: ID = 138, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_UNKNOWNINFOTYPE 138, "DBMSrv", __FILE__, __LINE__, "InfoType $DBMSRV_COMP1$ unknown, variable part is $DBMSRV_COMP2$", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_UNKNOWNINFOTYPE__DBMSRV_COMP1 "DBMSRV_COMP1"
#define SDBMSGTAG_DBMSRV_UNKNOWNINFOTYPE__DBMSRV_COMP2 "DBMSRV_COMP2"
/* <- End of defines for message UNKNOWNINFOTYPE */
/* Begin of defines for message NOSCHEDULERSTOP: ID = 139, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_NOSCHEDULERSTOP 139, "DBMSrv", __FILE__, __LINE__, "Could not stop scheduler (pid $DBMSRV_COMP$)", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_NOSCHEDULERSTOP__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message NOSCHEDULERSTOP */
/* Begin of defines for message NOSCHEDULERSTART: ID = 140, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NOSCHEDULERSTART 140, "DBMSrv", __FILE__, __LINE__, "Could not start scheduler", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NOSCHEDULERSTART */
/* Begin of defines for message NOTJOBOWNER: ID = 141, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NOTJOBOWNER 141, "DBMSrv", __FILE__, __LINE__, "You are not the owner of the job", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NOTJOBOWNER */
/* Begin of defines for message JOBNOTEXIST: ID = 142, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_JOBNOTEXIST 142, "DBMSrv", __FILE__, __LINE__, "Job does not exist", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message JOBNOTEXIST */
/* Begin of defines for message PREDECESSORNOTEXIST: ID = 143, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_PREDECESSORNOTEXIST 143, "DBMSrv", __FILE__, __LINE__, "Predecessor does not exist", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message PREDECESSORNOTEXIST */
/* Begin of defines for message ILLJOBNUMBER: ID = 144, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_ILLJOBNUMBER 144, "DBMSrv", __FILE__, __LINE__, "Job number \"$DBMSRV_COMP$\" is illegal", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_ILLJOBNUMBER__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message ILLJOBNUMBER */
/* Begin of defines for message JOBHASSUCCESSORS: ID = 145, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_JOBHASSUCCESSORS 145, "DBMSrv", __FILE__, __LINE__, "Job has successors. Cannot delete it", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message JOBHASSUCCESSORS */
/* Begin of defines for message INSERVERPROCESSSTARTER: ID = 146, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_INSERVERPROCESSSTARTER 146, "DBMSrv", __FILE__, __LINE__, "Could not start server process (used command: \"$DBMSRV_COMP$\")", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_INSERVERPROCESSSTARTER__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message INSERVERPROCESSSTARTER */
/* Begin of defines for message NOSERVERPROCESSRUNNING: ID = 147, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_NOSERVERPROCESSRUNNING 147, "DBMSrv", __FILE__, __LINE__, "Could not start server process (used command: \"$DBMSRV_COMP$\")", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_NOSERVERPROCESSRUNNING__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message NOSERVERPROCESSRUNNING */
/* Begin of defines for message PROCSTARTERROR: ID = 148, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_PROCSTARTERROR 148, "DBMSrv", __FILE__, __LINE__, "Could not start background process (errorcode: $DBMSRV_COMP$)", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_PROCSTARTERROR__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message PROCSTARTERROR */
/* Begin of defines for message PROCSPAWNFAILED: ID = 149, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_PROCSPAWNFAILED 149, "DBMSrv", __FILE__, __LINE__, "Error spawning child process", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message PROCSPAWNFAILED */
/* Begin of defines for message PROCWAITERROR: ID = 150, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_PROCWAITERROR 150, "DBMSrv", __FILE__, __LINE__, "Error waiting for child process (errno: $DBMSRV_COMP$)", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_PROCWAITERROR__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message PROCWAITERROR */
/* Begin of defines for message PROCCHLDEXIT: ID = 151, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_PROCCHLDEXIT 151, "DBMSrv", __FILE__, __LINE__, "Child process exited abnormally", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message PROCCHLDEXIT */
/* Begin of defines for message PROCSHMDESTERRORT: ID = 152, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_PROCSHMDESTERRORT 152, "DBMSrv", __FILE__, __LINE__, "Could not destroy shared memory (errno: $DBMSRV_COMP$)", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_PROCSHMDESTERRORT__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message PROCSHMDESTERRORT */
/* Begin of defines for message PROCSHMDETERROR: ID = 153, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_PROCSHMDETERROR 153, "DBMSrv", __FILE__, __LINE__, "Could not detach from shared memory (errno: $DBMSRV_COMP$)", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_PROCSHMDETERROR__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message PROCSHMDETERROR */
/* Begin of defines for message PROCSHMDETCHLDERR: ID = 154, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_PROCSHMDETCHLDERR 154, "DBMSrv", __FILE__, __LINE__, "Child could not detach from shared memory", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message PROCSHMDETCHLDERR */
/* Begin of defines for message PROCSHMATTERROR: ID = 155, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_PROCSHMATTERROR 155, "DBMSrv", __FILE__, __LINE__, "Could not attach to shared memory (errno: $DBMSRV_COMP$)", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_PROCSHMATTERROR__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message PROCSHMATTERROR */
/* Begin of defines for message PROCSHMCREATEERROR: ID = 156, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_PROCSHMCREATEERROR 156, "DBMSrv", __FILE__, __LINE__, "Could not create shared memory (errno: $DBMSRV_COMP$)", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_PROCSHMCREATEERROR__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message PROCSHMCREATEERROR */
/* Begin of defines for message SCHEDULERUNEXPECTED: ID = 157, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_SCHEDULERUNEXPECTED 157, "DBMSrv", __FILE__, __LINE__, "Unexpected scheduler reply", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message SCHEDULERUNEXPECTED */
/* Begin of defines for message NOBRAIN: ID = 158, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NOBRAIN 158, "DBMSrv", __FILE__, __LINE__, "I know nothing", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NOBRAIN */
/* Begin of defines for message NOBEER: ID = 159, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_NOBEER 159, "DBMSrv", __FILE__, __LINE__, "I want to drink $DBMSRV_COMP$ liters", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_NOBEER__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message NOBEER */
/* Begin of defines for message NODBMLOGGER: ID = 160, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NODBMLOGGER 160, "DBMSrv", __FILE__, __LINE__, "DBM logger could not be initialized", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NODBMLOGGER */
/* Begin of defines for message DBISDROPPED: ID = 161, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_DBISDROPPED 161, "DBMSrv", __FILE__, __LINE__, "database $DBMSRV_COMP$ is dropped, no commands can be executed", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_DBISDROPPED__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message DBISDROPPED */
/* Begin of defines for message IS_NO_OPTION: ID = 162, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_IS_NO_OPTION 162, "DBMSrv", __FILE__, __LINE__, "command $DBMSRV_COMP1$ has no option $DBMSRV_COMP2$", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_IS_NO_OPTION__DBMSRV_COMP1 "DBMSRV_COMP1"
#define SDBMSGTAG_DBMSRV_IS_NO_OPTION__DBMSRV_COMP2 "DBMSRV_COMP2"
/* <- End of defines for message IS_NO_OPTION */
/* Begin of defines for message FILECHK: ID = 163, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_FILECHK 163, "DBMSrv", __FILE__, __LINE__, "Error checking file $FILENAME$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_FILECHK__FILENAME "FILENAME"
/* <- End of defines for message FILECHK */
/* Begin of defines for message FILEDEL: ID = 164, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_FILEDEL 164, "DBMSrv", __FILE__, __LINE__, "Error deleting file $FILENAME$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_FILEDEL__FILENAME "FILENAME"
/* <- End of defines for message FILEDEL */
/* Begin of defines for message SHMNOINFOFILE: ID = 165, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_SHMNOINFOFILE 165, "DBMSrv", __FILE__, __LINE__, "Shared memory missing information file", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message SHMNOINFOFILE */
/* Begin of defines for message SHMNODATAFILE: ID = 166, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_SHMNODATAFILE 166, "DBMSrv", __FILE__, __LINE__, "Shared memory missing data file", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message SHMNODATAFILE */
/* Begin of defines for message SHMFILEPERM: ID = 167, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_SHMFILEPERM 167, "DBMSrv", __FILE__, __LINE__, "Shared memory wrong permissions (at $DBMSRV_COMP1$, $DBMSRV_COMP2$)", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_SHMFILEPERM__DBMSRV_COMP1 "DBMSRV_COMP1"
#define SDBMSGTAG_DBMSRV_SHMFILEPERM__DBMSRV_COMP2 "DBMSRV_COMP2"
/* <- End of defines for message SHMFILEPERM */
/* Begin of defines for message SHMNOTAVAILABLE: ID = 168, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_SHMNOTAVAILABLE 168, "DBMSrv", __FILE__, __LINE__, "Shared memory not available", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message SHMNOTAVAILABLE */
/* Begin of defines for message BHIST_EXT_INVALID_LINE: ID = 169, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_BHIST_EXT_INVALID_LINE 169, "DBMSrv", __FILE__, __LINE__, "The line \"$LINE2$\" is an invalid line for the external backup history", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_BHIST_EXT_INVALID_LINE__LINE2 "LINE2"
/* <- End of defines for message BHIST_EXT_INVALID_LINE */
/* Begin of defines for message BHIST_EXT_OPEN: ID = 170, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_BHIST_EXT_OPEN 170, "DBMSrv", __FILE__, __LINE__, "could not open external backup history file $DBMSRV_COMP$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_BHIST_EXT_OPEN__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message BHIST_EXT_OPEN */
/* Begin of defines for message BHIST_EXT_WRITE: ID = 171, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_BHIST_EXT_WRITE 171, "DBMSrv", __FILE__, __LINE__, "could not write to external backup history file $DBMSRV_COMP$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_BHIST_EXT_WRITE__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message BHIST_EXT_WRITE */
/* Begin of defines for message MEMORY: ID = 172, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_MEMORY 172, "DBMSrv", __FILE__, __LINE__, "required memory could not be allocated from operating system", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message MEMORY */
/* Begin of defines for message SHMALLOCFAILED: ID = 173, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_SHMALLOCFAILED 173, "DBMSrv", __FILE__, __LINE__, "ID $DBMSRV_COMP1$, requested size $DBMSRV_COMP2$", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_SHMALLOCFAILED__DBMSRV_COMP1 "DBMSRV_COMP1"
#define SDBMSGTAG_DBMSRV_SHMALLOCFAILED__DBMSRV_COMP2 "DBMSRV_COMP2"
/* <- End of defines for message SHMALLOCFAILED */
/* Begin of defines for message NIERROR: ID = 174, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_NIERROR 174, "DBMSrv", __FILE__, __LINE__, "$DBMSRV_COMP$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_NIERROR__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message NIERROR */
/* Begin of defines for message IOMANPROCWP: ID = 175, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_IOMANPROCWP 175, "DBMSrv", __FILE__, __LINE__, "IO managed process: error ($DBMSRV_COMP$) opening write pipe", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_IOMANPROCWP__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message IOMANPROCWP */
/* Begin of defines for message IOMANPROCRP: ID = 176, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_IOMANPROCRP 176, "DBMSrv", __FILE__, __LINE__, "IO managed process: error ($DBMSRV_COMP$) opening read pipe", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_IOMANPROCRP__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message IOMANPROCRP */
/* Begin of defines for message IOMANPROCLOGON: ID = 177, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_IOMANPROCLOGON 177, "DBMSrv", __FILE__, __LINE__, "IO managed process: error ($DBMSRV_COMP$) during logon", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_IOMANPROCLOGON__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message IOMANPROCLOGON */
/* Begin of defines for message IOMANPROCCMD: ID = 178, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_IOMANPROCCMD 178, "DBMSrv", __FILE__, __LINE__, "IO managed process: error ($DBMSRV_COMP1$) during command execution $DBMSRV_COMP2$", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_IOMANPROCCMD__DBMSRV_COMP1 "DBMSRV_COMP1"
#define SDBMSGTAG_DBMSRV_IOMANPROCCMD__DBMSRV_COMP2 "DBMSRV_COMP2"
/* <- End of defines for message IOMANPROCCMD */
/* Begin of defines for message IOMANPROCPID: ID = 179, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_IOMANPROCPID 179, "DBMSrv", __FILE__, __LINE__, "IO managed process: error ($DBMSRV_COMP$) getting pid", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_IOMANPROCPID__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message IOMANPROCPID */
/* Begin of defines for message IOMANPROCEXIT: ID = 180, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_IOMANPROCEXIT 180, "DBMSrv", __FILE__, __LINE__, "IO managed process: error ($DBMSRV_COMP$) during exit command", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_IOMANPROCEXIT__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message IOMANPROCEXIT */
/* Begin of defines for message IOMANPROCDELWP: ID = 181, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_IOMANPROCDELWP 181, "DBMSrv", __FILE__, __LINE__, "IO managed process: error ($DBMSRV_COMP$) deleting write pipe", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_IOMANPROCDELWP__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message IOMANPROCDELWP */
/* Begin of defines for message IOMANPROCDELRP: ID = 182, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_IOMANPROCDELRP 182, "DBMSrv", __FILE__, __LINE__, "IO managed process: error ($DBMSRV_COMP$) deleting read pipe", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_IOMANPROCDELRP__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message IOMANPROCDELRP */
/* Begin of defines for message IOMANPROCPROCDIED: ID = 183, VERSION = 1, TAGS = 4 -> */
#define SDBMSG_DBMSRV_IOMANPROCPROCDIED 183, "DBMSrv", __FILE__, __LINE__, "IO managed process: process (pid $DBMSRV_COMP1$, serverpid $DBMSRV_COMP2$) died (retcode $DBMSRV_COMP3$)", (Msg_Has4Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_IOMANPROCPROCDIED__DBMSRV_COMP1 "DBMSRV_COMP1"
#define SDBMSGTAG_DBMSRV_IOMANPROCPROCDIED__DBMSRV_COMP2 "DBMSRV_COMP2"
#define SDBMSGTAG_DBMSRV_IOMANPROCPROCDIED__DBMSRV_COMP3 "DBMSRV_COMP3"
/* <- End of defines for message IOMANPROCPROCDIED */
/* Begin of defines for message IOMANNOWP: ID = 184, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_IOMANNOWP 184, "DBMSrv", __FILE__, __LINE__, "IO managed process: error ($DBMSRV_COMP$) creating write pipe", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_IOMANNOWP__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message IOMANNOWP */
/* Begin of defines for message IOMANNORP: ID = 185, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_IOMANNORP 185, "DBMSrv", __FILE__, __LINE__, "IO managed process: error ($DBMSRV_COMP$) creating read pipe", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_IOMANNORP__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message IOMANNORP */
/* Begin of defines for message IOMANBADWP: ID = 186, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_IOMANBADWP 186, "DBMSrv", __FILE__, __LINE__, "IO managed process: write pipe is bad, error ($DBMSRV_COMP$)", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_IOMANBADWP__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message IOMANBADWP */
/* Begin of defines for message IOMANBADRP: ID = 187, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_IOMANBADRP 187, "DBMSrv", __FILE__, __LINE__, "IO managed process: read pipe is bad, error ($DBMSRV_COMP$)", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_IOMANBADRP__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message IOMANBADRP */
/* Begin of defines for message IOMANNOEND: ID = 188, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_IOMANNOEND 188, "DBMSrv", __FILE__, __LINE__, "IO managed process: no prompt after answer end", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message IOMANNOEND */
/* Begin of defines for message CONNLOST: ID = 189, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_CONNLOST 189, "DBMSrv", __FILE__, __LINE__, "connection to client lost (error code $DBMSRV_COMP$)", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_CONNLOST__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message CONNLOST */
/* Begin of defines for message EXCEPTIONCAUGHT: ID = 190, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_EXCEPTIONCAUGHT 190, "DBMSrv", __FILE__, __LINE__, "exception caught (address $DBMSRV_COMP1$, id $DBMSRV_COMP2$)", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_EXCEPTIONCAUGHT__DBMSRV_COMP1 "DBMSRV_COMP1"
#define SDBMSGTAG_DBMSRV_EXCEPTIONCAUGHT__DBMSRV_COMP2 "DBMSRV_COMP2"
/* <- End of defines for message EXCEPTIONCAUGHT */
/* Begin of defines for message STE: ID = 191, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_STE 191, "DBMSrv", __FILE__, __LINE__, "$DBMSRV_COMP$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_STE__DBMSRV_COMP "DBMSRV_COMP"
/* <- End of defines for message STE */
/* Begin of defines for message SHMVERSIONMISMATCH: ID = 193, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_SHMVERSIONMISMATCH 193, "DBMSrv", __FILE__, __LINE__, "Cannot work with shared memory version $DBMSRV_SHMVERSCURR$ (expected $DBMSRV_SHMVERSREQ$)", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_SHMVERSIONMISMATCH__DBMSRV_SHMVERSCURR "DBMSRV_SHMVERSCURR"
#define SDBMSGTAG_DBMSRV_SHMVERSIONMISMATCH__DBMSRV_SHMVERSREQ "DBMSRV_SHMVERSREQ"
/* <- End of defines for message SHMVERSIONMISMATCH */
/* Begin of defines for message NODISPATCHERSTART: ID = 194, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NODISPATCHERSTART 194, "DBMSrv", __FILE__, __LINE__, "cannot start Event Dispatcher", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NODISPATCHERSTART */
/* Begin of defines for message NOAUTOEXTEND: ID = 195, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NOAUTOEXTEND 195, "DBMSrv", __FILE__, __LINE__, "auto extend feature not activated", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NOAUTOEXTEND */
/* Begin of defines for message NOAUTOEXTENDOFF: ID = 196, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NOAUTOEXTENDOFF 196, "DBMSrv", __FILE__, __LINE__, "auto extend feature not deactivated", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NOAUTOEXTENDOFF */
/* Begin of defines for message NODISPATCHERSTOP: ID = 197, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NODISPATCHERSTOP 197, "DBMSrv", __FILE__, __LINE__, "cannot stop Event Dispatcher", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NODISPATCHERSTOP */
/* Begin of defines for message NOAUTOUPDSTAT: ID = 198, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NOAUTOUPDSTAT 198, "DBMSrv", __FILE__, __LINE__, "auto update statistics feature not activated", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NOAUTOUPDSTAT */
/* Begin of defines for message NOAUTOUPDSTATOFF: ID = 199, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NOAUTOUPDSTATOFF 199, "DBMSrv", __FILE__, __LINE__, "auto update statistics feature not deactivated", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NOAUTOUPDSTATOFF */
/* Begin of defines for message AUTOUPDSTAT_ILLMODE: ID = 200, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_AUTOUPDSTAT_ILLMODE 200, "DBMSrv", __FILE__, __LINE__, "mode illegal", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message AUTOUPDSTAT_ILLMODE */
/* Begin of defines for message CMDOPTION: ID = 201, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_CMDOPTION 201, "DBMSrv", __FILE__, __LINE__, "Invalid option or invalid parameter \"$DBMSRV_CMDOPTION$\" for command \"$DBMSRV_CMDNAME$\"", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_CMDOPTION__DBMSRV_CMDNAME "DBMSRV_CMDNAME"
#define SDBMSGTAG_DBMSRV_CMDOPTION__DBMSRV_CMDOPTION "DBMSRV_CMDOPTION"
/* <- End of defines for message CMDOPTION */
/* Begin of defines for message DATAFULL: ID = 202, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_DATAFULL 202, "DBMSrv", __FILE__, __LINE__, "Data area is full", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message DATAFULL */
/* Begin of defines for message NO_EVENTCONFIG_CHANGE: ID = 203, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NO_EVENTCONFIG_CHANGE 203, "DBMSrv", __FILE__, __LINE__, "Event configuration not changed", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NO_EVENTCONFIG_CHANGE */
/* Begin of defines for message EVENTCAT_UNKNOWN: ID = 204, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_EVENTCAT_UNKNOWN 204, "DBMSrv", __FILE__, __LINE__, "Event category $EVENTCATEGORY$ does not exist", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_EVENTCAT_UNKNOWN__EVENTCATEGORY "EVENTCATEGORY"
/* <- End of defines for message EVENTCAT_UNKNOWN */
/* Begin of defines for message EVENTPRIO_UNKNOWN: ID = 205, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_EVENTPRIO_UNKNOWN 205, "DBMSrv", __FILE__, __LINE__, "Event priority $EVENTPRIORITY$ does not exist", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_EVENTPRIO_UNKNOWN__EVENTPRIORITY "EVENTPRIORITY"
/* <- End of defines for message EVENTPRIO_UNKNOWN */
/* Begin of defines for message DISP_NO_EXIST: ID = 206, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_DISP_NO_EXIST 206, "DBMSrv", __FILE__, __LINE__, "Event Dispatcher instance $DISPID$ does not exist", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_DISP_NO_EXIST__DISPID "DISPID"
/* <- End of defines for message DISP_NO_EXIST */
/* Begin of defines for message DISP_NOT_STOPPED: ID = 207, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_DISP_NOT_STOPPED 207, "DBMSrv", __FILE__, __LINE__, "Event Dispatcher instance $DISPID$ not stopped", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_DISP_NOT_STOPPED__DISPID "DISPID"
/* <- End of defines for message DISP_NOT_STOPPED */
/* Begin of defines for message DISP_NO_REMOTE_ACCESS: ID = 208, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_DISP_NO_REMOTE_ACCESS 208, "DBMSrv", __FILE__, __LINE__, "Event Dispatcher instance $DISPID$ cannot be accessed remotely", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_DISP_NO_REMOTE_ACCESS__DISPID "DISPID"
/* <- End of defines for message DISP_NO_REMOTE_ACCESS */
/* Begin of defines for message DISP_NO_INTCMD_FOUND: ID = 209, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_DISP_NO_INTCMD_FOUND 209, "DBMSrv", __FILE__, __LINE__, "No internal command for Event Dispatcher instance $DISPID$ found", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_DISP_NO_INTCMD_FOUND__DISPID "DISPID"
/* <- End of defines for message DISP_NO_INTCMD_FOUND */
/* Begin of defines for message DISP_NO_LIST: ID = 210, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_DISP_NO_LIST 210, "DBMSrv", __FILE__, __LINE__, "Cannot list Event Dispatcher instances", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message DISP_NO_LIST */
/* Begin of defines for message DISP_NO_DELETE: ID = 211, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_DISP_NO_DELETE 211, "DBMSrv", __FILE__, __LINE__, "Event Dispatcher instances $DISPID$ cannot be deleted from shared memory", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_DISP_NO_DELETE__DISPID "DISPID"
/* <- End of defines for message DISP_NO_DELETE */
/* Begin of defines for message DISP_INTERNAL_EXISTS: ID = 212, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_DISP_INTERNAL_EXISTS 212, "DBMSrv", __FILE__, __LINE__, "internal Event Dispatcher already running", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message DISP_INTERNAL_EXISTS */
/* Begin of defines for message DISP_INTERNAL_NOACC: ID = 213, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_DISP_INTERNAL_NOACC 213, "DBMSrv", __FILE__, __LINE__, "No access to internal Event Dispatcher instance $DISPID$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_DISP_INTERNAL_NOACC__DISPID "DISPID"
/* <- End of defines for message DISP_INTERNAL_NOACC */
/* Begin of defines for message DISP_INTERNAL_NOT_REMOTE: ID = 214, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_DISP_INTERNAL_NOT_REMOTE 214, "DBMSrv", __FILE__, __LINE__, "internal Event Dispatcher cannot be started remotely", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message DISP_INTERNAL_NOT_REMOTE */
/* Begin of defines for message KNLUNKNOWN: ID = 215, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_KNLUNKNOWN 215, "DBMSrv", __FILE__, __LINE__, "Unknown reply from database instance", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message KNLUNKNOWN */
/* Begin of defines for message COMM_CLIENT_CONNECT: ID = 216, VERSION = 2, TAGS = 4 -> */
#define SDBMSG_DBMSRV_COMM_CLIENT_CONNECT 216, "DBMSrv", __FILE__, __LINE__, "DBM Server client connection (established at $TIME$): PID $PID$ on computer $HOSTNAME$", (Msg_Has4Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("2"))
#define SDBMSGTAG_DBMSRV_COMM_CLIENT_CONNECT__HOSTNAME "HOSTNAME"
#define SDBMSGTAG_DBMSRV_COMM_CLIENT_CONNECT__PID "PID"
#define SDBMSGTAG_DBMSRV_COMM_CLIENT_CONNECT__TIME "TIME"
/* <- End of defines for message COMM_CLIENT_CONNECT */
/* Begin of defines for message WRONGDBSTATE: ID = 217, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_WRONGDBSTATE 217, "DBMSrv", __FILE__, __LINE__, "Operational state $STATE$ of the database instance is unsuitable.", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_WRONGDBSTATE__STATE "STATE"
/* <- End of defines for message WRONGDBSTATE */
/* Begin of defines for message DBSTATENEEDED1: ID = 218, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_DBSTATENEEDED1 218, "DBMSrv", __FILE__, __LINE__, "Database instance must be in operational state $STATE$.", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_DBSTATENEEDED1__STATE "STATE"
/* <- End of defines for message DBSTATENEEDED1 */
/* Begin of defines for message DBSTATENEEDED2: ID = 219, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_DBSTATENEEDED2 219, "DBMSrv", __FILE__, __LINE__, "Database instance must be in one of the operational states $STATE1$ or $STATE2$.", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_DBSTATENEEDED2__STATE1 "STATE1"
#define SDBMSGTAG_DBMSRV_DBSTATENEEDED2__STATE2 "STATE2"
/* <- End of defines for message DBSTATENEEDED2 */
/* Begin of defines for message DBSTATENEEDED3: ID = 220, VERSION = 1, TAGS = 4 -> */
#define SDBMSG_DBMSRV_DBSTATENEEDED3 220, "DBMSrv", __FILE__, __LINE__, "Database instance must be in one of the operational states $STATE1$, $STATE2$ or $STATE3$.", (Msg_Has4Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_DBSTATENEEDED3__STATE1 "STATE1"
#define SDBMSGTAG_DBMSRV_DBSTATENEEDED3__STATE2 "STATE2"
#define SDBMSGTAG_DBMSRV_DBSTATENEEDED3__STATE3 "STATE3"
/* <- End of defines for message DBSTATENEEDED3 */
/* Begin of defines for message DBSTATENEEDED4: ID = 221, VERSION = 1, TAGS = 5 -> */
#define SDBMSG_DBMSRV_DBSTATENEEDED4 221, "DBMSrv", __FILE__, __LINE__, "Database instance must be in one of the operational states $STATE1$, $STATE2$, $STATE3$ or $STATE4$.", (Msg_Has5Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_DBSTATENEEDED4__STATE1 "STATE1"
#define SDBMSGTAG_DBMSRV_DBSTATENEEDED4__STATE2 "STATE2"
#define SDBMSGTAG_DBMSRV_DBSTATENEEDED4__STATE3 "STATE3"
#define SDBMSGTAG_DBMSRV_DBSTATENEEDED4__STATE4 "STATE4"
/* <- End of defines for message DBSTATENEEDED4 */
/* Begin of defines for message INTERNAL_TRANSPORT_MSG: ID = 222, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_INTERNAL_TRANSPORT_MSG 222, "DBMSrv", __FILE__, __LINE__, "$TAG$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_INTERNAL_TRANSPORT_MSG__TAG "TAG"
/* <- End of defines for message INTERNAL_TRANSPORT_MSG */
/* Begin of defines for message VOLTYPENOTALLOWED: ID = 223, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_VOLTYPENOTALLOWED 223, "DBMSrv", __FILE__, __LINE__, "Device type $TYPE$ of the volume is not allowed.", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_VOLTYPENOTALLOWED__TYPE "TYPE"
/* <- End of defines for message VOLTYPENOTALLOWED */
/* Begin of defines for message XPVALUNEX: ID = 224, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_XPVALUNEX 224, "DBMSrv", __FILE__, __LINE__, "The value '$VALUE$' is unexpected for the database parameter $DATABASE_PARAMETER$.", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_XPVALUNEX__DATABASE_PARAMETER "DATABASE_PARAMETER"
#define SDBMSGTAG_DBMSRV_XPVALUNEX__VALUE "VALUE"
/* <- End of defines for message XPVALUNEX */
/* Begin of defines for message VOLNFOUNDXP: ID = 225, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_VOLNFOUNDXP 225, "DBMSrv", __FILE__, __LINE__, "Could not find volume in parameter file of the database", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message VOLNFOUNDXP */
/* Begin of defines for message COMM_CLIENT_DISCONNECT: ID = 226, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_COMM_CLIENT_DISCONNECT 226, "DBMSrv", __FILE__, __LINE__, "DBM Server client disconnect: PID $PID$ on computer $HOSTNAME$", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_COMM_CLIENT_DISCONNECT__HOSTNAME "HOSTNAME"
#define SDBMSGTAG_DBMSRV_COMM_CLIENT_DISCONNECT__PID "PID"
/* <- End of defines for message COMM_CLIENT_DISCONNECT */
/* Begin of defines for message REPLY_ENDLESS: ID = 227, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_REPLY_ENDLESS 227, "DBMSrv", __FILE__, __LINE__, "DBM Server reply is no terminated correctly by a 0 byte.", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message REPLY_ENDLESS */
/* Begin of defines for message REPLY_2MSG: ID = 228, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_REPLY_2MSG 228, "DBMSrv", __FILE__, __LINE__, "Conversion of a reply into a message list was unsuccessful", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_REPLY_2MSG__BUFFER "BUFFER"
/* <- End of defines for message REPLY_2MSG */
/* Begin of defines for message PROCESSDATA_INVALID: ID = 230, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_PROCESSDATA_INVALID 230, "DBMSrv", __FILE__, __LINE__, "Process data for process $PID$ invalid", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_PROCESSDATA_INVALID__PID "PID"
/* <- End of defines for message PROCESSDATA_INVALID */
/* Begin of defines for message PROCESSDATA_ERR_SIZE: ID = 231, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_PROCESSDATA_ERR_SIZE 231, "DBMSrv", __FILE__, __LINE__, "Unable to calculate size of used virtual memory for PID $PID$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_PROCESSDATA_ERR_SIZE__PID "PID"
/* <- End of defines for message PROCESSDATA_ERR_SIZE */
/* Begin of defines for message PROCESSDATA_SIZE_NOTSUPPORTED: ID = 232, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_PROCESSDATA_SIZE_NOTSUPPORTED 232, "DBMSrv", __FILE__, __LINE__, "Size calculation of used virtual memory not supported on this platform", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message PROCESSDATA_SIZE_NOTSUPPORTED */
/* Begin of defines for message VOLSIZEILLEGAL: ID = 233, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_VOLSIZEILLEGAL 233, "DBMSrv", __FILE__, __LINE__, "The value '$SIZE$' is not permissible for the size of a database volume.", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_VOLSIZEILLEGAL__SIZE "SIZE"
/* <- End of defines for message VOLSIZEILLEGAL */
/* Begin of defines for message SETENV: ID = 234, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_SETENV 234, "DBMSrv", __FILE__, __LINE__, "Could not set the environment variable '$VALUE$'.", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_SETENV__VALUE "VALUE"
/* <- End of defines for message SETENV */
/* Begin of defines for message VOLLASTADDEDNFOUNDXPHIS: ID = 235, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_VOLLASTADDEDNFOUNDXPHIS 235, "DBMSrv", __FILE__, __LINE__, "No volume of type $VOLUME_TYPE$ could be found in the parameter history", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_VOLLASTADDEDNFOUNDXPHIS__VOLUME_TYPE "VOLUME_TYPE"
/* <- End of defines for message VOLLASTADDEDNFOUNDXPHIS */
/* Begin of defines for message NOAUTHENTICATION: ID = 236, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NOAUTHENTICATION 236, "DBMSrv", __FILE__, __LINE__, "no authentication method available", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NOAUTHENTICATION */
/* Begin of defines for message BHIST_INVALID_ENTRY: ID = 237, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_BHIST_INVALID_ENTRY 237, "DBMSrv", __FILE__, __LINE__, "The line \"$LINE2$\" is an invalid line for the backup history", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_BHIST_INVALID_ENTRY__LINE2 "LINE2"
/* <- End of defines for message BHIST_INVALID_ENTRY */
/* Begin of defines for message FORMAT_SEPARATORMISSING: ID = 238, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_FORMAT_SEPARATORMISSING 238, "DBMSrv", __FILE__, __LINE__, "String \"$STRING$\" does not contain the expected separator '$SEPARATOR$'", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_FORMAT_SEPARATORMISSING__STRING "STRING"
#define SDBMSGTAG_DBMSRV_FORMAT_SEPARATORMISSING__SEPARATOR "SEPARATOR"
/* <- End of defines for message FORMAT_SEPARATORMISSING */
/* Begin of defines for message FORMAT_UINTEGER: ID = 239, VERSION = 1, TAGS = 4 -> */
#define SDBMSG_DBMSRV_FORMAT_UINTEGER 239, "DBMSrv", __FILE__, __LINE__, "String \"$STRING$\" cannot be converted to an unsigned $BIT_SIZE$-bit integer value", (Msg_Has4Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_FORMAT_UINTEGER__STRING "STRING"
#define SDBMSGTAG_DBMSRV_FORMAT_UINTEGER__LIMIT_UPPER "LIMIT_UPPER"
#define SDBMSGTAG_DBMSRV_FORMAT_UINTEGER__BIT_SIZE "BIT_SIZE"
/* <- End of defines for message FORMAT_UINTEGER */
/* Begin of defines for message FORMAT_INTEGER: ID = 240, VERSION = 1, TAGS = 5 -> */
#define SDBMSG_DBMSRV_FORMAT_INTEGER 240, "DBMSrv", __FILE__, __LINE__, "String \"$STRING$\" cannot be converted to a signed $BIT_SIZE$-bit integer value", (Msg_Has5Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_FORMAT_INTEGER__STRING "STRING"
#define SDBMSGTAG_DBMSRV_FORMAT_INTEGER__LIMIT_UPPER "LIMIT_UPPER"
#define SDBMSGTAG_DBMSRV_FORMAT_INTEGER__BIT_SIZE "BIT_SIZE"
#define SDBMSGTAG_DBMSRV_FORMAT_INTEGER__LIMIT_LOWER "LIMIT_LOWER"
/* <- End of defines for message FORMAT_INTEGER */
/* Begin of defines for message BHIST_MED_INVALID_ENTRY: ID = 241, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_BHIST_MED_INVALID_ENTRY 241, "DBMSrv", __FILE__, __LINE__, "The line \"$LINE2$\" is an invalid line for the backup media history", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_BHIST_MED_INVALID_ENTRY__LINE2 "LINE2"
/* <- End of defines for message BHIST_MED_INVALID_ENTRY */
/* Begin of defines for message FORMAT_SEPARATORNO3: ID = 242, VERSION = 1, TAGS = 7 -> */
#define SDBMSG_DBMSRV_FORMAT_SEPARATORNO3 242, "DBMSrv", __FILE__, __LINE__, "String \"$STRING$\" does not contain the expected number of separators '$SEPARATOR$'", (Msg_Has7Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_FORMAT_SEPARATORNO3__STRING "STRING"
#define SDBMSGTAG_DBMSRV_FORMAT_SEPARATORNO3__SEPARATOR "SEPARATOR"
#define SDBMSGTAG_DBMSRV_FORMAT_SEPARATORNO3__NUMBER1 "NUMBER1"
#define SDBMSGTAG_DBMSRV_FORMAT_SEPARATORNO3__NUMBER2 "NUMBER2"
#define SDBMSGTAG_DBMSRV_FORMAT_SEPARATORNO3__NUMBER3 "NUMBER3"
#define SDBMSGTAG_DBMSRV_FORMAT_SEPARATORNO3__NUMBER_FOUND "NUMBER_FOUND"
/* <- End of defines for message FORMAT_SEPARATORNO3 */
/* Begin of defines for message FORMAT_SEPARATORNOP: ID = 243, VERSION = 1, TAGS = 5 -> */
#define SDBMSG_DBMSRV_FORMAT_SEPARATORNOP 243, "DBMSrv", __FILE__, __LINE__, "The separator '$SEPARATOR$' cannot be found $NUMBER$ times within string \"$STRING$\"", (Msg_Has5Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_FORMAT_SEPARATORNOP__STRING "STRING"
#define SDBMSGTAG_DBMSRV_FORMAT_SEPARATORNOP__SEPARATOR "SEPARATOR"
#define SDBMSGTAG_DBMSRV_FORMAT_SEPARATORNOP__NUMBER_FOUND "NUMBER_FOUND"
#define SDBMSGTAG_DBMSRV_FORMAT_SEPARATORNOP__NUMBER "NUMBER"
/* <- End of defines for message FORMAT_SEPARATORNOP */
/* Begin of defines for message SDBINST: ID = 244, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_SDBINST 244, "DBMSrv", __FILE__, __LINE__, "Error in component SDBINST: $ERRORTEXT$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_SDBINST__ERRORTEXT "ERRORTEXT"
/* <- End of defines for message SDBINST */
/* Begin of defines for message SESSIONLIMIT: ID = 245, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_SESSIONLIMIT 245, "DBMSrv", __FILE__, __LINE__, "No session of type '$SESSIONTYPE$' available", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_SESSIONLIMIT__SESSIONTYPE "SESSIONTYPE"
/* <- End of defines for message SESSIONLIMIT */
/* Begin of defines for message HSSNODEUNKNOWN: ID = 246, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_HSSNODEUNKNOWN 246, "DBMSrv", __FILE__, __LINE__, "The specified HSS node is not known", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message HSSNODEUNKNOWN */
/* Begin of defines for message MISSDBUSRPWD: ID = 247, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_MISSDBUSRPWD 247, "DBMSrv", __FILE__, __LINE__, "Missing database, user or password", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message MISSDBUSRPWD */
/* Begin of defines for message UNKNOWNTASK: ID = 248, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_UNKNOWNTASK 248, "DBMSrv", __FILE__, __LINE__, "Unknown task type", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message UNKNOWNTASK */
/* Begin of defines for message LOCISDIR: ID = 249, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_LOCISDIR 249, "DBMSrv", __FILE__, __LINE__, "The device or file  $FILENAME$ is a directory", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_LOCISDIR__FILENAME "FILENAME"
/* <- End of defines for message LOCISDIR */
/* Begin of defines for message INVPARAM: ID = 250, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_INVPARAM 250, "DBMSrv", __FILE__, __LINE__, "Parameter \"$PARAMETER$\" is not allowed", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_INVPARAM__PARAMETER "PARAMETER"
/* <- End of defines for message INVPARAM */
/* Begin of defines for message MISSPARAM: ID = 251, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_MISSPARAM 251, "DBMSrv", __FILE__, __LINE__, "Missing parameter $PARAMETER$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_MISSPARAM__PARAMETER "PARAMETER"
/* <- End of defines for message MISSPARAM */
/* Begin of defines for message FILEOPEN: ID = 252, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_FILEOPEN 252, "DBMSrv", __FILE__, __LINE__, "Error opening file $FILENAME$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_FILEOPEN__FILENAME "FILENAME"
/* <- End of defines for message FILEOPEN */
/* Begin of defines for message FILEWRITE: ID = 253, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_FILEWRITE 253, "DBMSrv", __FILE__, __LINE__, "Error writing file $FILENAME$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_FILEWRITE__FILENAME "FILENAME"
/* <- End of defines for message FILEWRITE */
/* Begin of defines for message FILECLOSE: ID = 254, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_FILECLOSE 254, "DBMSrv", __FILE__, __LINE__, "Error closing file $FILENAME$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_FILECLOSE__FILENAME "FILENAME"
/* <- End of defines for message FILECLOSE */
/* Begin of defines for message XPWRITE: ID = 255, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_XPWRITE 255, "DBMSrv", __FILE__, __LINE__, "Can not write configuration parameter $PARAMETER$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_XPWRITE__PARAMETER "PARAMETER"
/* <- End of defines for message XPWRITE */
/* Begin of defines for message SHMPLATFORMMISMATCH: ID = 256, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_SHMPLATFORMMISMATCH 256, "DBMSrv", __FILE__, __LINE__, "Shared Memory from different platform $SHMFILEPLATFORM$ (expected $SHMCODEPLATFORM$)", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_SHMPLATFORMMISMATCH__SHMFILEPLATFORM "SHMFILEPLATFORM"
#define SDBMSGTAG_DBMSRV_SHMPLATFORMMISMATCH__SHMCODEPLATFORM "SHMCODEPLATFORM"
/* <- End of defines for message SHMPLATFORMMISMATCH */
/* Begin of defines for message SHMNOLOCK: ID = 257, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_SHMNOLOCK 257, "DBMSrv", __FILE__, __LINE__, "Cound not lock Shared Memory", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message SHMNOLOCK */
/* Begin of defines for message SHMNOUNLOCK: ID = 258, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_SHMNOUNLOCK 258, "DBMSrv", __FILE__, __LINE__, "Could not release lock of Shared Memory", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message SHMNOUNLOCK */
/* Begin of defines for message SHMWRONGUNLOCKPID: ID = 259, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_SHMWRONGUNLOCKPID 259, "DBMSrv", __FILE__, __LINE__, "Attempting to release lock of process ID $PID$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_SHMWRONGUNLOCKPID__PID "PID"
/* <- End of defines for message SHMWRONGUNLOCKPID */
/* Begin of defines for message SHMSHIFTERROR: ID = 260, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_SHMSHIFTERROR 260, "DBMSrv", __FILE__, __LINE__, "Could not change size of Shared Memory ($ADDRESS$, $BYTES_NEEDED$)", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_SHMSHIFTERROR__ADDRESS "ADDRESS"
#define SDBMSGTAG_DBMSRV_SHMSHIFTERROR__BYTES_NEEDED "BYTES_NEEDED"
/* <- End of defines for message SHMSHIFTERROR */
/* Begin of defines for message SHMERREXTEND: ID = 261, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_SHMERREXTEND 261, "DBMSrv", __FILE__, __LINE__, "Could not resize Shared memory for linetype $SHMLINETYPE$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_SHMERREXTEND__SHMLINETYPE "SHMLINETYPE"
/* <- End of defines for message SHMERREXTEND */
/* Begin of defines for message SHMLINEOUTOFSCOPE: ID = 262, VERSION = 1, TAGS = 5 -> */
#define SDBMSG_DBMSRV_SHMLINEOUTOFSCOPE 262, "DBMSrv", __FILE__, __LINE__, "Shared Memory line invalid. ShM size $SIZE$, type $SHMLINETYPE$, offset $BYTE_OFFSET$, data $SHMLINEDATA$", (Msg_Has5Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_SHMLINEOUTOFSCOPE__BYTE_OFFSET "BYTE_OFFSET"
#define SDBMSGTAG_DBMSRV_SHMLINEOUTOFSCOPE__SIZE "SIZE"
#define SDBMSGTAG_DBMSRV_SHMLINEOUTOFSCOPE__SHMLINETYPE "SHMLINETYPE"
#define SDBMSGTAG_DBMSRV_SHMLINEOUTOFSCOPE__SHMLINEDATA "SHMLINEDATA"
/* <- End of defines for message SHMLINEOUTOFSCOPE */
/* Begin of defines for message SHMNORESOURCELYT: ID = 263, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_SHMNORESOURCELYT 263, "DBMSrv", __FILE__, __LINE__, "Could not create line layout for resource object $RESOURCE$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_SHMNORESOURCELYT__RESOURCE "RESOURCE"
/* <- End of defines for message SHMNORESOURCELYT */
/* Begin of defines for message SHMNORESOURCELYTDEL: ID = 264, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_SHMNORESOURCELYTDEL 264, "DBMSrv", __FILE__, __LINE__, "Could not delete line layout for resource object $RESOURCE$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_SHMNORESOURCELYTDEL__RESOURCE "RESOURCE"
/* <- End of defines for message SHMNORESOURCELYTDEL */
/* Begin of defines for message SHMNOSCHEDLYT: ID = 265, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_SHMNOSCHEDLYT 265, "DBMSrv", __FILE__, __LINE__, "Could not create line layout for Scheduler", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message SHMNOSCHEDLYT */
/* Begin of defines for message SHMNOSCHEDLYTDEL: ID = 266, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_SHMNOSCHEDLYTDEL 266, "DBMSrv", __FILE__, __LINE__, "Could not delete line layout for Scheduler", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message SHMNOSCHEDLYTDEL */
/* Begin of defines for message SHMNOEVTSILLYT: ID = 267, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_SHMNOEVTSILLYT 267, "DBMSrv", __FILE__, __LINE__, "Could not create line layout for Eventing (silent)", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message SHMNOEVTSILLYT */
/* Begin of defines for message SHMNOEVTSILLYTDEL: ID = 268, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_SHMNOEVTSILLYTDEL 268, "DBMSrv", __FILE__, __LINE__, "Could not delete line layout for Eventing (silent)", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message SHMNOEVTSILLYTDEL */
/* Begin of defines for message SHMNOEVTLYT: ID = 269, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_SHMNOEVTLYT 269, "DBMSrv", __FILE__, __LINE__, "Could not create line layout for Event Dispatcher $DISPID$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_SHMNOEVTLYT__DISPID "DISPID"
/* <- End of defines for message SHMNOEVTLYT */
/* Begin of defines for message SHMNOEVTLYTFOUND: ID = 270, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_SHMNOEVTLYTFOUND 270, "DBMSrv", __FILE__, __LINE__, "Could not find line layout for Event Dispatcher $DISPID$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_SHMNOEVTLYTFOUND__DISPID "DISPID"
/* <- End of defines for message SHMNOEVTLYTFOUND */
/* Begin of defines for message SHMNOEVTLYTDEL: ID = 271, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_SHMNOEVTLYTDEL 271, "DBMSrv", __FILE__, __LINE__, "Could not delete line layout for Event Dispatcher $DISPID$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_SHMNOEVTLYTDEL__DISPID "DISPID"
/* <- End of defines for message SHMNOEVTLYTDEL */
/* Begin of defines for message SHMNOEVTLYTNEW: ID = 272, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_SHMNOEVTLYTNEW 272, "DBMSrv", __FILE__, __LINE__, "Could not create new line layout for Event Dispatcher with process ID $PID$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_SHMNOEVTLYTNEW__PID "PID"
/* <- End of defines for message SHMNOEVTLYTNEW */
/* Begin of defines for message SHMNORESOURCELYTFOUND: ID = 273, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_SHMNORESOURCELYTFOUND 273, "DBMSrv", __FILE__, __LINE__, "Could not find line layout for resource object $RESOURCE$ nicht finden", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_SHMNORESOURCELYTFOUND__RESOURCE "RESOURCE"
/* <- End of defines for message SHMNORESOURCELYTFOUND */
/* Begin of defines for message SHMLINESEXCEEDED: ID = 274, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_SHMLINESEXCEEDED 274, "DBMSrv", __FILE__, __LINE__, "Too many lines of type $SHMLINETYPE$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_SHMLINESEXCEEDED__SHMLINETYPE "SHMLINETYPE"
/* <- End of defines for message SHMLINESEXCEEDED */
/* Begin of defines for message RESLOCK_NO_CREATE: ID = 275, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_RESLOCK_NO_CREATE 275, "DBMSrv", __FILE__, __LINE__, "Resource lock $RESOURCE$ not created", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_RESLOCK_NO_CREATE__RESOURCE "RESOURCE"
/* <- End of defines for message RESLOCK_NO_CREATE */
/* Begin of defines for message RESLOCK_NO_LOCK: ID = 276, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_RESLOCK_NO_LOCK 276, "DBMSrv", __FILE__, __LINE__, "Resource $RESOURCE$ not locked", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_RESLOCK_NO_LOCK__RESOURCE "RESOURCE"
/* <- End of defines for message RESLOCK_NO_LOCK */
/* Begin of defines for message RESLOCK_NO_UNLOCK: ID = 277, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_RESLOCK_NO_UNLOCK 277, "DBMSrv", __FILE__, __LINE__, "Resource $RESOURCE$ not unlocked", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_RESLOCK_NO_UNLOCK__RESOURCE "RESOURCE"
/* <- End of defines for message RESLOCK_NO_UNLOCK */
/* Begin of defines for message SCHEDCOM_NO_CREATE: ID = 278, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_SCHEDCOM_NO_CREATE 278, "DBMSrv", __FILE__, __LINE__, "Data structure for Scheduler communication not created", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message SCHEDCOM_NO_CREATE */
/* Begin of defines for message EVTSIL_NO_CREATE: ID = 279, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_EVTSIL_NO_CREATE 279, "DBMSrv", __FILE__, __LINE__, "Data structure for Event Dispatcher communication (silent) not created", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message EVTSIL_NO_CREATE */
/* Begin of defines for message EVT_NO_CREATE: ID = 280, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_EVT_NO_CREATE 280, "DBMSrv", __FILE__, __LINE__, "Data structure for Event Dispatcher communication (dispatcher $DISPID$) not created", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_EVT_NO_CREATE__DISPID "DISPID"
/* <- End of defines for message EVT_NO_CREATE */
/* Begin of defines for message EVT_NO_CREATE_PID: ID = 281, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_EVT_NO_CREATE_PID 281, "DBMSrv", __FILE__, __LINE__, "Data structure for Event Dispatcher communication ( process ID $PID$) not created", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_EVT_NO_CREATE_PID__PID "PID"
/* <- End of defines for message EVT_NO_CREATE_PID */
/* Begin of defines for message EVT_NO_ITERATOR_CREATE: ID = 282, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_EVT_NO_ITERATOR_CREATE 282, "DBMSrv", __FILE__, __LINE__, "Iterator on datastructures for Event Dispatcher communication not created", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message EVT_NO_ITERATOR_CREATE */
/* Begin of defines for message COMMAND_RECEIVED: ID = 283, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_COMMAND_RECEIVED 283, "DBMSrv", __FILE__, __LINE__, "command $DBMSRV_CMDNAME$ $DBMSRV_CMDOPTION$", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_COMMAND_RECEIVED__DBMSRV_CMDNAME "DBMSRV_CMDNAME"
#define SDBMSGTAG_DBMSRV_COMMAND_RECEIVED__DBMSRV_CMDOPTION "DBMSRV_CMDOPTION"
/* <- End of defines for message COMMAND_RECEIVED */
/* Begin of defines for message SHMNOCLOSE: ID = 284, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_SHMNOCLOSE 284, "DBMSrv", __FILE__, __LINE__, "Could not close Shared Memory", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message SHMNOCLOSE */
/* Begin of defines for message SHMNODELETE: ID = 285, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_SHMNODELETE 285, "DBMSrv", __FILE__, __LINE__, "Could not delete Shared Memory", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message SHMNODELETE */
/* Begin of defines for message SHMNOUNLOCKER: ID = 286, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_SHMNOUNLOCKER 286, "DBMSrv", __FILE__, __LINE__, "Could not create unlocker for Shared Memory", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message SHMNOUNLOCKER */
/* Begin of defines for message SHMNIADDRESS: ID = 287, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_SHMNIADDRESS 287, "DBMSrv", __FILE__, __LINE__, "Address ($ADDRESS$) of next-index variable for linetype $SHMLINETYPE$ out of scope", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_SHMNIADDRESS__ADDRESS "ADDRESS"
#define SDBMSGTAG_DBMSRV_SHMNIADDRESS__SHMLINETYPE "SHMLINETYPE"
/* <- End of defines for message SHMNIADDRESS */
/* Begin of defines for message SHMSOADDRESS: ID = 288, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_SHMSOADDRESS 288, "DBMSrv", __FILE__, __LINE__, "Address ($ADDRESS$) of start-of variable for linetype $SHMLINETYPE$ out of scope", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_SHMSOADDRESS__ADDRESS "ADDRESS"
#define SDBMSGTAG_DBMSRV_SHMSOADDRESS__SHMLINETYPE "SHMLINETYPE"
/* <- End of defines for message SHMSOADDRESS */
/* Begin of defines for message SHMEXADDRESS: ID = 289, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_SHMEXADDRESS 289, "DBMSrv", __FILE__, __LINE__, "Address ($ADDRESS$) of exists variable for linetype $SHMLINETYPE$ out of scope", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_SHMEXADDRESS__ADDRESS "ADDRESS"
#define SDBMSGTAG_DBMSRV_SHMEXADDRESS__SHMLINETYPE "SHMLINETYPE"
/* <- End of defines for message SHMEXADDRESS */
/* Begin of defines for message SHMMEMORYACCESS: ID = 290, VERSION = 1, TAGS = 4 -> */
#define SDBMSG_DBMSRV_SHMMEMORYACCESS 290, "DBMSrv", __FILE__, __LINE__, "Illegal memory access ($ADDRESS$, $ADDRESS1$, $BYTE_SIZE$)", (Msg_Has4Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_SHMMEMORYACCESS__ADDRESS "ADDRESS"
#define SDBMSGTAG_DBMSRV_SHMMEMORYACCESS__BYTE_SIZE "BYTE_SIZE"
#define SDBMSGTAG_DBMSRV_SHMMEMORYACCESS__ADDRESS1 "ADDRESS1"
/* <- End of defines for message SHMMEMORYACCESS */
/* Begin of defines for message NOT_EXCLUSIVE: ID = 291, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_NOT_EXCLUSIVE 291, "DBMSrv", __FILE__, __LINE__, "There are other active DBMServers, PIDs: $PIDLIST$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_NOT_EXCLUSIVE__PIDLIST "PIDLIST"
/* <- End of defines for message NOT_EXCLUSIVE */
/* Begin of defines for message BACKUPSESSIONLOST: ID = 292, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_BACKUPSESSIONLOST 292, "DBMSrv", __FILE__, __LINE__, "$SESSIONTYPE$ session was terminated", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_BACKUPSESSIONLOST__SESSIONTYPE "SESSIONTYPE"
/* <- End of defines for message BACKUPSESSIONLOST */
/* Begin of defines for message IMPLICITRECONNECT: ID = 293, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_IMPLICITRECONNECT 293, "DBMSrv", __FILE__, __LINE__, "Implicit reconnect of $SESSIONTYPE$ session at $DATETIME$", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_IMPLICITRECONNECT__SESSIONTYPE "SESSIONTYPE"
#define SDBMSGTAG_DBMSRV_IMPLICITRECONNECT__DATETIME "DATETIME"
/* <- End of defines for message IMPLICITRECONNECT */
/* Begin of defines for message RESULTLOST: ID = 294, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_RESULTLOST 294, "DBMSrv", __FILE__, __LINE__, "Lost result of previous $COMMAND_NAME$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_RESULTLOST__COMMAND_NAME "COMMAND_NAME"
/* <- End of defines for message RESULTLOST */
/* Begin of defines for message DUMP_WRITTEN: ID = 295, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_DUMP_WRITTEN 295, "DBMSrv", __FILE__, __LINE__, "$TAG$", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_DUMP_WRITTEN__TAG "TAG"
/* <- End of defines for message DUMP_WRITTEN */
/* Begin of defines for message NO_DUMP_WRITTEN: ID = 296, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_NO_DUMP_WRITTEN 296, "DBMSrv", __FILE__, __LINE__, "Could not create dump file", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message NO_DUMP_WRITTEN */
/* Begin of defines for message ILLEGALBLOCKINGFACTOR: ID = 297, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_ILLEGALBLOCKINGFACTOR 297, "DBMSrv", __FILE__, __LINE__, "A block size of $BLOCKSIZE$ pages cannot be used.", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_ILLEGALBLOCKINGFACTOR__BLOCKSIZE "BLOCKSIZE"
/* <- End of defines for message ILLEGALBLOCKINGFACTOR */
/* Begin of defines for message ILLEGALPAGESIZE: ID = 298, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_ILLEGALPAGESIZE 298, "DBMSrv", __FILE__, __LINE__, "A page size of '$PAGESIZE$' cannot be used.", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_ILLEGALPAGESIZE__PAGESIZE "PAGESIZE"
/* <- End of defines for message ILLEGALPAGESIZE */
/* Begin of defines for message EXHNDLR: ID = 299, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_EXHNDLR 299, "DBMSrv", __FILE__, __LINE__, "Could not initialize exception handler.", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message EXHNDLR */
/* Begin of defines for message DBMSRV_NOSTART: ID = 300, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_DBMSRV_NOSTART 300, "DBMSrv", __FILE__, __LINE__, "Could not start DBM server.", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message DBMSRV_NOSTART */
/* Begin of defines for message MEFDIRTY: ID = 301, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_MEFDIRTY 301, "DBMSrv", __FILE__, __LINE__, "Media file '$FILENAME$' is corrupt in line $LINE$.", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_MEFDIRTY__FILENAME "FILENAME"
#define SDBMSGTAG_DBMSRV_MEFDIRTY__LINE "LINE"
/* <- End of defines for message MEFDIRTY */
/* Begin of defines for message FORMAT_DELIMISS: ID = 302, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_FORMAT_DELIMISS 302, "DBMSrv", __FILE__, __LINE__, "Could not find delimiter '$DELIMITER$' within string \"$STRING$\"", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_FORMAT_DELIMISS__STRING "STRING"
#define SDBMSGTAG_DBMSRV_FORMAT_DELIMISS__DELIMITER "DELIMITER"
/* <- End of defines for message FORMAT_DELIMISS */
/* Begin of defines for message COMM_NO_REACT: ID = 303, VERSION = 1, TAGS = 3 -> */
#define SDBMSG_DBMSRV_COMM_NO_REACT 303, "DBMSrv", __FILE__, __LINE__, "The $COMMPARTNER$ did not react within the past $TIME_VALUE$ seconds.", (Msg_Has3Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_COMM_NO_REACT__TIME_VALUE "TIME_VALUE"
#define SDBMSGTAG_DBMSRV_COMM_NO_REACT__COMMPARTNER "COMMPARTNER"
/* <- End of defines for message COMM_NO_REACT */
/* Begin of defines for message COMM_PACKTOOSMALL: ID = 312, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_COMM_PACKTOOSMALL 312, "DBMSrv", __FILE__, __LINE__, "DBM communication packet of $BYTE_SIZE$ bytes is too small for answer", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_COMM_PACKTOOSMALL__BYTE_SIZE "BYTE_SIZE"
/* <- End of defines for message COMM_PACKTOOSMALL */
/* Begin of defines for message BHIST_TOOMUCHDATA: ID = 313, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_BHIST_TOOMUCHDATA 313, "DBMSrv", __FILE__, __LINE__, "Backup $BACKUP_ID_INTERNAL$ has too much media or external backup information", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_BHIST_TOOMUCHDATA__BACKUP_ID_INTERNAL "BACKUP_ID_INTERNAL"
/* <- End of defines for message BHIST_TOOMUCHDATA */
/* Begin of defines for message SHMNOCLEANUP: ID = 314, VERSION = 1, TAGS = 1 -> */
#define SDBMSG_DBMSRV_SHMNOCLEANUP 314, "DBMSrv", __FILE__, __LINE__, "Could not cleanup the DBM server Shared Memory", (Msg_Has1Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
/* <- End of defines for message SHMNOCLEANUP */
/* Begin of defines for message VOLMODE: ID = 326, VERSION = 1, TAGS = 5 -> */
#define SDBMSG_DBMSRV_VOLMODE 326, "DBMSrv", __FILE__, __LINE__, "The $VOLUME_CONT_TYPE$ volume with ID $VOLUME_ID$ has an invalid volume mode ($VOLUME_MODE$)", (Msg_Has5Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_VOLMODE__VOLUME_ID "VOLUME_ID"
#define SDBMSGTAG_DBMSRV_VOLMODE__PARAMETER "PARAMETER"
#define SDBMSGTAG_DBMSRV_VOLMODE__VOLUME_CONT_TYPE "VOLUME_CONT_TYPE"
#define SDBMSGTAG_DBMSRV_VOLMODE__VOLUME_MODE "VOLUME_MODE"
/* <- End of defines for message VOLMODE */
/* Begin of defines for message VOLMODENOTALLOWED: ID = 327, VERSION = 1, TAGS = 2 -> */
#define SDBMSG_DBMSRV_VOLMODENOTALLOWED 327, "DBMSrv", __FILE__, __LINE__, "Volume mode $VOLUME_MODE$ of the volume is not allowed.", (Msg_Has2Args*)0, Msg_SimpleArg("_MESSAGEVERSION", reinterpret_cast<const SAPDB_UTF8*>("1"))
#define SDBMSGTAG_DBMSRV_VOLMODENOTALLOWED__VOLUME_MODE "VOLUME_MODE"
/* <- End of defines for message VOLMODENOTALLOWED */
/* <- End of message defines for component DBMSrv */

/* some helpful enumerations (created by buildmsg.pl) -> */

#define SDBMSG_DBMSRV_ENUMERATION \
                    DBMSrv_ERR=1, \
                    DBMSrv_NOTIMPL=2, \
                    DBMSrv_FILE=3, \
                    DBMSrv_PARAM=4, \
                    DBMSrv_MEM=5, \
                    DBMSrv_RTE=6, \
                    DBMSrv_RTEEXT=7, \
                    DBMSrv_NOUTILSESSION=8, \
                    DBMSrv_NODBSESSION=9, \
                    DBMSrv_NOBACKUPSESSION=10, \
                    DBMSrv_NOHISTORYSESSION=11, \
                    DBMSrv_SQL=12, \
                    DBMSrv_TOOSMALL=13, \
                    DBMSrv_NOMEDIA=14, \
                    DBMSrv_MENOTFOUND=15, \
                    DBMSrv_MENOVALID=16, \
                    DBMSrv_BANOVALIDTYPE=17, \
                    DBMSrv_NOHISTORY=18, \
                    DBMSrv_NOHELP=20, \
                    DBMSrv_XPNOTFOUND=21, \
                    DBMSrv_XPSYNTAX=22, \
                    DBMSrv_COMMAND=23, \
                    DBMSrv_PARAMEXIST=24, \
                    DBMSrv_NOXPSESSION=25, \
                    DBMSrv_XPSESSION=26, \
                    DBMSrv_XPCHECK=27, \
                    DBMSrv_XPINFCONV=28, \
                    DBMSrv_NOCHECK=29, \
                    DBMSrv_XPNOMODIFY=30, \
                    DBMSrv_XPDIRTY=31, \
                    DBMSrv_XPREADONLY=32, \
                    DBMSrv_SYSTEM=33, \
                    DBMSrv_LOGON=34, \
                    DBMSrv_SYSLOGON=35, \
                    DBMSrv_EXECUTE=36, \
                    DBMSrv_VOLCHECK=37, \
                    DBMSrv_VOLTYPE=38, \
                    DBMSrv_STATE=39, \
                    DBMSrv_DBRUN=40, \
                    DBMSrv_XPOVERFLOW=41, \
                    DBMSrv_BAOVERWRITE=42, \
                    DBMSrv_NOUSER=43, \
                    DBMSrv_BASAVETYPECON=44, \
                    DBMSrv_BANOSAVETYPE=45, \
                    DBMSrv_BANOAUTOMED=46, \
                    DBMSrv_DBEXIST=47, \
                    DBMSrv_USRSAVE=48, \
                    DBMSrv_USRREAD=49, \
                    DBMSrv_USRFAIL=50, \
                    DBMSrv_USREXISTS=51, \
                    DBMSrv_NODBNAME=52, \
                    DBMSrv_DBNAME=53, \
                    DBMSrv_TOOMANYPARAM=54, \
                    DBMSrv_TOOFEWPARAM=55, \
                    DBMSrv_USRDELSELF=56, \
                    DBMSrv_USRDELDBM=57, \
                    DBMSrv_USRDELSDBA=58, \
                    DBMSrv_NEEDLOGON=59, \
                    DBMSrv_NEEDSYSLOGON=60, \
                    DBMSrv_LASTREG=61, \
                    DBMSrv_NOENTRY=62, \
                    DBMSrv_MISSRIGHT=63, \
                    DBMSrv_DBNORUN=64, \
                    DBMSrv_NOUSERS=65, \
                    DBMSrv_VERSION=66, \
                    DBMSrv_NOSERVICESESSION=67, \
                    DBMSrv_XPMIN=68, \
                    DBMSrv_XPMAX=69, \
                    DBMSrv_XPVALUESET=70, \
                    DBMSrv_USRFRM=71, \
                    DBMSrv_NOREPLY=72, \
                    DBMSrv_TOOLCHK=73, \
                    DBMSrv_MEDIUMCHK=74, \
                    DBMSrv_PREPARE=75, \
                    DBMSrv_DBREQ=76, \
                    DBMSrv_TOOLREQ=77, \
                    DBMSrv_OPCHK=78, \
                    DBMSrv_POSTOP=79, \
                    DBMSrv_BACKUPOP=80, \
                    DBMSrv_CLEANUP=81, \
                    DBMSrv_MISSMIRR=82, \
                    DBMSrv_MAXDATA=83, \
                    DBMSrv_MAXVOLCNT=84, \
                    DBMSrv_NOADDD=85, \
                    DBMSrv_KEYEXISTS=86, \
                    DBMSrv_SERVICEDB=87, \
                    DBMSrv_WRONGINST=88, \
                    DBMSrv_INVDBNAME=89, \
                    DBMSrv_PARAMVER=90, \
                    DBMSrv_DBAUNKNOWN=91, \
                    DBMSrv_AANOTEXIST_1=92, \
                    DBMSrv_DBAWRONG=93, \
                    DBMSrv_EBFDIRTY=94, \
                    DBMSrv_NOEBIDLIST=95, \
                    DBMSrv_AANOTEXIST_2=96, \
                    DBMSrv_IMPERSONATE=97, \
                    DBMSrv_ASCII=98, \
                    DBMSrv_NOTADMIN=99, \
                    DBMSrv_TOOMANYFILES=100, \
                    DBMSrv_INVUSRNAME=101, \
                    DBMSrv_SQLREADONLY=102, \
                    DBMSrv_BADVERSION=103, \
                    DBMSrv_MIGRATE=104, \
                    DBMSrv_SHUTDOWN=105, \
                    DBMSrv_KNLDIRTY=106, \
                    DBMSrv_MDFDIRTY=107, \
                    DBMSrv_NOVOLDIR=108, \
                    DBMSrv_NOVOLLINK=109, \
                    DBMSrv_BAWRONGMEDIUM=110, \
                    DBMSrv_BAWRONGSAVETYPE=111, \
                    DBMSrv_NOPREVSTAGEBACKUP=112, \
                    DBMSrv_MEEXISTSASGROUP=113, \
                    DBMSrv_MEEXISTSASMEDIUM=114, \
                    DBMSrv_MEAMBIGUOUS=115, \
                    DBMSrv_UTLIOSEQNEED=116, \
                    DBMSrv_UTLIOSEQAVAIL=117, \
                    DBMSrv_LOGFULL=118, \
                    DBMSrv_NOHSS=119, \
                    DBMSrv_HSS=120, \
                    DBMSrv_NORESTORESTRATEGY=121, \
                    DBMSrv_BACKNOTINHIST=122, \
                    DBMSrv_NOMASTER=123, \
                    DBMSrv_NOVERSIONMATCH=124, \
                    DBMSrv_NEEDADMI=125, \
                    DBMSrv_SERVICEDBNOTFOUND=126, \
                    DBMSrv_ADDVOLNAMETOOLONG=127, \
                    DBMSrv_NOEXPLAIN=128, \
                    DBMSrv_ILLEGALVOLSIZE=129, \
                    DBMSrv_PERCENTVAL_ILLEGAL=130, \
                    DBMSrv_AUTOEXT_ILLMODE=131, \
                    DBMSrv_SHMPANIC=132, \
                    DBMSrv_SHMRESLOCK=133, \
                    DBMSrv_EVENTNONEAVAIL=134, \
                    DBMSrv_ADDVOLWRONGMODE=135, \
                    DBMSrv_ADDVOLERRFDEGRANGE=136, \
                    DBMSrv_ILLEGALTIMEFMT=137, \
                    DBMSrv_UNKNOWNINFOTYPE=138, \
                    DBMSrv_NOSCHEDULERSTOP=139, \
                    DBMSrv_NOSCHEDULERSTART=140, \
                    DBMSrv_NOTJOBOWNER=141, \
                    DBMSrv_JOBNOTEXIST=142, \
                    DBMSrv_PREDECESSORNOTEXIST=143, \
                    DBMSrv_ILLJOBNUMBER=144, \
                    DBMSrv_JOBHASSUCCESSORS=145, \
                    DBMSrv_INSERVERPROCESSSTARTER=146, \
                    DBMSrv_NOSERVERPROCESSRUNNING=147, \
                    DBMSrv_PROCSTARTERROR=148, \
                    DBMSrv_PROCSPAWNFAILED=149, \
                    DBMSrv_PROCWAITERROR=150, \
                    DBMSrv_PROCCHLDEXIT=151, \
                    DBMSrv_PROCSHMDESTERRORT=152, \
                    DBMSrv_PROCSHMDETERROR=153, \
                    DBMSrv_PROCSHMDETCHLDERR=154, \
                    DBMSrv_PROCSHMATTERROR=155, \
                    DBMSrv_PROCSHMCREATEERROR=156, \
                    DBMSrv_SCHEDULERUNEXPECTED=157, \
                    DBMSrv_NOBRAIN=158, \
                    DBMSrv_NOBEER=159, \
                    DBMSrv_NODBMLOGGER=160, \
                    DBMSrv_DBISDROPPED=161, \
                    DBMSrv_IS_NO_OPTION=162, \
                    DBMSrv_FILECHK=163, \
                    DBMSrv_FILEDEL=164, \
                    DBMSrv_SHMNOINFOFILE=165, \
                    DBMSrv_SHMNODATAFILE=166, \
                    DBMSrv_SHMFILEPERM=167, \
                    DBMSrv_SHMNOTAVAILABLE=168, \
                    DBMSrv_BHIST_EXT_INVALID_LINE=169, \
                    DBMSrv_BHIST_EXT_OPEN=170, \
                    DBMSrv_BHIST_EXT_WRITE=171, \
                    DBMSrv_MEMORY=172, \
                    DBMSrv_SHMALLOCFAILED=173, \
                    DBMSrv_NIERROR=174, \
                    DBMSrv_IOMANPROCWP=175, \
                    DBMSrv_IOMANPROCRP=176, \
                    DBMSrv_IOMANPROCLOGON=177, \
                    DBMSrv_IOMANPROCCMD=178, \
                    DBMSrv_IOMANPROCPID=179, \
                    DBMSrv_IOMANPROCEXIT=180, \
                    DBMSrv_IOMANPROCDELWP=181, \
                    DBMSrv_IOMANPROCDELRP=182, \
                    DBMSrv_IOMANPROCPROCDIED=183, \
                    DBMSrv_IOMANNOWP=184, \
                    DBMSrv_IOMANNORP=185, \
                    DBMSrv_IOMANBADWP=186, \
                    DBMSrv_IOMANBADRP=187, \
                    DBMSrv_IOMANNOEND=188, \
                    DBMSrv_CONNLOST=189, \
                    DBMSrv_EXCEPTIONCAUGHT=190, \
                    DBMSrv_STE=191, \
                    DBMSrv_SHMVERSIONMISMATCH=193, \
                    DBMSrv_NODISPATCHERSTART=194, \
                    DBMSrv_NOAUTOEXTEND=195, \
                    DBMSrv_NOAUTOEXTENDOFF=196, \
                    DBMSrv_NODISPATCHERSTOP=197, \
                    DBMSrv_NOAUTOUPDSTAT=198, \
                    DBMSrv_NOAUTOUPDSTATOFF=199, \
                    DBMSrv_AUTOUPDSTAT_ILLMODE=200, \
                    DBMSrv_CMDOPTION=201, \
                    DBMSrv_DATAFULL=202, \
                    DBMSrv_NO_EVENTCONFIG_CHANGE=203, \
                    DBMSrv_EVENTCAT_UNKNOWN=204, \
                    DBMSrv_EVENTPRIO_UNKNOWN=205, \
                    DBMSrv_DISP_NO_EXIST=206, \
                    DBMSrv_DISP_NOT_STOPPED=207, \
                    DBMSrv_DISP_NO_REMOTE_ACCESS=208, \
                    DBMSrv_DISP_NO_INTCMD_FOUND=209, \
                    DBMSrv_DISP_NO_LIST=210, \
                    DBMSrv_DISP_NO_DELETE=211, \
                    DBMSrv_DISP_INTERNAL_EXISTS=212, \
                    DBMSrv_DISP_INTERNAL_NOACC=213, \
                    DBMSrv_DISP_INTERNAL_NOT_REMOTE=214, \
                    DBMSrv_KNLUNKNOWN=215, \
                    DBMSrv_COMM_CLIENT_CONNECT=216, \
                    DBMSrv_WRONGDBSTATE=217, \
                    DBMSrv_DBSTATENEEDED1=218, \
                    DBMSrv_DBSTATENEEDED2=219, \
                    DBMSrv_DBSTATENEEDED3=220, \
                    DBMSrv_DBSTATENEEDED4=221, \
                    DBMSrv_INTERNAL_TRANSPORT_MSG=222, \
                    DBMSrv_VOLTYPENOTALLOWED=223, \
                    DBMSrv_XPVALUNEX=224, \
                    DBMSrv_VOLNFOUNDXP=225, \
                    DBMSrv_COMM_CLIENT_DISCONNECT=226, \
                    DBMSrv_REPLY_ENDLESS=227, \
                    DBMSrv_REPLY_2MSG=228, \
                    DBMSrv_PROCESSDATA_INVALID=230, \
                    DBMSrv_PROCESSDATA_ERR_SIZE=231, \
                    DBMSrv_PROCESSDATA_SIZE_NOTSUPPORTED=232, \
                    DBMSrv_VOLSIZEILLEGAL=233, \
                    DBMSrv_SETENV=234, \
                    DBMSrv_VOLLASTADDEDNFOUNDXPHIS=235, \
                    DBMSrv_NOAUTHENTICATION=236, \
                    DBMSrv_BHIST_INVALID_ENTRY=237, \
                    DBMSrv_FORMAT_SEPARATORMISSING=238, \
                    DBMSrv_FORMAT_UINTEGER=239, \
                    DBMSrv_FORMAT_INTEGER=240, \
                    DBMSrv_BHIST_MED_INVALID_ENTRY=241, \
                    DBMSrv_FORMAT_SEPARATORNO3=242, \
                    DBMSrv_FORMAT_SEPARATORNOP=243, \
                    DBMSrv_SDBINST=244, \
                    DBMSrv_SESSIONLIMIT=245, \
                    DBMSrv_HSSNODEUNKNOWN=246, \
                    DBMSrv_MISSDBUSRPWD=247, \
                    DBMSrv_UNKNOWNTASK=248, \
                    DBMSrv_LOCISDIR=249, \
                    DBMSrv_INVPARAM=250, \
                    DBMSrv_MISSPARAM=251, \
                    DBMSrv_FILEOPEN=252, \
                    DBMSrv_FILEWRITE=253, \
                    DBMSrv_FILECLOSE=254, \
                    DBMSrv_XPWRITE=255, \
                    DBMSrv_SHMPLATFORMMISMATCH=256, \
                    DBMSrv_SHMNOLOCK=257, \
                    DBMSrv_SHMNOUNLOCK=258, \
                    DBMSrv_SHMWRONGUNLOCKPID=259, \
                    DBMSrv_SHMSHIFTERROR=260, \
                    DBMSrv_SHMERREXTEND=261, \
                    DBMSrv_SHMLINEOUTOFSCOPE=262, \
                    DBMSrv_SHMNORESOURCELYT=263, \
                    DBMSrv_SHMNORESOURCELYTDEL=264, \
                    DBMSrv_SHMNOSCHEDLYT=265, \
                    DBMSrv_SHMNOSCHEDLYTDEL=266, \
                    DBMSrv_SHMNOEVTSILLYT=267, \
                    DBMSrv_SHMNOEVTSILLYTDEL=268, \
                    DBMSrv_SHMNOEVTLYT=269, \
                    DBMSrv_SHMNOEVTLYTFOUND=270, \
                    DBMSrv_SHMNOEVTLYTDEL=271, \
                    DBMSrv_SHMNOEVTLYTNEW=272, \
                    DBMSrv_SHMNORESOURCELYTFOUND=273, \
                    DBMSrv_SHMLINESEXCEEDED=274, \
                    DBMSrv_RESLOCK_NO_CREATE=275, \
                    DBMSrv_RESLOCK_NO_LOCK=276, \
                    DBMSrv_RESLOCK_NO_UNLOCK=277, \
                    DBMSrv_SCHEDCOM_NO_CREATE=278, \
                    DBMSrv_EVTSIL_NO_CREATE=279, \
                    DBMSrv_EVT_NO_CREATE=280, \
                    DBMSrv_EVT_NO_CREATE_PID=281, \
                    DBMSrv_EVT_NO_ITERATOR_CREATE=282, \
                    DBMSrv_COMMAND_RECEIVED=283, \
                    DBMSrv_SHMNOCLOSE=284, \
                    DBMSrv_SHMNODELETE=285, \
                    DBMSrv_SHMNOUNLOCKER=286, \
                    DBMSrv_SHMNIADDRESS=287, \
                    DBMSrv_SHMSOADDRESS=288, \
                    DBMSrv_SHMEXADDRESS=289, \
                    DBMSrv_SHMMEMORYACCESS=290, \
                    DBMSrv_NOT_EXCLUSIVE=291, \
                    DBMSrv_BACKUPSESSIONLOST=292, \
                    DBMSrv_IMPLICITRECONNECT=293, \
                    DBMSrv_RESULTLOST=294, \
                    DBMSrv_DUMP_WRITTEN=295, \
                    DBMSrv_NO_DUMP_WRITTEN=296, \
                    DBMSrv_ILLEGALBLOCKINGFACTOR=297, \
                    DBMSrv_ILLEGALPAGESIZE=298, \
                    DBMSrv_EXHNDLR=299, \
                    DBMSrv_DBMSRV_NOSTART=300, \
                    DBMSrv_MEFDIRTY=301, \
                    DBMSrv_FORMAT_DELIMISS=302, \
                    DBMSrv_COMM_NO_REACT=303, \
                    DBMSrv_COMM_PACKTOOSMALL=312, \
                    DBMSrv_BHIST_TOOMUCHDATA=313, \
                    DBMSrv_SHMNOCLEANUP=314, \
                    DBMSrv_VOLMODE=326, \
                    DBMSrv_VOLMODENOTALLOWED=327
#define SDBMSG_DBMSRV_INITIALIZATIONLIST(x) \
                    x(SDBMSG_DBMSRV_ERR, "ERR"), \
                    x(SDBMSG_DBMSRV_NOTIMPL, "NOTIMPL"), \
                    x(SDBMSG_DBMSRV_FILE, "FILE"), \
                    x(SDBMSG_DBMSRV_PARAM, "PARAM"), \
                    x(SDBMSG_DBMSRV_MEM, "MEM"), \
                    x(SDBMSG_DBMSRV_RTE, "RTE"), \
                    x(SDBMSG_DBMSRV_RTEEXT, "RTEEXT"), \
                    x(SDBMSG_DBMSRV_NOUTILSESSION, "NOUTILSESSION"), \
                    x(SDBMSG_DBMSRV_NODBSESSION, "NODBSESSION"), \
                    x(SDBMSG_DBMSRV_NOBACKUPSESSION, "NOBACKUPSESSION"), \
                    x(SDBMSG_DBMSRV_NOHISTORYSESSION, "NOHISTORYSESSION"), \
                    x(SDBMSG_DBMSRV_SQL, "SQL"), \
                    x(SDBMSG_DBMSRV_TOOSMALL, "TOOSMALL"), \
                    x(SDBMSG_DBMSRV_NOMEDIA, "NOMEDIA"), \
                    x(SDBMSG_DBMSRV_MENOTFOUND, "MENOTFOUND"), \
                    x(SDBMSG_DBMSRV_MENOVALID, "MENOVALID"), \
                    x(SDBMSG_DBMSRV_BANOVALIDTYPE, "BANOVALIDTYPE"), \
                    x(SDBMSG_DBMSRV_NOHISTORY, "NOHISTORY"), \
                    x(SDBMSG_DBMSRV_NOHELP, "NOHELP"), \
                    x(SDBMSG_DBMSRV_XPNOTFOUND, "XPNOTFOUND"), \
                    x(SDBMSG_DBMSRV_XPSYNTAX, "XPSYNTAX"), \
                    x(SDBMSG_DBMSRV_COMMAND, "COMMAND"), \
                    x(SDBMSG_DBMSRV_PARAMEXIST, "PARAMEXIST"), \
                    x(SDBMSG_DBMSRV_NOXPSESSION, "NOXPSESSION"), \
                    x(SDBMSG_DBMSRV_XPSESSION, "XPSESSION"), \
                    x(SDBMSG_DBMSRV_XPCHECK, "XPCHECK"), \
                    x(SDBMSG_DBMSRV_XPINFCONV, "XPINFCONV"), \
                    x(SDBMSG_DBMSRV_NOCHECK, "NOCHECK"), \
                    x(SDBMSG_DBMSRV_XPNOMODIFY, "XPNOMODIFY"), \
                    x(SDBMSG_DBMSRV_XPDIRTY, "XPDIRTY"), \
                    x(SDBMSG_DBMSRV_XPREADONLY, "XPREADONLY"), \
                    x(SDBMSG_DBMSRV_SYSTEM, "SYSTEM"), \
                    x(SDBMSG_DBMSRV_LOGON, "LOGON"), \
                    x(SDBMSG_DBMSRV_SYSLOGON, "SYSLOGON"), \
                    x(SDBMSG_DBMSRV_EXECUTE, "EXECUTE"), \
                    x(SDBMSG_DBMSRV_VOLCHECK, "VOLCHECK"), \
                    x(SDBMSG_DBMSRV_VOLTYPE, "VOLTYPE"), \
                    x(SDBMSG_DBMSRV_STATE, "STATE"), \
                    x(SDBMSG_DBMSRV_DBRUN, "DBRUN"), \
                    x(SDBMSG_DBMSRV_XPOVERFLOW, "XPOVERFLOW"), \
                    x(SDBMSG_DBMSRV_BAOVERWRITE, "BAOVERWRITE"), \
                    x(SDBMSG_DBMSRV_NOUSER, "NOUSER"), \
                    x(SDBMSG_DBMSRV_BASAVETYPECON, "BASAVETYPECON"), \
                    x(SDBMSG_DBMSRV_BANOSAVETYPE, "BANOSAVETYPE"), \
                    x(SDBMSG_DBMSRV_BANOAUTOMED, "BANOAUTOMED"), \
                    x(SDBMSG_DBMSRV_DBEXIST, "DBEXIST"), \
                    x(SDBMSG_DBMSRV_USRSAVE, "USRSAVE"), \
                    x(SDBMSG_DBMSRV_USRREAD, "USRREAD"), \
                    x(SDBMSG_DBMSRV_USRFAIL, "USRFAIL"), \
                    x(SDBMSG_DBMSRV_USREXISTS, "USREXISTS"), \
                    x(SDBMSG_DBMSRV_NODBNAME, "NODBNAME"), \
                    x(SDBMSG_DBMSRV_DBNAME, "DBNAME"), \
                    x(SDBMSG_DBMSRV_TOOMANYPARAM, "TOOMANYPARAM"), \
                    x(SDBMSG_DBMSRV_TOOFEWPARAM, "TOOFEWPARAM"), \
                    x(SDBMSG_DBMSRV_USRDELSELF, "USRDELSELF"), \
                    x(SDBMSG_DBMSRV_USRDELDBM, "USRDELDBM"), \
                    x(SDBMSG_DBMSRV_USRDELSDBA, "USRDELSDBA"), \
                    x(SDBMSG_DBMSRV_NEEDLOGON, "NEEDLOGON"), \
                    x(SDBMSG_DBMSRV_NEEDSYSLOGON, "NEEDSYSLOGON"), \
                    x(SDBMSG_DBMSRV_LASTREG, "LASTREG"), \
                    x(SDBMSG_DBMSRV_NOENTRY, "NOENTRY"), \
                    x(SDBMSG_DBMSRV_MISSRIGHT, "MISSRIGHT"), \
                    x(SDBMSG_DBMSRV_DBNORUN, "DBNORUN"), \
                    x(SDBMSG_DBMSRV_NOUSERS, "NOUSERS"), \
                    x(SDBMSG_DBMSRV_VERSION, "VERSION"), \
                    x(SDBMSG_DBMSRV_NOSERVICESESSION, "NOSERVICESESSION"), \
                    x(SDBMSG_DBMSRV_XPMIN, "XPMIN"), \
                    x(SDBMSG_DBMSRV_XPMAX, "XPMAX"), \
                    x(SDBMSG_DBMSRV_XPVALUESET, "XPVALUESET"), \
                    x(SDBMSG_DBMSRV_USRFRM, "USRFRM"), \
                    x(SDBMSG_DBMSRV_NOREPLY, "NOREPLY"), \
                    x(SDBMSG_DBMSRV_TOOLCHK, "TOOLCHK"), \
                    x(SDBMSG_DBMSRV_MEDIUMCHK, "MEDIUMCHK"), \
                    x(SDBMSG_DBMSRV_PREPARE, "PREPARE"), \
                    x(SDBMSG_DBMSRV_DBREQ, "DBREQ"), \
                    x(SDBMSG_DBMSRV_TOOLREQ, "TOOLREQ"), \
                    x(SDBMSG_DBMSRV_OPCHK, "OPCHK"), \
                    x(SDBMSG_DBMSRV_POSTOP, "POSTOP"), \
                    x(SDBMSG_DBMSRV_BACKUPOP, "BACKUPOP"), \
                    x(SDBMSG_DBMSRV_CLEANUP, "CLEANUP"), \
                    x(SDBMSG_DBMSRV_MISSMIRR, "MISSMIRR"), \
                    x(SDBMSG_DBMSRV_MAXDATA, "MAXDATA"), \
                    x(SDBMSG_DBMSRV_MAXVOLCNT, "MAXVOLCNT"), \
                    x(SDBMSG_DBMSRV_NOADDD, "NOADDD"), \
                    x(SDBMSG_DBMSRV_KEYEXISTS, "KEYEXISTS"), \
                    x(SDBMSG_DBMSRV_SERVICEDB, "SERVICEDB"), \
                    x(SDBMSG_DBMSRV_WRONGINST, "WRONGINST"), \
                    x(SDBMSG_DBMSRV_INVDBNAME, "INVDBNAME"), \
                    x(SDBMSG_DBMSRV_PARAMVER, "PARAMVER"), \
                    x(SDBMSG_DBMSRV_DBAUNKNOWN, "DBAUNKNOWN"), \
                    x(SDBMSG_DBMSRV_AANOTEXIST_1, "AANOTEXIST_1"), \
                    x(SDBMSG_DBMSRV_DBAWRONG, "DBAWRONG"), \
                    x(SDBMSG_DBMSRV_EBFDIRTY, "EBFDIRTY"), \
                    x(SDBMSG_DBMSRV_NOEBIDLIST, "NOEBIDLIST"), \
                    x(SDBMSG_DBMSRV_AANOTEXIST_2, "AANOTEXIST_2"), \
                    x(SDBMSG_DBMSRV_IMPERSONATE, "IMPERSONATE"), \
                    x(SDBMSG_DBMSRV_ASCII, "ASCII"), \
                    x(SDBMSG_DBMSRV_NOTADMIN, "NOTADMIN"), \
                    x(SDBMSG_DBMSRV_TOOMANYFILES, "TOOMANYFILES"), \
                    x(SDBMSG_DBMSRV_INVUSRNAME, "INVUSRNAME"), \
                    x(SDBMSG_DBMSRV_SQLREADONLY, "SQLREADONLY"), \
                    x(SDBMSG_DBMSRV_BADVERSION, "BADVERSION"), \
                    x(SDBMSG_DBMSRV_MIGRATE, "MIGRATE"), \
                    x(SDBMSG_DBMSRV_SHUTDOWN, "SHUTDOWN"), \
                    x(SDBMSG_DBMSRV_KNLDIRTY, "KNLDIRTY"), \
                    x(SDBMSG_DBMSRV_MDFDIRTY, "MDFDIRTY"), \
                    x(SDBMSG_DBMSRV_NOVOLDIR, "NOVOLDIR"), \
                    x(SDBMSG_DBMSRV_NOVOLLINK, "NOVOLLINK"), \
                    x(SDBMSG_DBMSRV_BAWRONGMEDIUM, "BAWRONGMEDIUM"), \
                    x(SDBMSG_DBMSRV_BAWRONGSAVETYPE, "BAWRONGSAVETYPE"), \
                    x(SDBMSG_DBMSRV_NOPREVSTAGEBACKUP, "NOPREVSTAGEBACKUP"), \
                    x(SDBMSG_DBMSRV_MEEXISTSASGROUP, "MEEXISTSASGROUP"), \
                    x(SDBMSG_DBMSRV_MEEXISTSASMEDIUM, "MEEXISTSASMEDIUM"), \
                    x(SDBMSG_DBMSRV_MEAMBIGUOUS, "MEAMBIGUOUS"), \
                    x(SDBMSG_DBMSRV_UTLIOSEQNEED, "UTLIOSEQNEED"), \
                    x(SDBMSG_DBMSRV_UTLIOSEQAVAIL, "UTLIOSEQAVAIL"), \
                    x(SDBMSG_DBMSRV_LOGFULL, "LOGFULL"), \
                    x(SDBMSG_DBMSRV_NOHSS, "NOHSS"), \
                    x(SDBMSG_DBMSRV_HSS, "HSS"), \
                    x(SDBMSG_DBMSRV_NORESTORESTRATEGY, "NORESTORESTRATEGY"), \
                    x(SDBMSG_DBMSRV_BACKNOTINHIST, "BACKNOTINHIST"), \
                    x(SDBMSG_DBMSRV_NOMASTER, "NOMASTER"), \
                    x(SDBMSG_DBMSRV_NOVERSIONMATCH, "NOVERSIONMATCH"), \
                    x(SDBMSG_DBMSRV_NEEDADMI, "NEEDADMI"), \
                    x(SDBMSG_DBMSRV_SERVICEDBNOTFOUND, "SERVICEDBNOTFOUND"), \
                    x(SDBMSG_DBMSRV_ADDVOLNAMETOOLONG, "ADDVOLNAMETOOLONG"), \
                    x(SDBMSG_DBMSRV_NOEXPLAIN, "NOEXPLAIN"), \
                    x(SDBMSG_DBMSRV_ILLEGALVOLSIZE, "ILLEGALVOLSIZE"), \
                    x(SDBMSG_DBMSRV_PERCENTVAL_ILLEGAL, "PERCENTVAL_ILLEGAL"), \
                    x(SDBMSG_DBMSRV_AUTOEXT_ILLMODE, "AUTOEXT_ILLMODE"), \
                    x(SDBMSG_DBMSRV_SHMPANIC, "SHMPANIC"), \
                    x(SDBMSG_DBMSRV_SHMRESLOCK, "SHMRESLOCK"), \
                    x(SDBMSG_DBMSRV_EVENTNONEAVAIL, "EVENTNONEAVAIL"), \
                    x(SDBMSG_DBMSRV_ADDVOLWRONGMODE, "ADDVOLWRONGMODE"), \
                    x(SDBMSG_DBMSRV_ADDVOLERRFDEGRANGE, "ADDVOLERRFDEGRANGE"), \
                    x(SDBMSG_DBMSRV_ILLEGALTIMEFMT, "ILLEGALTIMEFMT"), \
                    x(SDBMSG_DBMSRV_UNKNOWNINFOTYPE, "UNKNOWNINFOTYPE"), \
                    x(SDBMSG_DBMSRV_NOSCHEDULERSTOP, "NOSCHEDULERSTOP"), \
                    x(SDBMSG_DBMSRV_NOSCHEDULERSTART, "NOSCHEDULERSTART"), \
                    x(SDBMSG_DBMSRV_NOTJOBOWNER, "NOTJOBOWNER"), \
                    x(SDBMSG_DBMSRV_JOBNOTEXIST, "JOBNOTEXIST"), \
                    x(SDBMSG_DBMSRV_PREDECESSORNOTEXIST, "PREDECESSORNOTEXIST"), \
                    x(SDBMSG_DBMSRV_ILLJOBNUMBER, "ILLJOBNUMBER"), \
                    x(SDBMSG_DBMSRV_JOBHASSUCCESSORS, "JOBHASSUCCESSORS"), \
                    x(SDBMSG_DBMSRV_INSERVERPROCESSSTARTER, "INSERVERPROCESSSTARTER"), \
                    x(SDBMSG_DBMSRV_NOSERVERPROCESSRUNNING, "NOSERVERPROCESSRUNNING"), \
                    x(SDBMSG_DBMSRV_PROCSTARTERROR, "PROCSTARTERROR"), \
                    x(SDBMSG_DBMSRV_PROCSPAWNFAILED, "PROCSPAWNFAILED"), \
                    x(SDBMSG_DBMSRV_PROCWAITERROR, "PROCWAITERROR"), \
                    x(SDBMSG_DBMSRV_PROCCHLDEXIT, "PROCCHLDEXIT"), \
                    x(SDBMSG_DBMSRV_PROCSHMDESTERRORT, "PROCSHMDESTERRORT"), \
                    x(SDBMSG_DBMSRV_PROCSHMDETERROR, "PROCSHMDETERROR"), \
                    x(SDBMSG_DBMSRV_PROCSHMDETCHLDERR, "PROCSHMDETCHLDERR"), \
                    x(SDBMSG_DBMSRV_PROCSHMATTERROR, "PROCSHMATTERROR"), \
                    x(SDBMSG_DBMSRV_PROCSHMCREATEERROR, "PROCSHMCREATEERROR"), \
                    x(SDBMSG_DBMSRV_SCHEDULERUNEXPECTED, "SCHEDULERUNEXPECTED"), \
                    x(SDBMSG_DBMSRV_NOBRAIN, "NOBRAIN"), \
                    x(SDBMSG_DBMSRV_NOBEER, "NOBEER"), \
                    x(SDBMSG_DBMSRV_NODBMLOGGER, "NODBMLOGGER"), \
                    x(SDBMSG_DBMSRV_DBISDROPPED, "DBISDROPPED"), \
                    x(SDBMSG_DBMSRV_IS_NO_OPTION, "IS_NO_OPTION"), \
                    x(SDBMSG_DBMSRV_FILECHK, "FILECHK"), \
                    x(SDBMSG_DBMSRV_FILEDEL, "FILEDEL"), \
                    x(SDBMSG_DBMSRV_SHMNOINFOFILE, "SHMNOINFOFILE"), \
                    x(SDBMSG_DBMSRV_SHMNODATAFILE, "SHMNODATAFILE"), \
                    x(SDBMSG_DBMSRV_SHMFILEPERM, "SHMFILEPERM"), \
                    x(SDBMSG_DBMSRV_SHMNOTAVAILABLE, "SHMNOTAVAILABLE"), \
                    x(SDBMSG_DBMSRV_BHIST_EXT_INVALID_LINE, "BHIST_EXT_INVALID_LINE"), \
                    x(SDBMSG_DBMSRV_BHIST_EXT_OPEN, "BHIST_EXT_OPEN"), \
                    x(SDBMSG_DBMSRV_BHIST_EXT_WRITE, "BHIST_EXT_WRITE"), \
                    x(SDBMSG_DBMSRV_MEMORY, "MEMORY"), \
                    x(SDBMSG_DBMSRV_SHMALLOCFAILED, "SHMALLOCFAILED"), \
                    x(SDBMSG_DBMSRV_NIERROR, "NIERROR"), \
                    x(SDBMSG_DBMSRV_IOMANPROCWP, "IOMANPROCWP"), \
                    x(SDBMSG_DBMSRV_IOMANPROCRP, "IOMANPROCRP"), \
                    x(SDBMSG_DBMSRV_IOMANPROCLOGON, "IOMANPROCLOGON"), \
                    x(SDBMSG_DBMSRV_IOMANPROCCMD, "IOMANPROCCMD"), \
                    x(SDBMSG_DBMSRV_IOMANPROCPID, "IOMANPROCPID"), \
                    x(SDBMSG_DBMSRV_IOMANPROCEXIT, "IOMANPROCEXIT"), \
                    x(SDBMSG_DBMSRV_IOMANPROCDELWP, "IOMANPROCDELWP"), \
                    x(SDBMSG_DBMSRV_IOMANPROCDELRP, "IOMANPROCDELRP"), \
                    x(SDBMSG_DBMSRV_IOMANPROCPROCDIED, "IOMANPROCPROCDIED"), \
                    x(SDBMSG_DBMSRV_IOMANNOWP, "IOMANNOWP"), \
                    x(SDBMSG_DBMSRV_IOMANNORP, "IOMANNORP"), \
                    x(SDBMSG_DBMSRV_IOMANBADWP, "IOMANBADWP"), \
                    x(SDBMSG_DBMSRV_IOMANBADRP, "IOMANBADRP"), \
                    x(SDBMSG_DBMSRV_IOMANNOEND, "IOMANNOEND"), \
                    x(SDBMSG_DBMSRV_CONNLOST, "CONNLOST"), \
                    x(SDBMSG_DBMSRV_EXCEPTIONCAUGHT, "EXCEPTIONCAUGHT"), \
                    x(SDBMSG_DBMSRV_STE, "STE"), \
                    x(SDBMSG_DBMSRV_SHMVERSIONMISMATCH, "SHMVERSIONMISMATCH"), \
                    x(SDBMSG_DBMSRV_NODISPATCHERSTART, "NODISPATCHERSTART"), \
                    x(SDBMSG_DBMSRV_NOAUTOEXTEND, "NOAUTOEXTEND"), \
                    x(SDBMSG_DBMSRV_NOAUTOEXTENDOFF, "NOAUTOEXTENDOFF"), \
                    x(SDBMSG_DBMSRV_NODISPATCHERSTOP, "NODISPATCHERSTOP"), \
                    x(SDBMSG_DBMSRV_NOAUTOUPDSTAT, "NOAUTOUPDSTAT"), \
                    x(SDBMSG_DBMSRV_NOAUTOUPDSTATOFF, "NOAUTOUPDSTATOFF"), \
                    x(SDBMSG_DBMSRV_AUTOUPDSTAT_ILLMODE, "AUTOUPDSTAT_ILLMODE"), \
                    x(SDBMSG_DBMSRV_CMDOPTION, "CMDOPTION"), \
                    x(SDBMSG_DBMSRV_DATAFULL, "DATAFULL"), \
                    x(SDBMSG_DBMSRV_NO_EVENTCONFIG_CHANGE, "NO_EVENTCONFIG_CHANGE"), \
                    x(SDBMSG_DBMSRV_EVENTCAT_UNKNOWN, "EVENTCAT_UNKNOWN"), \
                    x(SDBMSG_DBMSRV_EVENTPRIO_UNKNOWN, "EVENTPRIO_UNKNOWN"), \
                    x(SDBMSG_DBMSRV_DISP_NO_EXIST, "DISP_NO_EXIST"), \
                    x(SDBMSG_DBMSRV_DISP_NOT_STOPPED, "DISP_NOT_STOPPED"), \
                    x(SDBMSG_DBMSRV_DISP_NO_REMOTE_ACCESS, "DISP_NO_REMOTE_ACCESS"), \
                    x(SDBMSG_DBMSRV_DISP_NO_INTCMD_FOUND, "DISP_NO_INTCMD_FOUND"), \
                    x(SDBMSG_DBMSRV_DISP_NO_LIST, "DISP_NO_LIST"), \
                    x(SDBMSG_DBMSRV_DISP_NO_DELETE, "DISP_NO_DELETE"), \
                    x(SDBMSG_DBMSRV_DISP_INTERNAL_EXISTS, "DISP_INTERNAL_EXISTS"), \
                    x(SDBMSG_DBMSRV_DISP_INTERNAL_NOACC, "DISP_INTERNAL_NOACC"), \
                    x(SDBMSG_DBMSRV_DISP_INTERNAL_NOT_REMOTE, "DISP_INTERNAL_NOT_REMOTE"), \
                    x(SDBMSG_DBMSRV_KNLUNKNOWN, "KNLUNKNOWN"), \
                    x(SDBMSG_DBMSRV_COMM_CLIENT_CONNECT, "COMM_CLIENT_CONNECT"), \
                    x(SDBMSG_DBMSRV_WRONGDBSTATE, "WRONGDBSTATE"), \
                    x(SDBMSG_DBMSRV_DBSTATENEEDED1, "DBSTATENEEDED1"), \
                    x(SDBMSG_DBMSRV_DBSTATENEEDED2, "DBSTATENEEDED2"), \
                    x(SDBMSG_DBMSRV_DBSTATENEEDED3, "DBSTATENEEDED3"), \
                    x(SDBMSG_DBMSRV_DBSTATENEEDED4, "DBSTATENEEDED4"), \
                    x(SDBMSG_DBMSRV_INTERNAL_TRANSPORT_MSG, "INTERNAL_TRANSPORT_MSG"), \
                    x(SDBMSG_DBMSRV_VOLTYPENOTALLOWED, "VOLTYPENOTALLOWED"), \
                    x(SDBMSG_DBMSRV_XPVALUNEX, "XPVALUNEX"), \
                    x(SDBMSG_DBMSRV_VOLNFOUNDXP, "VOLNFOUNDXP"), \
                    x(SDBMSG_DBMSRV_COMM_CLIENT_DISCONNECT, "COMM_CLIENT_DISCONNECT"), \
                    x(SDBMSG_DBMSRV_REPLY_ENDLESS, "REPLY_ENDLESS"), \
                    x(SDBMSG_DBMSRV_REPLY_2MSG, "REPLY_2MSG"), \
                    x(SDBMSG_DBMSRV_PROCESSDATA_INVALID, "PROCESSDATA_INVALID"), \
                    x(SDBMSG_DBMSRV_PROCESSDATA_ERR_SIZE, "PROCESSDATA_ERR_SIZE"), \
                    x(SDBMSG_DBMSRV_PROCESSDATA_SIZE_NOTSUPPORTED, "PROCESSDATA_SIZE_NOTSUPPORTED"), \
                    x(SDBMSG_DBMSRV_VOLSIZEILLEGAL, "VOLSIZEILLEGAL"), \
                    x(SDBMSG_DBMSRV_SETENV, "SETENV"), \
                    x(SDBMSG_DBMSRV_VOLLASTADDEDNFOUNDXPHIS, "VOLLASTADDEDNFOUNDXPHIS"), \
                    x(SDBMSG_DBMSRV_NOAUTHENTICATION, "NOAUTHENTICATION"), \
                    x(SDBMSG_DBMSRV_BHIST_INVALID_ENTRY, "BHIST_INVALID_ENTRY"), \
                    x(SDBMSG_DBMSRV_FORMAT_SEPARATORMISSING, "FORMAT_SEPARATORMISSING"), \
                    x(SDBMSG_DBMSRV_FORMAT_UINTEGER, "FORMAT_UINTEGER"), \
                    x(SDBMSG_DBMSRV_FORMAT_INTEGER, "FORMAT_INTEGER"), \
                    x(SDBMSG_DBMSRV_BHIST_MED_INVALID_ENTRY, "BHIST_MED_INVALID_ENTRY"), \
                    x(SDBMSG_DBMSRV_FORMAT_SEPARATORNO3, "FORMAT_SEPARATORNO3"), \
                    x(SDBMSG_DBMSRV_FORMAT_SEPARATORNOP, "FORMAT_SEPARATORNOP"), \
                    x(SDBMSG_DBMSRV_SDBINST, "SDBINST"), \
                    x(SDBMSG_DBMSRV_SESSIONLIMIT, "SESSIONLIMIT"), \
                    x(SDBMSG_DBMSRV_HSSNODEUNKNOWN, "HSSNODEUNKNOWN"), \
                    x(SDBMSG_DBMSRV_MISSDBUSRPWD, "MISSDBUSRPWD"), \
                    x(SDBMSG_DBMSRV_UNKNOWNTASK, "UNKNOWNTASK"), \
                    x(SDBMSG_DBMSRV_LOCISDIR, "LOCISDIR"), \
                    x(SDBMSG_DBMSRV_INVPARAM, "INVPARAM"), \
                    x(SDBMSG_DBMSRV_MISSPARAM, "MISSPARAM"), \
                    x(SDBMSG_DBMSRV_FILEOPEN, "FILEOPEN"), \
                    x(SDBMSG_DBMSRV_FILEWRITE, "FILEWRITE"), \
                    x(SDBMSG_DBMSRV_FILECLOSE, "FILECLOSE"), \
                    x(SDBMSG_DBMSRV_XPWRITE, "XPWRITE"), \
                    x(SDBMSG_DBMSRV_SHMPLATFORMMISMATCH, "SHMPLATFORMMISMATCH"), \
                    x(SDBMSG_DBMSRV_SHMNOLOCK, "SHMNOLOCK"), \
                    x(SDBMSG_DBMSRV_SHMNOUNLOCK, "SHMNOUNLOCK"), \
                    x(SDBMSG_DBMSRV_SHMWRONGUNLOCKPID, "SHMWRONGUNLOCKPID"), \
                    x(SDBMSG_DBMSRV_SHMSHIFTERROR, "SHMSHIFTERROR"), \
                    x(SDBMSG_DBMSRV_SHMERREXTEND, "SHMERREXTEND"), \
                    x(SDBMSG_DBMSRV_SHMLINEOUTOFSCOPE, "SHMLINEOUTOFSCOPE"), \
                    x(SDBMSG_DBMSRV_SHMNORESOURCELYT, "SHMNORESOURCELYT"), \
                    x(SDBMSG_DBMSRV_SHMNORESOURCELYTDEL, "SHMNORESOURCELYTDEL"), \
                    x(SDBMSG_DBMSRV_SHMNOSCHEDLYT, "SHMNOSCHEDLYT"), \
                    x(SDBMSG_DBMSRV_SHMNOSCHEDLYTDEL, "SHMNOSCHEDLYTDEL"), \
                    x(SDBMSG_DBMSRV_SHMNOEVTSILLYT, "SHMNOEVTSILLYT"), \
                    x(SDBMSG_DBMSRV_SHMNOEVTSILLYTDEL, "SHMNOEVTSILLYTDEL"), \
                    x(SDBMSG_DBMSRV_SHMNOEVTLYT, "SHMNOEVTLYT"), \
                    x(SDBMSG_DBMSRV_SHMNOEVTLYTFOUND, "SHMNOEVTLYTFOUND"), \
                    x(SDBMSG_DBMSRV_SHMNOEVTLYTDEL, "SHMNOEVTLYTDEL"), \
                    x(SDBMSG_DBMSRV_SHMNOEVTLYTNEW, "SHMNOEVTLYTNEW"), \
                    x(SDBMSG_DBMSRV_SHMNORESOURCELYTFOUND, "SHMNORESOURCELYTFOUND"), \
                    x(SDBMSG_DBMSRV_SHMLINESEXCEEDED, "SHMLINESEXCEEDED"), \
                    x(SDBMSG_DBMSRV_RESLOCK_NO_CREATE, "RESLOCK_NO_CREATE"), \
                    x(SDBMSG_DBMSRV_RESLOCK_NO_LOCK, "RESLOCK_NO_LOCK"), \
                    x(SDBMSG_DBMSRV_RESLOCK_NO_UNLOCK, "RESLOCK_NO_UNLOCK"), \
                    x(SDBMSG_DBMSRV_SCHEDCOM_NO_CREATE, "SCHEDCOM_NO_CREATE"), \
                    x(SDBMSG_DBMSRV_EVTSIL_NO_CREATE, "EVTSIL_NO_CREATE"), \
                    x(SDBMSG_DBMSRV_EVT_NO_CREATE, "EVT_NO_CREATE"), \
                    x(SDBMSG_DBMSRV_EVT_NO_CREATE_PID, "EVT_NO_CREATE_PID"), \
                    x(SDBMSG_DBMSRV_EVT_NO_ITERATOR_CREATE, "EVT_NO_ITERATOR_CREATE"), \
                    x(SDBMSG_DBMSRV_COMMAND_RECEIVED, "COMMAND_RECEIVED"), \
                    x(SDBMSG_DBMSRV_SHMNOCLOSE, "SHMNOCLOSE"), \
                    x(SDBMSG_DBMSRV_SHMNODELETE, "SHMNODELETE"), \
                    x(SDBMSG_DBMSRV_SHMNOUNLOCKER, "SHMNOUNLOCKER"), \
                    x(SDBMSG_DBMSRV_SHMNIADDRESS, "SHMNIADDRESS"), \
                    x(SDBMSG_DBMSRV_SHMSOADDRESS, "SHMSOADDRESS"), \
                    x(SDBMSG_DBMSRV_SHMEXADDRESS, "SHMEXADDRESS"), \
                    x(SDBMSG_DBMSRV_SHMMEMORYACCESS, "SHMMEMORYACCESS"), \
                    x(SDBMSG_DBMSRV_NOT_EXCLUSIVE, "NOT_EXCLUSIVE"), \
                    x(SDBMSG_DBMSRV_BACKUPSESSIONLOST, "BACKUPSESSIONLOST"), \
                    x(SDBMSG_DBMSRV_IMPLICITRECONNECT, "IMPLICITRECONNECT"), \
                    x(SDBMSG_DBMSRV_RESULTLOST, "RESULTLOST"), \
                    x(SDBMSG_DBMSRV_DUMP_WRITTEN, "DUMP_WRITTEN"), \
                    x(SDBMSG_DBMSRV_NO_DUMP_WRITTEN, "NO_DUMP_WRITTEN"), \
                    x(SDBMSG_DBMSRV_ILLEGALBLOCKINGFACTOR, "ILLEGALBLOCKINGFACTOR"), \
                    x(SDBMSG_DBMSRV_ILLEGALPAGESIZE, "ILLEGALPAGESIZE"), \
                    x(SDBMSG_DBMSRV_EXHNDLR, "EXHNDLR"), \
                    x(SDBMSG_DBMSRV_DBMSRV_NOSTART, "DBMSRV_NOSTART"), \
                    x(SDBMSG_DBMSRV_MEFDIRTY, "MEFDIRTY"), \
                    x(SDBMSG_DBMSRV_FORMAT_DELIMISS, "FORMAT_DELIMISS"), \
                    x(SDBMSG_DBMSRV_COMM_NO_REACT, "COMM_NO_REACT"), \
                    x(SDBMSG_DBMSRV_COMM_PACKTOOSMALL, "COMM_PACKTOOSMALL"), \
                    x(SDBMSG_DBMSRV_BHIST_TOOMUCHDATA, "BHIST_TOOMUCHDATA"), \
                    x(SDBMSG_DBMSRV_SHMNOCLEANUP, "SHMNOCLEANUP"), \
                    x(SDBMSG_DBMSRV_VOLMODE, "VOLMODE"), \
                    x(SDBMSG_DBMSRV_VOLMODENOTALLOWED, "VOLMODENOTALLOWED")
/* <- some helpful enumerations */

#endif /* SDBMSG_DBMSRV_H */
