/*
        ========== licence begin  GPL
        Copyright (C) 2005 SAP AG

        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
        ========== licence end
 */
#ifndef RTE_CKC_MESSAGES_HPP
#define RTE_CKC_MESSAGES_HPP

// Generated Header file RTE_CKC_Messages.hpp.
// Generated by genmsg V2.2 DO NOT EDIT

#include "SAPDBCommon/ErrorsAndMessages/SAPDBErr_MessageList.hpp"

#define RTEERR_CKC_WRONG_PACKET_PTR                    SAPDBErr_MessageList::Error,14100,"Wrong packet pointer: %s",1
#define RTEERR_CKC_WRONG_PACKET_PTR_ID 14100
#define RTEERR_CKC_LEAVE_WITHOUT_ENTER_RECV            SAPDBErr_MessageList::Error,14101,"'LeaveReceive' called without 'EnterReceive'",0
#define RTEERR_CKC_LEAVE_WITHOUT_ENTER_RECV_ID 14101
#define RTEERR_CKC_PACKET_IN_USE                       SAPDBErr_MessageList::Error,14102,"Packet %s already in use",1
#define RTEERR_CKC_PACKET_IN_USE_ID 14102
#define RTEERR_CKC_NO_OUTSTANDING_PCKTS                SAPDBErr_MessageList::Error,14103,"No unreceived packet outstanding",0
#define RTEERR_CKC_NO_OUTSTANDING_PCKTS_ID 14103
#define RTEERR_CKC_RECEIVE_ALREADY_PENDING             SAPDBErr_MessageList::Error,14104,"A receive is pending",0
#define RTEERR_CKC_RECEIVE_ALREADY_PENDING_ID 14104
#define RTEERR_CKC_SEND_PENDING                        SAPDBErr_MessageList::Error,14105,"A send is pending",0
#define RTEERR_CKC_SEND_PENDING_ID 14105
#define RTEERR_CKC_WRONG_SET_PARAMETER                 SAPDBErr_MessageList::Error,14106,"Client communication sequence check parameter are invalid: %s, %s, %s",3
#define RTEERR_CKC_WRONG_SET_PARAMETER_ID 14106
#define RTEERR_CKC_SEND_OUTSTANDING                    SAPDBErr_MessageList::Error,14107,"A send is outstanding",0
#define RTEERR_CKC_SEND_OUTSTANDING_ID 14107
#define RTEERR_CKC_REQUEST_APPEND_OPTION               SAPDBErr_MessageList::Error,14120,"Request buffer to small to append '%s' to '%s'",2
#define RTEERR_CKC_REQUEST_APPEND_OPTION_ID 14120
#define RTEERR_CKC_MEMORY_EXHAUSTED                    SAPDBErr_MessageList::Error,14130,"Memory for %s could not be allocated, wanted size: %s",2
#define RTEERR_CKC_MEMORY_EXHAUSTED_ID 14130
#define RTEERR_CKC_REQUEST_TO_LARGE                    SAPDBErr_MessageList::Error,14131,"Client request is too long, maximal allowed length: %s",1
#define RTEERR_CKC_REQUEST_TO_LARGE_ID 14131
#define RTEERR_CKC_INCOMPLETE_REQUEST                  SAPDBErr_MessageList::Error,14132,"Client request is incomplete: %s",1
#define RTEERR_CKC_INCOMPLETE_REQUEST_ID 14132
#define RTEERR_CKC_WRITE_REQUEST                       SAPDBErr_MessageList::Error,14133,"Write request %s failed, request length: %s, byte to write: %s, bytes written : %s",4
#define RTEERR_CKC_WRITE_REQUEST_ID 14133
#define RTEERR_CKC_READ_REQUEST                        SAPDBErr_MessageList::Error,14134,"Read request failed, read: %s, minimum to read: %s",2
#define RTEERR_CKC_READ_REQUEST_ID 14134
#define RTEERR_CKC_PARSE_CLIENT_REQUEST                SAPDBErr_MessageList::Error,14135,"Parse client request failed, rc: %s",1
#define RTEERR_CKC_PARSE_CLIENT_REQUEST_ID 14135
#define RTEERR_CKC_REQUEST_WITHOUT_DB_PATH             SAPDBErr_MessageList::Error,14136,"Request URI contains no DB path: %s",1
#define RTEERR_CKC_REQUEST_WITHOUT_DB_PATH_ID 14136
#define RTEERR_CKC_REQUEST_MISSING_TYPE                SAPDBErr_MessageList::Error,14137,"Request URI contains no request type: %s",1
#define RTEERR_CKC_REQUEST_MISSING_TYPE_ID 14137
#define RTEERR_CKC_UNKNOWN_REQUEST                     SAPDBErr_MessageList::Error,14138,"Unknown request type: %s",1
#define RTEERR_CKC_UNKNOWN_REQUEST_ID 14138
#define RTEERR_CKC_CONNECT_REQUEST_MISSING_OPTION      SAPDBErr_MessageList::Error,14139,"Request URI %s contains no %s",2
#define RTEERR_CKC_CONNECT_REQUEST_MISSING_OPTION_ID 14139
#define RTEERR_CKC_SESSION_MISSING_TYP                 SAPDBErr_MessageList::Error,14140,"Request URI contains no session type: %s",1
#define RTEERR_CKC_SESSION_MISSING_TYP_ID 14140
#define RTEERR_CKC_CANCEL_MISSING_SESSION_ID           SAPDBErr_MessageList::Error,14141,"Cancel request URI contains no session ID: %s",1
#define RTEERR_CKC_CANCEL_MISSING_SESSION_ID_ID 14141
#define RTEERR_CKC_CONNECT_REQUEST_WRONG_COMMSEGSIZE   SAPDBErr_MessageList::Error,14142,"Request URI %s contains invalid CommSegSize: %s",2
#define RTEERR_CKC_CONNECT_REQUEST_WRONG_COMMSEGSIZE_ID 14142
#define RTEERR_CKC_PARSE_CONNECT_URI                   SAPDBErr_MessageList::Error,14155,"Connect URI could not be parsed, rc: %s",1
#define RTEERR_CKC_PARSE_CONNECT_URI_ID 14155
#define RTEERR_CKC_LOAD_REQUEST                        SAPDBErr_MessageList::Error,14160,"Load request failed",0
#define RTEERR_CKC_LOAD_REQUEST_ID 14160
#define RTEERR_CKC_DUMP_REQUEST                        SAPDBErr_MessageList::Error,14161,"Dump request failed",0
#define RTEERR_CKC_DUMP_REQUEST_ID 14161
#define RTEERR_CKC_REQUEST_CHANNEL_MISSING             SAPDBErr_MessageList::Error,14162,"Request channel is missing",0
#define RTEERR_CKC_REQUEST_CHANNEL_MISSING_ID 14162
#define RTEERR_CKC_OPEN_REQUEST_CHANNEL                SAPDBErr_MessageList::Error,14163,"Open request channel failed",0
#define RTEERR_CKC_OPEN_REQUEST_CHANNEL_ID 14163
#define RTEERR_CKC_CLOSE_REQUEST_CHANNEL               SAPDBErr_MessageList::Error,14164,"Close request channel failed",0
#define RTEERR_CKC_CLOSE_REQUEST_CHANNEL_ID 14164
#define RTEERR_CKC_CONNECT_REPLY_LENGTH                SAPDBErr_MessageList::Error,14180,"Length of connect reply differs from expected length: expected %s, read %s",2
#define RTEERR_CKC_CONNECT_REPLY_LENGTH_ID 14180
#define RTEERR_CKC_CONNECT_REQUEST_LENGTH              SAPDBErr_MessageList::Error,14181,"Length of connect request differs from expected length: expected %s, read %s",2
#define RTEERR_CKC_CONNECT_REQUEST_LENGTH_ID 14181
#define RTEERR_CKC_GET_PACKET_HEADER                   SAPDBErr_MessageList::Error,14182,"Get RTE packet header failed",0
#define RTEERR_CKC_GET_PACKET_HEADER_ID 14182
#define RTEERR_CKC_PROTOCOL_VERSION                    SAPDBErr_MessageList::Error,14183,"Read wrong protocol version: version supported %s, wanted version %s",2
#define RTEERR_CKC_PROTOCOL_VERSION_ID 14183
#define RTEERR_CKC_PROTOCOL_ID                         SAPDBErr_MessageList::Error,14184,"Read wrong protocol id: expected %s, given %s",2
#define RTEERR_CKC_PROTOCOL_ID_ID 14184
#define RTEERR_CKC_PROTOCOL_DATA_LEN                   SAPDBErr_MessageList::Error,14185,"Read data packet has invalid length: bytes total %s, bytes actual %s, bytes maximal %s",3
#define RTEERR_CKC_PROTOCOL_DATA_LEN_ID 14185
#define RTEERR_CKC_LOAD_EVENT                          SAPDBErr_MessageList::Error,14186,"Read error message failed",0
#define RTEERR_CKC_LOAD_EVENT_ID 14186
#define RTEERR_CKC_RESPONSE_TYPE                       SAPDBErr_MessageList::Error,14187,"Read wrong response type: expected %s, given %s",2
#define RTEERR_CKC_RESPONSE_TYPE_ID 14187
#define RTEERR_CKC_RECEIVER_REF                        SAPDBErr_MessageList::Error,14188,"Read wrong receiver reference: expected %s, given %s",2
#define RTEERR_CKC_RECEIVER_REF_ID 14188
#define RTEERR_CKC_SENDER_REF                          SAPDBErr_MessageList::Error,14189,"Read wrong sender reference: expected %s, given %s",2
#define RTEERR_CKC_SENDER_REF_ID 14189
#define RTEERR_CKC_SET_DATA_LEN                        SAPDBErr_MessageList::Error,14190,"Packet exceeds maximum allowed length: wanted %s, maximum %s",2
#define RTEERR_CKC_SET_DATA_LEN_ID 14190
#define RTEERR_CKC_CLOSE_ALL_CONNECTIONS               SAPDBErr_MessageList::Error,14200,"Close all connection failed",0
#define RTEERR_CKC_CLOSE_ALL_CONNECTIONS_ID 14200
#define RTEERR_CKC_PREPARE_CLOSE_CONNECTION            SAPDBErr_MessageList::Error,14201,"Prepare close for connection failed",0
#define RTEERR_CKC_PREPARE_CLOSE_CONNECTION_ID 14201
#define RTEERR_CKC_REL_HANDLE_DATA                     SAPDBErr_MessageList::Error,14202,"Release handle data failed",0
#define RTEERR_CKC_REL_HANDLE_DATA_ID 14202
#define RTEERR_CKC_CLOSE_CONNECTION                    SAPDBErr_MessageList::Error,14203,"Close connection failed",0
#define RTEERR_CKC_CLOSE_CONNECTION_ID 14203
#define RTEERR_CKC_CLOSE_CLIENT_COMM                   SAPDBErr_MessageList::Error,14220,"Close client communication failed",0
#define RTEERR_CKC_CLOSE_CLIENT_COMM_ID 14220
#define RTEERR_CKC_PARSE_URI_NEW_CONNECTION            SAPDBErr_MessageList::Error,14221,"Parse URI of new connection failed [%s]",1
#define RTEERR_CKC_PARSE_URI_NEW_CONNECTION_ID 14221
#define RTEERR_CKC_NEW_HANDLE_FOR_CONNECTION           SAPDBErr_MessageList::Error,14222,"Get handle for new connection failed [%s]",1
#define RTEERR_CKC_NEW_HANDLE_FOR_CONNECTION_ID 14222
#define RTEERR_CKC_PROTOCOL_NOT_IMPLEMENTED            SAPDBErr_MessageList::Error,14223,"Protocol is not implemented: %s",1
#define RTEERR_CKC_PROTOCOL_NOT_IMPLEMENTED_ID 14223
#define RTEERR_CKC_OPEN_NEW_CONNECTION                 SAPDBErr_MessageList::Error,14224,"Open new connection to %s failed",1
#define RTEERR_CKC_OPEN_NEW_CONNECTION_ID 14224
#define RTEERR_CKC_RELEASE_CONNECTION_DATA             SAPDBErr_MessageList::Error,14225,"Release connection data failed",0
#define RTEERR_CKC_RELEASE_CONNECTION_DATA_ID 14225
#define RTEERR_CKC_SEND_DATA                           SAPDBErr_MessageList::Error,14226,"Send data failed",0
#define RTEERR_CKC_SEND_DATA_ID 14226
#define RTEERR_CKC_RECEIVE_DATA                        SAPDBErr_MessageList::Error,14227,"Receive data failed",0
#define RTEERR_CKC_RECEIVE_DATA_ID 14227
#define RTEERR_CKC_CANCEL_REQUEST                      SAPDBErr_MessageList::Error,14228,"Cancel request failed",0
#define RTEERR_CKC_CANCEL_REQUEST_ID 14228
#define RTEERR_CKC_CONNECTION_ALREADY_OPEN             SAPDBErr_MessageList::Error,14229,"Connection is already open",0
#define RTEERR_CKC_CONNECTION_ALREADY_OPEN_ID 14229
#define RTEERR_CKC_ILLEGAL_PACKET_INDEX                SAPDBErr_MessageList::Error,14230,"Illegal packet index: %s",1
#define RTEERR_CKC_ILLEGAL_PACKET_INDEX_ID 14230
#define RTEERR_CKC_CLOSE_LOCAL_COMM                    SAPDBErr_MessageList::Error,14301,"Close local communication failed",0
#define RTEERR_CKC_CLOSE_LOCAL_COMM_ID 14301
#define RTEERR_CKC_GLOBAL_COMMSEG_MISSING              SAPDBErr_MessageList::Error,14302,"Global communication segment is missing",0
#define RTEERR_CKC_GLOBAL_COMMSEG_MISSING_ID 14302
#define RTEERR_CKC_OPEN_GLOBAL_COMMSEG                 SAPDBErr_MessageList::Error,14303,"Open global communication segment failed",0
#define RTEERR_CKC_OPEN_GLOBAL_COMMSEG_ID 14303
#define RTEERR_CKC_CLOSE_GLOBAL_COMM_SEG               SAPDBErr_MessageList::Error,14304,"Close global communication segment failed",0
#define RTEERR_CKC_CLOSE_GLOBAL_COMM_SEG_ID 14304
#define RTEERR_CKC_GET_UNIQUE_NAME                     SAPDBErr_MessageList::Error,14305,"Get unique name for %s failed",1
#define RTEERR_CKC_GET_UNIQUE_NAME_ID 14305
#define RTEERR_CKC_ALLOCATE_COMMSEG_NAME               SAPDBErr_MessageList::Error,14306,"Allocate %s bytes for communication segment name failed",1
#define RTEERR_CKC_ALLOCATE_COMMSEG_NAME_ID 14306
#define RTEERR_CKC_ALLOCATE_SERVER_URI                 SAPDBErr_MessageList::Error,14307,"Allocate %s bytes for server URI failed",1
#define RTEERR_CKC_ALLOCATE_SERVER_URI_ID 14307
#define RTEERR_CKC_INIT_SEQ_CHECK                      SAPDBErr_MessageList::Error,14308,"Initialize communication sequence check failed",0
#define RTEERR_CKC_INIT_SEQ_CHECK_ID 14308
#define RTEERR_CKC_ALLOCATE_CLIENT_SEM_NAME            SAPDBErr_MessageList::Error,14310,"Allocate %s bytes for client semaphore name failed",1
#define RTEERR_CKC_ALLOCATE_CLIENT_SEM_NAME_ID 14310
#define RTEERR_CKC_CREATE_CLIENT_SEM                   SAPDBErr_MessageList::Error,14311,"Create client semaphore failed",0
#define RTEERR_CKC_CREATE_CLIENT_SEM_ID 14311
#define RTEERR_CKC_CONNECT_TO_SERVER                   SAPDBErr_MessageList::Error,14312,"Connect to server failed",0
#define RTEERR_CKC_CONNECT_TO_SERVER_ID 14312
#define RTEERR_CKC_POST_CLIENT_SEM                     SAPDBErr_MessageList::Error,14314,"Post client semaphore failed",0
#define RTEERR_CKC_POST_CLIENT_SEM_ID 14314
#define RTEERR_CKC_CLOSE_COMM_SEG                      SAPDBErr_MessageList::Error,14315,"Close communication segment failed",0
#define RTEERR_CKC_CLOSE_COMM_SEG_ID 14315
#define RTEERR_CKC_CLOSE_CLIENT_SEM                    SAPDBErr_MessageList::Error,14318,"Close client semaphore failed",0
#define RTEERR_CKC_CLOSE_CLIENT_SEM_ID 14318
#define RTEERR_CKC_ENTER_SEND                          SAPDBErr_MessageList::Error,14320,"Enter sending packet failed",0
#define RTEERR_CKC_ENTER_SEND_ID 14320
#define RTEERR_CKC_SET_REQUEST_HEADER                  SAPDBErr_MessageList::Error,14321,"Set RTE header of request failed",0
#define RTEERR_CKC_SET_REQUEST_HEADER_ID 14321
#define RTEERR_CKC_CLIENT_SEND                         SAPDBErr_MessageList::Error,14322,"Send packet %s [%s bytes] failed",2
#define RTEERR_CKC_CLIENT_SEND_ID 14322
#define RTEERR_CKC_POST_SERVER_SEM                     SAPDBErr_MessageList::Error,14323,"Post server semaphore of UKT %s failed",1
#define RTEERR_CKC_POST_SERVER_SEM_ID 14323
#define RTEERR_CKC_ENTER_RECEIVE                       SAPDBErr_MessageList::Error,14324,"Enter receiving packet failed",0
#define RTEERR_CKC_ENTER_RECEIVE_ID 14324
#define RTEERR_CKC_RECEIVE                             SAPDBErr_MessageList::Error,14325,"Receive packet failed",0
#define RTEERR_CKC_RECEIVE_ID 14325
#define RTEERR_CKC_SERVERDB_OFFLINE                    SAPDBErr_MessageList::Error,14326,"Server DB is offline",0
#define RTEERR_CKC_SERVERDB_OFFLINE_ID 14326
#define RTEERR_CKC_WAIT_CLIENT_SEM                     SAPDBErr_MessageList::Error,14327,"Wait client semaphore failed",0
#define RTEERR_CKC_WAIT_CLIENT_SEM_ID 14327
#define RTEERR_CKC_CHECK_REPLY_HEADER                  SAPDBErr_MessageList::Error,14328,"Check reply header failed",0
#define RTEERR_CKC_CHECK_REPLY_HEADER_ID 14328
#define RTEERR_CKC_PUT_CANCEL_REQUEST                  SAPDBErr_MessageList::Error,14329,"Put cancel request failed",0
#define RTEERR_CKC_PUT_CANCEL_REQUEST_ID 14329
#define RTEERR_CKC_WRITE_REQUEST_CHANNEL               SAPDBErr_MessageList::Error,14330,"Write to request channel of server DB %s failed",1
#define RTEERR_CKC_WRITE_REQUEST_CHANNEL_ID 14330
#define RTEERR_CKC_SET_CONNECT_REQUEST_HEADER          SAPDBErr_MessageList::Error,14331,"Set RTE header of connect request failed",0
#define RTEERR_CKC_SET_CONNECT_REQUEST_HEADER_ID 14331
#define RTEERR_CKC_PUT_CONNECT_REQUEST                 SAPDBErr_MessageList::Error,14332,"Put connect request failed",0
#define RTEERR_CKC_PUT_CONNECT_REQUEST_ID 14332
#define RTEERR_CKC_TIMEOUT_CLIENT_SEM                  SAPDBErr_MessageList::Error,14333,"Connect timeout",0
#define RTEERR_CKC_TIMEOUT_CLIENT_SEM_ID 14333
#define RTEERR_CKC_CONNECT_RECEIVE                     SAPDBErr_MessageList::Error,14334,"Receive connect reply packet failed",0
#define RTEERR_CKC_CONNECT_RECEIVE_ID 14334
#define RTEERR_CKC_CHECK_CONNECT_REPLY_HEADER          SAPDBErr_MessageList::Error,14336,"Check connect reply header failed",0
#define RTEERR_CKC_CHECK_CONNECT_REPLY_HEADER_ID 14336
#define RTEERR_CKC_MAILSLOT_MISSING                    SAPDBErr_MessageList::Error,14338,"Mailslot of server DB is missing",0
#define RTEERR_CKC_MAILSLOT_MISSING_ID 14338
#define RTEERR_CKC_OPEN_MAILSLOT                       SAPDBErr_MessageList::Error,14339,"Open mailslot of server DB %s failed",1
#define RTEERR_CKC_OPEN_MAILSLOT_ID 14339
#define RTEERR_CKC_CLOSE_MAILSLOT                      SAPDBErr_MessageList::Error,14340,"Close mailslot failed",0
#define RTEERR_CKC_CLOSE_MAILSLOT_ID 14340
#define RTEERR_CKC_NUM_UKT                             SAPDBErr_MessageList::Error,14341,"Number of task scheduler is unknown",0
#define RTEERR_CKC_NUM_UKT_ID 14341
#define RTEERR_CKC_OPEN_SERVER_SEM                     SAPDBErr_MessageList::Error,14342,"Open server semaphore of task scheduler %s failed",1
#define RTEERR_CKC_OPEN_SERVER_SEM_ID 14342
#define RTEERR_CKC_CLOSE_SERVER_SEM                    SAPDBErr_MessageList::Error,14343,"Close server semaphore of task scheduler %s failed",1
#define RTEERR_CKC_CLOSE_SERVER_SEM_ID 14343
#define RTEERR_CKC_SERVER_STATE                        SAPDBErr_MessageList::Error,14344,"DB process [pid %s] is in state %s",2
#define RTEERR_CKC_SERVER_STATE_ID 14344
#define RTEERR_CKC_ALLOCATE_DB_NAME                    SAPDBErr_MessageList::Error,14345,"Allocate %s bytes for DB name %s failed",2
#define RTEERR_CKC_ALLOCATE_DB_NAME_ID 14345
#define RTEERR_CKC_MISSING_SERVERDB                    SAPDBErr_MessageList::Error,14346,"Missing DB name in given URI",0
#define RTEERR_CKC_MISSING_SERVERDB_ID 14346
#define RTEERR_CKC_MISSING_DB_PATH                     SAPDBErr_MessageList::Error,14347,"Missing DB path in given URI",0
#define RTEERR_CKC_MISSING_DB_PATH_ID 14347
#define RTEERR_CKC_NUM_PACKETS                         SAPDBErr_MessageList::Error,14348,"Number of wanted packets exceeds the allowed maximum: wanted %s, allowed %s",2
#define RTEERR_CKC_NUM_PACKETS_ID 14348
#define RTEERR_CKC_OPEN_NAMED_SHM                      SAPDBErr_MessageList::Error,14500,"Open named shared memory failed",0
#define RTEERR_CKC_OPEN_NAMED_SHM_ID 14500
#define RTEERR_CKC_COMMSEG_VERSION                     SAPDBErr_MessageList::Error,14501,"Wrong communication segment version: known version %s, given version %s",2
#define RTEERR_CKC_COMMSEG_VERSION_ID 14501
#define RTEERR_CKC_CLOSE_NAMED_SHM                     SAPDBErr_MessageList::Error,14502,"Close named shared memory failed",0
#define RTEERR_CKC_CLOSE_NAMED_SHM_ID 14502
#define RTEERR_CKC_INVALID_SEND_PACKET                 SAPDBErr_MessageList::Error,14503,"Invalid send packet : %s",1
#define RTEERR_CKC_INVALID_SEND_PACKET_ID 14503
#define RTEERR_CKC_WRONG_CONNECTION_STATE              SAPDBErr_MessageList::Error,14504,"Wrong connection state at %s: own state [%s], remote state [%s]",3
#define RTEERR_CKC_WRONG_CONNECTION_STATE_ID 14504
#define RTEERR_CKC_WRONG_SERVER_SEND_PACKET            SAPDBErr_MessageList::Error,14505,"Server has replied with wrong packet: expected UID %s, given UID %s",2
#define RTEERR_CKC_WRONG_SERVER_SEND_PACKET_ID 14505
#define RTEERR_CKC_CONNECTION_BROKEN                   SAPDBErr_MessageList::Error,14506,"%s: Connection is broken: synchronous state [%s], asynchronous state [%s] ",3
#define RTEERR_CKC_CONNECTION_BROKEN_ID 14506
#define RTEERR_CKC_CONNECT_PACKET_MISSING              SAPDBErr_MessageList::Error,14508,"Connect packet is missing",0
#define RTEERR_CKC_CONNECT_PACKET_MISSING_ID 14508
#define RTEERR_CKC_OPEN_COMM_SEG                       SAPDBErr_MessageList::Error,14509,"Open communication segment failed",0
#define RTEERR_CKC_OPEN_COMM_SEG_ID 14509
#define RTEERR_CKC_UNKNOWN_SESSION_TYPE                SAPDBErr_MessageList::Error,14510,"Unknown session type '%s'",1
#define RTEERR_CKC_UNKNOWN_SESSION_TYPE_ID 14510
#define RTEERR_CKC_INVALID_SESSIONID_TYPE              SAPDBErr_MessageList::Error,14511,"Invalid session type '%s', path contains sessionid",1
#define RTEERR_CKC_INVALID_SESSIONID_TYPE_ID 14511
#define RTEERR_CKC_INVALID_SESSION_ID                  SAPDBErr_MessageList::Error,14550,"Invalid session id, %s",1
#define RTEERR_CKC_INVALID_SESSION_ID_ID 14550
#define RTEERR_CKC_UNEXPECTED_QUEUE_ELEM               SAPDBErr_MessageList::Error,14551,"Unexpected queue element: '%s' expected: '%s'",2
#define RTEERR_CKC_UNEXPECTED_QUEUE_ELEM_ID 14551
#define RTEWARN_CKC_CLIENT_DIED                        SAPDBErr_MessageList::Warning,14600,"Client died, PID:%s",1
#define RTEWARN_CKC_CLIENT_DIED_ID 14600
#define RTEWARN_CKC_LOCK_COMMSEG                       SAPDBErr_MessageList::Warning,14620,"Lock communication segment failed",0
#define RTEWARN_CKC_LOCK_COMMSEG_ID 14620
#define RTEINFO_CKC_CLOSE_PENDING                      SAPDBErr_MessageList::Info,14900,"Close of connection is pending",0
#define RTEINFO_CKC_CLOSE_PENDING_ID 14900
#define RTEINFO_CKC_CLIENT_CLOSED_CONNECTION           SAPDBErr_MessageList::Info,14901,"Client has closed connection",0
#define RTEINFO_CKC_CLIENT_CLOSED_CONNECTION_ID 14901
#define RTEINFO_CKC_OPEN_NEW_CONNECTION                SAPDBErr_MessageList::Info,14905,"Open new connection to %s failed [%s]",2
#define RTEINFO_CKC_OPEN_NEW_CONNECTION_ID 14905
#define RTEINFO_CKC_LEASE_CONNECTION_DATA              SAPDBErr_MessageList::Info,14906,"Lease connection data failed",0
#define RTEINFO_CKC_LEASE_CONNECTION_DATA_ID 14906
#define RTEINFO_CKC_SEND_DATA                          SAPDBErr_MessageList::Info,14907,"Send data failed [%s]",1
#define RTEINFO_CKC_SEND_DATA_ID 14907
#define RTEINFO_CKC_RECEIVE_DATA                       SAPDBErr_MessageList::Info,14908,"Receive data failed [%s]",1
#define RTEINFO_CKC_RECEIVE_DATA_ID 14908
#define RTEINFO_CKC_CANCEL_REQUEST                     SAPDBErr_MessageList::Info,14909,"Cancel request failed [%s]",1
#define RTEINFO_CKC_CANCEL_REQUEST_ID 14909
#define RTEINFO_CKC_CONNECTION_CLOSED                  SAPDBErr_MessageList::Info,14910,"Connection closed successfully",0
#define RTEINFO_CKC_CONNECTION_CLOSED_ID 14910
#define RTEINFO_CKC_CONNECTION_IS_NOT_OPENED           SAPDBErr_MessageList::Info,14911,"Connection does not exist",0
#define RTEINFO_CKC_CONNECTION_IS_NOT_OPENED_ID 14911
#define RTEINFO_CKC_CONNECTION_FREED                   SAPDBErr_MessageList::Info,14912,"Connection was already freed",0
#define RTEINFO_CKC_CONNECTION_FREED_ID 14912
#define RTEINFO_CKC_OPTION_NOT_SUPPORTED               SAPDBErr_MessageList::Info,14920,"Option %s is not supported",1
#define RTEINFO_CKC_OPTION_NOT_SUPPORTED_ID 14920
#define RTEINFO_CKC_COMMAND_TIMEOUT                    SAPDBErr_MessageList::Info,14921,"Command timeout occurred",0
#define RTEINFO_CKC_COMMAND_TIMEOUT_ID 14921
#define RTEINFO_CKC_CONNECTION_RELEASED                SAPDBErr_MessageList::Info,14923,"Connection released by remote side",0
#define RTEINFO_CKC_CONNECTION_RELEASED_ID 14923
#define RTEINFO_CKC_UNKNOWN_CLIENT_STATE               SAPDBErr_MessageList::Info,14950,"Client state is unknown, PID:%s",1
#define RTEINFO_CKC_UNKNOWN_CLIENT_STATE_ID 14950
#define RTEINFO_CKC_ALL_TASKS_ARE_BUSY                 SAPDBErr_MessageList::Info,14951,"All '%s' tasks are busy, no free connections found.",1
#define RTEINFO_CKC_ALL_TASKS_ARE_BUSY_ID 14951

#endif /* RTE_CKC_MESSAGES_HPP */
