/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.udeserver;

import com.sap.dbtech.jdbc.ResultSetSapDB;
import com.sap.dbtech.udeserver.Callable;
import com.sap.dbtech.udeserver.CallableFactory;
import com.sap.dbtech.udeserver.JDBCDriverUDE;
import com.sap.dbtech.udeserver.JarClassLoader;
import com.sap.dbtech.udeserver.Log;
import com.sap.dbtech.udeserver.MethodFromString;
import com.sap.dbtech.udeserver.ProcParameterList;
import com.sap.dbtech.udeserver.Stop;
import com.sap.dbtech.udeserver.TypeDirectory;
import com.sap.dbtech.udeserver.UDEServerException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class SQLJCallable
implements Callable {
    Method method;
    String creationTime;
    private static SQLJCallableFactory sharedFactory = new SQLJCallableFactory();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public SQLJCallable(Method method, String string) {
        this.method = method;
        this.creationTime = string;
    }

    boolean isCurrent(String string) {
        return string.equals(this.creationTime);
    }

    public void call(ProcParameterList procParameterList) throws Stop, Throwable {
        int n;
        ParameterMetaData parameterMetaData = procParameterList.getParameterMetaData();
        this.logParameters(procParameterList);
        Class<?>[] classArray = this.method.getParameterTypes();
        int n2 = classArray.length;
        Object[] objectArray = new Object[n2];
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            objectArray[n] = classArray[n] == TypeDirectory.ResultSetArrayClassC ? new ResultSet[1] : this.convertInputParameter(procParameterList, parameterMetaData, classArray[n], ++n3);
        }
        try {
            this.method.invoke(this.method.getClass(), objectArray);
            Log.log("method call finished OK");
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.logErr("method call finished");
            Throwable throwable = invocationTargetException.getTargetException();
            Log.traceException(throwable);
            throw throwable;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.logErr("method call finished");
            this.logCall(this.method, objectArray);
            throw illegalArgumentException;
        }
        catch (Throwable throwable) {
            Log.logErr("method call finished");
            Log.traceException(throwable);
            throw throwable;
        }
        n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (classArray[n] == TypeDirectory.ResultSetArrayClassC) {
                ResultSet[] resultSetArray = (ResultSet[])objectArray[n];
                ResultSetSapDB resultSetSapDB = (ResultSetSapDB)resultSetArray[0];
                procParameterList.addCursorName(resultSetSapDB.getCursorName());
                resultSetSapDB.close(true);
                continue;
            }
            this.convertOutputParameter(procParameterList, parameterMetaData, objectArray[n], classArray[n], ++n3);
        }
    }

    protected void logParameters(ProcParameterList procParameterList) throws Stop, Throwable {
        String[] stringArray = new String[]{"unknown", "in", "in/out", "???", "out"};
        ParameterMetaData parameterMetaData = procParameterList.getParameterMetaData();
        int n = parameterMetaData.getParameterCount();
        for (int i = 1; i <= n; ++i) {
            Log.log("P " + i + ": " + parameterMetaData.getParameterTypeName(i) + " (" + parameterMetaData.getPrecision(i) + ", " + parameterMetaData.getScale(i) + ") " + stringArray[parameterMetaData.getParameterMode(i)]);
            switch (parameterMetaData.getParameterMode(i)) {
                case 1: 
                case 2: {
                    Log.log("   => '" + procParameterList.getString(i) + "'");
                }
            }
        }
    }

    protected void logCall(Method method, Object[] objectArray) {
        Log.log("Calling " + method);
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            try {
                Object object = objectArray[i];
                String string = object == null ? "" : " (" + object.getClass() + ")";
                Log.log("" + i + ": " + objectArray + string + " => " + classArray[i]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    protected Object convertInputParameter(ProcParameterList procParameterList, ParameterMetaData parameterMetaData, Class clazz, int n) throws Throwable {
        Object object = null;
        int n2 = parameterMetaData.getParameterMode(n);
        if (clazz.isArray()) {
            if (n2 == 1) {
                throw new UDEServerException("IN parameters must not be declared as array");
            }
            clazz = clazz.getComponentType();
        } else if (n2 != 1) {
            throw new UDEServerException("OUT or INOUT parameters must be declared as array");
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = SQLJCallable.class$("java.lang.String")) : class$java$lang$String)) {
            object = this.convertInputString(procParameterList, parameterMetaData, n);
        } else if (clazz == Integer.TYPE) {
            object = this.convertInputInt(procParameterList, parameterMetaData, n);
        } else if (clazz == Double.TYPE) {
            object = this.convertInputDouble(procParameterList, parameterMetaData, n);
        } else if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = SQLJCallable.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            object = this.convertInputInteger(procParameterList, parameterMetaData, n);
        } else if (clazz == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLJCallable.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            object = this.convertInputBigDecimal(procParameterList, parameterMetaData, n);
        } else if (clazz == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = SQLJCallable.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            object = this.convertInputBigInteger(procParameterList, parameterMetaData, n);
        } else if (clazz == (class$java$sql$Time == null ? (class$java$sql$Time = SQLJCallable.class$("java.sql.Time")) : class$java$sql$Time)) {
            object = this.convertInputTime(procParameterList, parameterMetaData, n);
        } else if (clazz == (class$java$sql$Date == null ? (class$java$sql$Date = SQLJCallable.class$("java.sql.Date")) : class$java$sql$Date)) {
            object = this.convertInputDate(procParameterList, parameterMetaData, n);
        } else if (clazz == (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = SQLJCallable.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
            object = this.convertInputTimestamp(procParameterList, parameterMetaData, n);
        } else {
            Log.log("unsupported java type: " + clazz);
        }
        return object;
    }

    protected Object convertInputString(ProcParameterList procParameterList, ParameterMetaData parameterMetaData, int n) throws Throwable {
        String[] stringArray = null;
        int n2 = parameterMetaData.getParameterMode(n);
        switch (n2) {
            case 1: {
                stringArray = procParameterList.getString(n);
                break;
            }
            case 2: {
                String[] stringArray2 = new String[]{procParameterList.getString(n)};
                stringArray = stringArray2;
                break;
            }
            case 4: {
                String[] stringArray3;
                stringArray = stringArray3 = new String[1];
            }
        }
        return stringArray;
    }

    protected Object convertInputInt(ProcParameterList procParameterList, ParameterMetaData parameterMetaData, int n) throws Throwable {
        Object object = null;
        int n2 = parameterMetaData.getParameterMode(n);
        switch (n2) {
            case 1: {
                object = new Integer(procParameterList.getInt(n));
                if (!procParameterList.wasNull()) break;
                throw new UDEServerException("parameter of type 'int' cannot handle NULL values");
            }
            case 2: {
                int[] nArray = new int[]{procParameterList.getInt(n)};
                if (procParameterList.wasNull()) {
                    throw new UDEServerException("parameter of type 'int' cannot handle NULL values");
                }
                object = nArray;
                break;
            }
            case 4: {
                int[] nArray;
                object = nArray = new int[1];
            }
        }
        return object;
    }

    protected Object convertInputDouble(ProcParameterList procParameterList, ParameterMetaData parameterMetaData, int n) throws Throwable {
        Object object = null;
        int n2 = parameterMetaData.getParameterMode(n);
        switch (n2) {
            case 1: {
                object = new Double(procParameterList.getDouble(n));
                if (!procParameterList.wasNull()) break;
                throw new UDEServerException("parameter of type 'double' cannot handle NULL values");
            }
            case 2: {
                double[] dArray = new double[]{procParameterList.getDouble(n)};
                if (procParameterList.wasNull()) {
                    throw new UDEServerException("parameter of type 'double' cannot handle NULL values");
                }
                object = dArray;
                break;
            }
            case 4: {
                double[] dArray;
                object = dArray = new double[1];
            }
        }
        return object;
    }

    protected Object convertInputInteger(ProcParameterList procParameterList, ParameterMetaData parameterMetaData, int n) throws Throwable {
        Object object = null;
        int n2 = parameterMetaData.getParameterMode(n);
        switch (n2) {
            case 1: {
                object = new Integer(procParameterList.getInt(n));
                break;
            }
            case 2: {
                Integer[] integerArray = new Integer[]{new Integer(procParameterList.getInt(n))};
                object = integerArray;
                break;
            }
            case 4: {
                Integer[] integerArray;
                object = integerArray = new Integer[1];
            }
        }
        return object;
    }

    protected Object convertInputBigDecimal(ProcParameterList procParameterList, ParameterMetaData parameterMetaData, int n) throws Throwable {
        BigDecimal[] bigDecimalArray = null;
        int n2 = parameterMetaData.getParameterMode(n);
        switch (n2) {
            case 1: {
                bigDecimalArray = procParameterList.getBigDecimal(n);
                break;
            }
            case 2: {
                BigDecimal[] bigDecimalArray2 = new BigDecimal[]{procParameterList.getBigDecimal(n)};
                bigDecimalArray = bigDecimalArray2;
                break;
            }
            case 4: {
                BigDecimal[] bigDecimalArray3;
                bigDecimalArray = bigDecimalArray3 = new BigDecimal[1];
            }
        }
        return bigDecimalArray;
    }

    protected Object convertInputBigInteger(ProcParameterList procParameterList, ParameterMetaData parameterMetaData, int n) throws Throwable {
        BigInteger[] bigIntegerArray = null;
        int n2 = parameterMetaData.getParameterMode(n);
        switch (n2) {
            case 1: {
                bigIntegerArray = procParameterList.getBigDecimal(n).toBigInteger();
                break;
            }
            case 2: {
                BigInteger[] bigIntegerArray2 = new BigInteger[]{procParameterList.getBigDecimal(n).toBigInteger()};
                bigIntegerArray = bigIntegerArray2;
                break;
            }
            case 4: {
                BigInteger[] bigIntegerArray3;
                bigIntegerArray = bigIntegerArray3 = new BigInteger[1];
            }
        }
        return bigIntegerArray;
    }

    protected Object convertInputDate(ProcParameterList procParameterList, ParameterMetaData parameterMetaData, int n) throws Throwable {
        Date[] dateArray = null;
        int n2 = parameterMetaData.getParameterMode(n);
        switch (n2) {
            case 1: {
                dateArray = procParameterList.getDate(n);
                break;
            }
            case 2: {
                Date[] dateArray2 = new Date[]{procParameterList.getDate(n)};
                dateArray = dateArray2;
                break;
            }
            case 4: {
                Date[] dateArray3;
                dateArray = dateArray3 = new Date[1];
            }
        }
        return dateArray;
    }

    protected Object convertInputTime(ProcParameterList procParameterList, ParameterMetaData parameterMetaData, int n) throws Throwable {
        Time[] timeArray = null;
        int n2 = parameterMetaData.getParameterMode(n);
        switch (n2) {
            case 1: {
                timeArray = procParameterList.getTime(n);
                break;
            }
            case 2: {
                Time[] timeArray2 = new Time[]{procParameterList.getTime(n)};
                timeArray = timeArray2;
                break;
            }
            case 4: {
                Time[] timeArray3;
                timeArray = timeArray3 = new Time[1];
            }
        }
        return timeArray;
    }

    protected Object convertInputTimestamp(ProcParameterList procParameterList, ParameterMetaData parameterMetaData, int n) throws Throwable {
        Timestamp[] timestampArray = null;
        int n2 = parameterMetaData.getParameterMode(n);
        switch (n2) {
            case 1: {
                timestampArray = procParameterList.getTimestamp(n);
                break;
            }
            case 2: {
                Timestamp[] timestampArray2 = new Timestamp[]{procParameterList.getTimestamp(n)};
                timestampArray = timestampArray2;
                break;
            }
            case 4: {
                Timestamp[] timestampArray3;
                timestampArray = timestampArray3 = new Timestamp[1];
            }
        }
        return timestampArray;
    }

    protected void convertOutputParameter(ProcParameterList procParameterList, ParameterMetaData parameterMetaData, Object object, Class clazz, int n) throws Throwable {
        int n2 = parameterMetaData.getParameterMode(n);
        if (n2 == 1) {
            return;
        }
        if (clazz == TypeDirectory.StringArrayClassC) {
            String[] stringArray = (String[])object;
            procParameterList.setString(n, stringArray[0]);
        } else if (clazz == TypeDirectory.intArrayClassC) {
            int[] nArray = (int[])object;
            procParameterList.setInt(n, nArray[0]);
        } else if (clazz == TypeDirectory.doubleArrayClassC) {
            double[] dArray = (double[])object;
            procParameterList.setDouble(n, dArray[0]);
        } else if (clazz == TypeDirectory.IntegerArrayClassC) {
            Integer[] integerArray = (Integer[])object;
            procParameterList.setInt(n, integerArray[0]);
        } else if (clazz == TypeDirectory.BigDecimalArrayClassC) {
            BigDecimal[] bigDecimalArray = (BigDecimal[])object;
            procParameterList.setBigDecimal(n, bigDecimalArray[0]);
        } else if (clazz == TypeDirectory.BigIntegerArrayClassC) {
            BigInteger[] bigIntegerArray = (BigInteger[])object;
            procParameterList.setBigDecimal(n, new BigDecimal(bigIntegerArray[0]));
        } else if (clazz == TypeDirectory.DateArrayClassC) {
            Date[] dateArray = (Date[])object;
            procParameterList.setDate(n, dateArray[0]);
        } else if (clazz == TypeDirectory.TimeArrayClassC) {
            Time[] timeArray = (Time[])object;
            procParameterList.setTime(n, timeArray[0]);
        } else if (clazz == TypeDirectory.TimestampArrayClassC) {
            Timestamp[] timestampArray = (Timestamp[])object;
            procParameterList.setTimestamp(n, timestampArray[0]);
        } else {
            throw new UDEServerException("SQL conversion not supported for parameter " + n);
        }
    }

    static SQLJCallableFactory getFactory() {
        return sharedFactory;
    }

    public static void main(String[] stringArray) throws Throwable {
        Class.forName("com.sap.dbtech.jdbc.DriverSapDB");
        Connection connection = DriverManager.getConnection("jdbc:sapdb:DB76", "DANIEL", "DANIEL");
        JDBCDriverUDE.storeDefaultConnection(connection);
        SQLJCallableFactory sQLJCallableFactory = SQLJCallable.getFactory();
        SQLJCallable sQLJCallable = (SQLJCallable)sQLJCallableFactory.create("hello:thiz.is.a.nestedpackage.Hello.hello", null);
        sQLJCallableFactory.createJarLoader("hello");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class SQLJCallableFactory
    implements CallableFactory {
        private Map methodCache = new HashMap();
        private Map loaderCache = new HashMap();

        public Callable create(String string, String string2) throws Throwable {
            Object object;
            String string3 = string;
            SQLJCallable sQLJCallable = (SQLJCallable)this.methodCache.get(string3);
            if (sQLJCallable != null && sQLJCallable.isCurrent(string2)) {
                return sQLJCallable;
            }
            ClassLoader classLoader = null;
            int n = string.indexOf(58);
            if (n > 0) {
                object = string.substring(0, n);
                string = string.substring(n + 1);
                JarClassLoader jarClassLoader = (JarClassLoader)this.loaderCache.get(object);
                if (sQLJCallable != null && jarClassLoader.isCurrent(null)) {
                    classLoader = jarClassLoader;
                } else {
                    classLoader = this.createJarLoader((String)object);
                    this.loaderCache.put(object, classLoader);
                }
            } else {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            object = new MethodFromString(classLoader, string).findMethod();
            sQLJCallable = new SQLJCallable((Method)object, string2);
            this.methodCache.put(string3, sQLJCallable);
            return sQLJCallable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private ClassLoader createJarLoader(String string) throws UDEServerException, SQLException {
            String string2;
            ClassLoader classLoader;
            String string3;
            File file = new File("jars");
            if (!file.exists()) {
                boolean bl = file.mkdir();
                if (!bl) {
                    throw new UDEServerException("Creation of JAR directory failed");
                }
            } else if (!file.isDirectory()) {
                throw new UDEServerException("JAR directory cannot be created");
            }
            try {
                Connection connection = JDBCDriverUDE.getDefaultConnection();
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery("select replace (translate (storetime, '- :.', '____'), '_', ''), jar from sysude.server_jars  WHERE ID = '" + string + "'");
                try {
                    if (!resultSet.next()) {
                        throw new UDEServerException("Jar entry not found: " + string);
                    }
                    String string4 = resultSet.getString(1);
                    string3 = string + "-" + string4;
                    classLoader = (ClassLoader)this.loaderCache.get(string);
                    if (classLoader != null) {
                        ClassLoader classLoader2 = classLoader;
                        return classLoader2;
                    }
                    InputStream inputStream = resultSet.getBinaryStream(2);
                    string2 = "jars/" + string + ".jar";
                    FileOutputStream fileOutputStream = new FileOutputStream(string2);
                    byte[] byArray = new byte[4096];
                    int n = inputStream.read(byArray);
                    while (n > 0) {
                        ((OutputStream)fileOutputStream).write(byArray, 0, n);
                        n = inputStream.read(byArray);
                    }
                }
                finally {
                    resultSet.close();
                }
            }
            catch (IOException iOException) {
                throw new UDEServerException("Failure downloading JAR: " + iOException);
            }
            try {
                classLoader = new JarClassLoader(string2, true);
                this.loaderCache.put(string3, classLoader);
                return classLoader;
            }
            catch (IOException iOException) {
                throw new UDEServerException("Error opening JAR: " + iOException);
            }
        }
    }
}

