
use qadb;
use Getopt::Long;
use strict;

my %Opts;
my $qah;
my $str;
my $fname;

if (!GetOptions( \%Opts,
                'id=i',
                's|string=s',
                'f|file=s',
                'h|help|?',
                'l|linktext=s',
                'n|name=s',
                'fp|force_prot') || $Opts{'h'})
{
    Usage();
}

if (@ARGV)
{
    print "\nUnknown option(s): @ARGV\n";
    Usage();
}

unless ($Opts{'id'})
{
    print "\nMissing mandatory option 'id'!\n";
    Usage();
}

my $qah = qadb->new( {'ID' => "$Opts{'id'}"} );

unless ($qah->{"error_code"} == 0)
{
    print "An QADB error has ocurred while opening connection:\n\n";
    print $qah->{'error_text'} . "\n";

    exit(2);
}

while ($Opts{'s'} || $Opts{'f'})
{
    $str = "";
    $fname = "";

    if ($Opts{'s'})
    {
        $str = $Opts{'s'};
        $Opts{'s'} = undef;
    }
    else
    {
        if(open(F_IN, "< $Opts{'f'}"))
        {
            while (<F_IN>)
            {
                $str .= "$_\n";
            }
        }
        else
        {
            print "ERROR: File $Opts{'f'} could not be opened!\n";
        }
        close (F_IN);
        $fname = $Opts{'f'};
        $Opts{'f'} = undef;
    }

    if ($str ne "")
    {
        if ((length($str) > 1023) or ($Opts{'fp'}))
        {
            # We have to use write_prot()

            $fname = ($Opts{'n'} ? $Opts{'n'} : ($fname ? $fname : die "When entering a string via write_prot() you have to give use\n-n <name> (or -name <name>) to give a file name!"));

            if ($Opts{'l'})
            {
                $qah->write_prot($fname, $str, $Opts{'l'});
            }
            else
            {
                $qah->write_prot($fname, $str);
            }

            if ($qah->{'error_code'} != 0)
            {
                print "QADB->write_prot(): An error has ocurred!\n\n$qah->{'error_string'}\n";
            }
        }
        else
        {
            $qah->write_log($str);

            if ($qah->{'error_code'} != 0)
            {
                print "QADB->write_log(): An error has ocurred!\n\n$qah->{'error_string'}\n";
            }
        }
    }
}

exit (0);

# Usage() - Displays usage and then exits the program.
sub Usage
{
    print <<USAGE_END;

Usage: qadb_putdata -id <QA_ID> [-(s|string) <string>]
                    [-(f|file) <file name>] [-(fp|force_prot)]
                    [-(l|linktext) <text for link>]
                    [-(n|name) <protocol name>]

Where:
        -id <QA_ID>
            ID of an existing QADB entry. (Mandatory)

        -s <string> or -string <string>
            A direct string to be inserted.

        -f <file name> or -file <file name>
            A File to be inserted.

        -fp or -force_prot
            Forces the program to use the write_prot routine which
            creates a link instead of directly inserting the text.
            If this option is NOT given, any string less than 1024
            characters will be inserted via write_log.

        -l <text for link> or -linktext <text for link>
            With this option, you can give a specific text for the
            link when using write_prot.

        -n <protocol name> or -name <protocol name>
            With this option you can save the protocol under a specific
            name on the WebDav server. If not given, the file name
            will be used.

USAGE_END

    exit(1);
}