#!/usr/bin/perl
#
# @(#)ntcpclnk		1997-11-18
#
# G. Gromann, SAP AG
#
# fm sqlpcr und cpclib -> pcrlib und sqlca
# 1996-08-09 JH use sqlcamt instead of sqlca
# 1996-09-04 JH use pcr62mt rather then pcrlib
#
#    ========== licence begin  GPL
#    Copyright (C) 2001 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#

package ntcpclnk;
use Env;
use Carp;
require "Flush.pl";
do "$TOOLVARS";
if ( $@ ) { print "$@"; exit }
ToolTrace("ntcpclnk called with @ARGV\n");

$SOURCE = shift;
$ENV{VMAKE_VERSION} = "fast";

printflush(STDOUT, "Compilation and Linking of $SOURCE ...\n");

system("$TOOL/bin/ntcpc $SOURCE") == 0
	or croak "Error while executing $TOOL\\bin\\ntcpc $SOURCE.cpc\n".
	"message: $!\n";

@ARGV = ( "-c", "$SOURCE.c" );
do "$TOOL/bin/compc$TOOLEXT";
if ( $@ ) { warn "Error while executing compc:\n", "$@"; exit }

if ($RELVER eq "R61"){
	@ARGV = ( "-o", "$SOURCE.exe", "-lib=gdi32", "-lib=cpclib.lib",
	"-lib=sqlpcr.lib", "-lib=ptocnt.lib",
	"-subsystem:console", "$SOURCE.o" );
}
else{
	@ARGV = ( "-o", "$SOURCE.exe", "-lib=gdi32", "-lib=pcr62mt", "-lib=sqlcamt",
	"-subsystem:console", "$SOURCE.o" );
}
do "$TOOL/bin/linklnk$TOOLEXT";
if ( $@ ) { warn "Error while executing linklnk:\n", "$@"; exit }



__ENDE__

