#!/usr/bin/perl
# mfpack        file(s)  (NOT called by vmake !)
#
# @(#)mfpack		1997-11-18
#
# pack files into a module frame
# output are names with the extension removed
#
package mfpack;
use Env;
use File::Basename;
use Carp;

my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);

$YEAR = $year + 1900;
$DATE = "$YEAR-".++$mon."-$mday";
fileparse_set_fstype('MSDOS');

foreach $f (@ARGV) {

    $BASE = basename($f);
	$BASE =~ tr[a-z][A-Z];
    ($BASE) = $BASE =~ /(\.*[^\.]*)/ ;  # alle Endungen werden abgeschnitten
    if ( $BASE eq $f ) {
		print "cannot create '$BASE': same as input file!\n";
		next;
    }
	open(FILE_OUT, "+>$BASE") or croak "Can't open $BASE (output): $!\n";
	open(FILE_IN, "$f") or croak "Can't open $f (input): $!\n";

	$\ = "\n";
	select FILE_OUT;
	print ".ad 8";
	print ".bm 8";
	print ".fm 4";
	print ".bt \$Copyright by SAP AG, $YEAR\$\$Page %\$";
	print ".tm 12";
	print ".hm 6";
	print ".hs 3";
    print ".tt 1 \$SAP AG\$ADABAS FOR R/3\$$BASE\$\n";
	print ".tt 2 \$\$\$";
	print ".tt 3 \$\$\$$DATE\$";
print << '+++';
***********************************************************
.nf
.sp
Module  :
=========
.sp
Purpose :
.CM *-END-* purpose -------------------------------------
.sp
.cp 3
Define  :

.CM *-END-* define --------------------------------------
.sp;.cp 3
Use     :

.CM *-END-* use -----------------------------------------
.sp;.cp 3
Synonym :

.CM *-END-* synonym -------------------------------------
.sp;.cp 3
Author  :
.sp
.cp 3
+++
	print "Created : $DATE";
	print ".sp";
	print ".cp 3";
	print "Version : $DATE";
	print << '+++';
.sp
.cp 3
Release :      Date :
.sp
***********************************************************
.sp
.cp 10
.fo
.oc _/1
Specification:

.CM *-END-* specification -------------------------------
.sp 2
***********************************************************
.sp
.cp 10
.fo
.oc _/1
Description:

.CM *-END-* description ---------------------------------
.sp 2
***********************************************************
.sp
.cp 10
.nf
.oc _/1
Structure:

.CM *-END-* structure -----------------------------------
.sp 2
**********************************************************
.sp
.cp 10
.nf
.oc _/1
.CM -lll-
Code    :
/*PRETTY*/

+++
    print FILE_OUT <FILE_IN>;
    print <<'+++';

.CM *-END-* code ----------------------------------------
.sp 2
***********************************************************
*-PRETTY-*  statements    :           0
*-PRETTY-*  lines of code :           0
*-PRETTY-*  lines in file :           0
.pa
+++

	close(FILE_OUT); close(FILE_IN);
	select STDOUT;
}

__END__

Hier knnen lange Kommentare stehen
