/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util.security;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.VarDataPart;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.Tracer;
import com.sap.dbtech.util.security.SCRAMMD5;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class Authentication {
    private static final String maxpasswordlenC = "maxpasswordlen";
    private byte[] salt;
    private byte[] clientchallenge = new byte[64];
    private byte[] serverchallenge;
    private int maxpasswordLen = 0;

    public Authentication() throws NoSuchAlgorithmException {
        SecureRandom.getInstance("SHA1PRNG").nextBytes(this.getClientchallenge());
    }

    public byte[] getClientchallenge() {
        return this.clientchallenge;
    }

    public byte[] getClientProof(byte[] byArray) throws SQLExceptionSapDB {
        try {
            return SCRAMMD5.scrammMD5(this.salt, byArray, this.clientchallenge, this.serverchallenge);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.connection.wrongserverchallengereceived", "NoSuchAlgorithmException - algorithm \"MD5\" not supported by the java vm"));
        }
    }

    public void parseServerChallenge(VarDataPart varDataPart) throws SQLExceptionSapDB {
        if (!varDataPart.nextRow() || !varDataPart.nextField()) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.connection.wrongserverchallengereceived", Tracer.Hex2String(varDataPart.getBytes(0, varDataPart.size()))));
        }
        String string = varDataPart.getString(varDataPart.getCurrentOffset(), varDataPart.getCurrentFieldLen());
        if (!string.equals("SCRAMMD5")) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.connection.wrongserverchallengereceived", Tracer.Hex2String(varDataPart.getBytes(0, varDataPart.size()))));
        }
        if (!varDataPart.nextField() || varDataPart.getCurrentFieldLen() < 8) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.connection.wrongserverchallengereceived", Tracer.Hex2String(varDataPart.getBytes(0, varDataPart.size()))));
        }
        if (varDataPart.getCurrentFieldLen() == 40) {
            this.salt = varDataPart.getBytes(varDataPart.getCurrentOffset(), 8);
            this.serverchallenge = varDataPart.getBytes(varDataPart.getCurrentOffset() + 8, varDataPart.getCurrentFieldLen() - 8);
        } else {
            VarDataPart varDataPart2 = new VarDataPart((StructuredMem)new StructuredBytes(varDataPart.getBytes(varDataPart.getCurrentOffset(), varDataPart.getCurrentFieldLen())), 1);
            if (!varDataPart2.nextRow() || !varDataPart2.nextField()) {
                throw new SQLExceptionSapDB(MessageTranslator.translate("error.connection.wrongserverchallengereceived", Tracer.Hex2String(varDataPart.getBytes(0, varDataPart.size()))));
            }
            this.salt = varDataPart2.getBytes(varDataPart2.getCurrentOffset(), varDataPart2.getCurrentFieldLen());
            if (!varDataPart2.nextField()) {
                throw new SQLExceptionSapDB(MessageTranslator.translate("error.connection.wrongserverchallengereceived", Tracer.Hex2String(varDataPart.getBytes(0, varDataPart.size()))));
            }
            this.serverchallenge = varDataPart2.getBytes(varDataPart2.getCurrentOffset(), varDataPart2.getCurrentFieldLen());
            if (varDataPart.nextField()) {
                VarDataPart varDataPart3 = new VarDataPart((StructuredMem)new StructuredBytes(varDataPart.getBytes(varDataPart.getCurrentOffset(), varDataPart.getCurrentFieldLen())), 1);
                if (!varDataPart3.nextRow() || !varDataPart3.nextField()) {
                    throw new SQLExceptionSapDB(MessageTranslator.translate("error.connection.wrongserverchallengereceived", Tracer.Hex2String(varDataPart.getBytes(0, varDataPart.size()))));
                }
                do {
                    if (varDataPart3.getString(varDataPart3.getCurrentOffset(), varDataPart3.getCurrentFieldLen()).equals(maxpasswordlenC)) {
                        if (!varDataPart3.nextField()) {
                            throw new SQLExceptionSapDB(MessageTranslator.translate("error.connection.wrongserverchallengereceived", Tracer.Hex2String(varDataPart.getBytes(0, varDataPart.size()))));
                        }
                        try {
                            this.maxpasswordLen = Integer.parseInt(varDataPart3.getString(varDataPart3.getCurrentOffset(), varDataPart3.getCurrentFieldLen()));
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new SQLExceptionSapDB(MessageTranslator.translate("error.connection.wrongserverchallengereceived", Tracer.Hex2String(varDataPart.getBytes(0, varDataPart.size()))));
                        }
                    } else {
                        if (varDataPart3.nextField()) continue;
                        throw new SQLExceptionSapDB(MessageTranslator.translate("error.connection.wrongserverchallengereceived", Tracer.Hex2String(varDataPart.getBytes(0, varDataPart.size()))));
                    }
                } while (varDataPart3.nextField());
            }
        }
    }

    public int getMaxpasswordLen() {
        return this.maxpasswordLen;
    }
}

