/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util;

import com.sap.dbtech.util.StringUtil;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.UnicodeUtil;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class StructuredBytes
implements StructuredMem {
    protected byte[] data;
    protected int ptrOffs;
    protected int byteSize;
    private static final String sapdbEncodingC = "ISO8859_1";
    protected static final byte blank_C = 32;
    public static final char[] hexDigits_C;
    private static final int fillBufSizeC = 1024;
    private static final int unicodeWidthC = 2;
    static byte[] zeroBytes;
    static byte[] blankBytes;
    static byte[] blankUnicodeBytes;

    public StructuredBytes(byte[] data) {
        this.data = data;
        this.ptrOffs = 0;
        this.byteSize = data.length;
    }

    public StructuredBytes(byte[] data, int offset) {
        this.data = data;
        this.ptrOffs = offset;
        this.byteSize = data.length - this.ptrOffs;
    }

    public StructuredBytes(int size) {
        this.data = new byte[size];
        this.ptrOffs = 0;
        this.byteSize = size;
    }

    public byte[] bytes() {
        return this.data;
    }

    public byte[] getBytes(int offset, int len) {
        byte[] result = new byte[len];
        System.arraycopy(this.data, offset + this.ptrOffs, result, 0, len);
        return result;
    }

    public int[] getIntArray(int offset, int len) {
        int[] result = new int[len];
        for (int i = 0; i < len; ++i) {
            result[i] = this.getUInt1(offset + i);
        }
        return result;
    }

    public byte getInt1(int offset) {
        return this.data[offset + this.ptrOffs];
    }

    public int getUInt1(int offset) {
        int result = this.data[offset + this.ptrOffs];
        if (result < 0) {
            result += 256;
        }
        return result;
    }

    public int getInt2(int offset) {
        int lowerByte;
        int ofs;
        block0: {
            ofs = offset + this.ptrOffs;
            lowerByte = this.data[ofs + 1];
            if (lowerByte >= 0) break block0;
            lowerByte += 256;
        }
        return this.data[ofs] * 256 + lowerByte;
    }

    public int getInt4(int offset) {
        byte[] d = this.data;
        int ofs = offset + this.ptrOffs;
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            int oneByte = d[ofs + i];
            if (oneByte < 0) {
                oneByte += 256;
            }
            result = result * 256 + oneByte;
        }
        return result;
    }

    public StructuredMem getPointer(int offset) {
        return new StructuredBytes(this.data, this.ptrOffs + offset);
    }

    public String getString(int offset, int len) {
        try {
            String string = new String(this.data, offset + this.ptrOffs, len, sapdbEncodingC);
            return string;
        }
        catch (UnsupportedEncodingException exc) {
            String string = new String(this.data, offset + this.ptrOffs, len);
            return string;
        }
    }

    public byte[] getStrippedBytes(int offset, int len) {
        while (len > 0 && this.data[offset + this.ptrOffs + len - 1] == 0) {
            --len;
        }
        return this.getBytes(offset, len);
    }

    public String getStrippedString(int offset, int len) {
        String trimmedString = StringUtil.trimLeft(this.getString(offset, len));
        return trimmedString;
    }

    public char getBigUnicodeChar(int offset) {
        int low;
        int realOffset = this.ptrOffs + offset;
        int high = this.data[realOffset];
        if (high < 0) {
            high += 256;
        }
        if ((low = this.data[realOffset + 1]) < 0) {
            low += 256;
        }
        int result = (high << 8) + low;
        return (char)result;
    }

    public char[] getBigUnicode(int offset, int lenInBytes) {
        int realOffset = this.ptrOffs + offset;
        return UnicodeUtil.bigUnicode2Chars(this.data, realOffset, lenInBytes);
    }

    public void moveBase(int offset) {
        this.ptrOffs += offset;
        if (this.size() < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.byteSize -= offset;
    }

    public void putBytes(byte[] value, int offset) {
        System.arraycopy(value, 0, this.data, offset + this.ptrOffs, value.length);
    }

    private void putBytes(byte[] value, int offset, int len, byte[] filler) {
        int copyLen = value.length;
        int fillLen = 0;
        if (copyLen > len) {
            copyLen = len;
        } else if (copyLen < len) {
            fillLen = len - copyLen;
        }
        System.arraycopy(value, 0, this.data, offset + this.ptrOffs, copyLen);
        if (fillLen > 0) {
            this.fill(offset + copyLen, fillLen, filler);
        }
    }

    public void putBytes(byte[] value, int offset, int len) {
        this.putBytes(value, offset, len, zeroBytes);
    }

    public void putStringBytes(byte[] value, int offset, int len) {
        this.putBytes(value, offset, len, blankBytes);
    }

    public void putUnicodeBytes(byte[] value, int offset, int len) {
        this.putBytes(value, offset, len, blankUnicodeBytes);
    }

    public void putBigUnicode(char[] value, int offsetInBytes, int lenInBytes) {
        int copyLen = value.length;
        int lenInChars = lenInBytes / 2;
        int fillLen = 0;
        if (copyLen > lenInChars) {
            copyLen = lenInChars;
        } else if (copyLen < lenInBytes) {
            fillLen = lenInBytes - copyLen * 2;
        }
        int realOffset = this.ptrOffs + offsetInBytes;
        for (int i = 0; i < copyLen; ++i) {
            char current = value[i];
            this.data[i * 2 + realOffset] = (byte)(current / 256);
            this.data[i * 2 + realOffset + 1] = (byte)(current % 256);
        }
        if (fillLen > 0) {
            this.fill(offsetInBytes + copyLen * 2, fillLen, blankUnicodeBytes);
        }
    }

    public void putInt1(int value, int offset) {
        this.data[offset + this.ptrOffs] = (byte)value;
    }

    public void putInt2(int value, int offset) {
        int ofs = offset + this.ptrOffs;
        byte[] d = this.data;
        if (value == 0) {
            d[ofs + 1] = 0;
            d[ofs] = 0;
            return;
        }
        d[ofs] = (byte)(value >> 8 & 0xFF);
        d[ofs + 1] = (byte)(value & 0xFF);
    }

    public void putInt4(int value, int offset) {
        int ofs = offset + this.ptrOffs;
        byte[] d = this.data;
        if (value == 0) {
            d[ofs + 3] = 0;
            d[ofs + 2] = 0;
            d[ofs + 1] = 0;
            d[ofs] = 0;
            return;
        }
        for (int i = 3; i >= 0; --i) {
            d[ofs + i] = (byte)(value & 0xFF);
            value >>= 8;
        }
    }

    public int putString(String value, int offset) {
        int ofs = offset + this.ptrOffs;
        char[] ca = value.toCharArray();
        int strlen = ca.length;
        byte[] d = this.data;
        for (int i = 0; i < strlen; ++i) {
            char c = ca[i];
            d[ofs++] = c <= '\u00ff' ? (int)c : 63;
        }
        return strlen;
    }

    public int putString(String value, int offset, int len) {
        char[] ca = value.toCharArray();
        int strlen = ca.length;
        byte[] d = this.data;
        if (strlen >= len) {
            int ofs = offset + this.ptrOffs;
            for (int i = 0; i < len; ++i) {
                char c = ca[i];
                d[ofs + i] = c <= '\u00ff' ? (int)c : 63;
            }
        } else {
            int ofs = offset + this.ptrOffs;
            for (int i = 0; i < strlen; ++i) {
                char c = ca[i];
                d[ofs + i] = c <= '\u00ff' ? (int)c : 63;
            }
            this.fill(offset + strlen, len - strlen, blankBytes);
        }
        return len;
    }

    public int size() {
        return this.data.length - this.ptrOffs;
    }

    private void fill(int offset, int len, byte[] filler) {
        while (len > 0) {
            int chunkLen = Math.min(len, 1024);
            System.arraycopy(filler, 0, this.data, offset + this.ptrOffs, chunkLen);
            len -= chunkLen;
            offset += chunkLen;
        }
    }

    public void traceOn(PrintStream outstream) {
        this.traceOn(outstream, 0, this.byteSize);
    }

    public void traceOn(PrintStream outstream, int maxBuf) {
        this.traceOn(outstream, 0, maxBuf);
    }

    public void traceOn(PrintStream outstream, int from, int to) {
        outstream.print(StringUtil.hexDump(this.data, from + this.ptrOffs, to + this.ptrOffs));
    }

    static {
        sapdbEncodingC = sapdbEncodingC;
        blank_C = (byte)32;
        hexDigits_C = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        fillBufSizeC = 1024;
        unicodeWidthC = 2;
        zeroBytes = new byte[1024];
        blankBytes = new byte[1024];
        blankUnicodeBytes = new byte[2048];
        for (int i = 0; i < 1024; i += 2) {
            StructuredBytes.zeroBytes[i + 1] = 0;
            StructuredBytes.zeroBytes[i] = 0;
            StructuredBytes.blankBytes[i + 1] = 32;
            StructuredBytes.blankBytes[i] = 32;
            StructuredBytes.blankUnicodeBytes[i] = 0;
            StructuredBytes.blankUnicodeBytes[i + 1] = 32;
        }
    }
}

