/*
 * Decompiled with CFR 0.152.
 */
package org.xml.sax.helpers;

import java.io.IOException;
import java.util.Enumeration;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;
import org.xml.sax.helpers.ParserFactory;

public class ParserAdapter
implements XMLReader,
DocumentHandler {
    private static final String FEATURES = "http://xml.org/sax/features/";
    private static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    private static final String VALIDATION = "http://xml.org/sax/features/validation";
    private static final String EXTERNAL_GENERAL = "http://xml.org/sax/features/external-general-entities";
    private static final String EXTERNAL_PARAMETER = "http://xml.org/sax/features/external-parameter-entities";
    private NamespaceSupport nsSupport;
    private AttributeListAdapter attAdapter;
    private boolean parsing = false;
    private String[] nameParts = new String[3];
    private Parser parser = null;
    private AttributesImpl atts = null;
    private boolean namespaces = true;
    private boolean prefixes = false;
    Locator locator;
    EntityResolver entityResolver = null;
    DTDHandler dtdHandler = null;
    ContentHandler contentHandler = null;
    ErrorHandler errorHandler = null;

    public ParserAdapter() throws SAXException {
        String driver = System.getProperty("org.xml.sax.parser");
        try {
            this.setup(ParserFactory.makeParser());
        }
        catch (ClassNotFoundException e12) {
            throw new SAXException("Cannot find SAX1 driver class " + driver, e12);
        }
        catch (IllegalAccessException e22) {
            throw new SAXException("SAX1 driver class " + driver + " found but cannot be loaded", e22);
        }
        catch (InstantiationException e32) {
            throw new SAXException("SAX1 driver class " + driver + " loaded but cannot be instantiated", e32);
        }
        catch (ClassCastException classCastException) {
            throw new SAXException("SAX1 driver class " + driver + " does not implement org.xml.sax.Parser");
        }
        catch (NullPointerException nullPointerException) {
            throw new SAXException("System property org.xml.sax.parser not specified");
        }
    }

    public ParserAdapter(Parser parser) {
        this.setup(parser);
    }

    public void characters(char[] ch2, int start, int length) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.characters(ch2, start, length);
        }
    }

    private void checkNotParsing(String type, String name) throws SAXNotSupportedException {
        if (this.parsing) {
            throw new SAXNotSupportedException("Cannot change " + type + ' ' + name + " while parsing");
        }
    }

    public void endDocument() throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.endDocument();
        }
    }

    public void endElement(String qName) throws SAXException {
        if (!this.namespaces) {
            if (this.contentHandler != null) {
                this.contentHandler.endElement("", "", qName.intern());
            }
            return;
        }
        String[] names = this.processName(qName, false);
        if (this.contentHandler != null) {
            this.contentHandler.endElement(names[0], names[1], names[2]);
            Enumeration prefixes = this.nsSupport.getDeclaredPrefixes();
            while (prefixes.hasMoreElements()) {
                String prefix = (String)prefixes.nextElement();
                this.contentHandler.endPrefixMapping(prefix);
            }
        }
        this.nsSupport.popContext();
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals(NAMESPACES)) {
            return this.namespaces;
        }
        if (name.equals(NAMESPACE_PREFIXES)) {
            return this.prefixes;
        }
        if (name.equals(VALIDATION) || name.equals(EXTERNAL_GENERAL) || name.equals(EXTERNAL_PARAMETER)) {
            throw new SAXNotSupportedException("Feature: " + name);
        }
        throw new SAXNotRecognizedException("Feature: " + name);
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException("Property: " + name);
    }

    public void ignorableWhitespace(char[] ch2, int start, int length) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.ignorableWhitespace(ch2, start, length);
        }
    }

    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    public void parse(InputSource input) throws IOException, SAXException {
        if (this.parsing) {
            throw new SAXException("Parser is already in use");
        }
        this.setupParser();
        this.parsing = true;
        try {
            this.parser.parse(input);
        }
        finally {
            Object var3_2 = null;
            this.parsing = false;
        }
        this.parsing = false;
    }

    private String[] processName(String qName, boolean isAttribute) throws SAXException {
        String[] parts = this.nsSupport.processName(qName, this.nameParts, isAttribute);
        if (parts == null) {
            parts = new String[3];
            parts[2] = qName.intern();
            this.reportError("Undeclared prefix: " + qName);
        }
        return parts;
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.processingInstruction(target, data);
        }
    }

    void reportError(String message) throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        SAXParseException e10 = this.locator != null ? new SAXParseException(message, this.locator) : new SAXParseException(message, null, null, -1, -1);
        this.errorHandler.error(e10);
    }

    public void setContentHandler(ContentHandler handler) {
        if (handler == null) {
            throw new NullPointerException("Null content handler");
        }
        this.contentHandler = handler;
    }

    public void setDTDHandler(DTDHandler handler) {
        if (handler == null) {
            throw new NullPointerException("Null DTD handler");
        }
        this.dtdHandler = handler;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        if (this.contentHandler != null) {
            this.contentHandler.setDocumentLocator(locator);
        }
    }

    public void setEntityResolver(EntityResolver resolver) {
        if (resolver == null) {
            throw new NullPointerException("Null entity resolver");
        }
        this.entityResolver = resolver;
    }

    public void setErrorHandler(ErrorHandler handler) {
        if (handler == null) {
            throw new NullPointerException("Null error handler");
        }
        this.errorHandler = handler;
    }

    public void setFeature(String name, boolean state) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals(NAMESPACES)) {
            this.checkNotParsing("feature", name);
            this.namespaces = state;
            if (!this.namespaces && !this.prefixes) {
                this.prefixes = true;
            }
        } else if (name.equals(NAMESPACE_PREFIXES)) {
            this.checkNotParsing("feature", name);
            this.prefixes = state;
            if (!this.prefixes && !this.namespaces) {
                this.namespaces = true;
            }
        } else {
            if (name.equals(VALIDATION) || name.equals(EXTERNAL_GENERAL) || name.equals(EXTERNAL_PARAMETER)) {
                throw new SAXNotSupportedException("Feature: " + name);
            }
            throw new SAXNotRecognizedException("Feature: " + name);
        }
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException("Property: " + name);
    }

    private void setup(Parser parser) {
        if (parser == null) {
            throw new NullPointerException("Parser argument must not be null");
        }
        this.parser = parser;
        this.atts = new AttributesImpl();
        this.nsSupport = new NamespaceSupport();
        this.attAdapter = new AttributeListAdapter();
    }

    private void setupParser() {
        this.nsSupport.reset();
        if (this.entityResolver != null) {
            this.parser.setEntityResolver(this.entityResolver);
        }
        if (this.dtdHandler != null) {
            this.parser.setDTDHandler(this.dtdHandler);
        }
        if (this.errorHandler != null) {
            this.parser.setErrorHandler(this.errorHandler);
        }
        this.parser.setDocumentHandler(this);
        this.locator = null;
    }

    public void startDocument() throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.startDocument();
        }
    }

    public void startElement(String qName, AttributeList qAtts) throws SAXException {
        if (!this.namespaces) {
            if (this.contentHandler != null) {
                this.attAdapter.setAttributeList(qAtts);
                this.contentHandler.startElement("", "", qName.intern(), this.attAdapter);
            }
            return;
        }
        this.nsSupport.pushContext();
        boolean seenDecl = false;
        this.atts.clear();
        int length = qAtts.getLength();
        int i2 = 0;
        while (i2 < length) {
            String attQName = qAtts.getName(i2);
            String type = qAtts.getType(i2);
            String value = qAtts.getValue(i2);
            if (attQName.startsWith("xmlns")) {
                int n2 = attQName.indexOf(58);
                String prefix = n2 == -1 ? "" : attQName.substring(n2 + 1);
                if (!this.nsSupport.declarePrefix(prefix, value)) {
                    this.reportError("Illegal Namespace prefix: " + prefix);
                }
                if (this.contentHandler != null) {
                    this.contentHandler.startPrefixMapping(prefix, value);
                }
                if (this.prefixes) {
                    this.atts.addAttribute("", "", attQName.intern(), type, value);
                }
                seenDecl = true;
            } else {
                String[] attName = this.processName(attQName, true);
                this.atts.addAttribute(attName[0], attName[1], attName[2], type, value);
            }
            ++i2;
        }
        if (seenDecl) {
            length = this.atts.getLength();
            int i3 = 0;
            while (i3 < length) {
                String attQName = this.atts.getQName(i3);
                if (!attQName.startsWith("xmlns")) {
                    String[] attName = this.processName(attQName, true);
                    this.atts.setURI(i3, attName[0]);
                    this.atts.setLocalName(i3, attName[1]);
                }
                ++i3;
            }
        }
        if (this.contentHandler != null) {
            String[] name = this.processName(qName, false);
            this.contentHandler.startElement(name[0], name[1], name[2], this.atts);
        }
    }

    final class AttributeListAdapter
    implements Attributes {
        private AttributeList qAtts;

        AttributeListAdapter() {
        }

        public int getIndex(String qName) {
            int max = ParserAdapter.this.atts.getLength();
            int i2 = 0;
            while (i2 < max) {
                if (this.qAtts.getName(i2).equals(qName)) {
                    return i2;
                }
                ++i2;
            }
            return -1;
        }

        public int getIndex(String uri, String localName) {
            return -1;
        }

        public int getLength() {
            return this.qAtts.getLength();
        }

        public String getLocalName(int i2) {
            return "";
        }

        public String getQName(int i2) {
            return this.qAtts.getName(i2).intern();
        }

        public String getType(int i2) {
            return this.qAtts.getType(i2).intern();
        }

        public String getType(String qName) {
            return this.qAtts.getType(qName).intern();
        }

        public String getType(String uri, String localName) {
            return null;
        }

        public String getURI(int i2) {
            return "";
        }

        public String getValue(int i2) {
            return this.qAtts.getValue(i2);
        }

        public String getValue(String qName) {
            return this.qAtts.getValue(qName);
        }

        public String getValue(String uri, String localName) {
            return null;
        }

        void setAttributeList(AttributeList qAtts) {
            this.qAtts = qAtts;
        }
    }
}

