/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import java.io.Serializable;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xpath.Expression;
import org.apache.xpath.NodeSet;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathException;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XRTreeFrag;
import org.apache.xpath.objects.XString;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.NodeIterator;

public class XObject
extends Expression
implements Serializable {
    protected Object m_obj;
    public static final int CLASS_NULL = -1;
    public static final int CLASS_UNKNOWN = 0;
    public static final int CLASS_BOOLEAN = 1;
    public static final int CLASS_NUMBER = 2;
    public static final int CLASS_STRING = 3;
    public static final int CLASS_NODESET = 4;
    public static final int CLASS_RTREEFRAG = 5;
    public static final int CLASS_UNRESOLVEDVARIABLE = 600;

    public XObject() {
    }

    public XObject(Object obj) {
        this.m_obj = obj;
    }

    public boolean bool() throws TransformerException {
        this.error(18, new Object[]{this.getTypeString()});
        return false;
    }

    public Object castToType(int t2, XPathContext support) throws TransformerException {
        Object result;
        switch (t2) {
            case 3: {
                result = this.str();
                break;
            }
            case 2: {
                result = new Double(this.num());
                break;
            }
            case 4: {
                result = this.nodeset();
                break;
            }
            case 1: {
                result = new Boolean(this.bool());
                break;
            }
            case 0: {
                result = this.m_obj;
                break;
            }
            case 5: {
                result = this.rtree(support);
                break;
            }
            default: {
                this.error(21, new Object[]{this.getTypeString(), Integer.toString(t2)});
                result = null;
            }
        }
        return result;
    }

    public static XObject create(Object val) {
        XObject result = val instanceof XObject ? (XObject)val : (val instanceof String ? new XString((String)val) : (val instanceof Boolean ? ((Boolean)val != false ? XBoolean.S_TRUE : XBoolean.S_FALSE) : (val instanceof Double ? new XNumber((Double)val) : (val instanceof DocumentFragment ? new XRTreeFrag((DocumentFragment)val) : (val instanceof Node ? new XNodeSet((Node)val) : (val instanceof NodeIterator ? new XNodeSet((NodeIterator)val) : new XObject(val)))))));
        return result;
    }

    public boolean equals(XObject obj2) throws TransformerException {
        if (obj2.getType() == 4) {
            return obj2.equals(this);
        }
        return this.m_obj.equals(obj2.m_obj);
    }

    protected void error(int msg) throws TransformerException {
        this.error(msg, null);
    }

    protected void error(int msg, Object[] args) throws TransformerException {
        String fmsg = XSLMessages.createXPATHMessage(msg, args);
        throw new XPathException(fmsg);
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        return this;
    }

    public int getType() {
        return 0;
    }

    public String getTypeString() {
        return "#UNKNOWN (" + this.object().getClass().getName() + ")";
    }

    public boolean greaterThan(XObject obj2) throws TransformerException {
        if (obj2.getType() == 4) {
            return obj2.lessThan(this);
        }
        return this.num() > obj2.num();
    }

    public boolean greaterThanOrEqual(XObject obj2) throws TransformerException {
        if (obj2.getType() == 4) {
            return obj2.lessThanOrEqual(this);
        }
        return this.num() >= obj2.num();
    }

    public boolean lessThan(XObject obj2) throws TransformerException {
        if (obj2.getType() == 4) {
            return obj2.greaterThan(this);
        }
        return this.num() < obj2.num();
    }

    public boolean lessThanOrEqual(XObject obj2) throws TransformerException {
        if (obj2.getType() == 4) {
            return obj2.greaterThanOrEqual(this);
        }
        return this.num() <= obj2.num();
    }

    public NodeSet mutableNodeset() throws TransformerException {
        this.error(20, new Object[]{this.getTypeString()});
        return (NodeSet)this.m_obj;
    }

    public NodeIterator nodeset() throws TransformerException {
        this.error(19, new Object[]{this.getTypeString()});
        return null;
    }

    public boolean notEquals(XObject obj2) throws TransformerException {
        if (obj2.getType() == 4) {
            return obj2.notEquals(this);
        }
        return this.equals(obj2) ^ true;
    }

    public double num() throws TransformerException {
        this.error(18, new Object[]{this.getTypeString()});
        return 0.0;
    }

    public Object object() {
        return this.m_obj;
    }

    public DocumentFragment rtree() {
        return null;
    }

    public DocumentFragment rtree(XPathContext support) {
        DocumentFragment result = this.rtree();
        if (result == null) {
            result = support.getDOMHelper().getDOMFactory().createDocumentFragment();
            Text textNode = support.getDOMHelper().getDOMFactory().createTextNode(this.str());
            result.appendChild(textNode);
        }
        return result;
    }

    public String str() {
        return this.m_obj.toString();
    }

    public String toString() {
        return this.str();
    }
}

