/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import javax.xml.transform.TransformerException;
import org.apache.xpath.objects.XObject;

public class XNumber
extends XObject {
    double m_val;

    public XNumber(double d10) {
        this.m_val = d10;
    }

    public boolean bool() {
        return !Double.isNaN(this.m_val) && this.m_val != 0.0;
    }

    public boolean equals(XObject obj2) throws TransformerException {
        if (obj2.getType() == 4) {
            return obj2.equals(this);
        }
        return this.m_val == obj2.num();
    }

    public int getType() {
        return 2;
    }

    public String getTypeString() {
        return "#NUMBER";
    }

    public double num() {
        return this.m_val;
    }

    public Object object() {
        return new Double(this.m_val);
    }

    public String str() {
        String sign;
        int len;
        if (Double.isNaN(this.m_val)) {
            return "NaN";
        }
        if (Double.isInfinite(this.m_val)) {
            if (this.m_val > 0.0) {
                return "Infinity";
            }
            return "-Infinity";
        }
        double num = this.m_val;
        String s2 = Double.toString(num);
        if (s2.charAt((len = s2.length()) - 2) == '.' && s2.charAt(len - 1) == '0') {
            if ((s2 = s2.substring(0, len - 2)).equals("-0")) {
                return "0";
            }
            return s2;
        }
        int e10 = s2.indexOf(69);
        if (e10 < 0) {
            return s2;
        }
        int exp = Integer.parseInt(s2.substring(e10 + 1));
        if (s2.charAt(0) == '-') {
            sign = "-";
            s2 = s2.substring(1);
            --e10;
        } else {
            sign = "";
        }
        int nDigits = e10 - 2;
        if (exp >= nDigits) {
            return String.valueOf(sign) + s2.substring(0, 1) + s2.substring(2, e10) + XNumber.zeros(exp - nDigits);
        }
        if (exp > 0) {
            return String.valueOf(sign) + s2.substring(0, 1) + s2.substring(2, 2 + exp) + "." + s2.substring(2 + exp, e10);
        }
        return String.valueOf(sign) + "0." + XNumber.zeros(-1 - exp) + s2.substring(0, 1) + s2.substring(2, e10);
    }

    private static String zeros(int n2) {
        char[] buf = new char[n2];
        int i2 = 0;
        while (i2 < n2) {
            buf[i2] = 48;
            ++i2;
        }
        return new String(buf);
    }
}

