/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.functions;

import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.StringVector;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.NodeSet;
import org.apache.xpath.XPathContext;
import org.apache.xpath.functions.FunctionOneArg;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class FuncId
extends FunctionOneArg {
    public XObject execute(XPathContext xctxt) throws TransformerException {
        Document docContext;
        Node context = xctxt.getCurrentNode();
        Document document = docContext = context.getNodeType() == 9 ? (Document)context : context.getOwnerDocument();
        if (docContext == null) {
            this.error(xctxt, 4, null);
        }
        XObject arg = this.m_arg0.execute(xctxt);
        int argType = arg.getType();
        XNodeSet nodes = new XNodeSet();
        NodeSet nodeSet = nodes.mutableNodeset();
        if (argType == 4) {
            NodeIterator ni = arg.nodeset();
            StringVector usedrefs = null;
            Node pos = ni.nextNode();
            while (pos != null) {
                String refval = DOMHelper.getNodeData(pos);
                pos = ni.nextNode();
                usedrefs = this.getNodesByID(xctxt, docContext, refval, usedrefs, nodeSet, pos != null);
            }
        } else {
            if (argType == -1) {
                return nodes;
            }
            String refval = arg.str();
            this.getNodesByID(xctxt, docContext, refval, null, nodeSet, false);
        }
        return nodes;
    }

    private StringVector getNodesByID(XPathContext xctxt, Document docContext, String refval, StringVector usedrefs, NodeSet nodeSet, boolean mayBeMore) {
        if (refval != null) {
            String ref = null;
            DOMHelper dh2 = xctxt.getDOMHelper();
            StringTokenizer tokenizer = new StringTokenizer(refval);
            boolean hasMore = tokenizer.hasMoreTokens();
            while (hasMore) {
                ref = tokenizer.nextToken();
                hasMore = tokenizer.hasMoreTokens();
                if (usedrefs != null && usedrefs.contains(ref)) {
                    ref = null;
                    continue;
                }
                Element node = dh2.getElementByID(ref, docContext);
                if (node != null) {
                    nodeSet.addNodeInDocOrder(node, xctxt);
                }
                if (ref == null || !hasMore && !mayBeMore) continue;
                if (usedrefs == null) {
                    usedrefs = new StringVector();
                }
                usedrefs.addElement(ref);
            }
        }
        return usedrefs;
    }
}

