/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.io.Serializable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.NodeSet;
import org.apache.xpath.VariableStack;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.ContextNodeList;
import org.apache.xpath.axes.PredicatedNodeTest;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class LocPathIterator
extends PredicatedNodeTest
implements Cloneable,
NodeIterator,
ContextNodeList,
NodeList,
Serializable {
    transient int m_waitingBottom = 0;
    transient int m_varStackPos = -1;
    transient int m_varStackContext;
    private boolean m_isTopLevel = false;
    private transient int m_last = 0;
    public transient Node m_lastFetched;
    transient NodeSet m_cachedNodes;
    protected AxesWalker m_lastUsedWalker;
    protected AxesWalker m_firstWalker;
    protected transient boolean m_foundLast = false;
    protected transient DOMHelper m_dhelper;
    protected transient Node m_context;
    protected transient Node m_currentContextNode;
    protected PrefixResolver m_prefixResolver;
    protected transient XPathContext m_execContext;
    protected transient int m_next = 0;
    private transient Vector m_waiting = null;
    protected int m_analysis = 0;

    public LocPathIterator(PrefixResolver nscontext) {
        this.setLocPathIterator(this);
        this.m_prefixResolver = nscontext;
    }

    public LocPathIterator(Compiler compiler, int opPos, int analysis) throws TransformerException {
        this(compiler, opPos, analysis, true);
    }

    public LocPathIterator(Compiler compiler, int opPos, int analysis, boolean shouldLoadWalkers) throws TransformerException {
        this.m_analysis = analysis;
        this.setLocPathIterator(this);
        int firstStepPos = OpMap.getFirstChildPos(opPos);
        if (shouldLoadWalkers) {
            this.m_lastUsedWalker = this.m_firstWalker = WalkerFactory.loadWalkers(this, compiler, firstStepPos, 0);
        }
    }

    public final void addToWaitList(AxesWalker walker) {
        if (this.m_waiting == null) {
            this.m_waiting = new Vector();
        }
        this.m_waiting.addElement(walker);
    }

    public boolean canTraverseOutsideSubtree() {
        if ((this.m_analysis & 0xDF86000) != 0) {
            return true;
        }
        if (this.m_firstWalker != null && this.m_firstWalker.canTraverseOutsideSubtree()) {
            return true;
        }
        return super.canTraverseOutsideSubtree();
    }

    public Object clone() throws CloneNotSupportedException {
        LocPathIterator clone = (LocPathIterator)super.clone();
        if (this.m_firstWalker != null) {
            Vector clones = this.m_waiting != null ? new Vector() : null;
            clone.m_firstWalker = this.m_firstWalker.cloneDeep(clone, clones);
            if (this.m_waiting != null) {
                clone.m_waiting = (Vector)this.m_waiting.clone();
                int n2 = this.m_waiting.size();
                int i2 = 0;
                while (i2 < n2) {
                    AxesWalker waiting = (AxesWalker)this.m_waiting.elementAt(i2);
                    clone.m_waiting.setElementAt(waiting.cloneDeep(clone, clones), i2);
                    ++i2;
                }
            }
        }
        return clone;
    }

    public NodeIterator cloneWithReset() throws CloneNotSupportedException {
        LocPathIterator clone = (LocPathIterator)this.clone();
        clone.reset();
        return clone;
    }

    public void detach() {
        this.m_context = null;
        this.m_execContext = null;
        this.m_prefixResolver = null;
        this.m_dhelper = null;
        this.m_varStackPos = -1;
        this.m_varStackContext = 0;
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        try {
            LocPathIterator clone = (LocPathIterator)this.clone();
            clone.initContext(xctxt);
            return new XNodeSet(clone);
        }
        catch (CloneNotSupportedException ncse) {
            throw new TransformerException(ncse);
        }
    }

    int getAnalysis() {
        return this.m_analysis;
    }

    public NodeSet getCachedNodes() {
        return this.m_cachedNodes;
    }

    public final Node getContext() {
        return this.m_context;
    }

    public final Node getCurrentContextNode() {
        return this.m_currentContextNode;
    }

    public Node getCurrentNode() {
        return this.m_lastFetched;
    }

    public final int getCurrentPos() {
        return this.m_next;
    }

    public final DOMHelper getDOMHelper() {
        return this.m_dhelper;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public NodeFilter getFilter() {
        return null;
    }

    public final AxesWalker getFirstWalker() {
        return this.m_firstWalker;
    }

    public final boolean getFoundLast() {
        return this.m_foundLast;
    }

    public boolean getIsTopLevel() {
        return this.m_isTopLevel;
    }

    public int getLast() {
        return this.m_last;
    }

    public int getLastPos(XPathContext xctxt) {
        Node next;
        LocPathIterator clone;
        int pos = this.getProximityPosition();
        try {
            clone = (LocPathIterator)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return -1;
        }
        clone.setPredicateCount(clone.getPredicateCount() - 1);
        while ((next = clone.nextNode()) != null) {
            ++pos;
        }
        return pos;
    }

    public final AxesWalker getLastUsedWalker() {
        return this.m_lastUsedWalker;
    }

    public int getLength() {
        this.resetToCachedList();
        return this.m_cachedNodes.getLength();
    }

    public final PrefixResolver getPrefixResolver() {
        return this.m_prefixResolver;
    }

    public Node getRoot() {
        return this.m_context;
    }

    AxesWalker getWaiting(int i2) {
        return (AxesWalker)this.m_waiting.elementAt(i2);
    }

    int getWaitingCount() {
        if (this.m_waiting == null) {
            return 0;
        }
        return this.m_waiting.size() - this.m_waitingBottom;
    }

    public int getWhatToShow() {
        return -17;
    }

    public final XPathContext getXPathContext() {
        return this.m_execContext;
    }

    void incrementNextPosition() {
        ++this.m_next;
    }

    public void initContext(XPathContext execContext) {
        this.m_context = execContext.getCurrentNode();
        this.m_currentContextNode = execContext.getCurrentExpressionNode();
        this.m_execContext = execContext;
        this.m_prefixResolver = execContext.getNamespaceContext();
        this.m_dhelper = execContext.getDOMHelper();
        if (this.m_isTopLevel) {
            VariableStack vars = execContext.getVarStack();
            this.m_varStackPos = vars.getSearchStartOrTop();
            this.m_varStackContext = vars.getContextPos();
        }
    }

    public boolean isFresh() {
        return this.m_next == 0;
    }

    public Node item(int index) {
        this.resetToCachedList();
        return this.m_cachedNodes.item(index);
    }

    public Node nextNode() throws DOMException {
        if (this.m_cachedNodes != null && this.m_cachedNodes.getCurrentPos() < this.m_cachedNodes.size()) {
            Node next = this.m_cachedNodes.nextNode();
            this.setCurrentPos(this.m_cachedNodes.getCurrentPos());
            return next;
        }
        if (this.m_varStackPos == -1) {
            if (this.m_firstWalker.getRoot() == null) {
                this.setNextPosition(0);
                this.m_firstWalker.setRoot(this.m_context);
                this.m_lastUsedWalker = this.m_firstWalker;
            }
            return this.returnNextNode(this.m_firstWalker.nextNode());
        }
        VariableStack vars = this.m_execContext.getVarStack();
        int savedStart = vars.getSearchStart();
        vars.setSearchStart(this.m_varStackPos);
        vars.pushContextPosition(this.m_varStackContext);
        if (this.m_firstWalker.getRoot() == null) {
            this.setNextPosition(0);
            this.m_firstWalker.setRoot(this.m_context);
            this.m_lastUsedWalker = this.m_firstWalker;
        }
        Node n2 = this.returnNextNode(this.m_firstWalker.nextNode());
        vars.setSearchStart(savedStart);
        vars.popContextPosition();
        return n2;
    }

    public Node previousNode() throws DOMException {
        if (this.m_cachedNodes == null) {
            throw new RuntimeException("This NodeSet can not iterate to a previous node!");
        }
        return this.m_cachedNodes.previousNode();
    }

    public final void removeFromWaitList(AxesWalker walker) {
        if (this.m_waiting != null) {
            this.m_waiting.removeElement(walker);
        }
    }

    public void reset() {
        this.m_foundLast = false;
        this.m_lastFetched = null;
        this.m_next = 0;
        this.m_last = 0;
        this.m_waitingBottom = 0;
        if (this.m_firstWalker != null) {
            this.m_lastUsedWalker = this.m_firstWalker;
            this.m_firstWalker.setRoot(this.m_context);
            if (this.m_waiting != null) {
                this.m_waiting.removeAllElements();
            }
        }
    }

    private void resetToCachedList() {
        int pos = this.getCurrentPos();
        if (this.m_cachedNodes == null || pos != 0) {
            this.setShouldCacheNodes(true);
        }
        this.runTo(-1);
        this.setCurrentPos(pos);
    }

    protected Node returnNextNode(Node nextNode) {
        if (nextNode != null) {
            if (this.m_cachedNodes != null) {
                this.m_cachedNodes.addElement(nextNode);
            }
            this.incrementNextPosition();
        }
        this.m_lastFetched = nextNode;
        if (nextNode == null) {
            this.m_foundLast = true;
        }
        return nextNode;
    }

    /*
     * Unable to fully structure code
     */
    public void runTo(int index) {
        block3: {
            if (this.m_foundLast || index >= 0 && index <= this.getCurrentPos()) {
                return;
            }
            if (index != -1) ** GOTO lbl-1000
            while ((n = this.nextNode()) != null) {
            }
            break block3;
            while (this.getCurrentPos() < index) lbl-1000:
            // 2 sources

            {
                if ((n = this.nextNode()) != null) continue;
            }
        }
    }

    void setAnalysis(int a) {
        this.m_analysis = a;
    }

    public final void setCurrentContextNode(Node n2) {
        this.m_currentContextNode = n2;
    }

    public void setCurrentPos(int i2) {
        if (this.m_cachedNodes == null) {
            throw new RuntimeException("This NodeSet can not do indexing or counting functions!");
        }
        this.setNextPosition(i2);
        this.m_cachedNodes.setCurrentPos(i2);
    }

    public void setIsTopLevel(boolean b10) {
        this.m_isTopLevel = b10;
    }

    public void setLast(int last) {
        this.m_last = last;
    }

    public final void setLastUsedWalker(AxesWalker walker) {
        this.m_lastUsedWalker = walker;
    }

    protected void setNextPosition(int next) {
        this.m_next = next;
    }

    public void setShouldCacheNodes(boolean b10) {
        this.m_cachedNodes = b10 ? new NodeSet() : null;
    }

    public int size() {
        if (this.m_cachedNodes == null) {
            return 0;
        }
        return this.m_cachedNodes.size();
    }
}

