/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.VariableStack;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.ContextNodeList;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTestFilter;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class FilterExprWalker
extends AxesWalker {
    private Expression m_expr;
    private transient NodeIterator m_nodeSet;
    private transient Node m_peek = null;

    public FilterExprWalker(LocPathIterator locPathIterator) {
        super(locPathIterator);
    }

    public short acceptNode(Node n2) {
        try {
            if (this.getPredicateCount() > 0) {
                this.countProximityPosition(0);
                if (!this.executePredicates(n2, this.m_lpi.getXPathContext())) {
                    return 3;
                }
            }
            return 1;
        }
        catch (TransformerException se) {
            throw new RuntimeException(se.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        FilterExprWalker clone = (FilterExprWalker)super.clone();
        if (this.m_nodeSet != null) {
            clone.m_nodeSet = (NodeIterator)((ContextNodeList)((Object)this.m_nodeSet)).clone();
        }
        return clone;
    }

    protected int getLevelMax() {
        return 1;
    }

    public Node getNextNode() {
        Node next;
        if (this.m_peek != null) {
            next = this.m_peek;
            this.m_peek = null;
        } else if (this.m_nodeSet != null) {
            Node current = this.getCurrentNode();
            if (current instanceof NodeTestFilter) {
                ((NodeTestFilter)((Object)current)).setNodeTest(this);
            }
            next = this.m_nodeSet.nextNode();
        } else {
            next = null;
        }
        this.m_nextLevelAmount = next == null ? 0 : (next.hasChildNodes() ? 1 : 0);
        return this.setCurrentIfNotNull(next);
    }

    public void init(Compiler compiler, int opPos, int stepType) throws TransformerException {
        super.init(compiler, opPos, stepType);
        switch (stepType) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.m_expr = compiler.compile(opPos);
                break;
            }
            default: {
                this.m_expr = compiler.compile(opPos + 2);
            }
        }
    }

    public void setRoot(Node root) {
        XPathContext xctxt = this.m_lpi.getXPathContext();
        PrefixResolver savedResolver = xctxt.getNamespaceContext();
        try {
            try {
                XObject obj;
                xctxt.pushCurrentNode(root);
                xctxt.setNamespaceContext(this.m_lpi.getPrefixResolver());
                if (this.m_lpi.getIsTopLevel()) {
                    VariableStack vars = this.m_lpi.m_execContext.getVarStack();
                    int savedStart = vars.getSearchStart();
                    vars.setSearchStart(this.m_lpi.m_varStackPos);
                    vars.pushContextPosition(this.m_lpi.m_varStackContext);
                    obj = this.m_expr.execute(this.m_lpi.getXPathContext());
                    vars.setSearchStart(savedStart);
                    vars.popContextPosition();
                } else {
                    obj = this.m_expr.execute(this.m_lpi.getXPathContext());
                }
                this.m_nodeSet = obj != null ? obj.nodeset() : null;
                this.m_peek = null;
            }
            catch (TransformerException se) {
                throw new WrappedRuntimeException(se);
            }
            Object var5_8 = null;
            xctxt.popCurrentNode();
            xctxt.setNamespaceContext(savedResolver);
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            xctxt.popCurrentNode();
            xctxt.setNamespaceContext(savedResolver);
            throw throwable;
        }
        super.setRoot(root);
    }
}

