/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import org.apache.xml.utils.XMLCharacterRecognizer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FastStringBuffer {
    int m_chunkBits = 15;
    int m_chunkSize;
    int m_chunkMask;
    int m_chunkAllocationUnit = 1024;
    char[][] m_array = new char[16][];
    int m_lastChunk = 0;
    int m_firstFree = 0;
    int m_lastChunkSize;

    public FastStringBuffer() {
        this(10, 15);
    }

    public FastStringBuffer(int initialAllocationUnit) {
        this(initialAllocationUnit, 15);
    }

    public FastStringBuffer(int initialChunkBits, int chunkBits) {
        if (initialChunkBits > chunkBits) {
            initialChunkBits = chunkBits;
        }
        this.m_chunkBits = chunkBits;
        this.m_chunkSize = 1 << chunkBits;
        this.m_chunkMask = this.m_chunkSize - 1;
        this.m_lastChunkSize = this.m_chunkAllocationUnit = 1 << initialChunkBits;
        this.m_array[0] = new char[this.m_lastChunkSize];
    }

    public final void append(char value) {
        char[] chunk;
        boolean lastchunk;
        boolean bl2 = lastchunk = this.m_lastChunk + 1 == this.m_array.length;
        if (this.m_firstFree < this.m_lastChunkSize) {
            chunk = this.m_array[this.m_lastChunk];
        } else if (this.m_lastChunkSize < this.m_chunkSize) {
            int newsize = this.m_lastChunkSize + this.m_chunkAllocationUnit;
            chunk = new char[newsize];
            System.arraycopy(this.m_array[this.m_lastChunk], 0, chunk, 0, this.m_firstFree);
            this.m_array[this.m_lastChunk] = chunk;
            this.m_lastChunkSize = newsize;
        } else {
            int i2 = this.m_array.length;
            if (this.m_lastChunk + 1 == i2) {
                char[][] newarray = new char[i2 + 16][];
                System.arraycopy(this.m_array, 0, newarray, 0, i2);
                this.m_array = newarray;
            }
            if ((chunk = this.m_array[++this.m_lastChunk]) == null) {
                if (this.m_chunkAllocationUnit < this.m_chunkSize) {
                    this.m_chunkAllocationUnit <<= 1;
                }
                this.m_lastChunkSize = this.m_chunkAllocationUnit;
                this.m_array[this.m_lastChunk] = new char[this.m_lastChunkSize];
                chunk = this.m_array[this.m_lastChunk];
            } else {
                this.m_lastChunkSize = chunk.length;
            }
            this.m_firstFree = 0;
        }
        chunk[this.m_firstFree++] = value;
    }

    public final void append(String value) {
        int strlen = value.length();
        if (strlen == 0) {
            return;
        }
        int copyfrom = 0;
        char[] chunk = this.m_array[this.m_lastChunk];
        int available = this.m_lastChunkSize - this.m_firstFree;
        while (strlen > 0) {
            int newsize = this.m_firstFree + strlen + this.m_chunkAllocationUnit - 1 & ~(this.m_chunkAllocationUnit - 1);
            if (newsize > this.m_chunkSize) {
                newsize = this.m_chunkSize;
            }
            if (newsize != this.m_lastChunkSize) {
                char[] newchunk = new char[newsize];
                if (chunk != null) {
                    System.arraycopy(chunk, 0, newchunk, 0, this.m_firstFree);
                }
                this.m_array[this.m_lastChunk] = newchunk;
                chunk = newchunk;
                this.m_lastChunkSize = newsize;
                available = newsize - this.m_firstFree;
            }
            if (available > strlen) {
                available = strlen;
            }
            value.getChars(copyfrom, available, this.m_array[this.m_lastChunk], this.m_firstFree);
            copyfrom += available;
            if ((strlen -= available) <= 0) continue;
            int i2 = this.m_array.length;
            if (this.m_lastChunk + 1 == i2) {
                char[][] newarray = new char[i2 + 16][];
                System.arraycopy(this.m_array, 0, newarray, 0, i2);
                this.m_array = newarray;
            }
            if ((chunk = this.m_array[++this.m_lastChunk]) == null) {
                if (this.m_chunkAllocationUnit < this.m_chunkSize) {
                    this.m_chunkAllocationUnit <<= 1;
                }
                available = this.m_lastChunkSize = this.m_chunkAllocationUnit;
                this.m_array[this.m_lastChunk] = new char[this.m_lastChunkSize];
                chunk = this.m_array[this.m_lastChunk];
            } else {
                available = this.m_lastChunkSize = chunk.length;
            }
            this.m_firstFree = 0;
        }
        this.m_firstFree += available;
    }

    public final void append(StringBuffer value) {
        int strlen = value.length();
        if (strlen == 0) {
            return;
        }
        int copyfrom = 0;
        char[] chunk = this.m_array[this.m_lastChunk];
        int available = this.m_lastChunkSize - this.m_firstFree;
        while (strlen > 0) {
            int newsize = this.m_firstFree + strlen + this.m_chunkAllocationUnit - 1 & ~(this.m_chunkAllocationUnit - 1);
            if (newsize > this.m_chunkSize) {
                newsize = this.m_chunkSize;
            }
            if (newsize != this.m_lastChunkSize) {
                char[] newchunk = new char[newsize];
                if (chunk != null) {
                    System.arraycopy(chunk, 0, newchunk, 0, this.m_firstFree);
                }
                this.m_array[this.m_lastChunk] = newchunk;
                chunk = newchunk;
                this.m_lastChunkSize = newsize;
                available = newsize - this.m_firstFree;
            }
            if (available > strlen) {
                available = strlen;
            }
            value.getChars(copyfrom, available, this.m_array[this.m_lastChunk], this.m_firstFree);
            copyfrom += available;
            if ((strlen -= available) <= 0) continue;
            int i2 = this.m_array.length;
            if (this.m_lastChunk + 1 == i2) {
                char[][] newarray = new char[i2 + 16][];
                System.arraycopy(this.m_array, 0, newarray, 0, i2);
                this.m_array = newarray;
            }
            if ((chunk = this.m_array[++this.m_lastChunk]) == null) {
                if (this.m_chunkAllocationUnit < this.m_chunkSize) {
                    this.m_chunkAllocationUnit <<= 1;
                }
                available = this.m_lastChunkSize = this.m_chunkAllocationUnit;
                this.m_array[this.m_lastChunk] = new char[this.m_lastChunkSize];
                chunk = this.m_array[this.m_lastChunk];
            } else {
                available = this.m_lastChunkSize = chunk.length;
            }
            this.m_firstFree = 0;
        }
        this.m_firstFree += available;
    }

    public final void append(FastStringBuffer value) {
        int strlen = value.length();
        if (strlen == 0) {
            return;
        }
        int copyfrom = 0;
        char[] chunk = this.m_array[this.m_lastChunk];
        int available = this.m_lastChunkSize - this.m_firstFree;
        while (strlen > 0) {
            int newsize = this.m_firstFree + strlen + this.m_chunkAllocationUnit - 1 & ~(this.m_chunkAllocationUnit - 1);
            if (newsize > this.m_chunkSize) {
                newsize = this.m_chunkSize;
            }
            if (newsize != this.m_lastChunkSize) {
                char[] newchunk = new char[newsize];
                if (chunk != null) {
                    System.arraycopy(chunk, 0, newchunk, 0, this.m_firstFree);
                }
                this.m_array[this.m_lastChunk] = newchunk;
                chunk = newchunk;
                this.m_lastChunkSize = newsize;
                available = newsize - this.m_firstFree;
            }
            if (available > strlen) {
                available = strlen;
            }
            int sourcechunk = copyfrom + value.m_chunkSize - 1 >>> value.m_chunkBits;
            int sourcecolumn = copyfrom & value.m_chunkMask;
            int runlength = value.m_chunkSize - sourcecolumn;
            if (runlength > available) {
                runlength = available;
            }
            System.arraycopy(value.m_array[sourcechunk], sourcecolumn, this.m_array[this.m_lastChunk], this.m_firstFree, runlength);
            if (runlength != available) {
                System.arraycopy(value.m_array[sourcechunk + 1], 0, this.m_array[this.m_lastChunk], this.m_firstFree + runlength, available - runlength);
            }
            copyfrom += available;
            if ((strlen -= available) <= 0) continue;
            int i2 = this.m_array.length;
            if (this.m_lastChunk + 1 == i2) {
                char[][] newarray = new char[i2 + 16][];
                System.arraycopy(this.m_array, 0, newarray, 0, i2);
                this.m_array = newarray;
            }
            if ((chunk = this.m_array[++this.m_lastChunk]) == null) {
                if (this.m_chunkAllocationUnit < this.m_chunkSize) {
                    this.m_chunkAllocationUnit <<= 1;
                }
                available = this.m_lastChunkSize = this.m_chunkAllocationUnit;
                this.m_array[this.m_lastChunk] = new char[this.m_lastChunkSize];
                chunk = this.m_array[this.m_lastChunk];
            } else {
                available = this.m_lastChunkSize = chunk.length;
            }
            this.m_firstFree = 0;
        }
        this.m_firstFree += available;
    }

    public final void append(char[] chars, int start, int length) {
        int strlen = length;
        if (strlen == 0) {
            return;
        }
        int copyfrom = start;
        char[] chunk = this.m_array[this.m_lastChunk];
        int available = this.m_lastChunkSize - this.m_firstFree;
        while (strlen > 0) {
            int newsize = this.m_firstFree + strlen + this.m_chunkAllocationUnit - 1 & ~(this.m_chunkAllocationUnit - 1);
            if (newsize > this.m_chunkSize) {
                newsize = this.m_chunkSize;
            }
            if (newsize != this.m_lastChunkSize) {
                char[] newchunk = new char[newsize];
                if (chunk != null) {
                    System.arraycopy(chunk, 0, newchunk, 0, this.m_firstFree);
                }
                this.m_array[this.m_lastChunk] = newchunk;
                chunk = newchunk;
                this.m_lastChunkSize = newsize;
                available = newsize - this.m_firstFree;
            }
            if (available > strlen) {
                available = strlen;
            }
            System.arraycopy(chars, copyfrom, this.m_array[this.m_lastChunk], this.m_firstFree, available);
            copyfrom += available;
            if ((strlen -= available) <= 0) continue;
            int i2 = this.m_array.length;
            if (this.m_lastChunk + 1 == i2) {
                char[][] newarray = new char[i2 + 16][];
                System.arraycopy(this.m_array, 0, newarray, 0, i2);
                this.m_array = newarray;
            }
            if ((chunk = this.m_array[++this.m_lastChunk]) == null) {
                if (this.m_chunkAllocationUnit < this.m_chunkSize) {
                    this.m_chunkAllocationUnit <<= 1;
                }
                available = this.m_lastChunkSize = this.m_chunkAllocationUnit;
                this.m_array[this.m_lastChunk] = new char[this.m_lastChunkSize];
                chunk = this.m_array[this.m_lastChunk];
            } else {
                available = this.m_lastChunkSize = chunk.length;
            }
            this.m_firstFree = 0;
        }
        this.m_firstFree += available;
    }

    public String getString(int start, int length) {
        return this.getString(start >>> this.m_chunkBits, start & this.m_chunkMask, length);
    }

    String getString(int startChunk, int startColumn, int length) {
        int stop = (startChunk << this.m_chunkBits) + startColumn + length;
        int stopChunk = stop >>> this.m_chunkBits;
        int stopColumn = stop & this.m_chunkMask;
        StringBuffer sb = new StringBuffer(length);
        int i2 = startChunk;
        while (i2 < stopChunk) {
            sb.append(this.m_array[i2], startColumn, this.m_chunkSize - startColumn);
            startColumn = 0;
            ++i2;
        }
        sb.append(this.m_array[stopChunk], startColumn, stopColumn - startColumn);
        return sb.toString();
    }

    public boolean isWhitespace(int start, int length) {
        int sourcechunk = start >>> this.m_chunkBits;
        int sourcecolumn = start & this.m_chunkMask;
        int available = this.m_chunkSize - sourcecolumn;
        while (length > 0) {
            int runlength;
            int n2 = runlength = length <= available ? length : available;
            if (!XMLCharacterRecognizer.isWhiteSpace(this.m_array[sourcechunk], sourcecolumn, runlength)) {
                return false;
            }
            length -= runlength;
            ++sourcechunk;
            sourcecolumn = 0;
            available = this.m_chunkSize;
        }
        return true;
    }

    public final int length() {
        return (this.m_lastChunk << this.m_chunkBits) + this.m_firstFree;
    }

    public final void reset() {
        this.m_lastChunk = 0;
        this.m_firstFree = 0;
    }

    public void sendSAXcharacters(ContentHandler ch2, int start, int length) throws SAXException {
        int stop = start + length;
        int startChunk = start >>> this.m_chunkBits;
        int startColumn = start & this.m_chunkMask;
        int stopChunk = stop >>> this.m_chunkBits;
        int stopColumn = stop & this.m_chunkMask;
        int i2 = startChunk;
        while (i2 < stopChunk) {
            ch2.characters(this.m_array[i2], startColumn, this.m_chunkSize - startColumn);
            startColumn = 0;
            ++i2;
        }
        ch2.characters(this.m_array[stopChunk], startColumn, stopColumn - startColumn);
    }

    public final void setLength(int l2) {
        this.m_lastChunk = l2 >>> this.m_chunkBits;
        this.m_firstFree = l2 & this.m_chunkMask;
    }

    public final int size() {
        return (this.m_lastChunk << this.m_chunkBits) + this.m_firstFree;
    }

    public final String toString() {
        return this.getString(0, 0, (this.m_lastChunk << this.m_chunkBits) + this.m_firstFree);
    }
}

