/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.io.IOException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.xalan.stree.SourceTreeHandler;
import org.apache.xalan.transformer.TransformerImpl;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class TrAXFilter
extends XMLFilterImpl {
    private Templates m_templates;
    private TransformerImpl m_transformer;

    public TrAXFilter(Templates templates) throws TransformerConfigurationException {
        this.m_templates = templates;
        this.m_transformer = (TransformerImpl)templates.newTransformer();
    }

    public void parse(String systemId) throws SAXException, IOException {
        this.parse(new InputSource(systemId));
    }

    public void parse(InputSource input) throws SAXException, IOException {
        if (this.getParent() == null) {
            XMLReader reader = null;
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                SAXParser jaxpParser = factory.newSAXParser();
                reader = jaxpParser.getXMLReader();
            }
            catch (ParserConfigurationException ex2) {
                throw new SAXException(ex2);
            }
            catch (FactoryConfigurationError ex1) {
                throw new SAXException(ex1.toString());
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            catch (AbstractMethodError abstractMethodError) {}
            XMLReader parent = reader == null ? XMLReaderFactory.createXMLReader() : reader;
            try {
                parent.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                parent.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            }
            catch (SAXException sAXException) {}
            this.setParent(parent);
        } else {
            this.setupParse();
        }
        if (this.m_transformer.getContentHandler() == null) {
            throw new SAXException("parse can not be called if the ContentHandler has not been set!");
        }
        this.getParent().parse(input);
        Exception e10 = this.m_transformer.getExceptionThrown();
        if (e10 != null) {
            if (e10 instanceof SAXException) {
                throw (SAXException)e10;
            }
            throw new SAXException(e10);
        }
    }

    public void setContentHandler(ContentHandler handler) {
        this.m_transformer.setContentHandler(handler);
    }

    public void setErrorListener(ErrorListener handler) {
        this.m_transformer.setErrorListener(handler);
    }

    public void setParent(XMLReader parent) {
        super.setParent(parent);
        if (parent.getContentHandler() != null) {
            this.setContentHandler(parent.getContentHandler());
        }
        this.setupParse();
    }

    private void setupParse() {
        XMLReader p2 = this.getParent();
        if (p2 == null) {
            throw new NullPointerException("No parent for filter");
        }
        ContentHandler ch2 = this.m_transformer.getInputContentHandler();
        if (ch2 instanceof SourceTreeHandler) {
            ((SourceTreeHandler)ch2).setUseMultiThreading(true);
        }
        p2.setContentHandler(ch2);
        if (ch2 instanceof EntityResolver) {
            p2.setEntityResolver((EntityResolver)((Object)ch2));
        } else {
            p2.setEntityResolver(this);
        }
        if (ch2 instanceof DTDHandler) {
            p2.setDTDHandler((DTDHandler)((Object)ch2));
        } else {
            p2.setDTDHandler(this);
        }
        ErrorListener elistener = this.m_transformer.getErrorListener();
        if (elistener != null && elistener instanceof ErrorHandler) {
            p2.setErrorHandler((ErrorHandler)((Object)elistener));
        } else {
            p2.setErrorHandler(this);
        }
    }
}

