/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import javax.xml.transform.TransformerException;
import org.apache.xalan.transformer.ResultTreeHandler;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.XPathContext;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ClonerToResultTree {
    private ResultTreeHandler m_rth;
    private TransformerImpl m_transformer;

    public ClonerToResultTree(TransformerImpl transformer, ResultTreeHandler rth) {
        this.m_rth = rth;
        this.m_transformer = transformer;
    }

    public void cloneToResultTree(Node node, boolean shouldCloneAttributes) throws TransformerException {
        try {
            boolean stripWhiteSpace = false;
            XPathContext xctxt = this.m_transformer.getXPathContext();
            DOMHelper dhelper = xctxt.getDOMHelper();
            switch (node.getNodeType()) {
                case 3: {
                    Text tx = (Text)node;
                    String data = null;
                    if (stripWhiteSpace) {
                        if (!dhelper.isIgnorableWhitespace(tx) && (data = tx.getData()) != null && data.trim().length() == 0) {
                            data = null;
                        }
                    } else {
                        Node parent = node.getParentNode();
                        if (parent != null) {
                            if (parent.getNodeType() != 9 && (data = tx.getData()) != null && data.length() == 0) {
                                data = null;
                            }
                        } else {
                            data = tx.getData();
                            if (data != null && data.length() == 0) {
                                data = null;
                            }
                        }
                    }
                    if (data != null) {
                        if (dhelper.isIgnorableWhitespace(tx)) {
                            this.m_rth.ignorableWhitespace(data.toCharArray(), 0, data.length());
                        } else {
                            this.m_rth.characters(data.toCharArray(), 0, data.length());
                        }
                    }
                    break;
                }
                case 1: {
                    if (shouldCloneAttributes) {
                        this.m_rth.addAttributes(node);
                        this.m_rth.processNSDecls(node);
                    }
                    String ns = dhelper.getNamespaceOfNode(node);
                    String localName = dhelper.getLocalNameOfNode(node);
                    this.m_rth.startElement(ns, localName, node.getNodeName(), null);
                    break;
                }
                case 4: {
                    this.m_rth.startCDATA();
                    String data = ((CDATASection)node).getData();
                    this.m_rth.characters(data.toCharArray(), 0, data.length());
                    this.m_rth.endCDATA();
                    break;
                }
                case 2: {
                    if (!this.m_rth.isDefinedNSDecl((Attr)node)) {
                        String ns = dhelper.getNamespaceOfNode(node);
                        String localName = dhelper.getLocalNameOfNode(node);
                        this.m_rth.addAttribute(ns, localName, node.getNodeName(), "CDATA", ((Attr)node).getValue());
                    }
                    break;
                }
                case 8: {
                    this.m_rth.comment(((Comment)node).getData());
                    break;
                }
                case 5: {
                    EntityReference er2 = (EntityReference)node;
                    this.m_rth.entityReference(er2.getNodeName());
                    break;
                }
                case 7: {
                    ProcessingInstruction pi = (ProcessingInstruction)node;
                    this.m_rth.processingInstruction(pi.getTarget(), pi.getData());
                    break;
                }
                default: {
                    this.m_transformer.getMsgMgr().error(null, 56, new Object[]{node.getNodeName()});
                    break;
                }
                case 9: 
                case 11: {
                    return;
                }
            }
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
    }
}

