/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.stree;

import org.apache.xalan.stree.Child;
import org.apache.xalan.stree.DocumentImpl;
import org.apache.xml.utils.FastStringBuffer;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TextImpl
extends Child
implements Text {
    protected String m_data;
    protected int m_start;
    protected int m_length;

    public TextImpl(DocumentImpl doc, String data) {
        super(doc);
        this.m_data = data;
        this.m_length = data.length();
        this.m_start = -1;
    }

    public TextImpl(DocumentImpl doc, char[] ch2, int start, int length) {
        super(doc);
        FastStringBuffer fsb;
        FastStringBuffer fastStringBuffer = fsb = doc.m_chars;
        synchronized (fastStringBuffer) {
            this.m_start = fsb.length();
            this.m_length = length;
            fsb.append(ch2, start, length);
        }
    }

    void appendText(char[] ch2, int start, int length) {
        if (this.m_data == null) {
            FastStringBuffer fsb;
            FastStringBuffer fastStringBuffer = fsb = this.m_doc.m_chars;
            synchronized (fastStringBuffer) {
                fsb.append(ch2, start, length);
            }
        } else {
            this.m_data.concat(ch2.toString());
        }
        this.m_length += length;
    }

    public void dispatchCharactersEvent(ContentHandler ch2) throws SAXException {
        if (this.m_start == -1) {
            ch2.characters(this.m_data.toCharArray(), 0, this.m_data.length());
        } else {
            FastStringBuffer fastStringBuffer = this.m_doc.m_chars;
            synchronized (fastStringBuffer) {
                this.m_doc.m_chars.sendSAXcharacters(ch2, this.m_start, this.m_length);
            }
        }
    }

    public String getData() {
        if (this.m_data == null) {
            FastStringBuffer fastStringBuffer = this.m_doc.m_chars;
            synchronized (fastStringBuffer) {
                this.m_data = this.m_doc.m_chars.getString(this.m_start, this.m_length);
            }
        }
        return this.m_data;
    }

    public int getLength() {
        return this.m_length;
    }

    public int getLengthInBuffer() {
        return this.m_length;
    }

    public String getLocalName() {
        return "#text";
    }

    public String getNodeName() {
        return "#text";
    }

    public short getNodeType() {
        return 3;
    }

    public String getNodeValue() {
        if (this.m_data == null) {
            FastStringBuffer fastStringBuffer = this.m_doc.m_chars;
            synchronized (fastStringBuffer) {
                this.m_data = this.m_doc.m_chars.getString(this.m_start, this.m_length);
            }
        }
        return this.m_data;
    }

    public int getStartOffsetInBuffer() {
        return this.m_start;
    }

    public boolean isWhitespace() {
        return this.m_doc.m_chars.isWhitespace(this.m_start, this.m_length);
    }
}

