/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.serialize.CharInfo;
import org.apache.xalan.serialize.DOMSerializer;
import org.apache.xalan.serialize.Encodings;
import org.apache.xalan.serialize.Serializer;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xml.utils.BoolStack;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xml.utils.TreeWalker;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.DOM2Helper;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class SerializerToXML
implements ContentHandler,
LexicalHandler,
DeclHandler,
Serializer,
DOMSerializer {
    protected Writer m_writer = null;
    boolean m_shouldFlush = true;
    protected OutputStream m_outputStream = System.out;
    private boolean m_bytesEqualChars = false;
    protected String m_encoding = null;
    static boolean javaEncodingIsISO = false;
    public boolean m_shouldNotWriteXMLHeader = false;
    public String m_version = null;
    protected BoolStack m_elemStack = new BoolStack();
    protected BoolStack m_disableOutputEscapingStates = new BoolStack();
    protected BoolStack m_cdataSectionStates = new BoolStack();
    protected Vector m_cdataSectionNames = null;
    protected boolean m_inCData = false;
    protected final String m_lineSep = System.getProperty("line.separator");
    protected final int m_lineSepLen = this.m_lineSep.length();
    protected boolean m_ispreserve = false;
    protected BoolStack m_preserves = new BoolStack();
    protected boolean m_isprevtext = false;
    protected boolean m_doIndent = false;
    protected int m_currentIndent = 0;
    public int m_indentAmount = 0;
    protected int level = 0;
    boolean m_startNewLine;
    boolean m_needToOutputDocTypeDecl = true;
    String m_doctypeSystem;
    String m_doctypePublic;
    boolean m_standalone = false;
    boolean m_standaloneWasSpecified = false;
    String m_mediatype;
    protected boolean m_inEntityRef = false;
    private boolean m_inDoctype = false;
    protected static CharInfo m_xmlcharInfo = new CharInfo(CharInfo.XML_ENTITIES_RESOURCE);
    protected CharInfo m_charInfo;
    private static Hashtable m_charInfos = null;
    boolean m_isUTF8;
    int m_maxCharacter = Encodings.getLastPrintable();
    public boolean m_spaceBeforeClose = false;
    protected Properties m_format;
    private static final boolean DEBUG = false;
    static final int MAXCHARBUF = 4096;
    static final int NUMBERBYTESTOWRITEDIRECT = 1024;
    protected char[] m_charBuf = new char[4096];
    protected byte[] m_byteBuf = new byte[4096];
    protected int m_pos = 0;
    private String m_elemName = "";

    public SerializerToXML() {
        this.m_charInfo = m_xmlcharInfo;
    }

    public void CopyFrom(SerializerToXML xmlListener) {
        this.m_writer = xmlListener.m_writer;
        this.m_outputStream = xmlListener.m_outputStream;
        this.m_bytesEqualChars = xmlListener.m_bytesEqualChars;
        this.m_encoding = xmlListener.m_encoding;
        this.m_shouldNotWriteXMLHeader = xmlListener.m_shouldNotWriteXMLHeader;
        this.m_shouldNotWriteXMLHeader = xmlListener.m_shouldNotWriteXMLHeader;
        this.m_elemStack = xmlListener.m_elemStack;
        this.m_ispreserve = xmlListener.m_ispreserve;
        this.m_preserves = xmlListener.m_preserves;
        this.m_isprevtext = xmlListener.m_isprevtext;
        this.m_doIndent = xmlListener.m_doIndent;
        this.m_currentIndent = xmlListener.m_currentIndent;
        this.m_indentAmount = xmlListener.m_indentAmount;
        this.level = xmlListener.level;
        this.m_startNewLine = xmlListener.m_startNewLine;
        this.m_needToOutputDocTypeDecl = xmlListener.m_needToOutputDocTypeDecl;
        this.m_doctypeSystem = xmlListener.m_doctypeSystem;
        this.m_doctypePublic = xmlListener.m_doctypePublic;
        this.m_standalone = xmlListener.m_standalone;
        this.m_mediatype = xmlListener.m_mediatype;
        this.m_maxCharacter = xmlListener.m_maxCharacter;
        this.m_spaceBeforeClose = xmlListener.m_spaceBeforeClose;
        this.m_inCData = xmlListener.m_inCData;
        this.m_charBuf = xmlListener.m_charBuf;
        this.m_byteBuf = xmlListener.m_byteBuf;
        this.m_pos = 0;
    }

    protected final void accum(byte b10) throws SAXException {
        if (this.m_bytesEqualChars) {
            this.m_byteBuf[this.m_pos++] = b10;
            if (this.m_pos >= 4096) {
                this.flushBytes();
            }
        } else {
            this.m_charBuf[this.m_pos++] = (char)b10;
            if (this.m_pos >= 4096) {
                this.flushChars();
            }
        }
    }

    protected final void accum(char b10) throws SAXException {
        if (this.m_bytesEqualChars) {
            this.m_byteBuf[this.m_pos++] = (byte)b10;
            if (this.m_pos >= 4096) {
                this.flushBytes();
            }
        } else {
            this.m_charBuf[this.m_pos++] = b10;
            if (this.m_pos >= 4096) {
                this.flushChars();
            }
        }
    }

    protected final void accum(String s2) throws SAXException {
        int n2 = s2.length();
        if (this.m_bytesEqualChars) {
            char[] chars = s2.toCharArray();
            int i2 = 0;
            while (i2 < n2) {
                this.m_byteBuf[this.m_pos++] = (byte)chars[i2];
                if (this.m_pos >= 4096) {
                    this.flushBytes();
                }
                ++i2;
            }
        } else if (n2 >= 1024) {
            if (this.m_pos != 0) {
                this.flushChars();
            }
            try {
                this.m_writer.write(s2);
            }
            catch (IOException ioe) {
                throw new SAXException(ioe);
            }
        } else {
            int i3 = 0;
            while (i3 < n2) {
                this.m_charBuf[this.m_pos++] = s2.charAt(i3);
                if (this.m_pos >= 4096) {
                    this.flushChars();
                }
                ++i3;
            }
        }
    }

    protected final void accum(char[] chars, int start, int length) throws SAXException {
        int n2 = start + length;
        if (this.m_bytesEqualChars) {
            int i2 = start;
            while (i2 < n2) {
                this.m_byteBuf[this.m_pos++] = (byte)chars[i2];
                if (this.m_pos >= 4096) {
                    this.flushBytes();
                }
                ++i2;
            }
        } else if (length >= 1024) {
            if (this.m_pos != 0) {
                this.flushChars();
            }
            try {
                this.m_writer.write(chars, start, length);
            }
            catch (IOException ioe) {
                throw new SAXException(ioe);
            }
        } else {
            if (this.m_pos + length >= 4096) {
                this.flushChars();
            }
            System.arraycopy(chars, start, this.m_charBuf, this.m_pos, length);
            this.m_pos += length;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final int accumDefaultEntity(char ch2, int i2, char[] chars, int len, boolean escLF) throws SAXException {
        if (!escLF && CharInfo.S_LINEFEED == ch2) {
            this.outputLineSep();
            return i2 + 1;
        } else {
            if (!this.m_charInfo.isSpecial(ch2)) return i2;
            String entityRef = this.m_charInfo.getEntityNameForChar(ch2);
            if (entityRef == null) return i2;
            this.accum('&');
            this.accum(entityRef);
            this.accum(';');
        }
        return i2 + 1;
    }

    final int accumDefaultEscape(char ch2, int i2, char[] chars, int len, boolean escLF) throws SAXException {
        int pos = this.accumDefaultEntity(ch2, i2, chars, len, escLF);
        if (i2 == pos) {
            ++pos;
            if (ch2 >= '\ud800' && ch2 < '\udc00') {
                int next;
                if (i2 + 1 >= len) {
                    throw new SAXException(XSLMessages.createXPATHMessage(65, new Object[]{Integer.toHexString(ch2)}));
                }
                if ((next = chars[++i2]) < 56320 || next >= 57344) {
                    throw new SAXException(XSLMessages.createXPATHMessage(65, new Object[]{String.valueOf(Integer.toHexString(ch2)) + " " + Integer.toHexString(next)}));
                }
                next = (ch2 - 55296 << 10) + next - 56320 + 65536;
                this.accum("&#");
                this.accum(Integer.toString(next));
                this.accum(";");
            } else if (ch2 > this.m_maxCharacter || this.m_charInfo.isSpecial(ch2)) {
                this.accum("&#");
                this.accum(Integer.toString(ch2));
                this.accum(";");
            } else {
                this.accum(ch2);
            }
        }
        return pos;
    }

    public ContentHandler asContentHandler() throws IOException {
        return this;
    }

    public DOMSerializer asDOMSerializer() throws IOException {
        return this;
    }

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
        if (this.m_inDoctype) {
            this.accum(" [");
            this.outputLineSep();
            this.m_inDoctype = false;
        }
        if (!eName.equals(this.m_elemName)) {
            this.accum("<!ATTLIST ");
            this.accum(eName);
            this.accum(" ");
            this.m_elemName = eName;
        } else {
            this.m_pos -= 3;
            this.outputLineSep();
        }
        this.accum(aName);
        this.accum(" ");
        this.accum(type);
        this.accum(" ");
        this.accum(valueDefault);
        this.accum(">");
        this.outputLineSep();
    }

    public void cdata(char[] ch2, int start, int length) throws SAXException {
        try {
            boolean writeCDataBrackets;
            this.writeParentTagEnd();
            this.m_ispreserve = true;
            if (this.shouldIndent()) {
                this.indent(this.m_currentIndent);
            }
            boolean bl2 = writeCDataBrackets = length >= 1 && ch2[start] <= this.m_maxCharacter;
            if (writeCDataBrackets) {
                this.accum("<![CDATA[");
            }
            if (this.isEscapingDisabled()) {
                this.charactersRaw(ch2, start, length);
            } else {
                this.writeNormalizedChars(ch2, start, length, true);
            }
            if (writeCDataBrackets) {
                this.accum("]]>");
            }
        }
        catch (IOException ioe) {
            throw new SAXException(XSLMessages.createXPATHMessage(66, null), ioe);
        }
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        if (length == 0) {
            return;
        }
        if (this.isCDataSection()) {
            this.cdata(chars, start, length);
            return;
        }
        if (this.isEscapingDisabled()) {
            this.charactersRaw(chars, start, length);
            return;
        }
        this.writeParentTagEnd();
        int startClean = start;
        int lengthClean = 0;
        int end = start + length;
        boolean checkWhite = true;
        int i2 = start;
        while (i2 < end) {
            char ch2 = chars[i2];
            if (checkWhite && !Character.isWhitespace(ch2)) {
                this.m_ispreserve = true;
                checkWhite = false;
            }
            if (ch2 < this.m_maxCharacter && !this.m_charInfo.isSpecial(ch2)) {
                ++lengthClean;
            } else if (ch2 == '\"') {
                ++lengthClean;
            } else {
                if (lengthClean > 0) {
                    this.accum(chars, startClean, lengthClean);
                    lengthClean = 0;
                }
                startClean = this.accumDefaultEscape(ch2, i2, chars, end, false);
                i2 = startClean - 1;
            }
            ++i2;
        }
        if (lengthClean > 0) {
            this.accum(chars, startClean, lengthClean);
        }
        this.m_isprevtext = true;
    }

    public void charactersRaw(char[] ch2, int start, int length) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        this.writeParentTagEnd();
        this.m_ispreserve = true;
        this.accum(ch2, start, length);
    }

    protected boolean childNodesWereAdded() {
        return this.m_elemStack.isEmpty() ? false : this.m_elemStack.pop();
    }

    public void comment(char[] ch2, int start, int length) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        this.writeParentTagEnd();
        if (this.shouldIndent()) {
            this.indent(this.m_currentIndent);
        }
        this.accum("<!--");
        this.accum(ch2, start, length);
        this.accum("-->");
        this.m_startNewLine = true;
    }

    public void elementDecl(String name, String model) throws SAXException {
        if (this.m_inDoctype) {
            this.accum(" [");
            this.outputLineSep();
            this.m_inDoctype = false;
        }
        this.accum("<!ELEMENT ");
        this.accum(name);
        this.accum(" ");
        this.accum(model);
        this.accum(">");
        this.outputLineSep();
    }

    public void endCDATA() throws SAXException {
        this.m_inCData = false;
    }

    public void endDTD() throws SAXException {
        if (!this.m_inDoctype) {
            this.accum("]>");
        } else {
            this.accum(">");
        }
        this.outputLineSep();
    }

    public void endDocument() throws SAXException {
        if (this.m_doIndent && !this.m_isprevtext) {
            this.outputLineSep();
        }
        this.flush();
        this.flushWriter();
    }

    public void endElement(String namespaceURI, String localName, String name) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        this.m_currentIndent -= this.m_indentAmount;
        boolean hasChildNodes = this.childNodesWereAdded();
        if (hasChildNodes) {
            if (this.shouldIndent()) {
                this.indent(this.m_currentIndent);
            }
            this.accum('<');
            this.accum('/');
            this.accum(name);
            this.accum('>');
        } else if (this.m_spaceBeforeClose) {
            this.accum(" />");
        } else {
            this.accum("/>");
        }
        if (hasChildNodes) {
            this.m_ispreserve = this.m_preserves.isEmpty() ? false : this.m_preserves.pop();
        }
        this.m_isprevtext = false;
        this.m_cdataSectionStates.pop();
    }

    public void endEntity(String name) throws SAXException {
        this.m_inEntityRef = false;
    }

    public void endNonEscaping() throws SAXException {
        this.m_disableOutputEscapingStates.pop();
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void endPreserving() throws SAXException {
        this.m_ispreserve = this.m_preserves.isEmpty() ? false : this.m_preserves.pop();
    }

    public void entityReference(String name) throws SAXException {
        this.writeParentTagEnd();
        if (this.shouldIndent()) {
            this.indent(this.m_currentIndent);
        }
        this.accum("&");
        this.accum(name);
        this.accum(";");
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public final void flush() throws SAXException {
        if (this.m_bytesEqualChars) {
            this.flushBytes();
        } else {
            this.flushChars();
        }
    }

    private final void flushBytes() throws SAXException {
        try {
            this.m_outputStream.write(this.m_byteBuf, 0, this.m_pos);
            this.m_pos = 0;
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    private final void flushChars() throws SAXException {
        try {
            this.m_writer.write(this.m_charBuf, 0, this.m_pos);
            this.m_pos = 0;
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public final void flushWriter() throws SAXException {
        if (this.m_shouldFlush && this.m_writer != null) {
            try {
                this.m_writer.flush();
            }
            catch (IOException ioe) {
                throw new SAXException(ioe);
            }
        }
    }

    public Properties getOutputFormat() {
        return this.m_format;
    }

    public OutputStream getOutputStream() {
        return this.m_outputStream;
    }

    int getURF16SurrogateValue(char c10, char[] ch2, int i2, int end) throws SAXException {
        int next;
        if (i2 + 1 >= end) {
            throw new SAXException(XSLMessages.createXPATHMessage(65, new Object[]{Integer.toHexString(c10)}));
        }
        if ((next = ch2[++i2]) < 56320 || next >= 57344) {
            throw new SAXException(XSLMessages.createXPATHMessage(65, new Object[]{String.valueOf(Integer.toHexString(c10)) + " " + Integer.toHexString(next)}));
        }
        next = (c10 - 55296 << 10) + next - 56320 + 65536;
        return next;
    }

    public Writer getWriter() {
        return this.m_writer;
    }

    public void ignorableWhitespace(char[] ch2, int start, int length) throws SAXException {
        if (length == 0) {
            return;
        }
        this.characters(ch2, start, length);
    }

    public void indent(int n2) throws SAXException {
        if (this.m_startNewLine) {
            this.outputLineSep();
        }
        if (this.m_doIndent) {
            this.printSpace(n2);
        }
    }

    public synchronized void init(OutputStream output, Properties format) throws UnsupportedEncodingException {
        if (format == null) {
            OutputProperties op = new OutputProperties("xml");
            format = op.getProperties();
        }
        this.m_encoding = Encodings.getMimeEncoding(format.getProperty("encoding"));
        if (this.m_encoding.equals("WINDOWS-1250") || this.m_encoding.equals("US-ASCII") || this.m_encoding.equals("ASCII")) {
            this.m_bytesEqualChars = true;
            this.m_outputStream = output;
            this.init(null, format, true);
        } else {
            Writer osw;
            try {
                osw = Encodings.getWriter(output, this.m_encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.out.println("Warning: encoding \"" + this.m_encoding + "\" not supported" + ", using " + "UTF-8");
                this.m_encoding = "UTF-8";
                osw = Encodings.getWriter(output, this.m_encoding);
            }
            this.m_maxCharacter = Encodings.getLastPrintable(this.m_encoding);
            this.init(osw, format, true);
        }
    }

    public synchronized void init(Writer writer, Properties format) {
        this.init(writer, format, false);
    }

    private synchronized void init(Writer writer, Properties format, boolean shouldFlush) {
        this.m_shouldFlush = shouldFlush;
        this.m_writer = writer;
        this.m_format = format;
        this.m_cdataSectionNames = OutputProperties.getQNameProperties("cdata-section-elements", format);
        this.m_indentAmount = OutputProperties.getIntProperty(OutputProperties.S_KEY_INDENT_AMOUNT, format);
        this.m_doIndent = OutputProperties.getBooleanProperty("indent", format);
        this.m_shouldNotWriteXMLHeader = OutputProperties.getBooleanProperty("omit-xml-declaration", format);
        this.m_doctypeSystem = format.getProperty("doctype-system");
        this.m_doctypePublic = format.getProperty("doctype-public");
        this.m_standaloneWasSpecified = ((Hashtable)format).get("standalone") != null;
        this.m_standalone = OutputProperties.getBooleanProperty("standalone", format);
        this.m_mediatype = format.getProperty("media-type");
        if (this.m_doctypePublic != null && this.m_doctypePublic.startsWith("-//W3C//DTD XHTML")) {
            this.m_spaceBeforeClose = true;
        }
        if (this.m_encoding == null) {
            this.m_encoding = Encodings.getMimeEncoding(format.getProperty("encoding"));
        }
        this.m_isUTF8 = this.m_encoding.equals("UTF-8");
        this.m_maxCharacter = Encodings.getLastPrintable(this.m_encoding);
        String entitiesFileName = (String)((Hashtable)format).get(OutputProperties.S_KEY_ENTITIES);
        if (entitiesFileName != null) {
            try {
                this.m_charInfo = null;
                if (m_charInfos == null) {
                    CharInfo charInfo = m_xmlcharInfo;
                    synchronized (charInfo) {
                        if (m_charInfos == null) {
                            m_charInfos = new Hashtable();
                        }
                    }
                } else {
                    this.m_charInfo = (CharInfo)m_charInfos.get(entitiesFileName);
                }
                if (this.m_charInfo == null) {
                    String absoluteEntitiesFileName = entitiesFileName.indexOf(58) < 0 ? SystemIDResolver.getAbsoluteURIFromRelative(entitiesFileName) : SystemIDResolver.getAbsoluteURI(entitiesFileName, null);
                    this.m_charInfo = new CharInfo(absoluteEntitiesFileName);
                    m_charInfos.put(entitiesFileName, this.m_charInfo);
                }
            }
            catch (TransformerException te) {
                throw new WrappedRuntimeException(te);
            }
        }
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
        if (this.m_inDoctype) {
            this.accum(" [");
            this.outputLineSep();
            this.m_inDoctype = false;
        }
        this.outputEntityDecl(name, value);
    }

    protected boolean isCDataSection() {
        return this.m_inCData || this.m_cdataSectionStates.peekOrFalse();
    }

    protected boolean isEscapingDisabled() {
        return this.m_disableOutputEscapingStates.peekOrFalse();
    }

    static final boolean isUTF16Surrogate(char c10) {
        return (c10 & 0xFC00) == 55296;
    }

    protected void openElementForChildren() {
        this.m_elemStack.push(false);
    }

    void outputDocTypeDecl(String name, boolean closeDecl) throws SAXException {
        this.accum("<!DOCTYPE ");
        this.accum(name);
        if (this.m_doctypePublic != null) {
            this.accum(" PUBLIC \"");
            this.accum(this.m_doctypePublic);
            this.accum("\"");
        }
        if (this.m_doctypeSystem != null) {
            if (this.m_doctypePublic == null) {
                this.accum(" SYSTEM \"");
            } else {
                this.accum(" \"");
            }
            this.accum(this.m_doctypeSystem);
            if (closeDecl) {
                this.accum("\">");
                this.outputLineSep();
            } else {
                this.accum("\"");
            }
        }
    }

    void outputEntityDecl(String name, String value) throws SAXException {
        this.accum("<!ENTITY ");
        this.accum(name);
        this.accum(" \"");
        this.accum(value);
        this.accum("\">");
        this.outputLineSep();
    }

    protected final void outputLineSep() throws SAXException {
        int z2 = 0;
        while (z2 < this.m_lineSepLen) {
            this.accum(this.m_lineSep.charAt(z2));
            ++z2;
        }
    }

    public void printSpace(int n2) throws SAXException {
        int i2 = 0;
        while (i2 < n2) {
            this.accum(' ');
            ++i2;
        }
    }

    protected void processAttribute(String name, String value) throws SAXException {
        this.accum(' ');
        this.accum(name);
        this.accum("=\"");
        this.writeAttrString(value, this.m_encoding);
        this.accum('\"');
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        if (target.equals("javax.xml.transform.disable-output-escaping")) {
            this.startNonEscaping();
        } else if (target.equals("javax.xml.transform.enable-output-escaping")) {
            this.endNonEscaping();
        } else {
            int indexOfQLT;
            this.writeParentTagEnd();
            if (this.shouldIndent()) {
                this.indent(this.m_currentIndent);
            }
            this.accum('<');
            this.accum('?');
            this.accum(target);
            if (data.length() > 0 && !Character.isSpaceChar(data.charAt(0))) {
                this.accum(' ');
            }
            if ((indexOfQLT = data.indexOf("?>")) >= 0) {
                if (indexOfQLT > 0) {
                    this.accum(data.substring(0, indexOfQLT));
                }
                this.accum("? >");
                if (indexOfQLT + 2 < data.length()) {
                    this.accum(data.substring(indexOfQLT + 2));
                }
            } else {
                this.accum(data);
            }
            this.accum('?');
            this.accum('>');
            if (this.m_elemStack.isEmpty()) {
                this.outputLineSep();
            }
            this.m_startNewLine = true;
        }
    }

    protected void pushState(String namespaceURI, String localName, Vector qnames, BoolStack state) {
        boolean b10;
        if (qnames != null) {
            b10 = false;
            if (namespaceURI != null && namespaceURI.length() == 0) {
                namespaceURI = null;
            }
            int nElems = qnames.size();
            int i2 = 0;
            while (i2 < nElems) {
                QName q2 = (QName)qnames.elementAt(i2);
                if (q2.getLocalName().equals(localName) && SerializerToXML.subPartMatch(namespaceURI, q2.getNamespaceURI())) {
                    b10 = true;
                    break;
                }
                ++i2;
            }
        } else {
            b10 = state.peekOrFalse();
        }
        state.push(b10);
    }

    public boolean reset() {
        return false;
    }

    public void serialize(Node node) throws IOException {
        try {
            TreeWalker walker = new TreeWalker(this, new DOM2Helper());
            walker.traverse(node);
        }
        catch (SAXException se) {
            throw new WrappedRuntimeException(se);
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void setOutputFormat(Properties format) {
        boolean shouldFlush = this.m_shouldFlush;
        this.init(this.m_writer, format, false);
        this.m_shouldFlush = shouldFlush;
    }

    public void setOutputStream(OutputStream output) {
        try {
            this.init(output, this.m_format);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    public void setWriter(Writer writer) {
        this.m_writer = writer;
    }

    protected boolean shouldIndent() {
        return this.m_doIndent && !this.m_ispreserve && !this.m_isprevtext;
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.m_inCData = true;
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.m_doctypeSystem = systemId;
        this.m_doctypePublic = publicId;
        if (this.m_needToOutputDocTypeDecl) {
            this.outputDocTypeDecl(name, false);
        }
        this.m_needToOutputDocTypeDecl = false;
        this.m_inDoctype = true;
    }

    public void startDocument() throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        this.m_needToOutputDocTypeDecl = true;
        this.m_startNewLine = false;
        if (!this.m_shouldNotWriteXMLHeader) {
            String version;
            String encoding = Encodings.getMimeEncoding(this.m_encoding);
            String string = version = this.m_version == null ? "1.0" : this.m_version;
            String standalone = this.m_standaloneWasSpecified ? " standalone=\"" + (this.m_standalone ? "yes" : "no") + "\"" : "";
            this.accum("<?xml version=\"" + version + "\" encoding=\"" + encoding + "\"" + standalone + "?>");
            this.outputLineSep();
        }
    }

    public void startElement(String namespaceURI, String localName, String name, Attributes atts) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        if (this.m_needToOutputDocTypeDecl && this.m_doctypeSystem != null) {
            this.outputDocTypeDecl(name, true);
        }
        this.m_needToOutputDocTypeDecl = false;
        this.writeParentTagEnd();
        this.pushState(namespaceURI, localName, this.m_cdataSectionNames, this.m_cdataSectionStates);
        this.m_ispreserve = false;
        if (this.shouldIndent() && this.m_startNewLine) {
            this.indent(this.m_currentIndent);
        }
        this.m_startNewLine = true;
        this.accum('<');
        this.accum(name);
        int nAttrs = atts.getLength();
        int i2 = 0;
        while (i2 < nAttrs) {
            this.processAttribute(atts.getQName(i2), atts.getValue(i2));
            ++i2;
        }
        this.openElementForChildren();
        this.m_currentIndent += this.m_indentAmount;
        this.m_isprevtext = false;
    }

    public void startEntity(String name) throws SAXException {
        this.m_inEntityRef = true;
    }

    public void startNonEscaping() throws SAXException {
        this.m_disableOutputEscapingStates.push(true);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void startPreserving() throws SAXException {
        this.m_preserves.push(true);
        this.m_ispreserve = true;
    }

    protected static final boolean subPartMatch(String p2, String t2) {
        return p2 == t2 || p2 != null && p2.equals(t2);
    }

    public void writeAttrString(String string, String encoding) throws SAXException {
        char[] stringChars = string.toCharArray();
        int len = stringChars.length;
        int i2 = 0;
        while (i2 < len) {
            char ch2 = stringChars[i2];
            if (ch2 < this.m_maxCharacter && !this.m_charInfo.isSpecial(ch2)) {
                this.accum(ch2);
            } else {
                if (CharInfo.S_CARRIAGERETURN == ch2 && i2 + 1 < len && CharInfo.S_LINEFEED == stringChars[i2 + 1]) {
                    ++i2;
                    ch2 = CharInfo.S_LINEFEED;
                }
                this.accumDefaultEscape(ch2, i2, stringChars, len, true);
            }
            ++i2;
        }
    }

    void writeNormalizedChars(char[] ch2, int start, int length, boolean isCData) throws IOException, SAXException {
        int end = start + length;
        int i2 = start;
        while (i2 < end) {
            String intStr;
            char c10 = ch2[i2];
            if (CharInfo.S_LINEFEED == c10) {
                this.outputLineSep();
            } else if (isCData && c10 > this.m_maxCharacter) {
                if (i2 != 0) {
                    this.accum("]]>");
                }
                if (SerializerToXML.isUTF16Surrogate(c10)) {
                    i2 = this.writeUTF16Surrogate(c10, ch2, i2, end);
                } else {
                    this.accum("&#");
                    intStr = Integer.toString(c10);
                    this.accum(intStr);
                    this.accum(';');
                }
                if (i2 != 0 && i2 < end - 1) {
                    this.accum("<![CDATA[");
                }
            } else if (isCData && i2 < end - 2 && c10 == ']' && ch2[i2 + 1] == ']' && ch2[i2 + 2] == '>') {
                this.accum("]]]]><![CDATA[>");
                i2 += 2;
            } else if (c10 <= this.m_maxCharacter) {
                this.accum(c10);
            } else if (SerializerToXML.isUTF16Surrogate(c10)) {
                i2 = this.writeUTF16Surrogate(c10, ch2, i2, end);
            } else {
                this.accum("&#");
                intStr = Integer.toString(c10);
                this.accum(intStr);
                this.accum(';');
            }
            ++i2;
        }
    }

    protected void writeParentTagEnd() throws SAXException {
        if (!this.m_elemStack.isEmpty() && !this.m_elemStack.peek()) {
            this.accum('>');
            this.m_isprevtext = false;
            this.m_elemStack.pop();
            this.m_elemStack.push(true);
            this.m_preserves.push(this.m_ispreserve);
        }
    }

    protected int writeUTF16Surrogate(char c10, char[] ch2, int i2, int end) throws IOException, SAXException {
        int surrogateValue = this.getURF16SurrogateValue(c10, ch2, i2, end);
        this.accum('&');
        this.accum('#');
        this.accum(Integer.toString(surrogateValue));
        this.accum(';');
        return ++i2;
    }
}

