/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.processor;

import org.apache.xalan.processor.XSLTAttributeDef;
import org.apache.xalan.processor.XSLTElementProcessor;
import org.apache.xalan.processor.XSLTSchema;
import org.apache.xml.utils.QName;

public class XSLTElementDef {
    static final int T_ELEMENT = 1;
    static final int T_PCDATA = 2;
    static final int T_ANY = 3;
    private int m_type = 1;
    private String m_namespace;
    private String m_name;
    private String m_nameAlias;
    private XSLTElementDef[] m_elements;
    private XSLTAttributeDef[] m_attributes;
    private XSLTElementProcessor m_elementProcessor;
    private Class m_classObject;

    XSLTElementDef() {
    }

    XSLTElementDef(Class classObject, XSLTElementProcessor contentHandler, int type) {
        this.m_classObject = classObject;
        this.m_type = type;
        this.setElementProcessor(contentHandler);
    }

    XSLTElementDef(XSLTSchema schema, String namespace, String name, String nameAlias, XSLTElementDef[] elements, XSLTAttributeDef[] attributes, XSLTElementProcessor contentHandler, Class classObject) {
        this.build(namespace, name, nameAlias, elements, attributes, contentHandler, classObject);
        if (namespace != null && (namespace.equals("http://www.w3.org/1999/XSL/Transform") || namespace.equals("http://xml.apache.org/xslt"))) {
            schema.addAvailableElement(new QName(namespace, name));
            if (nameAlias != null) {
                schema.addAvailableElement(new QName(namespace, nameAlias));
            }
        }
    }

    private boolean QNameEquals(String uri, String localName) {
        return XSLTElementDef.equalsMayBeNullOrZeroLen(this.m_namespace, uri) && (XSLTElementDef.equalsMayBeNullOrZeroLen(this.m_name, localName) || XSLTElementDef.equalsMayBeNullOrZeroLen(this.m_nameAlias, localName));
    }

    void build(String namespace, String name, String nameAlias, XSLTElementDef[] elements, XSLTAttributeDef[] attributes, XSLTElementProcessor contentHandler, Class classObject) {
        this.m_namespace = namespace;
        this.m_name = name;
        this.m_nameAlias = nameAlias;
        this.m_elements = elements;
        this.m_attributes = attributes;
        this.setElementProcessor(contentHandler);
        this.m_classObject = classObject;
    }

    private static boolean equalsMayBeNull(Object obj1, Object obj2) {
        return obj2 == obj1 || obj1 != null && obj2 != null && obj2.equals(obj1);
    }

    private static boolean equalsMayBeNullOrZeroLen(String s1, String s2) {
        int len2;
        int len1 = s1 == null ? 0 : s1.length();
        int n2 = len2 = s2 == null ? 0 : s2.length();
        return len1 != len2 ? false : (len1 == 0 ? true : s1.equals(s2));
    }

    XSLTAttributeDef getAttributeDef(String uri, String localName) {
        XSLTAttributeDef defaultDef = null;
        XSLTAttributeDef[] attrDefs = this.getAttributes();
        int nAttrDefs = attrDefs.length;
        int k2 = 0;
        while (k2 < nAttrDefs) {
            XSLTAttributeDef attrDef = attrDefs[k2];
            String uriDef = attrDef.getNamespace();
            String nameDef = attrDef.getName();
            if (nameDef.equals("*") && (XSLTElementDef.equalsMayBeNullOrZeroLen(uri, uriDef) || uriDef != null && uri.length() > 0 && uriDef.equals("*"))) {
                return attrDef;
            }
            if (nameDef.equals("*") && uriDef == null) {
                defaultDef = attrDef;
            } else if (XSLTElementDef.equalsMayBeNullOrZeroLen(uri, uriDef) && localName.equals(nameDef)) {
                return attrDef;
            }
            ++k2;
        }
        if (defaultDef == null && uri.length() > 0 && !XSLTElementDef.equalsMayBeNullOrZeroLen(uri, "http://www.w3.org/1999/XSL/Transform")) {
            return XSLTAttributeDef.m_foreignAttr;
        }
        return defaultDef;
    }

    XSLTAttributeDef[] getAttributes() {
        return this.m_attributes;
    }

    Class getClassObject() {
        return this.m_classObject;
    }

    XSLTElementProcessor getElementProcessor() {
        return this.m_elementProcessor;
    }

    XSLTElementDef[] getElements() {
        return this.m_elements;
    }

    String getName() {
        return this.m_name;
    }

    String getNameAlias() {
        return this.m_nameAlias;
    }

    String getNamespace() {
        return this.m_namespace;
    }

    XSLTElementProcessor getProcessorFor(String uri, String localName) {
        XSLTElementProcessor lreDef = null;
        if (this.m_elements == null) {
            return null;
        }
        int n2 = this.m_elements.length;
        int i2 = 0;
        while (i2 < n2) {
            XSLTElementDef def = this.m_elements[i2];
            if (def.m_name.equals("*")) {
                if (!XSLTElementDef.equalsMayBeNullOrZeroLen(uri, "http://www.w3.org/1999/XSL/Transform")) {
                    lreDef = def.m_elementProcessor;
                }
            } else if (def.QNameEquals(uri, localName)) {
                return def.m_elementProcessor;
            }
            ++i2;
        }
        return lreDef;
    }

    XSLTElementProcessor getProcessorForUnknown(String uri, String localName) {
        if (this.m_elements == null) {
            return null;
        }
        int n2 = this.m_elements.length;
        int i2 = 0;
        while (i2 < n2) {
            XSLTElementDef def = this.m_elements[i2];
            if (def.m_name.equals("unknown") && uri.length() > 0) {
                return def.m_elementProcessor;
            }
            ++i2;
        }
        return null;
    }

    int getType() {
        return this.m_type;
    }

    void setElementProcessor(XSLTElementProcessor handler) {
        if (handler != null) {
            this.m_elementProcessor = handler;
            this.m_elementProcessor.setElemDef(this);
        }
    }

    void setElements(XSLTElementDef[] defs) {
        this.m_elements = defs;
    }

    void setType(int t2) {
        this.m_type = t2;
    }
}

