/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.processor;

import java.util.EmptyStackException;
import java.util.Stack;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.TemplatesHandler;
import org.apache.xalan.processor.ProcessorStylesheetElement;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.apache.xalan.processor.XSLTElementDef;
import org.apache.xalan.processor.XSLTElementProcessor;
import org.apache.xalan.processor.XSLTSchema;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.FuncDocument;
import org.apache.xalan.templates.FuncFormatNumb;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xml.utils.BoolStack;
import org.apache.xml.utils.NodeConsumer;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xml.utils.XMLCharacterRecognizer;
import org.apache.xpath.XPath;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.functions.Function2Args;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class StylesheetHandler
extends DefaultHandler
implements TemplatesHandler,
PrefixResolver,
NodeConsumer {
    private static boolean m_xpathFunctionsInited = false;
    private int m_stylesheetLevel = -1;
    private boolean m_parsingComplete = false;
    private Vector m_prefixMappings = new Vector();
    private boolean m_shouldProcess = true;
    private String m_fragmentIDString;
    private int m_elementID = 0;
    private int m_fragmentID = 0;
    private TransformerFactoryImpl m_stylesheetProcessor;
    static final int STYPE_ROOT = 1;
    static final int STYPE_INCLUDE = 2;
    static final int STYPE_IMPORT = 3;
    private int m_stylesheetType = 1;
    private Stack m_stylesheets = new Stack();
    StylesheetRoot m_stylesheetRoot;
    Stylesheet m_lastPoppedStylesheet;
    private Stack m_processors = new Stack();
    private XSLTSchema m_schema = new XSLTSchema();
    private Stack m_elems = new Stack();
    private int m_docOrderCount = 0;
    private boolean m_foundNotImport = false;
    private static XSLMessages m_XSLMessages = new XSLMessages();
    Stack m_baseIdentifiers = new Stack();
    private Stack m_stylesheetLocatorStack = new Stack();
    private Stack m_importStack = new Stack();
    private boolean warnedAboutOldXSLTNamespace = false;
    Stack m_nsSupportStack = new Stack();
    private Node m_originatingNode;
    private BoolStack m_spacePreserveStack = new BoolStack();

    public StylesheetHandler(TransformerFactoryImpl processor) throws TransformerConfigurationException {
        this.init(processor);
    }

    private void assertion(boolean condition, String msg) throws RuntimeException {
        if (!condition) {
            throw new RuntimeException(msg);
        }
    }

    public void characters(char[] ch2, int start, int length) throws SAXException {
        if (!this.m_shouldProcess) {
            return;
        }
        XSLTElementProcessor elemProcessor = this.getCurrentProcessor();
        XSLTElementDef def = elemProcessor.getElemDef();
        if (def.getType() != 2) {
            elemProcessor = def.getProcessorFor(null, "text()");
        }
        if (elemProcessor == null) {
            if (!XMLCharacterRecognizer.isWhiteSpace(ch2, start, length)) {
                this.error("Non-whitespace text is not allowed in this position in the stylesheet!", null);
            }
        } else {
            elemProcessor.characters(this, ch2, start, length);
        }
    }

    private void checkForFragmentID(Attributes attributes) {
        if (!this.m_shouldProcess && attributes != null && this.m_fragmentIDString != null) {
            int n2 = attributes.getLength();
            int i2 = 0;
            while (i2 < n2) {
                String val;
                String type = attributes.getType(i2);
                if (type.equalsIgnoreCase("ID") && (val = attributes.getValue(i2)).equalsIgnoreCase(this.m_fragmentIDString)) {
                    this.m_shouldProcess = true;
                    this.m_fragmentID = this.m_elementID;
                }
                ++i2;
            }
        }
    }

    XPath createMatchPatternXPath(String str) throws TransformerException {
        ErrorListener handler = this.m_stylesheetProcessor.getErrorListener();
        return new XPath(str, this.getLocator(), this, 1, handler);
    }

    public XPath createXPath(String str) throws TransformerException {
        ErrorListener handler = this.m_stylesheetProcessor.getErrorListener();
        return new XPath(str, this.getLocator(), this, 0, handler);
    }

    public void endDocument() throws SAXException {
        try {
            if (this.getStylesheetRoot() != null) {
                if (this.m_stylesheetLevel == 0) {
                    this.getStylesheetRoot().recompose();
                }
            } else {
                throw new TransformerException("Did not find the stylesheet root!");
            }
            XSLTElementProcessor elemProcessor = this.getCurrentProcessor();
            if (elemProcessor != null) {
                elemProcessor.startNonText(this);
            }
            --this.m_stylesheetLevel;
            this.popSpaceHandling();
            this.m_parsingComplete = this.m_stylesheetLevel < 0;
        }
        catch (TransformerException te) {
            throw new SAXException(te);
        }
    }

    public void endElement(String uri, String localName, String rawName) throws SAXException {
        --this.m_elementID;
        if (!this.m_shouldProcess) {
            return;
        }
        if (this.m_elementID + 1 == this.m_fragmentID) {
            this.m_shouldProcess = false;
        }
        this.flushCharacters();
        this.popSpaceHandling();
        XSLTElementProcessor p2 = this.getCurrentProcessor();
        p2.endElement(this, uri, localName, rawName);
        this.popProcessor();
        this.getNamespaceSupport().popContext();
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    protected void error(int msg, Object[] args, Exception e10) throws SAXException {
        String formattedMsg = XSLMessages.createMessage(msg, args);
        this.error(formattedMsg, e10);
    }

    protected void error(String msg, Exception e10) throws SAXException {
        SAXSourceLocator locator = this.getLocator();
        ErrorListener handler = this.m_stylesheetProcessor.getErrorListener();
        TransformerException pe = !(e10 instanceof TransformerException) ? (e10 == null ? new TransformerException(msg, locator) : new TransformerException(msg, locator, e10)) : (TransformerException)e10;
        if (handler != null) {
            try {
                handler.error(pe);
            }
            catch (TransformerException te) {
                throw new SAXException(te);
            }
        } else {
            throw new SAXException(pe);
        }
    }

    public void error(SAXParseException e10) throws SAXException {
        String formattedMsg = e10.getMessage();
        SAXSourceLocator locator = this.getLocator();
        ErrorListener handler = this.m_stylesheetProcessor.getErrorListener();
        try {
            handler.error(new TransformerException(formattedMsg, locator));
        }
        catch (TransformerException te) {
            throw new SAXException(te);
        }
    }

    public void fatalError(SAXParseException e10) throws SAXException {
        String formattedMsg = e10.getMessage();
        SAXSourceLocator locator = this.getLocator();
        ErrorListener handler = this.m_stylesheetProcessor.getErrorListener();
        try {
            handler.fatalError(new TransformerException(formattedMsg, locator));
        }
        catch (TransformerException te) {
            throw new SAXException(te);
        }
    }

    private void flushCharacters() throws SAXException {
        XSLTElementProcessor elemProcessor = this.getCurrentProcessor();
        if (elemProcessor != null) {
            elemProcessor.startNonText(this);
        }
    }

    public String getBaseIdentifier() {
        String base = this.m_baseIdentifiers.isEmpty() ? null : this.m_baseIdentifiers.peek();
        if (base == null) {
            SAXSourceLocator locator = this.getLocator();
            base = locator == null ? "" : locator.getSystemId();
        }
        return base;
    }

    XSLTElementProcessor getCurrentProcessor() {
        return (XSLTElementProcessor)this.m_processors.peek();
    }

    ElemTemplateElement getElemTemplateElement() {
        try {
            return (ElemTemplateElement)this.m_elems.peek();
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    Stylesheet getLastPoppedStylesheet() {
        return this.m_lastPoppedStylesheet;
    }

    public SAXSourceLocator getLocator() {
        if (this.m_stylesheetLocatorStack.isEmpty()) {
            SAXSourceLocator locator = new SAXSourceLocator();
            locator.setSystemId(this.getStylesheetProcessor().getDOMsystemID());
            return locator;
        }
        return (SAXSourceLocator)this.m_stylesheetLocatorStack.peek();
    }

    public String getNamespaceForPrefix(String prefix) {
        return this.getNamespaceSupport().getURI(prefix);
    }

    public String getNamespaceForPrefix(String prefix, Node context) {
        this.assertion(true, "can't process a context node in StylesheetHandler!");
        return null;
    }

    NamespaceSupport getNamespaceSupport() {
        return (NamespaceSupport)this.m_nsSupportStack.peek();
    }

    public Node getOriginatingNode() {
        return this.m_originatingNode;
    }

    XSLTElementProcessor getProcessorFor(String uri, String localName, String rawName) throws SAXException {
        XSLTElementProcessor currentProcessor = this.getCurrentProcessor();
        XSLTElementDef def = currentProcessor.getElemDef();
        XSLTElementProcessor elemProcessor = def.getProcessorFor(uri, localName);
        if (elemProcessor == null && (this.getStylesheet() == null || Double.valueOf(this.getStylesheet().getVersion()) > 1.0 || currentProcessor instanceof ProcessorStylesheetElement)) {
            elemProcessor = def.getProcessorForUnknown(uri, localName);
        }
        if (elemProcessor == null) {
            this.error(String.valueOf(rawName) + " is not allowed in this position in the stylesheet!", null);
        }
        return elemProcessor;
    }

    XSLTSchema getSchema() {
        return this.m_schema;
    }

    Stylesheet getStylesheet() {
        return this.m_stylesheets.size() == 0 ? null : (Stylesheet)this.m_stylesheets.peek();
    }

    TransformerFactoryImpl getStylesheetProcessor() {
        return this.m_stylesheetProcessor;
    }

    public StylesheetRoot getStylesheetRoot() {
        return this.m_stylesheetRoot;
    }

    int getStylesheetType() {
        return this.m_stylesheetType;
    }

    public String getSystemId() {
        return this.getBaseIdentifier();
    }

    public Templates getTemplates() {
        return this.getStylesheetRoot();
    }

    XSLMessages getXSLMessages() {
        return m_XSLMessages;
    }

    public void ignorableWhitespace(char[] ch2, int start, int length) throws SAXException {
        if (!this.m_shouldProcess) {
            return;
        }
        this.getCurrentProcessor().ignorableWhitespace(this, ch2, start, length);
    }

    boolean importStackContains(String hrefUrl) {
        return this.stackContains(this.m_importStack, hrefUrl);
    }

    void init(TransformerFactoryImpl processor) {
        if (!m_xpathFunctionsInited) {
            StylesheetHandler stylesheetHandler = this;
            synchronized (stylesheetHandler) {
                if (!m_xpathFunctionsInited) {
                    m_xpathFunctionsInited = true;
                    Function2Args func = new FuncDocument();
                    FunctionTable.installFunction("document", func);
                    func = new FuncFormatNumb();
                    FunctionTable.installFunction("format-number", func);
                }
            }
        }
        this.m_stylesheetProcessor = processor;
        this.m_processors.push(this.m_schema.getElementProcessor());
        this.pushNewNamespaceSupport();
    }

    boolean isSpacePreserve() {
        return this.m_spacePreserveStack.peek();
    }

    public boolean isStylesheetParsingComplete() {
        return this.m_parsingComplete;
    }

    int nextUid() {
        return this.m_docOrderCount++;
    }

    public void notationDecl(String name, String publicId, String systemId) {
        this.getCurrentProcessor().notationDecl(this, name, publicId, systemId);
    }

    String popBaseIndentifier() {
        return (String)this.m_baseIdentifiers.pop();
    }

    ElemTemplateElement popElemTemplateElement() {
        return (ElemTemplateElement)this.m_elems.pop();
    }

    String popImportURL() {
        return (String)this.m_importStack.pop();
    }

    void popNamespaceSupport() {
        this.m_nsSupportStack.pop();
    }

    XSLTElementProcessor popProcessor() {
        return (XSLTElementProcessor)this.m_processors.pop();
    }

    void popSpaceHandling() {
        this.m_spacePreserveStack.pop();
    }

    Stylesheet popStylesheet() {
        if (!this.m_stylesheetLocatorStack.isEmpty()) {
            this.m_stylesheetLocatorStack.pop();
        }
        if (!this.m_stylesheets.isEmpty()) {
            this.m_lastPoppedStylesheet = (Stylesheet)this.m_stylesheets.pop();
        }
        return this.m_lastPoppedStylesheet;
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (!this.m_shouldProcess) {
            return;
        }
        this.flushCharacters();
        this.getCurrentProcessor().processingInstruction(this, target, data);
    }

    void pushBaseIndentifier(String baseID) {
        if (baseID != null) {
            int posOfHash = baseID.indexOf(35);
            if (posOfHash > -1) {
                this.m_fragmentIDString = baseID.substring(posOfHash + 1);
                this.m_shouldProcess = false;
            } else {
                this.m_shouldProcess = true;
            }
        } else {
            this.m_shouldProcess = true;
        }
        this.m_baseIdentifiers.push(baseID);
    }

    void pushElemTemplateElement(ElemTemplateElement elem) {
        if (elem.getUid() == -1) {
            elem.setUid(this.nextUid());
        }
        this.m_elems.push(elem);
    }

    void pushImportURL(String hrefUrl) {
        this.m_importStack.push(hrefUrl);
    }

    void pushNewNamespaceSupport() {
        this.m_nsSupportStack.push(new NamespaceSupport());
    }

    void pushProcessor(XSLTElementProcessor processor) {
        this.m_processors.push(processor);
    }

    void pushSpaceHandling(Attributes attrs) throws SAXParseException {
        String value = attrs.getValue("xml:space");
        if (value == null) {
            this.m_spacePreserveStack.push(this.m_spacePreserveStack.peek());
        } else if (value.equals("preserve")) {
            this.m_spacePreserveStack.push(true);
        } else if (value.equals("default")) {
            this.m_spacePreserveStack.push(false);
        } else {
            SAXSourceLocator locator = this.getLocator();
            ErrorListener handler = this.m_stylesheetProcessor.getErrorListener();
            try {
                handler.error(new TransformerException("Illegal value for xml:space", locator));
            }
            catch (TransformerException te) {
                throw new SAXParseException(te.getMessage(), locator, te);
            }
            this.m_spacePreserveStack.push(this.m_spacePreserveStack.peek());
        }
    }

    void pushSpaceHandling(boolean b10) throws SAXParseException {
        this.m_spacePreserveStack.push(b10);
    }

    public void pushStylesheet(Stylesheet s2) {
        if (this.m_stylesheets.size() == 0) {
            this.m_stylesheetRoot = (StylesheetRoot)s2;
        }
        this.m_stylesheets.push(s2);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return this.getCurrentProcessor().resolveEntity(this, publicId, systemId);
    }

    public void setDocumentLocator(Locator locator) {
        this.m_stylesheetLocatorStack.push(new SAXSourceLocator(locator));
    }

    public void setOriginatingNode(Node n2) {
        this.m_originatingNode = n2;
    }

    void setStylesheetType(int type) {
        this.m_stylesheetType = type;
    }

    public void setSystemId(String baseID) {
        this.pushBaseIndentifier(baseID);
    }

    public void skippedEntity(String name) throws SAXException {
        if (!this.m_shouldProcess) {
            return;
        }
        this.getCurrentProcessor().skippedEntity(this, name);
    }

    private boolean stackContains(Stack stack, String url) {
        int n2 = stack.size();
        boolean contains = false;
        int i2 = 0;
        while (i2 < n2) {
            String url2 = (String)stack.elementAt(i2);
            if (url2.equals(url)) {
                contains = true;
                break;
            }
            ++i2;
        }
        return contains;
    }

    public void startDocument() throws SAXException {
        ++this.m_stylesheetLevel;
        this.pushSpaceHandling(false);
    }

    public void startElement(String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        NamespaceSupport nssupport = this.getNamespaceSupport();
        nssupport.pushContext();
        int n2 = this.m_prefixMappings.size();
        int i2 = 0;
        while (i2 < n2) {
            String prefix = (String)this.m_prefixMappings.elementAt(i2++);
            String nsURI = (String)this.m_prefixMappings.elementAt(i2);
            nssupport.declarePrefix(prefix, nsURI);
            ++i2;
        }
        this.m_prefixMappings.removeAllElements();
        ++this.m_elementID;
        this.checkForFragmentID(attributes);
        if (!this.m_shouldProcess) {
            return;
        }
        this.flushCharacters();
        this.pushSpaceHandling(attributes);
        XSLTElementProcessor elemProcessor = this.getProcessorFor(uri, localName, rawName);
        this.pushProcessor(elemProcessor);
        elemProcessor.startElement(this, uri, localName, rawName, attributes);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.m_prefixMappings.addElement(prefix);
        this.m_prefixMappings.addElement(uri);
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) {
        this.getCurrentProcessor().unparsedEntityDecl(this, name, publicId, systemId, notationName);
    }

    public void warn(int msg, Object[] args) throws SAXException {
        String formattedMsg = XSLMessages.createWarning(msg, args);
        SAXSourceLocator locator = this.getLocator();
        ErrorListener handler = this.m_stylesheetProcessor.getErrorListener();
        try {
            if (handler != null) {
                handler.warning(new TransformerException(formattedMsg, locator));
            }
        }
        catch (TransformerException te) {
            throw new SAXException(te);
        }
    }

    public void warning(SAXParseException e10) throws SAXException {
        String formattedMsg = e10.getMessage();
        SAXSourceLocator locator = this.getLocator();
        ErrorListener handler = this.m_stylesheetProcessor.getErrorListener();
        try {
            handler.warning(new TransformerException(formattedMsg, locator));
        }
        catch (TransformerException te) {
            throw new SAXException(te);
        }
    }
}

