/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.processor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Templates;
import org.apache.xalan.templates.Stylesheet;

public class CompiledStylesheetBundle {
    static void createBundle(Stylesheet root, Vector compiledTemplates) {
        String outdir = "." + File.separator;
        try {
            ZipEntry ze;
            String zipname = null;
            String systemID = root.getSystemId();
            if (systemID != null) {
                int namestart = systemID.lastIndexOf(47) + 1;
                int nameend = systemID.lastIndexOf(35, namestart);
                if (nameend < 0) {
                    nameend = systemID.length();
                }
                if (namestart < nameend) {
                    zipname = systemID.substring(namestart, nameend);
                }
            }
            if (zipname == null) {
                zipname = "UnidentifiedStylesheet";
            }
            FileOutputStream f2 = new FileOutputStream(String.valueOf(outdir) + zipname + ".xsb");
            ZipOutputStream zf = new ZipOutputStream(f2);
            zf.setMethod(8);
            byte[] buffer = new byte[4096];
            int i2 = compiledTemplates.size() - 1;
            while (i2 >= 0) {
                Class<?> c10 = compiledTemplates.elementAt(i2).getClass();
                String fullname = c10.getName();
                int start = fullname.lastIndexOf(".");
                String packagename = fullname.substring(0, start);
                String shortname = fullname.substring(start + 1);
                String sink = String.valueOf(CompiledStylesheetBundle.packageNameToDirectory(packagename, "", '/')) + shortname + ".class";
                ze = new ZipEntry(sink);
                zf.putNextEntry(ze);
                String source = String.valueOf(CompiledStylesheetBundle.packageNameToDirectory(packagename, outdir, File.separatorChar)) + shortname + ".class";
                FileInputStream fis = new FileInputStream(source);
                int count = 0;
                int got = 1;
                while (got >= 0) {
                    got = ((InputStream)fis).read(buffer);
                    if (got <= 0) continue;
                    zf.write(buffer, 0, got);
                    count += got;
                }
                ((InputStream)fis).close();
                ze.setSize(count);
                zf.closeEntry();
                --i2;
            }
            ze = new ZipEntry("Stylesheet.ser");
            zf.putNextEntry(ze);
            ObjectOutputStream of = new ObjectOutputStream(zf);
            of.writeObject(root);
            of.flush();
            zf.closeEntry();
            zf.finish();
            ((FilterOutputStream)zf).flush();
            zf.close();
            f2.flush();
            f2.close();
        }
        catch (IOException e10) {
            System.err.println("Exception while bundling compiled stylesheet");
            e10.printStackTrace(System.err);
        }
    }

    public Templates loadBundle(String filename) throws IOException, ClassNotFoundException {
        InputStream is = null;
        ObjectInputStream os = null;
        Templates ss = null;
        try {
            ZipfileClassLoader cl2 = new ZipfileClassLoader(filename, false);
            is = ((ClassLoader)cl2).getResourceAsStream("Stylesheet.ser");
            os = new ClassLoaderObjectInputStream(cl2, is);
            ss = (Templates)os.readObject();
        }
        finally {
            Object var6_6 = null;
            if (os != null) {
                os.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return ss;
    }

    static String packageNameToDirectory(String packagename, String baseLocation, char separator) {
        int fnstart = baseLocation.lastIndexOf(separator);
        StringBuffer subdir = new StringBuffer(fnstart >= 0 ? baseLocation.substring(0, fnstart + 1) : "");
        subdir.append(packagename.replace('.', separator)).append(separator);
        return subdir.toString();
    }

    class ZipfileClassLoader
    extends ClassLoader {
        ZipFile zip = null;
        Hashtable cache;

        public ZipfileClassLoader(String filename, boolean cached) throws IOException {
            this.zip = new ZipFile(filename);
            if (cached) {
                this.cache = new Hashtable();
            }
        }

        public Class findClass(String name) {
            Class<?> c10;
            block2: {
                c10 = null;
                try {
                    this.getClass();
                    c10 = Class.forName(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    byte[] b10 = this.loadClassData(name);
                    if (b10 == null) break block2;
                    c10 = this.defineClass(name, b10, 0, b10.length);
                }
            }
            return c10;
        }

        public InputStream getResourceAsStream(String name) {
            InputStream is = null;
            try {
                ZipEntry entry = this.zip.getEntry(name);
                is = this.zip.getInputStream(entry);
            }
            catch (IOException e10) {
                System.err.println("Problem loading compiled stylesheet");
                e10.printStackTrace();
            }
            return is;
        }

        public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class c10;
            Class clazz = c10 = this.cache == null ? null : (Class)this.cache.get(name);
            if (c10 == null) {
                c10 = this.findClass(name);
                if (c10 != null && resolve) {
                    this.resolveClass(c10);
                }
                if (this.cache != null) {
                    this.cache.put(name, c10);
                }
            }
            return c10;
        }

        private byte[] loadClassData(String name) {
            int start = name.lastIndexOf(".");
            String packagename = name.substring(0, start);
            String shortname = name.substring(start + 1);
            String fn = String.valueOf(CompiledStylesheetBundle.packageNameToDirectory(packagename, "", '/')) + shortname + ".class";
            byte[] data = null;
            try {
                ZipEntry entry = this.zip.getEntry(fn);
                if (entry != null) {
                    int bufsize = (int)entry.getSize();
                    data = new byte[bufsize];
                    InputStream is = this.zip.getInputStream(entry);
                    int len = 0;
                    int off = 0;
                    while (off < bufsize) {
                        len = is.read(data, off, bufsize - off);
                        off += len;
                    }
                    is.close();
                }
            }
            catch (IOException e10) {
                System.err.println("Exception while reloading compiled stylesheet");
                e10.printStackTrace(System.err);
            }
            return data;
        }
    }

    class ClassLoaderObjectInputStream
    extends ObjectInputStream {
        ClassLoader cl;

        public ClassLoaderObjectInputStream(ClassLoader cl2, InputStream is) throws IOException {
            super(is);
            this.cl = cl2;
        }

        protected Class resolveClass(ObjectStreamClass v2) throws IOException, ClassNotFoundException {
            return this.cl.loadClass(v2.getName());
        }
    }
}

