/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib.sql;

import java.sql.ResultSetMetaData;
import org.apache.xalan.lib.sql.ColumnAttribute;
import org.apache.xalan.lib.sql.Row;
import org.apache.xalan.lib.sql.RowSet;
import org.apache.xalan.lib.sql.StreamableNode;
import org.apache.xalan.lib.sql.XStatement;
import org.apache.xpath.patterns.NodeTest;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ColumnHeader
extends StreamableNode
implements NamedNodeMap {
    private static final boolean DEBUG = false;
    int m_columnIndex;
    ResultSetMetaData m_metaData;
    RowSet m_parent;
    ColumnAttribute[] m_attributes = null;

    public ColumnHeader(XStatement statement, RowSet parent, int columnIndex, ResultSetMetaData metaData) {
        super(statement);
        this.m_columnIndex = columnIndex;
        this.m_metaData = metaData;
        this.m_parent = parent;
    }

    private ColumnAttribute allocAttr(int pos, String name) {
        if (this.m_attributes[pos] == null) {
            ColumnAttribute attr = new ColumnAttribute(this.getXStatement(), this, this.m_columnIndex, pos, this.m_metaData);
            attr.m_name = name;
            this.m_attributes[pos] = attr;
        }
        return this.m_attributes[pos];
    }

    private void allocAttrs() {
        this.m_attributes = new ColumnAttribute[16];
    }

    public NamedNodeMap getAttributes() {
        return this;
    }

    public Node getFirstChild() {
        return null;
    }

    public int getLength() {
        return 16;
    }

    public Node getNamedItem(String name) {
        int pos;
        if (this.m_attributes == null) {
            this.allocAttrs();
        }
        if ((pos = ColumnAttribute.getAttrPosFromName(name)) >= 0) {
            return this.allocAttr(pos, name);
        }
        return null;
    }

    public Node getNamedItemNS(String namespaceURI, String localName) {
        if (namespaceURI == null) {
            return this.getNamedItem(localName);
        }
        return null;
    }

    public Node getNextSibling() {
        NodeTest nt = this.getNodeTest();
        if (!(nt != null && nt.getNamespace() != null || nt != null && !nt.getLocalName().equals("column-header"))) {
            int nextIndex = this.m_columnIndex + 1;
            if (nextIndex < this.m_parent.m_columnHeaders.length) {
                if (this.m_parent.m_columnHeaders[nextIndex] == null) {
                    this.m_parent.m_columnHeaders[nextIndex] = new ColumnHeader(this.getXStatement(), this.m_parent, nextIndex, this.m_metaData);
                }
                return this.m_parent.m_columnHeaders[nextIndex];
            }
            if (nt == null) {
                return new Row(this.getXStatement(), this.m_parent);
            }
            return null;
        }
        return null;
    }

    public String getNodeName() {
        return "column-header";
    }

    public Node getParentNode() {
        return this.m_parent;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public Node item(int index) {
        String name;
        if (this.m_attributes == null) {
            this.allocAttrs();
        }
        if ((name = ColumnAttribute.getAttrNameFromPos(index)) != null) {
            return this.allocAttr(index, name);
        }
        return null;
    }

    public Node removeNamedItem(String name) throws DOMException {
        this.error(80);
        return null;
    }

    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        this.error(80);
        return null;
    }

    public Node setNamedItem(Node arg) throws DOMException {
        this.error(80);
        return null;
    }

    public Node setNamedItemNS(Node arg) throws DOMException {
        this.error(80);
        return null;
    }
}

