/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.Hashtable;
import java.util.Stack;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.VariableInfo;
import org.apache.jasper.compiler.GeneratorBase;
import org.apache.jasper.compiler.ServletWriter;

abstract class TagGeneratorBase
extends GeneratorBase {
    private Stack tagHandlerStack;
    private Hashtable tagVarNumbers;

    TagGeneratorBase() {
    }

    protected void declareVariables(ServletWriter writer, VariableInfo[] vi, TagVariableInfo[] tvi, TagData tagData, boolean declare, boolean update, int scope) {
        block9: {
            block8: {
                if (vi == null) break block8;
                int i2 = 0;
                while (i2 < vi.length) {
                    if (vi[i2].getScope() == scope) {
                        if (vi[i2].getDeclare() && declare) {
                            writer.println(String.valueOf(vi[i2].getClassName()) + " " + vi[i2].getVarName() + " = null;");
                        }
                        if (update) {
                            writer.println(String.valueOf(vi[i2].getVarName()) + " = (" + vi[i2].getClassName() + ") pageContext.findAttribute(" + writer.quoteString(vi[i2].getVarName()) + ");");
                        }
                    }
                    ++i2;
                }
                break block9;
            }
            if (tvi == null) break block9;
            int i3 = 0;
            while (i3 < tvi.length) {
                String name = tvi[i3].getNameGiven() != null ? tvi[i3].getNameGiven() : tagData.getAttributeString(tvi[i3].getNameFromAttribute());
                if (tvi[i3].getScope() == scope) {
                    if (tvi[i3].getDeclare() && declare) {
                        writer.println(String.valueOf(tvi[i3].getClassName()) + " " + name + " = null;");
                    }
                    if (update) {
                        writer.println(String.valueOf(name) + " = (" + tvi[i3].getClassName() + ") pageContext.findAttribute(" + writer.quoteString(name) + ");");
                    }
                }
                ++i3;
            }
        }
    }

    protected String getTagVarName(String prefix, String shortTagName) {
        Hashtable hashtable = this.tagVarNumbers;
        synchronized (hashtable) {
            String tag = String.valueOf(prefix) + ":" + shortTagName;
            String varName = String.valueOf(prefix) + "_" + shortTagName + "_";
            if (this.tagVarNumbers.get(tag) != null) {
                Integer i2 = (Integer)this.tagVarNumbers.get(tag);
                varName = String.valueOf(varName) + i2;
                this.tagVarNumbers.put(tag, new Integer(i2 + 1));
                String string = varName;
                Object var5_9 = null;
                return string;
            }
            this.tagVarNumbers.put(tag, new Integer(1));
            String string = String.valueOf(varName) + "0";
            Object var5_10 = null;
            return string;
        }
    }

    protected void setTagHandlerStack(Stack tagHandlerStack) {
        this.tagHandlerStack = tagHandlerStack;
    }

    protected void setTagVarNumbers(Hashtable tagVarNumbers) {
        this.tagVarNumbers = tagVarNumbers;
    }

    protected void tagBegin(TagVariableData tvd) {
        this.tagHandlerStack.push(tvd);
    }

    protected TagVariableData tagEnd() {
        return (TagVariableData)this.tagHandlerStack.pop();
    }

    protected TagVariableData topTag() {
        if (this.tagHandlerStack.empty()) {
            return null;
        }
        return (TagVariableData)this.tagHandlerStack.peek();
    }

    class TagVariableData {
        String tagHandlerInstanceName;
        String tagEvalVarName;

        TagVariableData(String tagHandlerInstanceName, String tagEvalVarName) {
            this.tagHandlerInstanceName = tagHandlerInstanceName;
            this.tagEvalVarName = tagEvalVarName;
        }
    }
}

