/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.VariableInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.CompileException;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ServiceMethodPhase;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.compiler.TagCache;
import org.apache.jasper.compiler.TagGeneratorBase;
import org.apache.jasper.compiler.TagLibraries;
import org.xml.sax.Attributes;

public class TagBeginGenerator
extends TagGeneratorBase
implements ServiceMethodPhase {
    String prefix;
    String shortTagName;
    Attributes attrs;
    TagLibraryInfo tli;
    TagInfo ti;
    TagAttributeInfo[] attributes;
    String baseVarName;
    String thVarName;
    TagCache tc;
    TagData tagData;
    Mark start;
    TagLibraries libraries;
    boolean hasBody;
    boolean isXml;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$javax$servlet$jsp$tagext$BodyTag;

    public TagBeginGenerator(Mark start, String prefix, String shortTagName, Attributes attrs, TagLibraryInfo tli, TagInfo ti, TagLibraries libraries, Stack tagHandlerStack, Hashtable tagVarNumbers, boolean hasBody, boolean isXml) throws JasperException {
        this.setTagHandlerStack(tagHandlerStack);
        this.setTagVarNumbers(tagVarNumbers);
        this.prefix = prefix;
        this.shortTagName = shortTagName;
        this.attrs = attrs;
        this.tli = tli;
        this.ti = ti;
        this.attributes = ti.getAttributes();
        this.baseVarName = this.getTagVarName(prefix, shortTagName);
        this.thVarName = "_jspx_th_" + this.baseVarName;
        this.start = start;
        this.libraries = libraries;
        this.hasBody = hasBody;
        this.isXml = isXml;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public String convertString(Class c10, String s2, ServletWriter writer, String attrName, Class propertyEditorClass) throws JasperException {
        if (propertyEditorClass != null) {
            return "(" + c10.getName() + ")JspRuntimeLibrary.getValueFromBeanInfoPropertyEditor(" + c10.getName() + ".class, \"" + attrName + "\", " + writer.quoteString(s2) + ", " + propertyEditorClass.getName() + ".class)";
        }
        if (c10 == (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = TagBeginGenerator.class$("java.lang.String")))) {
            return writer.quoteString(s2);
        }
        if (c10 == Boolean.TYPE) {
            return Boolean.valueOf(s2).toString();
        }
        if (c10 == (class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = TagBeginGenerator.class$("java.lang.Boolean")))) {
            return "new Boolean(" + Boolean.valueOf(s2).toString() + ")";
        }
        if (c10 == Byte.TYPE) {
            return "((byte)" + Byte.valueOf(s2).toString() + ")";
        }
        if (c10 == (class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = TagBeginGenerator.class$("java.lang.Byte")))) {
            return "new Byte((byte)" + Byte.valueOf(s2).toString() + ")";
        }
        if (c10 == Character.TYPE) {
            if (s2.length() > 1) {
                char ch2 = s2.charAt(0);
                return "((char) " + ch2 + ")";
            }
            throw new NumberFormatException(Constants.getString("jsp.error.bad_string_char", new Object[0]));
        }
        if (c10 == (class$java$lang$Character != null ? class$java$lang$Character : (class$java$lang$Character = TagBeginGenerator.class$("java.lang.Character")))) {
            if (s2.length() > 1) {
                char ch3 = s2.charAt(0);
                return "new Character((char) " + ch3 + ")";
            }
            throw new NumberFormatException(Constants.getString("jsp.error.bad_string_Character", new Object[0]));
        }
        if (c10 == Double.TYPE) {
            return Double.valueOf(s2).toString();
        }
        if (c10 == (class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = TagBeginGenerator.class$("java.lang.Double")))) {
            return "new Double(" + Double.valueOf(s2).toString() + ")";
        }
        if (c10 == Float.TYPE) {
            return String.valueOf(Float.valueOf(s2).toString()) + "f";
        }
        if (c10 == (class$java$lang$Float != null ? class$java$lang$Float : (class$java$lang$Float = TagBeginGenerator.class$("java.lang.Float")))) {
            return "new Float(" + Float.valueOf(s2).toString() + "f)";
        }
        if (c10 == Integer.TYPE) {
            return Integer.valueOf(s2).toString();
        }
        if (c10 == (class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = TagBeginGenerator.class$("java.lang.Integer")))) {
            return "new Integer(" + Integer.valueOf(s2).toString() + ")";
        }
        if (c10 == Short.TYPE) {
            return Short.valueOf(s2).toString();
        }
        if (c10 == (class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = TagBeginGenerator.class$("java.lang.Short")))) {
            return "new Short(" + Short.valueOf(s2).toString() + ")";
        }
        if (c10 == Long.TYPE) {
            return String.valueOf(Long.valueOf(s2).toString()) + "l";
        }
        if (c10 == (class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = TagBeginGenerator.class$("java.lang.Long")))) {
            return "new Long(" + Long.valueOf(s2).toString() + "l)";
        }
        if (c10 == (class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = TagBeginGenerator.class$("java.lang.Object")))) {
            return "new String(" + s2 + ")";
        }
        return "(" + c10.getName() + ")JspRuntimeLibrary.getValueFromPropertyEditorManager(" + c10.getName() + ".class, \"" + attrName + "\", " + writer.quoteString(s2) + ")";
    }

    public void generate(ServletWriter writer, Class phase) throws JasperException {
        this.generateServiceMethodStatements(writer);
    }

    public void generateServiceMethodStatements(ServletWriter writer) throws JasperException {
        TagGeneratorBase.TagVariableData top = this.topTag();
        String parent = top == null ? null : top.tagHandlerInstanceName;
        String evalVar = "_jspx_eval_" + this.baseVarName;
        TagBeginGenerator tagBeginGenerator = this;
        tagBeginGenerator.getClass();
        this.tagBegin(new TagGeneratorBase.TagVariableData(tagBeginGenerator, this.thVarName, evalVar));
        writer.println("/* ----  " + this.prefix + ":" + this.shortTagName + " ---- */");
        writer.println(String.valueOf(this.ti.getTagClassName()) + " " + this.thVarName + " = new " + this.ti.getTagClassName() + "();");
        this.generateSetters(writer, parent);
        VariableInfo[] vi = this.ti.getVariableInfo(this.tagData);
        TagVariableInfo[] tvi = this.ti.getTagVariableInfos();
        this.declareVariables(writer, vi, tvi, this.tagData, true, false, 1);
        writer.println("try {");
        writer.pushIndent();
        writer.println("int " + evalVar + " = " + this.thVarName + ".doStartTag();");
        boolean implementsBodyTag = (class$javax$servlet$jsp$tagext$BodyTag != null ? class$javax$servlet$jsp$tagext$BodyTag : (class$javax$servlet$jsp$tagext$BodyTag = TagBeginGenerator.class$("javax.servlet.jsp.tagext.BodyTag"))).isAssignableFrom(this.tc.getTagHandlerClass());
        this.declareVariables(writer, vi, tvi, this.tagData, false, true, 1);
        if (!implementsBodyTag) {
            writer.println("if (" + evalVar + " == BodyTag.EVAL_BODY_BUFFERED)");
            writer.pushIndent();
            writer.println("throw new JspTagException(\"Since tag handler " + this.tc.getTagHandlerClass() + " does not implement BodyTag, it can't return BodyTag.EVAL_BODY_TAG\");");
            writer.popIndent();
        }
        if (this.hasBody) {
            writer.println("if (" + evalVar + " != Tag.SKIP_BODY) {");
            writer.pushIndent();
            if (implementsBodyTag) {
                writer.println("try {");
                writer.pushIndent();
                writer.println("if (" + evalVar + " != Tag.EVAL_BODY_INCLUDE) {");
                writer.pushIndent();
                writer.println("out = pageContext.pushBody();");
                writer.println(String.valueOf(this.thVarName) + ".setBodyContent((BodyContent) out);");
                writer.popIndent();
                writer.println("}");
                writer.println(String.valueOf(this.thVarName) + ".doInitBody();");
            }
            writer.println("do {");
            writer.pushIndent();
        }
        this.declareVariables(writer, vi, tvi, this.tagData, true, true, 0);
        this.declareVariables(writer, vi, tvi, this.tagData, false, true, 1);
    }

    private final void generateSetters(ServletWriter writer, String parent) throws JasperException {
        writer.println(String.valueOf(this.thVarName) + ".setPageContext(pageContext);");
        writer.println(String.valueOf(this.thVarName) + ".setParent(" + parent + ");");
        int attrsLength = this.attrs.getLength();
        int i2 = 0;
        while (i2 < attrsLength) {
            String attrValue = this.attrs.getValue(i2);
            if (attrValue != null) {
                String attrName = this.attrs.getQName(i2);
                Method m2 = this.tc.getSetterMethod(attrName);
                if (m2 == null) {
                    throw new CompileException(this.start, Constants.getString("jsp.error.unable.to_find_method", new Object[]{attrName}));
                }
                Class<?>[] c10 = m2.getParameterTypes();
                int j2 = 0;
                while (j2 < this.attributes.length) {
                    if (this.attrs.getQName(i2).equals(this.attributes[j2].getName())) {
                        attrValue = this.attributes[j2].canBeRequestTime() && JspUtil.isExpression(attrValue, this.isXml) ? JspUtil.getExpr(attrValue, this.isXml) : this.convertString(c10[0], attrValue, writer, attrName, this.tc.getPropertyEditorClass(attrName));
                    }
                    ++j2;
                }
                writer.println(String.valueOf(this.thVarName) + "." + m2.getName() + "(" + attrValue + ");");
            }
            ++i2;
        }
    }

    public void init(JspCompilationContext ctxt) throws JasperException {
        this.validate();
        this.tc = this.libraries.getTagCache(this.prefix, this.shortTagName);
        if (this.tc == null) {
            this.tc = new TagCache(this.shortTagName);
            ClassLoader cl2 = ctxt.getClassLoader();
            Class<?> clz = null;
            try {
                clz = cl2.loadClass(this.ti.getTagClassName());
            }
            catch (Exception ex2) {
                throw new CompileException(this.start, Constants.getString("jsp.error.unable.loadclass", new Object[]{this.ti.getTagClassName(), ex2.getMessage()}));
            }
            this.tc.setTagHandlerClass(clz);
            this.libraries.putTagCache(this.prefix, this.shortTagName, this.tc);
        }
    }

    void validate() throws JasperException {
        Hashtable attribs = JspUtil.attrsToHashtable(this.attrs);
        int i2 = 0;
        while (i2 < this.attributes.length) {
            if (this.attributes[i2].isRequired() && attribs.get(this.attributes[i2].getName()) == null) {
                throw new CompileException(this.start, Constants.getString("jsp.error.missing_attribute", new Object[]{this.attributes[i2].getName(), this.shortTagName}));
            }
            ++i2;
        }
        Enumeration e10 = attribs.keys();
        while (e10.hasMoreElements()) {
            String attr = (String)e10.nextElement();
            boolean found = false;
            int i3 = 0;
            while (i3 < this.attributes.length) {
                if (attr.equals(this.attributes[i3].getName())) {
                    found = true;
                    if (this.attributes[i3].canBeRequestTime() && JspUtil.isExpression((String)attribs.get(attr), this.isXml)) {
                        attribs.put(attr, TagData.REQUEST_TIME_VALUE);
                    }
                }
                ++i3;
            }
            if (found) continue;
            throw new CompileException(this.start, Constants.getString("jsp.error.bad_attribute", new Object[]{attr}));
        }
        this.tagData = new TagData(attribs);
        if (!this.ti.isValid(this.tagData)) {
            throw new CompileException(this.start, Constants.getString("jsp.error.invalid_attributes"));
        }
    }
}

