/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.util;

import org.apache.crimson.util.XmlChars;

public class XmlNames {
    public static final String SPEC_XML_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String SPEC_XMLNS_URI = "http://www.w3.org/2000/xmlns/";

    private XmlNames() {
    }

    public static boolean isName(String value) {
        if (value == null) {
            return false;
        }
        char c10 = value.charAt(0);
        if (!XmlChars.isLetter(c10) && c10 != '_' && c10 != ':') {
            return false;
        }
        int i2 = 1;
        while (i2 < value.length()) {
            if (!XmlChars.isNameChar(value.charAt(i2))) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static boolean isUnqualifiedName(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        char c10 = value.charAt(0);
        if (!XmlChars.isLetter(c10) && c10 != '_') {
            return false;
        }
        int i2 = 1;
        while (i2 < value.length()) {
            if (!XmlChars.isNCNameChar(value.charAt(i2))) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static boolean isQualifiedName(String value) {
        if (value == null) {
            return false;
        }
        int first = value.indexOf(58);
        if (first <= 0) {
            return XmlNames.isUnqualifiedName(value);
        }
        int last = value.lastIndexOf(58);
        if (last != first) {
            return false;
        }
        return XmlNames.isUnqualifiedName(value.substring(0, first)) && XmlNames.isUnqualifiedName(value.substring(first + 1));
    }

    public static boolean isNmtoken(String token) {
        int length = token.length();
        int i2 = 0;
        while (i2 < length) {
            if (!XmlChars.isNameChar(token.charAt(i2))) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static boolean isNCNmtoken(String token) {
        return XmlNames.isNmtoken(token) && token.indexOf(58) < 0;
    }

    public static String getPrefix(String qualifiedName) {
        int index = qualifiedName.indexOf(58);
        return index <= 0 ? null : qualifiedName.substring(0, index);
    }

    public static String getLocalPart(String qualifiedName) {
        int index = qualifiedName.indexOf(58);
        if (index < 0) {
            return qualifiedName;
        }
        if (index == qualifiedName.length() - 1) {
            return null;
        }
        return qualifiedName.substring(index + 1);
    }
}

