/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util.ssi;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.catalina.util.ssi.SsiCommand;
import org.apache.catalina.util.ssi.SsiConfig;
import org.apache.catalina.util.ssi.SsiMediator;

public final class SsiFsize
extends SsiMediator
implements SsiCommand {
    private String commaFormat(String length) {
        String retString = "";
        int i2 = length.length();
        while (i2 - 1 >= 0) {
            retString = length.substring(i2 - 1, i2).concat(retString);
            if ((length.length() - (i2 - 1)) % 3 == 0 && retString.length() < length.length()) {
                retString = ",".concat(retString);
            }
            --i2;
        }
        return retString;
    }

    private String formatSize(String length, String format) {
        String retString = "";
        if (format.equalsIgnoreCase("bytes")) {
            retString = this.commaFormat(length);
        } else {
            double lParse = new Long(length).doubleValue();
            if (lParse >= 1048576.0) {
                double abbrevSize = lParse / 1048576.0;
                long splitSize = (long)abbrevSize;
                int catSize = (int)(100.0 * (abbrevSize - (double)splitSize));
                retString = String.valueOf(this.commaFormat(new Long(splitSize).toString())) + "." + catSize + " MB";
            } else if (lParse >= 1024.0) {
                double abbrevSize = lParse / 1024.0;
                long splitSize = (long)abbrevSize;
                int catSize = (int)(100.0 * (abbrevSize - (double)splitSize));
                retString = String.valueOf(this.commaFormat(new Long(splitSize).toString())) + "." + catSize + " KB";
            } else {
                retString = String.valueOf(this.commaFormat(length)) + " bytes";
            }
        }
        return retString;
    }

    public final String getStream(String[] strParamType, String[] strParam) {
        String length = "";
        String retLength = "";
        String path = "";
        URL url = null;
        long lLength = -1L;
        if (strParamType[0].equals("file")) {
            path = super.getFilePath(strParam[0]);
        } else if (strParamType[0].equals("virtual")) {
            path = super.getVirtualPath(strParam[0]);
        }
        try {
            url = SsiMediator.servletContext.getResource(path);
            lLength = url.openConnection().getContentLength();
            length = new Long(lLength).toString();
        }
        catch (MalformedURLException malformedURLException) {
            length = null;
        }
        catch (IOException iOException) {
            length = null;
        }
        catch (NullPointerException nullPointerException) {
            length = null;
        }
        retLength = length == null ? new String(super.getError()) : this.formatSize(length, ((SsiConfig)super.getCommand("config")).getSizefmt());
        return retLength;
    }

    public final boolean isModified() {
        return false;
    }

    public final boolean isPrintable() {
        return true;
    }

    public final void process(String[] strParamType, String[] strParam) {
    }
}

