/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.net.URL;
import org.apache.catalina.Deployer;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.util.StringManager;

public final class HostConfig
implements LifecycleListener {
    private String configClass = "org.apache.catalina.startup.ContextConfig";
    private String contextClass = "org.apache.catalina.core.StandardContext";
    private int debug = 0;
    private Host host = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");

    private File appBase() {
        File file = new File(this.host.getAppBase());
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.home"), this.host.getAppBase());
        }
        return file;
    }

    private void deployApps() {
        File appBase;
        if (!(this.host instanceof Deployer)) {
            return;
        }
        if (this.debug >= 1) {
            this.log(sm.getString("hostConfig.deploying"));
        }
        if (!(appBase = this.appBase()).exists() || !appBase.isDirectory()) {
            return;
        }
        String[] files = appBase.list();
        int i2 = 0;
        while (i2 < files.length) {
            if (!files[i2].equalsIgnoreCase("META-INF") && !files[i2].equalsIgnoreCase("WEB-INF")) {
                URL url;
                File dir = new File(appBase, files[i2]);
                if (dir.isDirectory()) {
                    File webInf = new File(dir, "/WEB-INF");
                    if (webInf.exists() && webInf.isDirectory() && webInf.canRead()) {
                        String contextPath = "/" + files[i2];
                        if (files[i2].equals("ROOT")) {
                            contextPath = "";
                        }
                        if (this.host.findChild(contextPath) == null) {
                            if (this.debug >= 1) {
                                this.log(sm.getString("hostConfig.deployDir", files[i2]));
                            }
                            try {
                                url = new URL("file", null, dir.getCanonicalPath());
                                ((Deployer)((Object)this.host)).install(contextPath, url);
                            }
                            catch (Throwable t2) {
                                this.log(sm.getString("hostConfig.deployDir.error", files[i2]), t2);
                            }
                        }
                    }
                } else if (files[i2].toLowerCase().endsWith(".war")) {
                    String contextPath = "/" + files[i2];
                    int period = contextPath.lastIndexOf(".");
                    if (period >= 0) {
                        contextPath = contextPath.substring(0, period);
                    }
                    if (contextPath.equals("/ROOT")) {
                        contextPath = "";
                    }
                    if (this.host.findChild(contextPath) == null) {
                        if (this.debug >= 1) {
                            this.log(sm.getString("hostConfig.deployJar", files[i2]));
                        }
                        try {
                            url = new URL("file", null, dir.getCanonicalPath());
                            url = new URL("jar:" + url.toString() + "!/");
                            ((Deployer)((Object)this.host)).install(contextPath, url);
                        }
                        catch (Throwable t3) {
                            this.log(sm.getString("hostConfig.deployJar.error", files[i2]), t3);
                        }
                    }
                }
            }
            ++i2;
        }
    }

    public String getConfigClass() {
        return this.configClass;
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public int getDebug() {
        return this.debug;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            int hostDebug;
            this.host = (Host)((Object)event.getLifecycle());
            if (this.host instanceof StandardHost && (hostDebug = ((StandardHost)this.host).getDebug()) > this.debug) {
                this.debug = hostDebug;
            }
        }
        catch (ClassCastException e10) {
            this.log(sm.getString("hostConfig.cce", event.getLifecycle()), e10);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    private void log(String message) {
        Logger logger = null;
        if (this.host != null) {
            logger = this.host.getLogger();
        }
        if (logger != null) {
            logger.log("HostConfig[" + this.host.getName() + "]: " + message);
        } else {
            System.out.println("HostConfig[" + this.host.getName() + "]: " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = null;
        if (this.host != null) {
            logger = this.host.getLogger();
        }
        if (logger != null) {
            logger.log("HostConfig[" + this.host.getName() + "] " + message, throwable);
        } else {
            System.out.println("HostConfig[" + this.host.getName() + "]: " + message);
            System.out.println(String.valueOf(String.valueOf(throwable)));
            throwable.printStackTrace(System.out);
        }
    }

    public void setConfigClass(String configClass) {
        this.configClass = configClass;
    }

    public void setContextClass(String contextClass) {
        this.contextClass = contextClass;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    private void start() {
        if (this.debug >= 1) {
            this.log(sm.getString("hostConfig.start"));
        }
        this.deployApps();
    }

    private void stop() {
        if (this.debug >= 1) {
            this.log(sm.getString("hostConfig.stop"));
        }
        this.undeployApps();
    }

    private void undeployApps() {
        if (!(this.host instanceof Deployer)) {
            return;
        }
        if (this.debug >= 1) {
            this.log(sm.getString("hostConfig.undeploying"));
        }
        String[] contextPaths = ((Deployer)((Object)this.host)).findDeployedApps();
        int i2 = 0;
        while (i2 < contextPaths.length) {
            if (this.debug >= 1) {
                this.log(sm.getString("hostConfig.undeploy", contextPaths[i2]));
            }
            try {
                ((Deployer)((Object)this.host)).remove(contextPaths[i2]);
            }
            catch (Throwable t2) {
                this.log(sm.getString("hostConfig.undeploy.error", contextPaths[i2]), t2);
            }
            ++i2;
        }
    }
}

