/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.PersistentManagerBase;
import org.apache.catalina.session.StandardSession;

public final class PersistentManager
extends PersistentManagerBase
implements Lifecycle,
PropertyChangeListener,
Runnable {
    private static final String info = "PersistentManager/1.0";
    private boolean saveOnRestart = true;
    private int maxIdleBackup = -1;
    private int minIdleSwap = -1;
    private int maxIdleSwap = -1;
    protected static String name = "PersistentManager";

    public String getInfo() {
        return info;
    }

    public int getMaxIdleBackup() {
        return this.maxIdleBackup;
    }

    public int getMaxIdleSwap() {
        return this.maxIdleSwap;
    }

    public int getMinIdleSwap() {
        return this.minIdleSwap;
    }

    public String getName() {
        return name;
    }

    public boolean getSaveOnRestart() {
        return this.saveOnRestart;
    }

    private void processMaxActiveSwaps() {
        if (!this.isStarted() || this.getMaxActiveSessions() < 0) {
            return;
        }
        Session[] sessions = this.findSessions();
        if (this.getMaxActiveSessions() >= sessions.length) {
            return;
        }
        if (this.debug > 0) {
            this.log(ManagerBase.sm.getString("persistentManager.tooManyActive", new Integer(sessions.length)));
        }
        int toswap = sessions.length - this.getMaxActiveSessions();
        long timeNow = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < sessions.length && toswap > 0) {
            int timeIdle = (int)((timeNow - sessions[i2].getLastAccessedTime()) / 1000L);
            if (timeIdle > this.minIdleSwap) {
                if (this.debug > 1) {
                    this.log(ManagerBase.sm.getString("persistentManager.swapTooManyActive", sessions[i2].getId(), new Integer(timeIdle)));
                }
                try {
                    this.swapOut(sessions[i2]);
                }
                catch (IOException iOException) {}
                --toswap;
            }
            ++i2;
        }
    }

    private void processMaxIdleBackups() {
        if (!this.isStarted() || this.maxIdleBackup < 0) {
            return;
        }
        Session[] sessions = this.findSessions();
        long timeNow = System.currentTimeMillis();
        if (this.maxIdleBackup >= 0) {
            int i2 = 0;
            while (i2 < sessions.length) {
                int timeIdle;
                StandardSession session = (StandardSession)sessions[i2];
                if (session.isValid() && (timeIdle = (int)((timeNow - session.getLastAccessedTime()) / 1000L)) > this.maxIdleBackup) {
                    if (this.debug > 1) {
                        this.log(ManagerBase.sm.getString("persistentManager.backupMaxIdle", session.getId(), new Integer(timeIdle)));
                    }
                    try {
                        this.writeSession(session);
                    }
                    catch (IOException iOException) {}
                }
                ++i2;
            }
        }
    }

    private void processMaxIdleSwaps() {
        if (!this.isStarted() || this.maxIdleSwap < 0) {
            return;
        }
        Session[] sessions = this.findSessions();
        long timeNow = System.currentTimeMillis();
        if (this.maxIdleSwap >= 0) {
            int i2 = 0;
            while (i2 < sessions.length) {
                int timeIdle;
                StandardSession session = (StandardSession)sessions[i2];
                if (session.isValid() && (timeIdle = (int)((timeNow - session.getLastAccessedTime()) / 1000L)) > this.maxIdleSwap && timeIdle > this.minIdleSwap) {
                    if (this.debug > 1) {
                        this.log(ManagerBase.sm.getString("persistentManager.swapMaxIdle", session.getId(), new Integer(timeIdle)));
                    }
                    try {
                        this.swapOut(session);
                    }
                    catch (IOException iOException) {}
                }
                ++i2;
            }
        }
    }

    public void processPersistenceChecks() {
        this.processMaxIdleSwaps();
        this.processMaxActiveSwaps();
        this.processMaxIdleBackups();
    }

    public void setMaxIdleBackup(int backup) {
        if (backup == this.maxIdleBackup) {
            return;
        }
        int oldBackup = this.maxIdleBackup;
        this.maxIdleBackup = backup;
        this.support.firePropertyChange("maxIdleBackup", new Integer(oldBackup), new Integer(this.maxIdleBackup));
    }

    public void setMaxIdleSwap(int max) {
        if (max == this.maxIdleSwap) {
            return;
        }
        int oldMaxIdleSwap = this.maxIdleSwap;
        this.maxIdleSwap = max;
        this.support.firePropertyChange("maxIdleSwap", new Integer(oldMaxIdleSwap), new Integer(this.maxIdleSwap));
    }

    public void setMinIdleSwap(int min) {
        if (this.minIdleSwap == min) {
            return;
        }
        int oldMinIdleSwap = this.minIdleSwap;
        this.minIdleSwap = min;
        this.support.firePropertyChange("minIdleSwap", new Integer(oldMinIdleSwap), new Integer(this.minIdleSwap));
    }

    public void setSaveOnRestart(boolean saveOnRestart) {
        if (saveOnRestart == this.saveOnRestart) {
            return;
        }
        boolean oldSaveOnRestart = this.saveOnRestart;
        this.saveOnRestart = saveOnRestart;
        this.support.firePropertyChange("saveOnRestart", new Boolean(oldSaveOnRestart), new Boolean(this.saveOnRestart));
    }

    public void stop() throws LifecycleException {
        if (this.debug >= 1) {
            this.log("Stopping");
        }
        if (!this.isStarted()) {
            throw new LifecycleException(ManagerBase.sm.getString("standardManager.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.setStarted(false);
        this.threadStop();
        if (this.getStore() != null && this.saveOnRestart) {
            this.unload();
        } else {
            Session[] sessions = this.findSessions();
            int i2 = 0;
            while (i2 < sessions.length) {
                StandardSession session = (StandardSession)sessions[i2];
                if (session.isValid()) {
                    session.expire();
                }
                ++i2;
            }
        }
        if (this.getStore() != null && this.getStore() instanceof Lifecycle) {
            ((Lifecycle)((Object)this.getStore())).stop();
        }
        this.random = null;
    }
}

