/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.ValveContext;
import org.apache.catalina.authenticator.SingleSignOnEntry;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

public class SingleSignOn
extends ValveBase {
    protected HashMap cache = new HashMap();
    protected int debug = 0;
    protected static String info = "org.apache.catalina.authenticator.SingleSignOn";
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.authenticator");

    public void deregister(String cookie) {
        this.log("Deregistering cookie value '" + cookie + "'");
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            this.cache.remove(cookie);
        }
    }

    public int getDebug() {
        return this.debug;
    }

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response, ValveContext context) throws IOException, ServletException {
        SingleSignOnEntry entry;
        if (!(request instanceof HttpRequest) || !(response instanceof HttpResponse)) {
            context.invokeNext(request, response);
            return;
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        if (this.debug >= 1) {
            this.log("Process request for '" + hreq.getRequestURI() + "'");
        }
        if (hreq.getUserPrincipal() != null) {
            if (this.debug >= 1) {
                this.log(" Principal '" + hreq.getUserPrincipal().getName() + "' has already been authenticated");
            }
            context.invokeNext(request, response);
            return;
        }
        if (this.debug >= 1) {
            this.log(" Checking for SSO cookie");
        }
        Cookie cookie = null;
        Cookie[] cookies = hreq.getCookies();
        if (cookies == null) {
            cookies = new Cookie[]{};
        }
        int i2 = 0;
        while (i2 < cookies.length) {
            if ("JSESSIONIDSSO".equals(cookies[i2].getName())) {
                cookie = cookies[i2];
                break;
            }
            ++i2;
        }
        if (cookie == null) {
            if (this.debug >= 1) {
                this.log(" SSO cookie is not present");
            }
            context.invokeNext(request, response);
            return;
        }
        if (this.debug >= 1) {
            this.log(" Checking for cached principal");
        }
        if ((entry = this.lookup(cookie.getValue())) != null) {
            if (this.debug >= 1) {
                this.log(" Found cached principal '" + entry.principal.getName() + "' with auth type '" + entry.authType + "'");
            }
            ((HttpRequest)request).setAuthType(entry.authType);
            ((HttpRequest)request).setUserPrincipal(entry.principal);
        } else if (this.debug >= 1) {
            this.log(" No cached principal found");
        }
        context.invokeNext(request, response);
    }

    protected void log(String message) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(String.valueOf(this.toString()) + ": " + message);
        } else {
            System.out.println(String.valueOf(this.toString()) + ": " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(String.valueOf(this.toString()) + ": " + message, throwable);
        } else {
            System.out.println(String.valueOf(this.toString()) + ": " + message);
            throwable.printStackTrace(System.out);
        }
    }

    protected SingleSignOnEntry lookup(String cookie) {
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            SingleSignOnEntry singleSignOnEntry = (SingleSignOnEntry)this.cache.get(cookie);
            Object var4_4 = null;
            return singleSignOnEntry;
        }
    }

    public void register(String cookie, Principal principal, String authType) {
        if (this.debug >= 1) {
            this.log("Registering cookie value '" + cookie + "' for user '" + principal.getName() + "' with auth type '" + authType + "'");
        }
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            this.cache.put(cookie, new SingleSignOnEntry(principal, authType));
        }
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SingleSignOn[");
        sb.append(this.container.getName());
        sb.append("]");
        return sb.toString();
    }
}

