/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import java.io.Serializable;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.security.auth.AuthPermission;
import javax.security.auth.Debug;
import javax.security.auth.Policy;
import javax.security.auth.Subject;

public class SubjectDomainCombiner
implements DomainCombiner {
    private static Policy policy;
    private Subject subject;
    private Hashtable cachedProtectionDomains = new Hashtable();
    private static boolean checkedCacheProperty;
    private static boolean allowCaching;
    private static final AllPermission ALL_PERMISSION;
    private static final Debug debug;

    public SubjectDomainCombiner(Subject subject) {
        this.subject = subject;
        if (policy == null) {
            policy = Policy.getPolicy();
        }
        if (!checkedCacheProperty) {
            allowCaching = this.cachePolicy();
            checkedCacheProperty = true;
        }
    }

    public Subject getSubject() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("getSubjectFromDomainCombiner"));
        }
        return this.subject;
    }

    public ProtectionDomain[] combine(ProtectionDomain[] protectionDomainArray, ProtectionDomain[] protectionDomainArray2) {
        if (protectionDomainArray == null || protectionDomainArray.length == 0) {
            return this.optimize(protectionDomainArray2);
        }
        if (debug != null) {
            if (this.subject == null) {
                debug.println("null subject");
            } else {
                final Subject subject = this.subject;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        debug.println(subject.toString());
                        return null;
                    }
                });
            }
            this.printInputDomains(protectionDomainArray, protectionDomainArray2);
        }
        if (!allowCaching) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    policy.refresh();
                    return null;
                }
            });
        }
        protectionDomainArray = this.optimize(protectionDomainArray);
        protectionDomainArray2 = this.optimize(protectionDomainArray2);
        if (debug != null) {
            debug.println("after optimize");
            this.printInputDomains(protectionDomainArray, protectionDomainArray2);
        }
        if (protectionDomainArray == null && protectionDomainArray2 == null) {
            return null;
        }
        int n2 = protectionDomainArray == null ? 0 : protectionDomainArray.length;
        int n3 = protectionDomainArray2 == null ? 0 : protectionDomainArray2.length;
        ProtectionDomain[] protectionDomainArray3 = new ProtectionDomain[n2 + n3];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            CodeSource codeSource = protectionDomainArray[n5].getCodeSource();
            ProtectionDomain protectionDomain = null;
            CacheEntry cacheEntry = new CacheEntry(this.subject, codeSource);
            protectionDomain = (ProtectionDomain)this.cachedProtectionDomains.get(cacheEntry);
            if (protectionDomain == null) {
                Serializable serializable;
                Permissions permissions = new Permissions();
                Enumeration<Permission> enumeration = protectionDomainArray[n5].getPermissions().elements();
                while (enumeration.hasMoreElements()) {
                    serializable = enumeration.nextElement();
                    permissions.add((Permission)serializable);
                }
                serializable = null;
                final CodeSource codeSource2 = codeSource;
                final Subject subject = this.subject;
                serializable = (PermissionCollection)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return policy.getPermissions(subject, codeSource2);
                    }
                });
                enumeration = ((PermissionCollection)serializable).elements();
                while (enumeration.hasMoreElements()) {
                    Permission permission = enumeration.nextElement();
                    if (permissions.implies(permission)) continue;
                    permissions.add(permission);
                }
                protectionDomain = new ProtectionDomain(codeSource, permissions);
            }
            protectionDomainArray3[n4++] = protectionDomain;
            if (allowCaching) {
                this.cachedProtectionDomains.put(cacheEntry, protectionDomain);
            }
            ++n5;
        }
        if (debug != null) {
            debug.println("updated current: ");
            if (n4 == 0) {
                debug.println("\tkept nothing");
            } else {
                int n6 = 0;
                while (n6 < n4) {
                    debug.println("\tupdated[" + n6 + "] = " + protectionDomainArray3[n6]);
                    ++n6;
                }
            }
        }
        if (n3 > 0) {
            System.arraycopy(protectionDomainArray2, 0, protectionDomainArray3, n4, n3);
        }
        protectionDomainArray3 = this.optimize(protectionDomainArray3);
        if (debug != null) {
            if (protectionDomainArray3 == null || protectionDomainArray3.length == 0) {
                debug.println("returning null");
            } else {
                debug.println("combinedDomains: ");
                int n7 = 0;
                while (n7 < protectionDomainArray3.length) {
                    debug.println("newDomain " + n7 + ": " + protectionDomainArray3[n7].toString());
                    ++n7;
                }
            }
        }
        if (protectionDomainArray3 == null || protectionDomainArray3.length == 0) {
            return null;
        }
        return protectionDomainArray3;
    }

    ProtectionDomain[] optimize(ProtectionDomain[] protectionDomainArray) {
        if (protectionDomainArray == null) {
            return null;
        }
        ProtectionDomain[] protectionDomainArray2 = new ProtectionDomain[protectionDomainArray.length];
        int n2 = 0;
        int n3 = 0;
        while (n3 < protectionDomainArray.length) {
            if (protectionDomainArray[n3] != null) {
                boolean bl2 = false;
                int n4 = 0;
                while (n4 < n2) {
                    if (protectionDomainArray2[n4] == protectionDomainArray[n3]) {
                        bl2 = true;
                        break;
                    }
                    ++n4;
                }
                if (!bl2) {
                    protectionDomainArray2[n2++] = protectionDomainArray[n3];
                }
            }
            ++n3;
        }
        if (n2 < protectionDomainArray.length) {
            ProtectionDomain[] protectionDomainArray3 = new ProtectionDomain[n2];
            System.arraycopy(protectionDomainArray2, 0, protectionDomainArray3, 0, protectionDomainArray3.length);
            protectionDomainArray2 = protectionDomainArray3;
        }
        return protectionDomainArray2.length == 0 ? null : protectionDomainArray2;
    }

    private boolean cachePolicy() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty("cache.auth.policy");
            }
        });
        if (string != null) {
            Boolean bl2 = new Boolean(string);
            return bl2;
        }
        return true;
    }

    private void printInputDomains(ProtectionDomain[] protectionDomainArray, ProtectionDomain[] protectionDomainArray2) {
        int n2;
        if (protectionDomainArray == null || protectionDomainArray.length == 0) {
            debug.println("currentDomains null or 0 length");
        } else {
            n2 = 0;
            while (protectionDomainArray != null && n2 < protectionDomainArray.length) {
                if (protectionDomainArray[n2] == null) {
                    debug.println("currentDomain " + n2 + ": SystemDomain");
                } else {
                    debug.println("currentDomain " + n2 + ": " + protectionDomainArray[n2].toString());
                }
                ++n2;
            }
        }
        if (protectionDomainArray2 == null || protectionDomainArray2.length == 0) {
            debug.println("assignedDomains null or 0 length");
        } else {
            debug.println("assignedDomains = ");
            n2 = 0;
            while (protectionDomainArray2 != null && n2 < protectionDomainArray2.length) {
                if (protectionDomainArray2[n2] == null) {
                    debug.println("assignedDomain " + n2 + ": SystemDomain");
                } else {
                    debug.println("assignedDomain " + n2 + ": " + protectionDomainArray2[n2].toString());
                }
                ++n2;
            }
        }
    }

    static {
        checkedCacheProperty = false;
        allowCaching = true;
        ALL_PERMISSION = new AllPermission();
        debug = Debug.getInstance("combiner", "\t[SubjectDomainCombiner]");
    }

    private class CacheEntry {
        private Subject subject;
        private CodeSource codesource;

        public CacheEntry(Subject subject, CodeSource codeSource) {
            this.subject = subject;
            this.codesource = codeSource;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (object instanceof CacheEntry) {
                CacheEntry cacheEntry = (CacheEntry)object;
                if ((this.codesource == null && cacheEntry.codesource == null || this.codesource != null && cacheEntry.codesource != null && this.codesource.equals(cacheEntry.codesource)) && (this.subject == null && cacheEntry.subject == null || this.subject != null && cacheEntry.subject != null && this.subject.getPrincipals().containsAll(cacheEntry.subject.getPrincipals()) && cacheEntry.subject.getPrincipals().containsAll(this.subject.getPrincipals()))) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            if (this.codesource != null) {
                return this.codesource.hashCode();
            }
            if (this.subject == null) {
                return 0;
            }
            return this.subject.hashCode();
        }
    }
}

