/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;

public final class PrivateCredentialPermission
extends Permission {
    private static final ResourceBundle rb = ResourceBundle.getBundle("com.sun.security.auth.Resources");
    private String credentialClass;
    private Set principals;
    private boolean testing = false;

    private static void main(String[] stringArray) {
        int n2;
        LinkedList<PrivateCredentialPermission> linkedList = new LinkedList<PrivateCredentialPermission>();
        PrivateCredentialPermission privateCredentialPermission = new PrivateCredentialPermission("a.b.c d.e.f \"charlie\"", "read");
        linkedList.add(privateCredentialPermission);
        privateCredentialPermission = new PrivateCredentialPermission("a.b.c a \"lai\" d.e.f \"charlie\"", "read");
        System.out.println("pcp.credentialClass = " + privateCredentialPermission.getCredentialClass());
        String[][] stringArray2 = privateCredentialPermission.getPrincipals();
        int n3 = 0;
        while (n3 < stringArray2.length) {
            n2 = 0;
            while (n2 < 2) {
                System.out.println("pArray[" + n3 + "][" + n2 + "] = " + stringArray2[n3][n2]);
                ++n2;
            }
            ++n3;
        }
        linkedList.add(privateCredentialPermission);
        n2 = 0;
        while (n2 < stringArray.length) {
            privateCredentialPermission = new PrivateCredentialPermission(stringArray[n2], "read");
            linkedList.add(privateCredentialPermission);
            ++n2;
        }
        if (linkedList.size() % 2 != 0) {
            privateCredentialPermission = new PrivateCredentialPermission(" none none \"none\"", "read");
            linkedList.add(privateCredentialPermission);
        }
        ListIterator listIterator = linkedList.listIterator(0);
        while (listIterator.hasNext()) {
            PrivateCredentialPermission privateCredentialPermission2 = (PrivateCredentialPermission)listIterator.next();
            PrivateCredentialPermission privateCredentialPermission3 = (PrivateCredentialPermission)listIterator.next();
            System.out.println("p1.implies(p2): " + privateCredentialPermission2.implies(privateCredentialPermission3));
        }
    }

    static String buildTarget(String string, Set set) {
        if (string == null || set == null || set.size() == 0) {
            throw new IllegalArgumentException(rb.getString("invalid null input(s)"));
        }
        String string2 = string;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Principal principal = (Principal)iterator.next();
            string2 = string2 + " " + principal.getClass().getName() + " \"" + principal.getName() + "\"";
        }
        return string2;
    }

    Set getPrincipalSet() {
        return this.principals;
    }

    PrivateCredentialPermission(String string, Set set) {
        super(string);
        this.credentialClass = string;
        this.principals = set;
    }

    public PrivateCredentialPermission(String string, String string2) {
        super(string);
        if (!"read".equalsIgnoreCase(string2)) {
            throw new IllegalArgumentException(rb.getString("actions can only be 'read'"));
        }
        this.init(string);
    }

    public String getCredentialClass() {
        return this.credentialClass;
    }

    public String[][] getPrincipals() {
        if (this.principals == null) {
            return new String[0][0];
        }
        String[][] stringArray = new String[this.principals.size()][2];
        Iterator iterator = this.principals.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            CredOwner credOwner = (CredOwner)iterator.next();
            stringArray[n2][0] = credOwner.principalClass;
            stringArray[n2][1] = credOwner.principalName;
            ++n2;
        }
        return stringArray;
    }

    public boolean implies(Permission permission) {
        if (permission == null || !(permission instanceof PrivateCredentialPermission)) {
            return false;
        }
        PrivateCredentialPermission privateCredentialPermission = (PrivateCredentialPermission)permission;
        if (!this.impliesCredentialClass(this.credentialClass, privateCredentialPermission.getCredentialClass())) {
            return false;
        }
        return this.impliesPrincipalSet(this.principals, privateCredentialPermission.getPrincipalSet());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PrivateCredentialPermission)) {
            return false;
        }
        PrivateCredentialPermission privateCredentialPermission = (PrivateCredentialPermission)object;
        return this.getName().equalsIgnoreCase(privateCredentialPermission.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getActions() {
        return "read";
    }

    public PermissionCollection newPermissionCollection() {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private void init(String var1_1) {
        this.principals = new HashSet<E>();
        var2_2 = new StringTokenizer(var1_1, " ", false);
        var3_3 = null;
        var4_4 = null;
        if (this.testing) {
            System.out.println("whole name = " + var1_1);
        }
        this.credentialClass = var2_2.nextToken();
        if (this.testing) {
            System.out.println("Credential Class = " + this.credentialClass);
        }
        if (var2_2.hasMoreTokens()) ** GOTO lbl36
        throw new IllegalArgumentException(PrivateCredentialPermission.rb.getString("permission name [") + var1_1 + PrivateCredentialPermission.rb.getString("] syntax invalid: ") + PrivateCredentialPermission.rb.getString("Credential Class not followed by a ") + PrivateCredentialPermission.rb.getString("Principal Class and Name"));
lbl-1000:
        // 1 sources

        {
            var3_3 = var2_2.nextToken();
            if (this.testing) {
                System.out.println("    Principal Class = " + var3_3);
            }
            if (!var2_2.hasMoreTokens()) {
                throw new IllegalArgumentException(PrivateCredentialPermission.rb.getString("permission name [") + var1_1 + PrivateCredentialPermission.rb.getString("] syntax invalid: ") + PrivateCredentialPermission.rb.getString("Principal Class not followed by a ") + PrivateCredentialPermission.rb.getString("Principal Name"));
            }
            var4_4 = var2_2.nextToken();
            if (!var4_4.startsWith("\"")) {
                throw new IllegalArgumentException(PrivateCredentialPermission.rb.getString("permission name [") + var1_1 + PrivateCredentialPermission.rb.getString("] syntax invalid: ") + PrivateCredentialPermission.rb.getString("Principal Name must be surrounded by quotes"));
            }
            if (!var4_4.endsWith("\"")) {
                while (var2_2.hasMoreTokens()) {
                    if ((var4_4 = var4_4 + " " + var2_2.nextToken()).endsWith("\"")) break;
                }
                if (!var4_4.endsWith("\"")) {
                    throw new IllegalArgumentException(PrivateCredentialPermission.rb.getString("permission name [") + var1_1 + PrivateCredentialPermission.rb.getString("] syntax invalid: ") + PrivateCredentialPermission.rb.getString("Principal Name missing end quote"));
                }
            }
            if (this.testing) {
                System.out.println("\tprincipalName = '" + var4_4 + "'");
            }
            var4_4 = var4_4.substring(1, var4_4.length() - 1);
            if (var3_3.equals("*") && !var4_4.equals("*")) {
                throw new IllegalArgumentException(PrivateCredentialPermission.rb.getString("PrivateCredentialPermission ") + PrivateCredentialPermission.rb.getString("Principal Class can not be a ") + PrivateCredentialPermission.rb.getString("wildcard (*) value if Principal Name ") + PrivateCredentialPermission.rb.getString("is not a wildcard (*) value"));
            }
            if (this.testing) {
                System.out.println("\tprincipalName = '" + var4_4 + "'");
            }
            var5_5 = new CredOwner(var3_3, var4_4);
            this.principals.add(var5_5);
lbl36:
            // 2 sources

            ** while (var2_2.hasMoreTokens())
        }
lbl37:
        // 1 sources

    }

    private boolean impliesCredentialClass(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (this.testing) {
            System.out.println("credential class comparison: " + string + "/" + string2);
        }
        if (string.equals("*")) {
            return true;
        }
        return string.equals(string2);
    }

    private boolean impliesPrincipalSet(Set set, Set set2) {
        Object object;
        Iterator iterator;
        if (set == null || set2 == null) {
            return false;
        }
        if (this.testing) {
            iterator = set.iterator();
            int n2 = 0;
            while (n2 < set.size()) {
                object = (CredOwner)iterator.next();
                System.out.println("this permission set [" + n2 + "]= " + ((CredOwner)object).toString());
                ++n2;
            }
        }
        if (set2.size() == 0) {
            return true;
        }
        if (set.size() == 0) {
            return false;
        }
        iterator = set.iterator();
        while (iterator.hasNext()) {
            CredOwner credOwner = (CredOwner)iterator.next();
            object = set2.iterator();
            boolean bl2 = false;
            while (object.hasNext()) {
                CredOwner credOwner2 = (CredOwner)object.next();
                if (!credOwner.implies(credOwner2)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            return false;
        }
        return true;
    }

    class CredOwner
    implements Serializable {
        String principalClass;
        String principalName;

        CredOwner(String string, String string2) {
            this.principalClass = string;
            this.principalName = string2;
        }

        public boolean implies(Object object) {
            if (object == null || !(object instanceof CredOwner)) {
                return false;
            }
            CredOwner credOwner = (CredOwner)object;
            if (PrivateCredentialPermission.this.testing) {
                System.out.println("principal comparison:\n\t" + this.principalClass + "/" + credOwner.principalClass + "\n\t" + this.principalName + "/" + credOwner.principalName);
            }
            return !(!this.principalClass.equals("*") && !this.principalClass.equals(credOwner.principalClass) || !this.principalName.equals("*") && !this.principalName.equals(credOwner.principalName));
        }

        public String toString() {
            return rb.getString("CredOwner:\n\t") + rb.getString("Principal Class = ") + this.principalClass + rb.getString("\n\t") + rb.getString("Principal Name = ") + this.principalName;
        }
    }
}

