/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.log.Log;
import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManagerFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.catalina.net.ServerSocketFactory;

public class SSLSocketFactory
implements ServerSocketFactory {
    private static final boolean clientAuth = false;
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$web$security$SSLSocketFactory == null ? (class$com$sun$web$security$SSLSocketFactory = SSLSocketFactory.class$("com.sun.web.security.SSLSocketFactory")) : class$com$sun$web$security$SSLSocketFactory);
    private SSLContext context = null;
    private SSLServerSocketFactory factory = null;
    private String[] cipherSuites;
    private static KeyManagerFactory keyManagerFactory = null;
    private static TrustManagerFactory trustManagerFactory = null;
    static /* synthetic */ Class class$com$sun$web$security$SSLSocketFactory;

    public SSLSocketFactory() {
        try {
            if (keyManagerFactory == null || trustManagerFactory == null) {
                SSLUtils.initKeyStore();
            }
            this.context = SSLContext.getInstance("TLS");
            KeyManagerFactory kmf = keyManagerFactory;
            TrustManagerFactory tmf = trustManagerFactory;
            this.context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            this.factory = this.context.getServerSocketFactory();
            this.cipherSuites = this.factory.getSupportedCipherSuites();
        }
        catch (Exception e10) {
            Log.err.print(e10);
            System.out.println(e10.getMessage());
        }
    }

    public ServerSocket createSocket(int port) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.factory.createServerSocket(port);
        this.init(socket);
        return socket;
    }

    private void init(SSLServerSocket socket) {
        socket.setNeedClientAuth(false);
    }

    public ServerSocket createSocket(int port, int backlog) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.factory.createServerSocket(port, backlog);
        this.init(socket);
        return socket;
    }

    public ServerSocket createSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.factory.createServerSocket(port, backlog, ifAddress);
        this.init(socket);
        return socket;
    }

    public static void setFactories(KeyManagerFactory k2, TrustManagerFactory t2) {
        keyManagerFactory = k2;
        trustManagerFactory = t2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

