/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.deployment.web.WebComponentDescriptor;
import com.sun.enterprise.security.LoginContext;
import com.sun.enterprise.security.LoginException;
import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.catalina.realm.RealmBase;

public class RealmAdapter
extends RealmBase {
    public static final String SECURITY_CONTEXT = "SecurityContext";
    public static final String BASIC = "BASIC";
    public static final String FORM = "FORM";
    public static final String CERT = "CLIENT-CERT";
    private static final boolean debug = false;
    private static int MAX_COUNT = 5;
    private static int SLEEP_TIME = 5000;
    private String realm = "default";
    private LoginContext lc = null;
    private RoleMapper mapper = null;
    private String authMethod = "BASIC";
    private WebBundleDescriptor webDesc = null;
    protected static final String name = "J2EE-RI-RealmAdapter";
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$PasswordCredential;
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$X509CertificateCredential;

    public RealmAdapter(WebBundleDescriptor descriptor) {
        this.webDesc = descriptor;
        this.lc = this.initLoginContext();
        this.mapper = descriptor.getApplication().getRoleMapper();
        LoginConfiguration loginConfig = descriptor.getLoginConfiguration();
        if (loginConfig != null) {
            this.authMethod = loginConfig.getAuthenticationMethod();
        }
    }

    public WebBundleDescriptor getWebDescriptor() {
        return this.webDesc;
    }

    public boolean hasRole(Principal principal, String role) {
        return this.mapper.hasRole(principal, role);
    }

    public Principal authenticate(String username, String password) {
        return this.authenticate(username, password.getBytes());
    }

    public Principal authenticate(String username, byte[] authData) {
        PrincipalImpl p2 = null;
        SecurityContext sc = SecurityContext.getCurrent();
        if (sc != null) {
            this.lc.clear();
        }
        if (this.authenticate(username, null, authData)) {
            p2 = new PrincipalImpl(username);
        }
        return p2;
    }

    protected boolean authenticate(String username, String authmethod, byte[] authData) {
        this.lc.setRealmName(this.realm);
        if (authmethod != null) {
            this.lc.setAuthenticationMethod(authmethod);
        }
        SecurityContext.setCurrent(null);
        try {
            Class c10;
            Subject s2;
            if (this.lc != null) {
                final Subject fs = s2 = new Subject();
                c10 = null;
                if (!this.authMethod.equals(CERT)) {
                    final PasswordCredential pc = new PasswordCredential(username, new String(authData), this.realm);
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            fs.getPrivateCredentials().add(pc);
                            return null;
                        }
                    });
                    s2 = fs;
                    c10 = class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (class$com$sun$enterprise$security$auth$login$PasswordCredential = RealmAdapter.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : class$com$sun$enterprise$security$auth$login$PasswordCredential;
                } else {
                    c10 = class$com$sun$enterprise$security$auth$login$X509CertificateCredential == null ? (class$com$sun$enterprise$security$auth$login$X509CertificateCredential = RealmAdapter.class$("com.sun.enterprise.security.auth.login.X509CertificateCredential")) : class$com$sun$enterprise$security$auth$login$X509CertificateCredential;
                }
            } else {
                return false;
            }
            this.lc.login(s2, c10);
        }
        catch (LoginException le) {
            le.printStackTrace();
            return false;
        }
        return true;
    }

    public void preSetRunAsIdentity(ComponentInvocation inv) {
        SecurityContext old = null;
        String runAs = this.getRunAsPrincipal(this.webDesc);
        if (runAs != null) {
            old = this.getSecurityContext();
            inv.setOldSecurityContext(old);
            this.loginForRunAs(runAs);
        }
    }

    public void postSetRunAsIdentity(ComponentInvocation inv) {
        String runAs = this.getRunAsPrincipal(this.webDesc);
        if (runAs != null) {
            this.setSecurityContext(inv.getOldSecurityContext());
        }
    }

    private void loginForRunAs(String principal) {
        try {
            this.lc.loginPrincipalForWebRunAs(principal);
        }
        catch (LoginException e10) {
            e10.printStackTrace();
        }
    }

    private SecurityContext getSecurityContext() {
        return SecurityContext.getCurrent();
    }

    private void setSecurityContext(SecurityContext sc) {
        SecurityContext.setCurrent(sc);
    }

    private LoginContext initLoginContext() {
        LoginContext lc = null;
        int i2 = 0;
        while (i2 < MAX_COUNT) {
            try {
                lc = new LoginContext();
                lc.setRealmName(this.realm);
                break;
            }
            catch (Exception e10) {
                e10.printStackTrace();
                try {
                    Thread.sleep(SLEEP_TIME);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                ++i2;
            }
        }
        return lc;
    }

    protected String getPassword(String username) {
        return null;
    }

    protected Principal getPrincipal(String username) {
        return null;
    }

    public String getRunAsPrincipal(WebBundleDescriptor wbd) {
        String prin = null;
        Set s2 = wbd.getWebComponentDescriptorsSet();
        Iterator itr = s2.iterator();
        while (itr.hasNext()) {
            WebComponentDescriptor wcd = (WebComponentDescriptor)itr.next();
            RunAsIdentityDescriptor raid = wcd.getRunAsIdentity();
            if (raid == null) continue;
            prin = raid.getPrincipal();
            return prin;
        }
        return prin;
    }

    protected String getName() {
        return name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

