/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPStore;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.ListInfo;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.MethodNotSupportedException;

public class DefaultFolder
extends IMAPFolder {
    protected DefaultFolder(IMAPStore iMAPStore) {
        super("", '\uffff', iMAPStore);
        this.exists = true;
        this.type = 2;
    }

    public String getName() {
        return this.fullName;
    }

    public Folder getParent() {
        return null;
    }

    public Folder[] list(String string) throws MessagingException {
        Folder[] folderArray;
        ListInfo[] listInfoArray = null;
        IMAPProtocol iMAPProtocol = null;
        try {
            Object var7_9;
            try {
                iMAPProtocol = this.getStoreProtocol();
                folderArray = this.lockFor(iMAPProtocol);
                synchronized (folderArray) {
                    listInfoArray = iMAPProtocol.list("", string);
                }
                var7_9 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (CommandFailedException commandFailedException) {
                var7_9 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        if (listInfoArray == null) {
            return null;
        }
        folderArray = new IMAPFolder[listInfoArray.length];
        int n2 = 0;
        while (n2 < folderArray.length) {
            folderArray[n2] = new IMAPFolder(listInfoArray[n2], (IMAPStore)this.store);
            ++n2;
        }
        return folderArray;
    }

    public Folder[] listSubscribed(String string) throws MessagingException {
        Folder[] folderArray;
        ListInfo[] listInfoArray = null;
        IMAPProtocol iMAPProtocol = null;
        try {
            Object var7_9;
            try {
                iMAPProtocol = this.getStoreProtocol();
                folderArray = this.lockFor(iMAPProtocol);
                synchronized (folderArray) {
                    listInfoArray = iMAPProtocol.lsub("", string);
                }
                var7_9 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (CommandFailedException commandFailedException) {
                var7_9 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        if (listInfoArray == null) {
            return null;
        }
        folderArray = new IMAPFolder[listInfoArray.length];
        int n2 = 0;
        while (n2 < folderArray.length) {
            folderArray[n2] = new IMAPFolder(listInfoArray[n2], (IMAPStore)this.store);
            ++n2;
        }
        return folderArray;
    }

    public boolean hasNewMessages() throws MessagingException {
        return false;
    }

    public Folder getFolder(String string) throws MessagingException {
        return new IMAPFolder(string, '\uffff', (IMAPStore)this.store);
    }

    public boolean delete(boolean bl2) throws MessagingException {
        throw new MethodNotSupportedException("Cannot delete Default Folder");
    }

    public boolean renameTo(Folder folder) throws MessagingException {
        throw new MethodNotSupportedException("Cannot rename Default Folder");
    }

    public void appendMessages(Message[] messageArray) throws MessagingException {
        throw new MethodNotSupportedException("Cannot append to Default Folder");
    }

    public Message[] expunge() throws MessagingException {
        throw new MethodNotSupportedException("Cannot expunge Default Folder");
    }
}

