/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.iap;

import com.sun.mail.iap.AString;
import com.sun.mail.iap.Atom;
import com.sun.mail.iap.Literal;
import com.sun.mail.iap.Protocol;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.util.ASCIIUtility;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class Argument {
    protected Vector items = new Vector(1);

    public void append(Argument argument) {
        this.items.ensureCapacity(this.items.size() + argument.items.size());
        int n2 = 0;
        while (n2 < argument.items.size()) {
            this.items.addElement(argument.items.elementAt(n2));
            ++n2;
        }
    }

    public void writeString(String string) {
        this.items.addElement(new AString(ASCIIUtility.getBytes(string)));
    }

    public void writeString(String string, String string2) throws UnsupportedEncodingException {
        if (string2 == null) {
            this.writeString(string);
        } else {
            this.items.addElement(new AString(string.getBytes(string2)));
        }
    }

    public void writeBytes(byte[] byArray) {
        this.items.addElement(byArray);
    }

    public void writeBytes(ByteArrayOutputStream byteArrayOutputStream) {
        this.items.addElement(byteArrayOutputStream);
    }

    public void writeBytes(Literal literal) {
        this.items.addElement(literal);
    }

    public void writeAtom(String string) {
        this.items.addElement(new Atom(string));
    }

    public void writeNumber(int n2) {
        this.items.addElement(new Integer(n2));
    }

    public void writeNumber(long l2) {
        this.items.addElement(new Long(l2));
    }

    public void writeArgument(Argument argument) {
        this.items.addElement(argument);
    }

    public void write(Protocol protocol) throws IOException, ProtocolException {
        int n2 = this.items != null ? this.items.size() : 0;
        DataOutputStream dataOutputStream = (DataOutputStream)protocol.getOutputStream();
        int n3 = 0;
        while (n3 < n2) {
            Object e10;
            if (n3 > 0) {
                dataOutputStream.write(32);
            }
            if ((e10 = this.items.elementAt(n3)) instanceof Atom) {
                dataOutputStream.writeBytes(((Atom)e10).string);
            } else if (e10 instanceof Number) {
                dataOutputStream.writeBytes(((Number)e10).toString());
            } else if (e10 instanceof AString) {
                this.astring(((AString)e10).bytes, protocol);
            } else if (e10 instanceof byte[]) {
                this.literal((byte[])e10, protocol);
            } else if (e10 instanceof ByteArrayOutputStream) {
                this.literal((ByteArrayOutputStream)e10, protocol);
            } else if (e10 instanceof Literal) {
                this.literal((Literal)e10, protocol);
            } else if (e10 instanceof Argument) {
                dataOutputStream.write(40);
                ((Argument)e10).write(protocol);
                dataOutputStream.write(41);
            }
            ++n3;
        }
    }

    private void astring(byte[] byArray, Protocol protocol) throws IOException, ProtocolException {
        byte by2;
        DataOutputStream dataOutputStream = (DataOutputStream)protocol.getOutputStream();
        int n2 = byArray.length;
        if (n2 > 1024) {
            this.literal(byArray, protocol);
            return;
        }
        boolean bl2 = n2 == 0;
        boolean bl3 = false;
        int n3 = 0;
        while (n3 < n2) {
            by2 = byArray[n3];
            if (by2 == 0 || by2 == 13 || by2 == 10 || (by2 & 0xFF) > 127) {
                this.literal(byArray, protocol);
                return;
            }
            if (by2 == 42 || by2 == 37 || by2 == 40 || by2 == 41 || by2 == 123 || by2 == 34 || by2 == 92 || (by2 & 0xFF) <= 32) {
                bl2 = true;
                if (by2 == 34 || by2 == 92) {
                    bl3 = true;
                }
            }
            ++n3;
        }
        if (bl2) {
            dataOutputStream.write(34);
        }
        if (bl3) {
            int n4 = 0;
            while (n4 < n2) {
                by2 = byArray[n4];
                if (by2 == 34 || by2 == 92) {
                    dataOutputStream.write(92);
                }
                dataOutputStream.write(by2);
                ++n4;
            }
        } else {
            dataOutputStream.write(byArray);
        }
        if (bl2) {
            dataOutputStream.write(34);
        }
    }

    private void literal(byte[] byArray, Protocol protocol) throws IOException, ProtocolException {
        DataOutputStream dataOutputStream = (DataOutputStream)protocol.getOutputStream();
        boolean bl2 = protocol.supportsNonSyncLiterals();
        dataOutputStream.write(123);
        dataOutputStream.writeBytes(Integer.toString(byArray.length));
        if (bl2) {
            dataOutputStream.writeBytes("+}\r\n");
        } else {
            dataOutputStream.writeBytes("}\r\n");
        }
        dataOutputStream.flush();
        if (!bl2) {
            Response response;
            while (!(response = protocol.readResponse()).isContinuation()) {
            }
        }
        dataOutputStream.write(byArray);
    }

    private void literal(ByteArrayOutputStream byteArrayOutputStream, Protocol protocol) throws IOException, ProtocolException {
        DataOutputStream dataOutputStream = (DataOutputStream)protocol.getOutputStream();
        boolean bl2 = protocol.supportsNonSyncLiterals();
        dataOutputStream.write(123);
        dataOutputStream.writeBytes(Integer.toString(byteArrayOutputStream.size()));
        if (bl2) {
            dataOutputStream.writeBytes("+}\r\n");
        } else {
            dataOutputStream.writeBytes("}\r\n");
        }
        dataOutputStream.flush();
        if (!bl2) {
            Response response;
            while (!(response = protocol.readResponse()).isContinuation()) {
            }
        }
        byteArrayOutputStream.writeTo(dataOutputStream);
    }

    private void literal(Literal literal, Protocol protocol) throws IOException, ProtocolException {
        DataOutputStream dataOutputStream = (DataOutputStream)protocol.getOutputStream();
        boolean bl2 = protocol.supportsNonSyncLiterals();
        dataOutputStream.write(123);
        dataOutputStream.writeBytes(Integer.toString(literal.size()));
        if (bl2) {
            dataOutputStream.writeBytes("+}\r\n");
        } else {
            dataOutputStream.writeBytes("}\r\n");
        }
        dataOutputStream.flush();
        if (!bl2) {
            Response response;
            while (!(response = protocol.readResponse()).isContinuation()) {
            }
        }
        literal.writeTo(dataOutputStream);
    }
}

