/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.CoordinatorLog;
import com.sun.jts.CosTransactions.ErrorLog;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.utils.RecoveryHooks.FailureInducer;
import java.util.Date;

class TransactionState {
    static final int STATE_NONE = 0;
    static final int STATE_ACTIVE = 1;
    static final int STATE_PREPARING = 2;
    static final int STATE_PREPARED_SUCCESS = 3;
    static final int STATE_PREPARED_FAIL = 4;
    static final int STATE_PREPARED_READONLY = 5;
    static final int STATE_COMMITTING = 6;
    static final int STATE_COMMITTED = 7;
    static final int STATE_ROLLING_BACK = 8;
    static final int STATE_ROLLED_BACK = 9;
    static final int STATE_COMMITTING_ONE_PHASE = 10;
    static final int STATE_COMMITTED_ONE_PHASE_OK = 11;
    static final int STATE_COMMIT_ONE_PHASE_ROLLED_BACK = 12;
    static final int STATE_COMMIT_ONE_PHASE_HEURISTIC_HAZARD = 13;
    static final int STATE_COMMIT_ONE_PHASE_HEURISTIC_MIXED = 14;
    GlobalTID globalTID = null;
    Long localTID = null;
    int state = 0;
    boolean subordinate = false;
    CoordinatorLog logRecord = null;
    Object logSection = null;
    static long epochNumber = new Date().getTime();
    static long sequenceNumber = 1L;
    static boolean inDoubt = false;
    String serverName = Configuration.getServerName();
    static final boolean[][] validStateChange = new boolean[][]{{false, true, false, false, false, false, false, false, true, false, false, false, false, false, false}, {false, false, true, false, false, false, false, false, true, false, true, false, false, false, false}, {false, false, false, true, true, true, false, false, true, true, false, false, false, false, false}, {false, false, false, false, false, false, true, false, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, false}, {true, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, true, false, true, true, true, true, true}, {false, false, false, false, false, false, false, true, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, true, false, false, false, false, false}, {false, false, false, false, false, false, false, true, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, true, false, false, false, false, false, false, false}};
    static final int XID_FORMAT_ID = 4871251;
    private static final String LOG_SECTION_NAME = "TS";

    TransactionState() {
    }

    TransactionState(CoordinatorLog log) {
        this.localTID = new Long(TransactionState.getSequenceNumber());
        int epoch = TransactionState.getEpochNumber();
        this.globalTID = new GlobalTID(4871251, 0, TransactionState.generateTID(this.localTID, epoch, this.serverName));
        this.state = 0;
        this.subordinate = false;
        if (log != null) {
            this.logRecord = log;
            this.logRecord.setLocalTID(this.localTID);
            this.logSection = this.logRecord.createSection(LOG_SECTION_NAME);
        }
    }

    TransactionState(GlobalTID globalTID, CoordinatorLog log) {
        this.globalTID = globalTID;
        this.localTID = new Long(TransactionState.getSequenceNumber());
        this.state = 0;
        this.subordinate = true;
        if (log != null) {
            this.logRecord = log;
            this.logRecord.setLocalTID(this.localTID);
            this.logSection = this.logRecord.createSection(LOG_SECTION_NAME);
        }
    }

    TransactionState(Long parentLocalTID, GlobalTID parentGlobalTID) {
        this.localTID = new Long(TransactionState.getSequenceNumber());
        int epoch = TransactionState.getEpochNumber();
        this.globalTID = new GlobalTID(4871251, 0, TransactionState.generateTID(this.localTID, epoch, this.serverName));
        this.state = 0;
        this.subordinate = false;
    }

    int reconstruct(CoordinatorLog log) {
        int result = 0;
        this.logSection = log.createSection(LOG_SECTION_NAME);
        byte[][] logData = log.getData(this.logSection);
        int logState = 0;
        int i2 = 0;
        while (i2 < logData.length) {
            if (logData[i2].length > 1) {
                logState |= ((logData[i2][0] & 0xFF) << 8) + (logData[i2][1] & 0xFF);
            } else {
                ErrorLog.error(50, new Object[]{LOG_SECTION_NAME}, true);
            }
            ++i2;
        }
        if ((logState & 0x200) != 0) {
            result = 9;
        } else if ((logState & 0x80) != 0) {
            result = 7;
        } else if ((logState & 0x40) != 0) {
            result = 6;
        } else if ((logState & 0x100) != 0) {
            result = 8;
        } else if ((logState & 0x20) != 0) {
            result = 5;
        } else if ((logState & 0x10) != 0) {
            result = 4;
        } else if ((logState & 8) != 0) {
            result = 3;
        } else if ((logState & 0x400) != 0) {
            result = 10;
        } else if ((logState & 0x800) != 0) {
            result = 11;
        } else if ((logState & 0x1000) != 0) {
            result = 12;
        } else if ((logState & 0x2000) != 0) {
            result = 13;
        } else if ((logState & 0x4000) != 0) {
            result = 14;
        }
        this.state = result;
        this.subordinate = false;
        this.logRecord = log;
        return result;
    }

    public void finalize() {
        this.state = 0;
        this.globalTID = null;
        this.localTID = null;
        this.logRecord = null;
        this.logSection = null;
    }

    boolean setState(int newState) {
        boolean result = false;
        if (validStateChange[this.state][newState]) {
            Integer failurePoint;
            if (FailureInducer.isFailureInducerActive() && !Thread.currentThread().getName().equals("JTS Resync Thread")) {
                failurePoint = null;
                switch (newState) {
                    case 2: {
                        failurePoint = FailureInducer.ACTIVE;
                        break;
                    }
                    case 3: {
                        failurePoint = FailureInducer.PREPARING;
                        break;
                    }
                    case 4: {
                        failurePoint = FailureInducer.PREPARING;
                        break;
                    }
                    case 5: {
                        failurePoint = FailureInducer.PREPARING;
                        break;
                    }
                    case 10: {
                        failurePoint = FailureInducer.ACTIVE;
                        break;
                    }
                    case 11: {
                        failurePoint = FailureInducer.COMPLETING;
                        break;
                    }
                    case 12: {
                        failurePoint = FailureInducer.COMPLETING;
                        break;
                    }
                    case 6: {
                        failurePoint = FailureInducer.PREPARED;
                        break;
                    }
                    case 7: {
                        failurePoint = FailureInducer.COMPLETING;
                        break;
                    }
                    case 8: {
                        if (this.state == 3) {
                            failurePoint = FailureInducer.PREPARED;
                            break;
                        }
                        if (this.state == 4) {
                            failurePoint = FailureInducer.PREPARED;
                            break;
                        }
                        if (this.state == 5) {
                            failurePoint = FailureInducer.PREPARED;
                            break;
                        }
                        if (this.state != 1) break;
                        failurePoint = FailureInducer.ACTIVE;
                        break;
                    }
                    case 9: {
                        failurePoint = FailureInducer.COMPLETING;
                    }
                }
                FailureInducer.waitForFailure(this.globalTID, failurePoint);
            }
            this.state = newState;
            result = true;
            if (this.logRecord != null && (newState == 3 || newState == 4 || newState == 6 && this.subordinate || newState == 8 && this.subordinate || newState == 7 || newState == 9 || newState == 10 || newState == 11 || newState == 12 || newState == 13 || newState == 14)) {
                byte[] byteData = new byte[]{(byte)((1 << this.state & 0xFF00) >> 8), (byte)(1 << this.state & 0xFF)};
                result = this.logRecord.addData(this.logSection, byteData);
            }
            if (this.logRecord != null && (newState == 3 || newState == 13 || newState == 14 || newState == 6 && this.subordinate || newState == 8 && this.subordinate)) {
                TransactionState.setInDoubt(true);
                result = this.logRecord.write(true);
                if (!result) {
                    // empty if block
                }
            }
            if (this.logRecord == null || newState != 7 && newState != 10 && newState != 11 && newState != 12 && newState != 9 || !(result = this.logRecord.write(false))) {
                // empty if block
            }
            if (FailureInducer.isFailureInducerActive() && !Thread.currentThread().getName().equals("JTS Resync Thread")) {
                failurePoint = null;
                switch (newState) {
                    case 11: {
                        failurePoint = FailureInducer.COMPLETED;
                        break;
                    }
                    case 7: {
                        failurePoint = FailureInducer.COMPLETED;
                        break;
                    }
                    case 9: {
                        failurePoint = FailureInducer.COMPLETED;
                    }
                }
                FailureInducer.waitForFailure(this.globalTID, failurePoint);
            }
        }
        return result;
    }

    static long getSequenceNumber() {
        long result = sequenceNumber++;
        return result;
    }

    static int getEpochNumber() {
        int result = (int)epochNumber;
        return result;
    }

    static boolean inDoubt() {
        return inDoubt;
    }

    static void setInDoubt(boolean value) {
        inDoubt = value;
    }

    private static final byte[] generateTID(long localTID, long epoch, String serverName) {
        int nameLength = serverName == null ? 0 : serverName.length();
        byte[] result = new byte[nameLength + 8];
        int index = 0;
        result[index++] = (byte)localTID;
        result[index++] = (byte)(localTID >> 8);
        result[index++] = (byte)(localTID >> 16);
        result[index++] = (byte)(localTID >> 24);
        result[index++] = (byte)epoch;
        result[index++] = (byte)(epoch >> 8);
        result[index++] = (byte)(epoch >> 16);
        result[index++] = (byte)(epoch >> 24);
        int i2 = 0;
        while (i2 < nameLength) {
            result[index++] = (byte)serverName.charAt(i2);
            ++i2;
        }
        return result;
    }
}

