/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.CoordinatorImpl;
import com.sun.jts.CosTransactions.CoordinatorLog;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.CosTransactions.RecoveryManager;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.RecoveryCoordinatorHelper;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.SubtransactionAwareResourceHelper;

class SuperiorInfo {
    Long localTID = null;
    GlobalTID globalTID = null;
    Coordinator superior = null;
    RecoveryCoordinator recovery = null;
    SubtransactionAwareResource resource = null;
    private CoordinatorLog logRecord = null;
    private java.lang.Object logSection = null;
    private int resyncRetries = 0;
    private static final String LOG_SECTION_NAME = "SI";

    SuperiorInfo() {
    }

    SuperiorInfo(Long localTID, GlobalTID globalTID, Coordinator superior, CoordinatorLog log) {
        this.localTID = localTID;
        this.globalTID = globalTID;
        this.superior = superior;
        this.recovery = null;
        this.resource = null;
        this.logRecord = log;
        this.resyncRetries = 0;
        if (log != null) {
            this.logSection = log.createSection(LOG_SECTION_NAME);
            log.addData(this.logSection, globalTID.toBytes());
        }
    }

    public void finalize() {
        if (this.superior != null) {
            this.superior._release();
        }
        if (this.recovery != null) {
            this.recovery._release();
        }
        this.localTID = null;
        this.globalTID = null;
        this.superior = null;
        this.recovery = null;
        this.resource = null;
    }

    void reconstruct(CoordinatorLog log, CoordinatorImpl coord) {
        this.superior = null;
        this.logSection = log.createSection(LOG_SECTION_NAME);
        byte[][] logData = log.getData(this.logSection);
        this.globalTID = new GlobalTID(logData[0]);
        this.localTID = log.localTID;
        this.logRecord = log;
        this.resyncRetries = 0;
        RecoveryManager.addCoordinator(this.globalTID, this.localTID, coord, 0);
        java.lang.Object[] logObjects = log.getObjects(this.logSection);
        try {
            if (logObjects.length > 1) {
                if (((Object)logObjects[0])._is_a(RecoveryCoordinatorHelper.id())) {
                    ObjectImpl rcimpl = (ObjectImpl)logObjects[0];
                    String[] ids = rcimpl._ids();
                    ObjectImpl crimpl = (ObjectImpl)logObjects[1];
                    ids = crimpl._ids();
                    this.recovery = RecoveryCoordinatorHelper.narrow((Object)logObjects[0]);
                    this.resource = SubtransactionAwareResourceHelper.narrow((Object)logObjects[1]);
                } else {
                    this.recovery = RecoveryCoordinatorHelper.narrow((Object)logObjects[1]);
                    this.resource = SubtransactionAwareResourceHelper.narrow((Object)logObjects[0]);
                }
            } else {
                this.recovery = null;
                this.resource = null;
            }
        }
        catch (Throwable exc) {
            // empty catch block
        }
    }

    void setRecovery(RecoveryCoordinator rec) {
        if (this.recovery == null) {
            this.recovery = rec;
            if (this.logRecord != null) {
                this.logRecord.addObject(this.logSection, rec);
            }
        }
    }

    void setResource(SubtransactionAwareResource res) {
        if (this.resource == null) {
            this.resource = res;
            if (this.logRecord != null) {
                this.logRecord.addObject(this.logSection, res);
            }
        }
    }

    int resyncRetries() {
        int result = this.resyncRetries++;
        return result;
    }
}

