/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.Messages;
import java.io.File;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import org.omg.CORBA.INTERNAL;

public class ErrorLog {
    private static Messages messages = null;
    static final String DEFAULT_LOGFILE = "jts.log";
    private static String errorLogPath = null;
    private static String serverName = null;

    private static final void setup() {
        int[] result = new int[1];
        errorLogPath = Configuration.getDirectory("com.sun.jts.traceDirectory", "jts", result);
        if (result[0] == 1 || result[0] == 2) {
            boolean loggingOn;
            boolean bl2 = loggingOn = Configuration.getPropertyValue("com.sun.jts.errorLogging") != null;
            if (errorLogPath != null && loggingOn) {
                System.err.println(ErrorLog.getMessage(18, new Object[]{errorLogPath}));
            }
            if (result[0] == 2) {
                if (loggingOn) {
                    System.err.println(ErrorLog.getMessage(19));
                }
                errorLogPath = ".";
            }
        }
        if ((serverName = Configuration.getServerName()) == null) {
            serverName = "Anonymous transient server";
        }
        messages = (Messages)ResourceBundle.getBundle("com.sun.jts.CosTransactions.Messages");
    }

    private static final void fileWrite(String message) {
        if (Configuration.getPropertyValue("com.sun.jts.errorLogging") == null) {
            return;
        }
        try {
            File errFileHandle = new File(errorLogPath, DEFAULT_LOGFILE);
            RandomAccessFile fileOutput = new RandomAccessFile(errFileHandle, "rw");
            fileOutput.seek(fileOutput.length());
            fileOutput.writeBytes(message);
            fileOutput.close();
        }
        catch (Throwable e10) {
            System.err.println(ErrorLog.getMessage(61));
        }
    }

    public static final void error(int message, Object[] inserts, boolean fatal) {
        String messageStr = ErrorLog.getMessage(message, inserts);
        System.err.println(ErrorLog.getMessage(62, new Object[]{messageStr}));
        new Exception().printStackTrace();
        String dateString = DateFormat.getDateTimeInstance().format(new Date());
        messageStr = ErrorLog.getMessage(65, new Object[]{dateString, serverName, messages.getMessageNumber(message), fatal ? "F" : "E", messageStr});
        ErrorLog.fileWrite(messageStr);
        if (fatal) {
            throw new INTERNAL(messageStr);
        }
    }

    public static final void warning(int message, Object[] inserts) {
        String messageStr = ErrorLog.getMessage(message, inserts);
        System.err.println(ErrorLog.getMessage(63, new Object[]{messageStr}));
        String dateString = DateFormat.getDateTimeInstance().format(new Date());
        messageStr = ErrorLog.getMessage(65, new Object[]{dateString, serverName, messages.getMessageNumber(message), "W", messageStr});
        ErrorLog.fileWrite(messageStr);
    }

    public static final void info(int message, Object[] inserts) {
        String messageStr = ErrorLog.getMessage(message, inserts);
        System.err.println(ErrorLog.getMessage(64, new Object[]{messageStr}));
        String dateString = DateFormat.getDateTimeInstance().format(new Date());
        messageStr = ErrorLog.getMessage(65, new Object[]{dateString, serverName, messages.getMessageNumber(message), "I", messageStr});
        ErrorLog.fileWrite(messageStr);
    }

    static final String getMessage(int message, Object[] inserts) {
        Object result = null;
        if (errorLogPath == null) {
            ErrorLog.setup();
        }
        if (inserts == null) {
            inserts = new Object[]{};
        }
        return messages.getMessage(message, inserts);
    }

    public static final String getMessage(int messageNum) {
        Object result = null;
        if (errorLogPath == null) {
            ErrorLog.setup();
        }
        return messages.getMessage(messageNum);
    }
}

